/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.legend;

import com.klg.jclass.util.Changeable;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.JCUtil;
import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.graphics.GraphicsUtil;
import com.klg.jclass.util.graphics.JCFont;
import com.klg.jclass.util.graphics.JCFontMetrics;
import com.klg.jclass.util.legend.JCLegendBundle;
import com.klg.jclass.util.legend.JCLegendItem;
import com.klg.jclass.util.legend.JCLegendPopulator;
import com.klg.jclass.util.legend.JCLegendRenderer;
import com.klg.jclass.util.legend.LegendColumn;
import com.klg.jclass.util.style.JCFillStyle;
import com.klg.jclass.util.style.JCLineStyle;
import com.klg.jclass.util.swing.TextRenderer;
import com.klg.jclass.util.swing.ToolTipUser;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCLegend
extends JComponent
implements Changeable,
Serializable {
    public static final int NORTH = 16;
    public static final int SOUTH = 32;
    public static final int EAST = 1;
    public static final int WEST = 2;
    public static final int NORTHEAST = 17;
    public static final int NORTHWEST = 18;
    public static final int SOUTHEAST = 33;
    public static final int SOUTHWEST = 34;
    public static final int NORTHSOUTH_MASK = 240;
    public static final int EASTWEST_MASK = 15;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int NONE = 0;
    public static final int BOX = 1;
    public static final int IMAGE = 2;
    public static final int IMAGE_OUTLINED = 3;
    public static final int CUSTOM_SYMBOL = 4;
    public static final int CUSTOM_ALL = 5;
    public static final int BOX_PLAIN = 6;
    public static final int LINE = 7;
    public static final int TRUNCATE_LEFT = 0;
    public static final int TRUNCATE_RIGHT = 1;
    public static final int TRUNCATE_MIDDLE = 2;
    public static final int TRUNCATE_END = 3;
    public static final int TRUNCATE_LEADING = 4;
    public static final int TRUNCATE_TRAILING = 5;
    public static final int FIXED = 0;
    public static final int ACTUAL = 1;
    public static final String THREE_DOTS = "...";
    public static final String TWO_DOTS = "..";
    public static final String ONE_DOT = ".";
    protected int anchor = 1;
    protected int effectiveAnchor = 0;
    protected int orientation = 1;
    protected ArrayList<LegendColumn> legendColumns = new ArrayList();
    protected LegendColumn defaultLegendColumn = new LegendColumn();
    protected boolean itemTextToolTipEnabled = false;
    protected boolean useEllipsisWhenTruncating = true;
    protected JCFillStyle fillStyle = null;
    protected transient TextRenderer textRenderer = null;
    protected List<List<JCLegendItem>> legendItems = null;
    protected Dimension ps = new Dimension();
    protected int itemRenderMode = 0;
    protected int symbolSize = 8;
    protected int ascent = 0;
    protected int descent = 0;
    protected ImageMapInfo imageMapInfo = null;
    protected boolean cachedVertical = false;
    protected transient Font cachedFont;
    protected boolean updateParent = true;
    protected boolean changed = true;
    protected int changedFlag = 0;
    protected Dimension preferredSize = null;
    protected CellRendererPane cellRendererPane = null;
    protected JCLegendPopulator legendPopulator = null;
    protected JCLegendRenderer legendRenderer = null;
    private transient Graphics prevSetGraphics = null;
    protected Locale locale = Locale.getDefault();
    protected boolean adjustable = true;

    public JCLegend() {
        this.setOpaque(false);
        this.setVisible(false);
        this.cellRendererPane = new CellRendererPane();
        this.add(this.cellRendererPane);
        this.legendColumns.add((LegendColumn)this.defaultLegendColumn.clone());
    }

    public void setLegendPopulator(JCLegendPopulator jCLegendPopulator) {
        this.legendPopulator = jCLegendPopulator;
    }

    public JCLegendPopulator getLegendPopulator() {
        return this.legendPopulator;
    }

    public void setLegendRenderer(JCLegendRenderer jCLegendRenderer) {
        this.legendRenderer = jCLegendRenderer;
    }

    public JCLegendRenderer getLegendRenderer() {
        return this.legendRenderer;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAnchor(int n2) {
        if (n2 == this.anchor) {
            return;
        }
        this.anchor = this.checkAnchor(n2);
        this.effectiveAnchor = 0;
        this.setChanged(true, 9);
    }

    protected int checkAnchor(int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 16: 
            case 17: 
            case 18: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            default: {
                String string = JCLegendBundle.string("invalid_anchor");
                throw new IllegalArgumentException(string);
            }
        }
        return n2;
    }

    public int getEffectiveAnchor() {
        return this.effectiveAnchor == 0 ? this.anchor : this.effectiveAnchor;
    }

    public void setEffectiveAnchor(int n2) {
        this.effectiveAnchor = n2 == 0 ? 0 : this.checkAnchor(n2);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n2) {
        if (n2 == this.orientation) {
            return;
        }
        switch (n2) {
            case 0: 
            case 1: {
                this.orientation = n2;
                break;
            }
            default: {
                String string = JCLegendBundle.string("invalid_orientation");
                throw new IllegalArgumentException(string);
            }
        }
        this.setChanged(true, 2);
    }

    public ImageMapInfo getImageMapInfo() {
        return this.imageMapInfo;
    }

    public void setImageMapInfo(ImageMapInfo imageMapInfo) {
        this.imageMapInfo = imageMapInfo;
    }

    public int getMaxItemTextWidth(int n2) {
        this.checkLegendColumnsArraySize(n2);
        LegendColumn legendColumn = this.legendColumns.get(n2);
        return legendColumn.getMaxItemTextWidth();
    }

    public void setMaxItemTextWidth(int n2) {
        for (LegendColumn legendColumn : this.legendColumns) {
            legendColumn.setMaxItemTextWidth(n2);
        }
        this.defaultLegendColumn.setMaxItemTextWidth(n2);
        this.setChanged(true, 10);
    }

    public void setMaxItemTextWidth(int n2, int n3) {
        this.checkLegendColumnsArraySize(n3);
        LegendColumn legendColumn = this.legendColumns.get(n3);
        if (n2 == legendColumn.getMaxItemTextWidth()) {
            return;
        }
        legendColumn.setMaxItemTextWidth(n2);
        this.setChanged(true, 10);
    }

    public boolean isItemTextToolTipEnabled() {
        return this.itemTextToolTipEnabled;
    }

    protected JComponent getToolTipParent() {
        Container container = this.getParent();
        if (container != null && container instanceof JComponent) {
            return (JComponent)container;
        }
        return this;
    }

    public void setItemTextToolTipEnabled(boolean bl) {
        if (bl == this.itemTextToolTipEnabled) {
            return;
        }
        this.itemTextToolTipEnabled = bl;
        JComponent jComponent = this.getToolTipParent();
        if (bl) {
            if (jComponent instanceof ToolTipUser) {
                ((ToolTipUser)((Object)jComponent)).registerForTooltips();
            } else {
                ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                toolTipManager.registerComponent(jComponent);
            }
        } else if (jComponent instanceof ToolTipUser) {
            ((ToolTipUser)((Object)jComponent)).unregisterForTooltips(this);
        } else if (jComponent.getToolTipText() == null) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.unregisterComponent(jComponent);
        }
        this.setChanged(true, 1);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Point point;
        JCLegendItem jCLegendItem;
        String string = null;
        if (this.itemTextToolTipEnabled && (jCLegendItem = this.pick(point = mouseEvent.getPoint())) != null && jCLegendItem.contents != null) {
            string = jCLegendItem.contents.toString();
        }
        if (string == null) {
            string = super.getToolTipText(mouseEvent);
        }
        return string;
    }

    public int getItemTextAlignment(int n2) {
        this.checkLegendColumnsArraySize(n2);
        LegendColumn legendColumn = this.legendColumns.get(n2);
        return legendColumn.getItemTextAlignment();
    }

    public void setItemTextAlignment(int n2) {
        for (LegendColumn legendColumn : this.legendColumns) {
            legendColumn.setItemTextAlignment(n2);
        }
        this.defaultLegendColumn.setItemTextAlignment(n2);
        this.setChanged(true, 2);
    }

    public void setItemTextAlignment(int n2, int n3) {
        this.checkLegendColumnsArraySize(n3);
        LegendColumn legendColumn = this.legendColumns.get(n3);
        if (n2 == legendColumn.getItemTextAlignment()) {
            return;
        }
        legendColumn.setItemTextAlignment(n2);
        this.setChanged(true, 2);
    }

    public int getTruncateMode(int n2) {
        this.checkLegendColumnsArraySize(n2);
        LegendColumn legendColumn = this.legendColumns.get(n2);
        return legendColumn.getTruncateMode();
    }

    public void setTruncateMode(int n2) {
        for (LegendColumn legendColumn : this.legendColumns) {
            legendColumn.setTruncateMode(n2);
        }
        this.defaultLegendColumn.setTruncateMode(n2);
        this.setChanged(true, 2);
    }

    public void setTruncateMode(int n2, int n3) {
        this.checkLegendColumnsArraySize(n3);
        LegendColumn legendColumn = this.legendColumns.get(n3);
        if (n2 == legendColumn.getTruncateMode()) {
            return;
        }
        legendColumn.setTruncateMode(n2);
        this.setChanged(true, 2);
    }

    public boolean useEllipsisWhenTruncating() {
        return this.useEllipsisWhenTruncating;
    }

    public void setUseEllipsisWhenTruncating(boolean bl) {
        if (bl == this.useEllipsisWhenTruncating) {
            return;
        }
        this.useEllipsisWhenTruncating = bl;
        this.setChanged(true, 2);
    }

    public boolean isAdjustable() {
        return this.adjustable;
    }

    public int getItemRenderMode() {
        return this.itemRenderMode;
    }

    public void setItemRenderMode(int n2) {
        this.itemRenderMode = n2;
        this.setChanged(true, 2);
    }

    public int getSymbolRenderMode() {
        return this.getItemRenderMode();
    }

    public void setSymbolRenderMode(int n2) {
        this.setItemRenderMode(n2);
    }

    public int getSymbolSize() {
        return this.symbolSize;
    }

    protected void checkLegendColumnsArraySize(int n2) {
        if (n2 < 0 || n2 == Integer.MAX_VALUE) {
            String string = JCLegendBundle.string("invalid_column_index");
            throw new IllegalArgumentException(string + n2);
        }
        int n3 = this.legendColumns.size();
        if (n3 <= n2) {
            this.legendColumns.ensureCapacity(n2 + 1);
            for (int i2 = 0; i2 < n2 - n3 + 1; ++i2) {
                this.legendColumns.add((LegendColumn)this.defaultLegendColumn.clone());
            }
        }
    }

    public List<LegendColumn> getLegendColumns() {
        return this.legendColumns;
    }

    public void recalc() {
        if (!this.isChanged(2) && this.isValid()) {
            return;
        }
        Insets insets = this.getInsets();
        this.ps = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        if (!this.isVisible()) {
            this.setChanged(false, 0);
            return;
        }
        this.setUpLegendVariables();
        Dimension dimension = this.layoutLegend(this.legendItems, this.cachedVertical, this.cachedFont);
        this.ps.width += dimension.width;
        this.ps.height += dimension.height;
        this.setChanged(false, 0);
    }

    protected void setUpLegendVariables() {
        FontMetrics fontMetrics;
        Graphics graphics;
        this.cachedVertical = this.orientation == 1;
        this.cachedFont = this.getFont();
        if (this.cachedFont == null) {
            this.cachedFont = new Font("dialog", 0, 12);
        }
        if ((graphics = this.getGraphics()) != null) {
            fontMetrics = graphics.getFontMetrics(this.cachedFont);
            graphics.dispose();
        } else {
            fontMetrics = this.getToolkit().getFontMetrics(this.cachedFont);
        }
        if (fontMetrics == null) {
            return;
        }
        this.descent = fontMetrics.getDescent();
        this.symbolSize = this.ascent = fontMetrics.getAscent();
        if (this.legendPopulator != null) {
            this.legendItems = this.legendPopulator.getLegendItems(fontMetrics);
        }
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        JCFont jCFont;
        JCFontMetrics jCFontMetrics;
        if (font instanceof JCFont && (jCFontMetrics = (jCFont = (JCFont)((Object)font)).getJCFontMetrics()) != null) {
            return jCFontMetrics.getEncoderFontMetrics();
        }
        return super.getFontMetrics(font);
    }

    public List<List<JCLegendItem>> getLegendItems() {
        return this.legendItems;
    }

    public abstract Dimension layoutLegend(List<List<JCLegendItem>> var1, boolean var2, Font var3);

    public abstract int getNumRows();

    public abstract int getNumColumns();

    public JCFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        if (this.fillStyle != null) {
            this.fillStyle.parent = null;
        }
        this.fillStyle = jCFillStyle;
        if (this.fillStyle != null) {
            this.fillStyle.parent = this;
        }
        this.setChanged(true, 1);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Rectangle rectangle;
        if (!this.isVisible() || graphics == null) {
            return;
        }
        Container container = this.getParent();
        if (container == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderProperties renderProperties = GraphicsUtil.getRenderPropertiesParent(this);
        if (renderProperties != null) {
            GraphicsUtil.setAntiAliasing(graphics2D, renderProperties.getAntiAliasing());
        }
        if (this.isOpaque()) {
            JCFillStyle object2;
            rectangle = this.getBounds();
            Color color = this.getBackground();
            if (color != null) {
                if (!graphics2D.getColor().equals(color)) {
                    graphics2D.setColor(color);
                }
                graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
            }
            if ((object2 = this.getFillStyle()) != null) {
                Insets insets = this.getInsets();
                int n2 = Math.max(0, rectangle.width - insets.left - insets.right);
                int n3 = Math.max(0, rectangle.height - insets.top - insets.bottom);
                Rectangle rectangle2 = new Rectangle(insets.left, insets.top, n2, n3);
                object2.updateAnchorRect(rectangle2);
                object2.fillRect((Graphics)graphics2D, insets.left, insets.top, n2, n3);
                object2.updateAnchorRect(null);
            }
        }
        rectangle = this.getDrawingArea();
        graphics2D.translate(rectangle.x, rectangle.y);
        graphics2D.clipRect(0, 0, rectangle.width + 1, rectangle.height + 1);
        if (this.legendRenderer != null && this.legendItems != null) {
            for (List list : this.legendItems) {
                for (JCLegendItem jCLegendItem : list) {
                    if (jCLegendItem.drawType == 5) {
                        this.legendRenderer.drawLegendItem(graphics2D, this.cachedFont, jCLegendItem);
                        continue;
                    }
                    this.drawLegendItem(graphics2D, this.cachedFont, jCLegendItem);
                }
            }
        }
        this.textRenderer = null;
        graphics2D.dispose();
        this.setChanged(false, 0);
    }

    protected String ellipsisCheck(String string, int n2, FontMetrics fontMetrics) {
        if (string == null || n2 <= 0 || fontMetrics == null) {
            return string;
        }
        String string2 = string + THREE_DOTS;
        int n3 = fontMetrics.stringWidth(string2);
        if (n3 <= n2) {
            return string2;
        }
        string2 = string + TWO_DOTS;
        n3 = fontMetrics.stringWidth(string2);
        if (n3 <= n2) {
            return string2;
        }
        string2 = string + ONE_DOT;
        n3 = fontMetrics.stringWidth(string2);
        if (n3 <= n2) {
            return string2;
        }
        return string;
    }

    protected int calcItemTextAlignment(int n2) {
        boolean bl = true;
        if (!this.getComponentOrientation().isLeftToRight()) {
            bl = false;
        }
        switch (n2) {
            case 10: {
                n2 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n2 = bl ? 4 : 2;
            }
        }
        return n2;
    }

    public void drawLegendItem(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
        if (graphics == null || jCLegendItem == null) {
            return;
        }
        if (graphics.getColor() != this.getForeground()) {
            graphics.setColor(this.getForeground());
        }
        if (graphics.getFont() != font) {
            graphics.setFont(font);
        }
        Color color = null;
        if (this.legendRenderer != null) {
            color = this.legendRenderer.getOutlineColor(jCLegendItem);
        }
        if (color == null) {
            color = this.getForeground();
        }
        int n2 = jCLegendItem.column;
        int n3 = jCLegendItem.maxContentsWidth;
        int n4 = this.calcItemTextAlignment(this.getItemTextAlignment(n2));
        int n5 = this.getTruncateMode(n2);
        boolean bl = this.useEllipsisWhenTruncating;
        if (this.isTitleItem(jCLegendItem)) {
            if (jCLegendItem.contents instanceof String && n3 > 0) {
                String string = (String)jCLegendItem.contents;
                if (TextRenderer.isHTML(string)) {
                    TextRenderer textRenderer = this.getTextRenderer();
                    textRenderer.setHorizontalAlignment(n4);
                    textRenderer.drawHTMLText(graphics, this.getCellRendererPane(), this, string, jCLegendItem.pos.x + jCLegendItem.textPos.x, jCLegendItem.pos.y + jCLegendItem.textPos.y, n3, jCLegendItem.textDim.height);
                } else {
                    String string2 = this.isAdjustable() ? JCUtil.truncateString(graphics, this, string, n3, n5, bl, false) : string;
                    boolean bl2 = jCLegendItem.itemTextTruncated = !string.equals(string2);
                    if (string2.length() > 0) {
                        int n6 = 0;
                        if (n3 < Integer.MAX_VALUE) {
                            int n7 = graphics.getFontMetrics().stringWidth(string2);
                            if (n4 == 4) {
                                n6 = n3 - n7;
                            } else if (n4 == 0) {
                                n6 = (n3 - n7) / 2;
                            }
                        }
                        graphics.drawString(string2, jCLegendItem.pos.x + jCLegendItem.textPos.x + n6, jCLegendItem.pos.y + jCLegendItem.textPos.y + this.ascent);
                    }
                }
            }
        } else {
            Object object;
            int n8 = jCLegendItem.pos.x + jCLegendItem.symbolPos.x;
            int n9 = jCLegendItem.pos.y + jCLegendItem.symbolPos.y;
            int n10 = jCLegendItem.symbolDim.width - 1;
            int n11 = jCLegendItem.symbolDim.height - 1;
            if (jCLegendItem.drawType == 1 || jCLegendItem.drawType == 6) {
                if (graphics.getColor() != this.getBackground()) {
                    graphics.setColor(this.getBackground());
                }
                if (this.legendRenderer != null) {
                    this.legendRenderer.setFillGraphics(graphics, jCLegendItem);
                }
                graphics.fillRect(n8, n9, n10, n11);
                boolean bl3 = false;
                object = null;
                if (jCLegendItem.drawType == 1) {
                    if (jCLegendItem.drawStyle instanceof JCLineStyle) {
                        object = (JCLineStyle)jCLegendItem.drawStyle;
                        ((JCLineStyle)object).updateGraphics(graphics);
                    } else if (jCLegendItem.drawStyle instanceof List) {
                        bl3 = true;
                    } else {
                        graphics.setColor(color);
                    }
                }
                if (bl3) {
                    List list = (List)jCLegendItem.drawStyle;
                    JCLineStyle jCLineStyle = new JCLineStyle(1, graphics.getColor(), 1);
                    object = jCLineStyle;
                    ((JCLineStyle)object).updateGraphics(graphics);
                    graphics.drawLine(n8, n9 + n11, n8, n9);
                    graphics.drawLine(n8 + n10, n9, n8 + n10, n9 + n11);
                    ((JCLineStyle)object).resetGraphics(graphics);
                    int n12 = list.size();
                    if (n12 >= 1) {
                        JCLineStyle jCLineStyle2 = (JCLineStyle)list.get(0);
                        object = jCLineStyle2 != null ? jCLineStyle2 : jCLineStyle;
                    }
                    ((JCLineStyle)object).updateGraphics(graphics);
                    int n13 = ((JCLineStyle)object).getWidth() > 1 ? n10 + 1 : n10;
                    graphics.drawLine(n8, n9, n8 + n13, n9);
                    if (n12 >= 2) {
                        JCLineStyle jCLineStyle3 = (JCLineStyle)list.get(1);
                        object = jCLineStyle3 != null ? jCLineStyle3 : jCLineStyle;
                    }
                    ((JCLineStyle)object).updateGraphics(graphics);
                    n13 = ((JCLineStyle)object).getWidth() > 1 ? n10 + 1 : n10;
                    graphics.drawLine(n8 + n13, n9 + n11, n8, n9 + n11);
                } else {
                    graphics.drawRect(n8, n9, n10, n11);
                }
                if (object != null) {
                    ((JCLineStyle)object).resetGraphics(graphics);
                }
            } else if (jCLegendItem.drawType == 7) {
                if (this.legendRenderer != null) {
                    this.legendRenderer.setFillGraphics(graphics, jCLegendItem);
                }
                graphics.drawLine(n8, n9 + n11 / 2, n8 + n10, n9 + n11 / 2);
            } else if (jCLegendItem.drawType == 2) {
                if (jCLegendItem.symbol instanceof Image) {
                    graphics.drawImage((Image)jCLegendItem.symbol, n8, n9, null);
                }
            } else if (jCLegendItem.drawType == 3) {
                if (jCLegendItem.symbol instanceof Image) {
                    graphics.drawImage((Image)jCLegendItem.symbol, n8, n9, null);
                    graphics.setColor(color);
                    graphics.drawRect(n8, n9, n10, n11);
                }
            } else if (jCLegendItem.drawType == 4 && this.legendRenderer != null) {
                this.legendRenderer.drawLegendItemSymbol(graphics, font, jCLegendItem);
            }
            if (graphics.getColor() != this.getForeground()) {
                graphics.setColor(this.getForeground());
            }
            if (graphics.getFont() != font) {
                graphics.setFont(font);
            }
            if (jCLegendItem.contents instanceof String && n3 > 0) {
                String string = (String)jCLegendItem.contents;
                if (TextRenderer.isHTML(string)) {
                    object = this.getTextRenderer();
                    ((JLabel)object).setHorizontalAlignment(n4);
                    ((TextRenderer)object).drawHTMLText(graphics, this.getCellRendererPane(), this, string, jCLegendItem.pos.x + jCLegendItem.textPos.x, jCLegendItem.pos.y + jCLegendItem.textPos.y, n3, jCLegendItem.textDim.height);
                } else {
                    object = this.isAdjustable() ? JCUtil.truncateString(graphics, this, string, n3, n5, bl, false) : string;
                    boolean bl4 = jCLegendItem.itemTextTruncated = !string.equals(object);
                    if (((String)object).length() > 0) {
                        int n14 = 0;
                        if (n3 < Integer.MAX_VALUE) {
                            int n15 = graphics.getFontMetrics().stringWidth((String)object);
                            if (n4 == 4) {
                                n14 = n3 - n15;
                            } else if (n4 == 0) {
                                n14 = (n3 - n15) / 2;
                            }
                        }
                        graphics.drawString((String)object, jCLegendItem.pos.x + jCLegendItem.textPos.x + n14, jCLegendItem.pos.y + jCLegendItem.textPos.y + this.ascent);
                    }
                }
            } else if (this.legendRenderer != null) {
                this.legendRenderer.drawLegendItemText(graphics, font, jCLegendItem);
            }
        }
    }

    public boolean isTitleItem(JCLegendItem jCLegendItem) {
        return this.legendPopulator != null && this.legendPopulator.isTitleItem(jCLegendItem);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.preferredSize;
        if (dimension != null) {
            return dimension;
        }
        this.recalc();
        return new Dimension(this.ps);
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    public TextRenderer getTextRenderer() {
        if (this.textRenderer == null) {
            this.textRenderer = new TextRenderer();
        }
        return this.textRenderer;
    }

    public JCLegendItem pick(Point point) {
        Rectangle rectangle = this.getDrawingArea();
        point.x -= rectangle.x;
        point.y -= rectangle.y;
        JCLegendItem jCLegendItem = null;
        block0: for (List<JCLegendItem> list : this.legendItems) {
            for (JCLegendItem jCLegendItem2 : list) {
                Rectangle rectangle2 = jCLegendItem2.pickRectangle;
                if (rectangle2 == null && jCLegendItem2.pos != null && jCLegendItem2.dim != null) {
                    rectangle2 = new Rectangle(jCLegendItem2.pos, jCLegendItem2.dim);
                }
                if (rectangle2 == null || !rectangle2.contains(point.x, point.y)) continue;
                jCLegendItem = jCLegendItem2;
                continue block0;
            }
        }
        return jCLegendItem;
    }

    public Rectangle getDrawingArea() {
        Rectangle rectangle = new Rectangle();
        this.getDrawingArea(rectangle);
        return rectangle;
    }

    public void getDrawingArea(Rectangle rectangle) {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        rectangle.setBounds(insets.left, insets.top, Math.max(0, dimension.width - (insets.left + insets.right)), Math.max(0, dimension.height - (insets.top + insets.bottom)));
    }

    public CellRendererPane getCellRendererPane() {
        return this.cellRendererPane;
    }

    @Override
    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics.create();
    }

    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
    }

    @Override
    public boolean getChanged() {
        return this.changed;
    }

    @Override
    public boolean getChanged(int n2) {
        return (this.changedFlag & n2) == n2;
    }

    @Override
    public final boolean isChanged() {
        return this.getChanged();
    }

    @Override
    public final boolean isChanged(int n2) {
        return this.getChanged(n2);
    }

    @Override
    public void setChanged(boolean bl, int n2) {
        if (bl != this.getChanged() || !this.getChanged(n2)) {
            this.changed = bl;
            this.changedFlag = bl ? (this.changedFlag |= n2) : n2;
        }
        if (bl && this.getParent() != null && this.updateParent) {
            this.updateParent(n2);
        }
    }

    @Override
    public void setChanged(boolean bl, int n2, boolean bl2) {
        if (bl2) {
            this.setChanged(bl, n2);
        } else {
            this.changed = bl;
            this.changedFlag = bl ? (this.changedFlag |= n2) : n2;
        }
    }

    public void updateParent(int n2) {
        Container container = this.getParent();
        if (container != null) {
            Changeable changeable = null;
            if (container instanceof Changeable) {
                changeable = (Changeable)((Object)container);
            }
            if ((n2 & 2) > 0 || (n2 & 8) > 0) {
                container.invalidate();
                if (changeable != null && !changeable.isBatched() || changeable == null) {
                    container.validate();
                    container.repaint();
                }
            } else if ((n2 & 1) > 0 && (changeable != null && !changeable.isBatched() || changeable == null)) {
                container.repaint();
            }
        }
    }

    @Override
    public boolean isBatched() {
        return false;
    }

    @Override
    public void setLocale(Locale locale) {
        if (this.locale == locale || locale == null) {
            return;
        }
        try {
            this.locale = locale;
        }
        catch (MissingResourceException missingResourceException) {
            this.locale = Locale.getDefault();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.changed;
        int n2 = this.changedFlag;
        this.changed = true;
        this.changedFlag = 2;
        objectOutputStream.defaultWriteObject();
        this.changed = bl;
        this.changedFlag = n2;
    }
}

