/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.legend;

import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.legend.JCLegendBundle;
import com.klg.jclass.util.legend.JCLegendItem;
import com.klg.jclass.util.legend.LegendComponentLayoutUser;
import com.klg.jclass.util.swing.TextRenderer;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCGridLegend
extends JCLegend {
    public int[] rowHeights;
    public int[] rowFirstLineHeights;
    public int[] titleColWidths;
    public int[] colWidths;
    public int[] symWidths;
    public int[] strWidths;
    protected int marginGap = 2;
    protected int itemGap = 2;
    protected int insideItemGap = 2;
    protected int groupGap = 5;

    public void setMarginGap(int n2) {
        this.marginGap = n2;
        this.setChanged(true, 2);
    }

    public int getMarginGap() {
        return this.marginGap;
    }

    public void setItemGap(int n2) {
        this.itemGap = n2;
        this.setChanged(true, 2);
    }

    public int getItemGap() {
        return this.itemGap;
    }

    public void setInsideItemGap(int n2) {
        this.insideItemGap = n2;
        this.setChanged(true, 2);
    }

    public int getInsideItemGap() {
        return this.insideItemGap;
    }

    public void setGroupGap(int n2) {
        this.groupGap = n2;
        this.setChanged(true, 2);
    }

    public int getGroupGap() {
        return this.groupGap;
    }

    @Override
    public Dimension layoutLegend(List<List<JCLegendItem>> list, boolean bl, Font font) {
        if (list == null) {
            return new Dimension(0, 0);
        }
        this.fillSizeArrays(list, bl, font);
        if (this.isAdjustable()) {
            this.adjustStringWidths(list, bl, font);
        }
        Dimension dimension = this.calcLegendSize(bl);
        this.layoutLegendItems(list, bl);
        return dimension;
    }

    @Override
    public int getNumRows() {
        return this.rowHeights == null ? 0 : this.rowHeights.length;
    }

    @Override
    public int getNumColumns() {
        return this.colWidths == null ? 0 : this.colWidths.length;
    }

    public int getColumnWidth(int n2) {
        if (n2 < 0 || this.colWidths != null && n2 >= this.colWidths.length) {
            String string = JCLegendBundle.string("invalid_column_index");
            throw new IllegalArgumentException(string + n2);
        }
        return this.colWidths == null ? 0 : this.colWidths[n2];
    }

    protected void updateColumnWidths(List<List<JCLegendItem>> list, boolean bl, int[] nArray, boolean bl2) {
        int n2;
        int n3;
        this.checkLegendColumnsArraySize(this.colWidths.length);
        for (n3 = 0; n3 < this.colWidths.length; ++n3) {
            this.colWidths[n3] = bl2 ? this.titleColWidths[n3] : 0;
        }
        for (n3 = 0; n3 < this.colWidths.length; ++n3) {
            n2 = this.symWidths[n3] + nArray[n3];
            if (this.symWidths[n3] != 0 && nArray[n3] != 0) {
                n2 += this.getInsideItemGap();
            }
            if (this.colWidths[n3] >= n2) continue;
            this.colWidths[n3] = n2;
        }
        n3 = list.size();
        for (n2 = 0; n2 < n3; ++n2) {
            List<JCLegendItem> list2 = list.get(n2);
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                JCLegendItem jCLegendItem = list2.get(i2);
                jCLegendItem.maxContentsWidth = this.isTitleItem(jCLegendItem) ? (bl ? this.colWidths[n2] : this.colWidths[i2]) : (bl ? nArray[n2] : nArray[i2]);
            }
        }
    }

    public void fillSizeArrays(List<List<JCLegendItem>> list, boolean bl, Font font) {
        int n2;
        int n3 = list.size();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 = Math.max(n4, list.get(n2).size());
        }
        this.rowHeights = new int[bl ? n4 : n3];
        for (n2 = 0; n2 < this.rowHeights.length; ++n2) {
            this.rowHeights[n2] = 0;
        }
        this.rowFirstLineHeights = new int[bl ? n4 : n3];
        for (n2 = 0; n2 < this.rowFirstLineHeights.length; ++n2) {
            this.rowFirstLineHeights[n2] = 0;
        }
        this.titleColWidths = new int[bl ? n3 : n4];
        this.colWidths = new int[bl ? n3 : n4];
        for (n2 = 0; n2 < this.colWidths.length; ++n2) {
            this.colWidths[n2] = 0;
            this.titleColWidths[n2] = 0;
        }
        this.symWidths = new int[bl ? n3 : n4];
        for (n2 = 0; n2 < this.symWidths.length; ++n2) {
            this.symWidths[n2] = 0;
        }
        this.strWidths = new int[bl ? n3 : n4];
        for (n2 = 0; n2 < this.strWidths.length; ++n2) {
            this.strWidths[n2] = 0;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            List<JCLegendItem> list2 = list.get(n2);
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                JCLegendItem jCLegendItem = list2.get(i2);
                Dimension dimension = jCLegendItem.textDim;
                Dimension dimension2 = jCLegendItem.symbolDim;
                Dimension dimension3 = null;
                if (jCLegendItem.contents instanceof String) {
                    if (dimension != null) {
                        String string = (String)jCLegendItem.contents;
                        if (TextRenderer.isHTML(string)) {
                            TextRenderer textRenderer = this.getTextRenderer();
                            dimension3 = textRenderer.calcHTMLLineSize(string, dimension.width, dimension.height);
                        } else {
                            dimension3 = new Dimension(dimension.width, this.ascent);
                        }
                    }
                } else if (dimension != null) {
                    dimension3 = new Dimension(dimension.width, dimension.height);
                }
                if (bl) {
                    jCLegendItem.column = n2;
                    if (this.isTitleItem(jCLegendItem)) {
                        if (dimension != null && this.titleColWidths[n2] < dimension.width) {
                            this.titleColWidths[n2] = Math.min(dimension.width, this.getMaxItemTextWidth(n2));
                        }
                    } else {
                        if (dimension2 != null && this.symWidths[n2] < dimension2.width) {
                            this.symWidths[n2] = dimension2.width;
                        }
                        if (dimension != null && this.strWidths[n2] < dimension.width) {
                            this.strWidths[n2] = dimension.width;
                        }
                    }
                    if (dimension2 != null && this.rowHeights[i2] < dimension2.height) {
                        this.rowHeights[i2] = dimension2.height;
                    }
                    if (dimension != null && this.rowHeights[i2] < dimension.height) {
                        this.rowHeights[i2] = dimension.height;
                    }
                    if (dimension3 == null || this.rowFirstLineHeights[i2] >= dimension3.height) continue;
                    this.rowFirstLineHeights[i2] = dimension3.height;
                    continue;
                }
                jCLegendItem.column = i2;
                if (dimension2 != null && this.rowHeights[n2] < dimension2.height) {
                    this.rowHeights[n2] = dimension2.height;
                }
                if (dimension != null && this.rowHeights[n2] < dimension.height) {
                    this.rowHeights[n2] = dimension.height;
                }
                if (dimension3 != null && this.rowFirstLineHeights[n2] < dimension3.height) {
                    this.rowFirstLineHeights[n2] = dimension3.height;
                }
                if (dimension2 != null && this.symWidths[i2] < dimension2.width) {
                    this.symWidths[i2] = dimension2.width;
                }
                if (dimension == null || this.strWidths[i2] >= dimension.width) continue;
                this.strWidths[i2] = dimension.width;
            }
        }
        this.updateColumnWidths(list, bl, this.strWidths, true);
    }

    protected boolean isVariableColumn(int n2, boolean bl) {
        int n3 = this.getMaxItemTextWidth(n2);
        return n3 == Integer.MAX_VALUE && (bl || n2 > 0);
    }

    protected void adjustStringWidths(List<List<JCLegendItem>> list, boolean bl, Font font) {
        int n2;
        int n3;
        int n4;
        boolean bl2 = true;
        int n5 = this.colWidths.length;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n6 = this.getMaxItemTextWidth(i2);
            if (this.strWidths[i2] <= n6) continue;
            this.strWidths[i2] = n6;
            bl2 = false;
        }
        if (!bl2) {
            this.updateColumnWidths(list, bl, this.strWidths, true);
        }
        Insets insets = this.getInsets();
        Dimension dimension = this.calcLegendSize(bl);
        Container container = this.getParent();
        Rectangle rectangle = null;
        if (container instanceof LegendComponentLayoutUser) {
            LegendComponentLayoutUser legendComponentLayoutUser = (LegendComponentLayoutUser)((Object)container);
            rectangle = legendComponentLayoutUser.getLayoutHints(this);
        }
        int n7 = n4 = rectangle == null ? Integer.MAX_VALUE : rectangle.width - insets.left - insets.right;
        if (dimension.width <= n4) {
            return;
        }
        int n8 = dimension.width - n4;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            if (this.isVariableColumn(n3, bl)) {
                ++n9;
                n10 += this.strWidths[n3];
                if (this.symWidths[n3] != 0 && this.strWidths[n3] != 0) {
                    n12 += this.getInsideItemGap();
                }
            }
            n11 += this.strWidths[n3];
            if (this.symWidths[n3] == 0 || this.strWidths[n3] == 0) continue;
            n13 += this.getInsideItemGap();
        }
        n3 = n5 - n9;
        boolean bl3 = n9 > 0 && n10 + n12 >= n8;
        boolean bl4 = !bl3 && n3 > 0 && n11 + n13 >= n8;
        int n14 = 0;
        int n15 = 0;
        if (bl3) {
            n2 = n10 - n8;
            n14 = n2 / n9;
            n15 = n2 % n9;
        } else if (bl4) {
            n2 = n11 - n8;
            n14 = n2 / n3;
            n15 = n2 % n3;
        }
        n2 = 0;
        for (int i3 = 0; i3 < n5; ++i3) {
            boolean bl5 = this.isVariableColumn(i3, bl);
            if (bl3) {
                if (!bl5) continue;
                this.strWidths[i3] = n14 + (n2 < n15 ? 1 : 0);
                ++n2;
                continue;
            }
            if (bl4) {
                if (bl5) {
                    this.strWidths[i3] = 0;
                    continue;
                }
                this.strWidths[i3] = n14 + (n2 < n15 ? 1 : 0);
                ++n2;
                continue;
            }
            this.strWidths[i3] = 0;
        }
        this.updateColumnWidths(list, bl, this.strWidths, false);
    }

    public Dimension calcLegendSize(boolean bl) {
        Dimension dimension = new Dimension(0, 0);
        for (int n2 : this.colWidths) {
            dimension.width += n2;
        }
        for (int n2 : this.rowHeights) {
            dimension.height += n2;
        }
        if (bl) {
            dimension.width += (this.colWidths.length - 1) * this.getGroupGap();
            dimension.width += 2 * this.getMarginGap();
            dimension.height += (this.rowHeights.length - 1) * this.getItemGap();
            dimension.height += 2 * this.getMarginGap();
        } else {
            dimension.width += (this.colWidths.length - 1) * this.getItemGap();
            dimension.width += 2 * this.getMarginGap();
            dimension.height += (this.rowHeights.length - 1) * this.getGroupGap();
            dimension.height += 2 * this.getMarginGap();
        }
        return dimension;
    }

    public void layoutLegendItems(List<List<JCLegendItem>> list, boolean bl) {
        int n2 = this.getMarginGap();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            List<JCLegendItem> list2 = list.get(i2);
            int n3 = this.getMarginGap();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                JCLegendItem jCLegendItem = list2.get(i3);
                jCLegendItem.pos = new Point(bl ? n2 : n3, bl ? n3 : n2);
                jCLegendItem.dim = new Dimension(bl ? this.colWidths[i2] : this.colWidths[i3], bl ? this.rowHeights[i3] : this.rowHeights[i2]);
                if (this.isTitleItem(jCLegendItem)) {
                    jCLegendItem.textPos = this.positionItemText(bl, jCLegendItem, jCLegendItem.dim, new Point(0, 0));
                } else {
                    int n4 = bl ? this.rowFirstLineHeights[i3] : this.rowFirstLineHeights[i2];
                    jCLegendItem.symbolPos = this.positionItemSymbol(bl, jCLegendItem, new Dimension(0, n4), new Point(0, 0));
                    jCLegendItem.textPos = this.positionItemText(bl, jCLegendItem, new Dimension(0, n4), new Point(this.getInsideItemGap() + (bl ? this.symWidths[i2] : this.symWidths[i3]), 0));
                }
                jCLegendItem.pickRectangle = new Rectangle(jCLegendItem.pos.x, jCLegendItem.pos.y, jCLegendItem.dim.width, jCLegendItem.dim.height);
                if (i3 != list2.size() - 1) {
                    if (bl) {
                        jCLegendItem.pickRectangle.height += this.getItemGap();
                    } else {
                        jCLegendItem.pickRectangle.width += this.getItemGap();
                    }
                }
                if (i2 != list.size() - 1) {
                    if (bl) {
                        jCLegendItem.pickRectangle.width += this.getGroupGap();
                    } else {
                        jCLegendItem.pickRectangle.height += this.getGroupGap();
                    }
                }
                n3 += (bl ? this.rowHeights[i3] : this.colWidths[i3]) + this.getItemGap();
            }
            n2 += (bl ? this.colWidths[i2] : this.rowHeights[i2]) + this.getGroupGap();
        }
    }

    public Point positionItemSymbol(boolean bl, JCLegendItem jCLegendItem, Dimension dimension, Point point) {
        if (bl) {
            if (jCLegendItem.symbolDim.height < dimension.height) {
                return this.centerItemComponentVertically(bl, jCLegendItem.symbolDim, dimension.height, point);
            }
            return point;
        }
        return this.centerItemComponentVertically(bl, jCLegendItem.symbolDim, jCLegendItem.dim.height, point);
    }

    public Point positionItemText(boolean bl, JCLegendItem jCLegendItem, Dimension dimension, Point point) {
        if (bl) {
            if (jCLegendItem.textDim.height < dimension.height) {
                return this.centerItemComponentVertically(bl, jCLegendItem.textDim, dimension.height, point);
            }
            return point;
        }
        return this.centerItemComponentVertically(bl, jCLegendItem.textDim, jCLegendItem.dim.height, point);
    }

    protected Point centerItemComponentVertically(boolean bl, Dimension dimension, int n2, Point point) {
        Point point2 = new Point(point.x, point.y);
        if (n2 - point.y > dimension.height) {
            point2.y += (int)Math.ceil((double)(n2 - point.y - dimension.height) / 2.0);
        }
        return point2;
    }
}

