/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.label;

import com.klg.jclass.util.graphics.GraphicsUtil;
import com.klg.jclass.util.graphics.JCFontMetrics;
import com.klg.jclass.util.label.JCLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class JCLabelUI
extends LabelUI
implements PropertyChangeListener {
    protected JLabel label = null;

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabel(JLabel jLabel) {
        this.label = jLabel;
    }

    protected void paintEnabledText(Graphics graphics, String string, int n2, int n3) {
        int n4 = this.label.getDisplayedMnemonicIndex();
        graphics.setColor(this.label.getForeground());
        BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, n2, n3);
    }

    protected void paintDisabledText(Graphics graphics, String string, int n2, int n3) {
        int n4 = this.label.getDisplayedMnemonicIndex();
        Color color = this.label.getBackground();
        graphics.setColor(color.brighter());
        BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, n2 + 1, n3 + 1);
        graphics.setColor(color.darker());
        BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, n2, n3);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Icon icon;
        if (jComponent != this.label) {
            return;
        }
        String string = this.label.getText();
        Icon icon2 = icon = this.label.isEnabled() ? this.label.getIcon() : this.label.getDisabledIcon();
        if (icon == null && string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = GraphicsUtil.getDrawingArea(this.label, null);
        String string2 = SwingUtilities.layoutCompoundLabel(this.label, fontMetrics, string, icon, this.label.getVerticalAlignment(), this.label.getHorizontalAlignment(), this.label.getVerticalTextPosition(), this.label.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, this.label.getIconTextGap());
        if (icon != null) {
            icon.paintIcon(this.label, graphics, rectangle.x, rectangle.y);
        }
        if (string != null) {
            View view = (View)this.label.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, rectangle2);
            } else {
                int n2 = rectangle2.x;
                int n3 = rectangle2.y + fontMetrics.getAscent();
                if (this.label.isEnabled()) {
                    this.paintEnabledText(graphics, string2, n2, n3);
                } else {
                    this.paintDisabledText(graphics, string2, n2, n3);
                }
            }
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics;
        if (jComponent != this.label) {
            return null;
        }
        String string = this.label.getText();
        Icon icon = this.label.isEnabled() ? this.label.getIcon() : this.label.getDisabledIcon();
        Insets insets = this.label.getInsets();
        Font font = this.label.getFont();
        int n2 = insets.left + insets.right;
        int n3 = insets.top + insets.bottom;
        if (icon == null && (string == null || font == null)) {
            return new Dimension(n2, n3);
        }
        if (string == null || icon != null && font == null) {
            return new Dimension(icon.getIconWidth() + n2, icon.getIconHeight() + n3);
        }
        Graphics graphics = jComponent.getGraphics();
        FontMetrics fontMetrics2 = fontMetrics = graphics != null ? graphics.getFontMetrics(font) : this.label.getToolkit().getFontMetrics(font);
        if (fontMetrics instanceof JCFontMetrics) {
            fontMetrics = ((JCFontMetrics)((Object)fontMetrics)).getEncoderFontMetrics();
        }
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(n2, n3, Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(this.label, fontMetrics, string, icon, this.label.getVerticalAlignment(), this.label.getHorizontalAlignment(), this.label.getVerticalTextPosition(), this.label.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, this.label.getIconTextGap());
        int n4 = Math.min(rectangle.x, rectangle2.x);
        int n5 = Math.max(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
        int n6 = Math.min(rectangle.y, rectangle2.y);
        int n7 = Math.max(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height);
        Dimension dimension = new Dimension(n5 - n4, n7 - n6);
        dimension.width += n2;
        dimension.height += n3;
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (jComponent != this.label) {
            return null;
        }
        Dimension dimension = this.getPreferredSize(this.label);
        View view = (View)this.label.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (jComponent != this.label) {
            return null;
        }
        Dimension dimension = this.getPreferredSize(this.label);
        View view = (View)this.label.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    public void installUI(JComponent jComponent) {
        if (jComponent != this.label) {
            return;
        }
        LookAndFeel.installColorsAndFont(this.label, "Label.background", "Label.foreground", "Label.font");
        this.label.addPropertyChangeListener(this);
        BasicHTML.updateRenderer(this.label, this.label.getText());
    }

    public void uninstallUI(JComponent jComponent) {
        if (jComponent != this.label) {
            return;
        }
        this.label.removePropertyChangeListener(this);
        BasicHTML.updateRenderer(this.label, "");
    }

    public static ComponentUI createUI(JComponent jComponent) {
        if (jComponent instanceof JCLabel) {
            return ((JCLabel)jComponent).getUI();
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("text".equals(string) || "font".equals(string) || "foreground".equals(string)) {
            JLabel jLabel = (JLabel)propertyChangeEvent.getSource();
            String string2 = jLabel.getText();
            BasicHTML.updateRenderer(jLabel, string2);
        }
    }
}

