/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.io;

import com.klg.jclass.util.LocaleBundle;
import com.klg.jclass.util.LocaleHandler;
import com.klg.jclass.util.io.Properties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadProperties
extends Properties {
    protected Class<?> resolvingClass;
    protected String relativeURLPrefix;
    protected Object userObject;
    protected boolean storeUserObject;
    protected String localEntitySystemId = "";
    protected ErrorHandler xmlErrorHandler = null;
    protected LocaleHandler localeHandler = null;

    public LoadProperties() {
        this(null, "", null, true);
    }

    public LoadProperties(Class<?> clazz, String string, Object object, boolean bl) {
        this.setResolvingClass(clazz);
        this.setRelativeURLPrefix(string);
        this.setUserObject(object);
        this.setStoreUserObject(bl);
    }

    public void setResolvingClass(Class<?> clazz) {
        this.resolvingClass = clazz;
    }

    public Class<?> getResolvingClass() {
        return this.resolvingClass;
    }

    public void setRelativeURLPrefix(String string) {
        if (string == null) {
            string = "";
        }
        this.relativeURLPrefix = string;
    }

    public String getRelativeURLPrefix() {
        return this.relativeURLPrefix;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setStoreUserObject(boolean bl) {
        this.storeUserObject = bl;
    }

    public boolean getStoreUserObject() {
        return this.storeUserObject;
    }

    public URL getURLByAccessType(String string, int n2) throws MalformedURLException {
        String string2;
        Object object;
        URL uRL = null;
        String string3 = null;
        switch (n2) {
            case 0: 
            case 1: {
                object = new File(string);
                uRL = ((File)object).toURL();
                break;
            }
            case 2: {
                if (this.resolvingClass == null || (uRL = this.resolvingClass.getResource(string)) != null) break;
                string3 = "Cannot find file relative to resolving class";
                break;
            }
            case 3: {
                uRL = new URL(string);
                break;
            }
            case 4: {
                string2 = this.relativeURLPrefix;
                if (string.charAt(0) != '/') {
                    string2 = string2 + '/';
                }
                string2 = string2 + string;
                uRL = new URL(string2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad access type: " + n2 + " for file: " + string);
            }
        }
        if (uRL == null) {
            object = this.getFileAccessStringFromEnum(n2, true);
            string2 = string3 == null ? "" : " Error:" + string3;
            throw new MalformedURLException("Cannot create URL from:" + string + " for access type:" + (String)object + string2);
        }
        return uRL;
    }

    public InputStream getInputStreamByAccessType(String string, int n2) throws IOException {
        InputStream inputStream = null;
        URL uRL = this.getURLByAccessType(string, n2);
        if (uRL != null) {
            inputStream = uRL.openStream();
        }
        return inputStream;
    }

    public void setLocalEntitySystemId(String string) {
        this.localEntitySystemId = string;
    }

    public String getLocalEntitySystemId() {
        return this.localEntitySystemId;
    }

    public ErrorHandler getXmlErrorHandler() {
        return this.xmlErrorHandler;
    }

    public void setXmlErrorHandler(ErrorHandler errorHandler) {
        this.xmlErrorHandler = errorHandler;
    }

    public LocaleHandler getLocaleHandler() {
        return this.localeHandler;
    }

    public void setLocaleHandler(LocaleHandler localeHandler) {
        this.localeHandler = localeHandler;
    }

    public ResourceBundle getResourceBundle() {
        return this.localeHandler.getBundle();
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.localeHandler = new LocaleBundle(resourceBundle);
    }
}

