/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.internal;

import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.internal.JCEvalManager;
import com.klg.jclass.util.internal.JClassInfo;
import com.klg.jclass.util.swing.JCAlignLayout;
import com.klg.jclass.util.swing.JCBox;
import com.klg.jclass.util.swing.JCBrace;
import com.klg.jclass.util.swing.JCSpring;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public final class JCEvalFrame
extends JFrame
implements Runnable {
    private static final JCEvalFrame EVAL_FRAME = new JCEvalFrame();
    private boolean initialized = false;
    private JPanel expiryPanel = null;
    private JLabel evalLabel = null;
    private JLabel frequencyLabel = null;
    private static final int MINUTE = 60000;
    private int sleepTime = 0;
    private static final String evalNotice = "You are using time-limited, evaluation copies of the following JClass products:";
    private static final String expiredEvalNotice = "At least one JClass product in use has expired.  Please refer to  the table below for more information.";
    private JCBox box = JCBox.createVerticalBox();

    private JCEvalFrame() {
        super("JClass Evaluation Information");
        this.box.setAlignment(0);
        this.expiryPanel = new JPanel();
        this.expiryPanel.setLayout(new JCAlignLayout(3, 5, 5));
        this.expiryPanel.setOpaque(false);
        JCBox jCBox = JCBox.createHorizontalBox();
        jCBox.setOpaque(false);
        jCBox.add(JCSpring.createHorizontalSpring());
        jCBox.add(this.expiryPanel);
        jCBox.add(JCSpring.createHorizontalSpring());
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WindowEvent windowEvent = new WindowEvent(JCEvalFrame.this, 201);
                JCEvalFrame.this.dispatchEvent(windowEvent);
            }
        });
        jButton.setOpaque(false);
        JLabel jLabel = new JLabel("http://www.dell.com", JClassInfo.makeKLIcon((Color)null), 0);
        jLabel.setOpaque(false);
        jLabel.setHorizontalTextPosition(0);
        jLabel.setVerticalTextPosition(3);
        this.box.add(JCBrace.createVerticalBrace(10));
        this.box.add(jLabel);
        this.box.add(JCBrace.createVerticalBrace(10));
        this.evalLabel = new JLabel(evalNotice);
        this.box.add(this.evalLabel);
        this.box.add(JCBrace.createVerticalBrace(10));
        this.box.add(jCBox);
        if (JCEnvironment.isDesignTime()) {
            this.sleepTime = 3600000;
            this.frequencyLabel = new JLabel("This dialog will reappear every hour");
        } else {
            this.sleepTime = 600000;
            this.frequencyLabel = new JLabel("This dialog will reappear every 10 minutes");
        }
        this.box.add(this.frequencyLabel);
        this.box.add(JCBrace.createVerticalBrace(10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("North", this.box);
        JCBox jCBox2 = JCBox.createHorizontalBox();
        jCBox2.setOpaque(false);
        jCBox2.add(JCSpring.createHorizontalSpring());
        jCBox2.add(jButton);
        jCBox2.add(JCSpring.createHorizontalSpring());
        this.getContentPane().add("South", jCBox2);
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosing(WindowEvent windowEvent) {
                JCEvalFrame.this.setVisible(false);
                JCEvalFrame jCEvalFrame = JCEvalFrame.this;
                synchronized (jCEvalFrame) {
                    JCEvalFrame.this.notifyAll();
                }
            }
        });
    }

    public static JCEvalFrame getEvalFrame() {
        return EVAL_FRAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize() {
        JCEvalFrame jCEvalFrame = this;
        synchronized (jCEvalFrame) {
            if (!this.initialized) {
                this.setSize(640, 640);
                Thread thread = new Thread(this);
                thread.start();
                this.initialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (true) {
            this.updateMessage();
            this.setVisible(true);
            this.toFront();
            JCEvalFrame jCEvalFrame = this;
            synchronized (jCEvalFrame) {
                while (this.isVisible()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void updateMessage() {
        Object object;
        int n2;
        String[] stringArray = JClassInfo.getEvalPackageNames();
        String[] stringArray2 = JClassInfo.getEvalServerPackageNames();
        boolean[] blArray = new boolean[stringArray.length];
        boolean[] blArray2 = new boolean[stringArray2.length];
        this.expiryPanel.removeAll();
        this.expiryPanel.add(new JLabel("Product", 0));
        this.expiryPanel.add(new JLabel("Expired", 0));
        this.expiryPanel.add(new JLabel("Expiry Date", 0));
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            if (stringArray2[n2] != null) {
                if (JCEvalManager.isEval(stringArray2[n2])) {
                    bl2 = true;
                    blArray2[n2] = true;
                    continue;
                }
                blArray2[n2] = false;
                continue;
            }
            blArray2[n2] = false;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!blArray2[n2]) {
                if (JCEvalManager.isEval(stringArray[n2])) {
                    bl3 = true;
                    blArray[n2] = true;
                    continue;
                }
                blArray[n2] = false;
                continue;
            }
            blArray[n2] = false;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            boolean bl4;
            if (blArray2[n2]) {
                object = stringArray2[n2];
                bl4 = true;
            } else {
                object = stringArray[n2];
                bl4 = blArray[n2];
            }
            if (!bl4) continue;
            this.expiryPanel.add(new JLabel(JCEvalManager.getProductName((String)object), 0));
            if (JCEvalManager.isExpired((String)object)) {
                bl = true;
            }
            String string = JCEvalManager.isExpired((String)object) ? "Yes" : "No";
            this.expiryPanel.add(new JLabel(string, 0));
            Calendar calendar = JCEvalManager.getExpiry((String)object);
            if (calendar == null) {
                this.expiryPanel.add(new JLabel("Unknown", 0));
                continue;
            }
            DateFormat dateFormat = DateFormat.getDateInstance(1);
            this.expiryPanel.add(new JLabel(dateFormat.format(calendar.getTime()), 0));
        }
        JEditorPane jEditorPane = JCEnvironment.isWorking("HTMLInComponents") == 1 ? new JEditorPane("text/html", JClassInfo.getEvalMessage(bl3, bl2)) : new JEditorPane("text", JClassInfo.getEvalMessageNonHTML(bl3, bl2));
        jEditorPane.setOpaque(false);
        jEditorPane.setEditable(false);
        jEditorPane.setBackground(this.getBackground());
        object = new JScrollPane(jEditorPane);
        ((JScrollPane)object).setVerticalScrollBarPolicy(22);
        ((JComponent)object).setPreferredSize(new Dimension(600, 410));
        this.getContentPane().add("Center", (Component)object);
        if (bl) {
            this.evalLabel.setText(expiredEvalNotice);
            this.sleepTime = 120000;
            this.frequencyLabel.setText("This dialog will reappear every 2 minutes");
            this.evalLabel.revalidate();
            this.frequencyLabel.revalidate();
            Color color = new Color(255, 255, 204);
            this.box.setBackground(color);
            this.getContentPane().setBackground(color);
        }
        this.expiryPanel.revalidate();
    }
}

