/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.graphics;

import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.graphics.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Graphics2DBase
extends Graphics2D
implements Cloneable {
    protected OutputStream os;
    protected boolean finished = false;
    protected Shape clip = new Rectangle2D.Double();
    protected boolean clipSet = false;
    protected AffineTransform transform = new AffineTransform();
    protected Point translation = new Point(0, 0);
    protected boolean underline = false;
    protected boolean subscript = false;
    protected Font currentFont;
    protected Color currentColor;
    protected Stroke currentStroke = new BasicStroke();
    protected boolean dashMode = false;
    protected int windingRule = 1;
    protected boolean fontChanged = true;
    protected boolean colorChanged = true;
    protected boolean strokeChanged = true;
    protected Hashtable<String, String> loadedFonts = new Hashtable();
    protected Buffer out = new Buffer();
    protected int maxDecimalDigits = 4;
    protected DecimalFormat decimalFormat = new DecimalFormat();
    protected boolean isFrameGraphics = false;
    protected Graphics parent = null;
    protected static Map<Graphics, Graphics> contextMap = new Hashtable<Graphics, Graphics>();
    protected boolean isLive = true;
    protected boolean contextUsed = true;
    private Component component = null;
    public static final int NOT_NEEDED = 0;
    public static final int POSSIBLE = 1;
    public static final int NOT_POSSIBLE = 2;
    protected static int storeFontMetricInfo = 0;

    public Graphics2DBase(OutputStream outputStream) {
        this.os = outputStream;
        this.setColor(new Color(0, 0, 0));
        DecimalFormatSymbols decimalFormatSymbols = this.decimalFormat.getDecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        this.decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        this.decimalFormat.setDecimalSeparatorAlwaysShown(true);
        this.decimalFormat.setGroupingUsed(false);
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    protected static int getStoreFontMetricInfo() {
        return storeFontMetricInfo;
    }

    @Override
    public void draw3DRect(int n2, int n3, int n4, int n5, boolean bl) {
        Paint paint = this.getPaint();
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        this.setColor(bl ? color2 : color3);
        this.fillRect(n2, n3, 1, n5 + 1);
        this.fillRect(n2 + 1, n3, n4 - 1, 1);
        this.setColor(bl ? color3 : color2);
        this.fillRect(n2 + 1, n3 + n5, n4, 1);
        this.fillRect(n2 + n4, n3, 1, n5);
        this.setPaint(paint);
    }

    @Override
    public void fill3DRect(int n2, int n3, int n4, int n5, boolean bl) {
        Paint paint = this.getPaint();
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        if (!bl) {
            this.setColor(color3);
        } else if (paint != color) {
            this.setColor(color);
        }
        this.fillRect(n2 + 1, n3 + 1, n4 - 2, n5 - 2);
        this.setColor(bl ? color2 : color3);
        this.fillRect(n2, n3, 1, n5);
        this.fillRect(n2 + 1, n3, n4 - 2, 1);
        this.setColor(bl ? color3 : color2);
        this.fillRect(n2 + 1, n3 + n5 - 1, n4 - 1, 1);
        this.fillRect(n2 + n4 - 1, n3, 1, n5 - 1);
        this.setPaint(paint);
    }

    @Override
    public void draw(Shape shape) {
        if (shape instanceof GeneralPath || shape instanceof Line2D) {
            PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
            this.drawLine(pathIterator);
        } else if (shape instanceof Rectangle2D) {
            this.drawRect((Rectangle2D)shape);
        } else if (shape instanceof RoundRectangle2D) {
            this.drawRoundRect((RoundRectangle2D)shape);
        } else if (shape instanceof Polygon) {
            this.drawPolygon((Polygon)shape);
        } else if (shape instanceof Arc2D) {
            this.drawArc((Arc2D)shape);
        } else if (shape instanceof Ellipse2D) {
            this.drawOval((Ellipse2D)shape);
        }
    }

    @Override
    public void fill(Shape shape) {
        if (shape instanceof GeneralPath || shape instanceof Line2D) {
            this.fillShape(shape);
        } else if (this.isPath2D(shape)) {
            this.fillPath2D(shape);
        } else if (shape instanceof Rectangle2D) {
            this.fillRect((Rectangle2D)shape);
        } else if (shape instanceof RoundRectangle2D) {
            this.fillRoundRect((RoundRectangle2D)shape);
        } else if (shape instanceof Polygon) {
            this.fillPolygon((Polygon)shape);
        } else if (shape instanceof Arc2D) {
            this.fillArc((Arc2D)shape);
        } else if (shape instanceof Ellipse2D) {
            this.fillOval((Ellipse2D)shape);
        }
    }

    private boolean isPath2D(Shape shape) {
        return shape != null && shape.getClass().getName().equals("java.awt.geom.Path2D$Float");
    }

    public int getWindingRuleForPath2D(Shape shape) {
        int n2 = 0;
        try {
            Class<?> clazz = Class.forName("java.awt.geom.Path2D$Float");
            Method method = clazz.getMethod("getWindingRule", null);
            n2 = (Integer)method.invoke((Object)shape, null);
        }
        catch (Exception exception) {
            return 0;
        }
        return n2;
    }

    public void fillPath2D(Shape shape) {
        this.fillShape(shape, true);
    }

    private void fillShape(Shape shape, boolean bl) {
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
        Polygon polygon = GraphicsUtil.getPolygonFromPathIterator(pathIterator);
        this.windingRule = bl ? this.getWindingRuleForPath2D(shape) : ((GeneralPath)shape).getWindingRule();
        this.fillPolygon(polygon);
    }

    public void fillShape(Shape shape) {
        this.fillShape(shape, false);
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return true;
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        this.drawString(attributedCharacterIterator, (float)n2, (float)n3);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        this.doString(attributedCharacterIterator, f2, f3);
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f2, float f3) {
        this.fill(glyphVector.getOutline(f2, f3));
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return true;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    @Override
    public void setComposite(Composite composite) {
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint instanceof Color) {
            this.setColor((Color)paint);
        } else if (paint instanceof GradientPaint) {
            this.setColor(((GradientPaint)paint).getColor1());
        }
    }

    @Override
    public void setStroke(Stroke stroke) {
        if (!this.currentStroke.equals(stroke)) {
            this.currentStroke = stroke;
            this.strokeChanged = true;
        }
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
    }

    @Override
    public void addRenderingHints(Map<?, ?> map) {
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    @Override
    public void translate(int n2, int n3) {
    }

    @Override
    public void translate(double d2, double d3) {
    }

    @Override
    public void rotate(double d2) {
    }

    @Override
    public void rotate(double d2, double d3, double d4) {
    }

    @Override
    public void scale(double d2, double d3) {
    }

    @Override
    public void shear(double d2, double d3) {
    }

    @Override
    public void transform(AffineTransform affineTransform) {
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
    }

    @Override
    public AffineTransform getTransform() {
        return this.transform;
    }

    public AffineTransform getCumulativeTransform() {
        AffineTransform affineTransform = null;
        Graphics2DBase graphics2DBase = this;
        while (graphics2DBase != null) {
            if (graphics2DBase.isFrameGraphics) {
                if (affineTransform == null) {
                    affineTransform = (AffineTransform)graphics2DBase.getTransform().clone();
                } else {
                    affineTransform.preConcatenate(graphics2DBase.getTransform());
                }
            }
            graphics2DBase = (Graphics2DBase)graphics2DBase.parent;
        }
        return affineTransform;
    }

    @Override
    public Paint getPaint() {
        return this.getColor();
    }

    @Override
    public Composite getComposite() {
        return null;
    }

    @Override
    public void setBackground(Color color) {
    }

    @Override
    public Color getBackground() {
        return null;
    }

    @Override
    public Stroke getStroke() {
        return this.currentStroke;
    }

    @Override
    public void clip(Shape shape) {
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(new AffineTransform(), false, false);
    }

    @Override
    public void drawRect(int n2, int n3, int n4, int n5) {
        this.draw(new Rectangle2D.Double(n2, n3, n4, n5));
    }

    @Override
    public void fillRect(int n2, int n3, int n4, int n5) {
        this.fill(new Rectangle2D.Double(n2, n3, n4, n5));
    }

    @Override
    public void fillRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.fill(new RoundRectangle2D.Double(n2, n3, n4, n5, n6, n7));
    }

    @Override
    public void drawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.draw(new RoundRectangle2D.Double(n2, n3, n4, n5, n6, n7));
    }

    @Override
    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.draw(new Arc2D.Double(n2, n3, n4, n5, n6, n7, 2));
    }

    @Override
    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.fill(new Arc2D.Double(n2, n3, n4, n5, n6, n7, 2));
    }

    @Override
    public Graphics create() {
        Graphics2DBase graphics2DBase;
        try {
            graphics2DBase = (Graphics2DBase)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        graphics2DBase.transform = this.isFrameGraphics ? new AffineTransform() : new AffineTransform(this.transform);
        graphics2DBase.clip = this.clip instanceof GeneralPath ? (Shape)((GeneralPath)this.clip).clone() : (this.clip instanceof Rectangle2D ? (Shape)((Rectangle2D)this.clip).clone() : this.clip);
        graphics2DBase.fontChanged = true;
        graphics2DBase.colorChanged = true;
        graphics2DBase.strokeChanged = true;
        graphics2DBase.parent = this;
        graphics2DBase.isFrameGraphics = false;
        graphics2DBase.component = this.component;
        return graphics2DBase;
    }

    @Override
    public Graphics create(int n2, int n3, int n4, int n5) {
        Graphics graphics = this.create();
        graphics.translate(n2, n3);
        graphics.clipRect(0, 0, n4, n5);
        return graphics;
    }

    @Override
    public Color getColor() {
        return this.currentColor;
    }

    @Override
    public void setColor(Color color) {
        if (color == null || !color.equals(this.currentColor)) {
            this.currentColor = color;
            this.colorChanged = true;
        }
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color color) {
    }

    @Override
    public Font getFont() {
        if (this.currentFont == null) {
            this.currentFont = Font.decode("TimesRoman-12");
            this.setFont(this.currentFont);
        }
        return this.currentFont;
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    @Override
    public Rectangle getClipBounds() {
        return this.clip.getBounds();
    }

    @Override
    public void clipRect(int n2, int n3, int n4, int n5) {
    }

    @Override
    public Shape getClip() {
        return this.clip;
    }

    @Override
    public void setClip(int n2, int n3, int n4, int n5) {
        this.setClip(new Rectangle2D.Double(n2, n3, n4, n5));
    }

    @Override
    public void setClip(Shape shape) {
        if (!(shape instanceof Rectangle2D)) {
            throw new IllegalArgumentException("setClip:  only Rectangles are supported");
        }
        Rectangle2D rectangle2D = (Rectangle2D)shape;
        this.setClipPW(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    @Override
    public void clearRect(int n2, int n3, int n4, int n5) {
    }

    @Override
    public void drawOval(int n2, int n3, int n4, int n5) {
        this.draw(new Arc2D.Double(n2, n3, n4, n5, 0.0, 360.0, 1));
    }

    protected void drawOval(Ellipse2D ellipse2D) {
        this.draw(new Arc2D.Double(ellipse2D.getX(), ellipse2D.getY(), ellipse2D.getWidth(), ellipse2D.getHeight(), 0.0, 360.0, 1));
    }

    @Override
    public void fillOval(int n2, int n3, int n4, int n5) {
        this.fill(new Arc2D.Double(n2, n3, n4, n5, 0.0, 360.0, 1));
    }

    protected void fillOval(Ellipse2D ellipse2D) {
        this.fill(new Arc2D.Double(ellipse2D.getX(), ellipse2D.getY(), ellipse2D.getWidth(), ellipse2D.getHeight(), 0.0, 360.0, 1));
    }

    @Override
    public void drawPolygon(Polygon polygon) {
        this.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    @Override
    public void fillPolygon(Polygon polygon) {
        this.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    @Override
    public void drawChars(char[] cArray, int n2, int n3, int n4, int n5) {
        this.drawString(new String(cArray, n2, n3), n4, n5);
    }

    @Override
    public void drawBytes(byte[] byArray, int n2, int n3, int n4, int n5) {
        this.drawString(new String(byArray, n2, n3), n4, n5);
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, image.getWidth(imageObserver), image.getHeight(imageObserver), null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, n4, n5, null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        return true;
    }

    @Override
    public void dispose() {
        Graphics graphics = null;
        Graphics graphics2 = null;
        if (!this.isLive) {
            return;
        }
        Graphics graphics3 = this.getPageRoot();
        Graphics graphics4 = this.getFrameRoot();
        if (contextMap.containsKey(graphics3)) {
            graphics = contextMap.get(graphics3);
        }
        if (graphics == graphics4) {
            if (graphics3 != graphics && contextMap.containsKey(graphics)) {
                graphics2 = contextMap.get(graphics);
            }
            if (this == graphics) {
                if (graphics2 != null && graphics2 != graphics4) {
                    ((Graphics2DBase)graphics2).endContext();
                }
                this.endContext();
                this.removeContext(graphics);
                if (this != graphics3) {
                    contextMap.put(graphics3, this.parent);
                }
            } else if (graphics2 == this) {
                this.endContext();
                contextMap.put(graphics4, graphics4);
            }
        }
        this.component = null;
        this.isLive = false;
    }

    private void removeContext(Graphics graphics) {
        Graphics graphics2;
        if (contextMap.containsKey(graphics) && (graphics2 = contextMap.get(graphics)) != null && graphics2 != graphics) {
            this.removeContext(graphics2);
        }
        contextMap.remove(graphics);
    }

    @Override
    public void finalize() {
        this.dispose();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[font=" + this.getFont() + ",color=" + this.getColor() + "]";
    }

    @Override
    public boolean hitClip(int n2, int n3, int n4, int n5) {
        return true;
    }

    @Override
    public Rectangle getClipBounds(Rectangle rectangle) {
        Rectangle2D rectangle2D = this.clip.getBounds2D();
        rectangle.x = (int)rectangle2D.getX();
        rectangle.y = (int)rectangle2D.getY();
        rectangle.width = (int)rectangle2D.getWidth();
        rectangle.height = (int)rectangle2D.getHeight();
        return rectangle;
    }

    @Override
    public void drawString(String string, int n2, int n3) {
        this.drawString(string, (float)n2, (float)n3);
    }

    @Override
    public void drawLine(int n2, int n3, int n4, int n5) {
        this.draw(new Line2D.Double(n2, n3, n4, n5));
    }

    protected void initializeOutString(float f2, float f3) {
        this.out.x = f2;
        this.out.y = f3;
        this.out.text.delete(0, this.out.text.length());
    }

    protected void output(String string) throws IOException {
        if (this.finished) {
            return;
        }
        this.os.write(string.getBytes());
        this.os.write(10);
    }

    protected void drawLine(PathIterator pathIterator) {
        float[] fArray;
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.currentStroke != null) {
            f2 = ((BasicStroke)this.currentStroke).getDashPhase();
            fArray = ((BasicStroke)this.currentStroke).getDashArray();
            if (fArray != null) {
                for (float f4 : fArray) {
                    f3 += f4;
                }
            }
        }
        while (!pathIterator.isDone()) {
            fArray = new float[6];
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    double_.setLocation(fArray[0], fArray[1]);
                    double_2.setLocation(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    f2 = this.drawLinearSegment(double_, fArray[0], fArray[1], f3, f2);
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    f2 = this.drawQuadraticSegment(double_, fArray[0], fArray[1], fArray[2], fArray[3], f3, f2);
                    break;
                }
                case 4: {
                    f2 = this.drawLinearSegment(double_, double_2.getX(), double_2.getY(), f3, f2);
                }
            }
            pathIterator.next();
        }
    }

    protected float drawLinearSegment(Point2D.Double double_, double d2, double d3, float f2, float f3) {
        this.drawLinePW(double_.getX(), double_.getY(), d2, d3);
        double_.setLocation(d2, d3);
        return f3;
    }

    protected float drawQuadraticSegment(Point2D.Double double_, double d2, double d3, double d4, double d5, float f2, float f3) {
        this.drawQuadraticPW(double_.getX(), double_.getY(), d2, d3, d4, d5);
        double_.setLocation(d4, d5);
        return f3;
    }

    protected void drawRect(Rectangle2D rectangle2D) {
        this.drawRectPW(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    protected void drawArc(Arc2D arc2D) {
        this.drawArcPW(arc2D.getX(), arc2D.getY(), arc2D.getWidth(), arc2D.getHeight(), arc2D.getAngleStart(), arc2D.getAngleExtent(), arc2D.getArcType());
    }

    protected void drawRoundRect(RoundRectangle2D roundRectangle2D) {
        this.drawRoundRectPW(roundRectangle2D.getX(), roundRectangle2D.getY(), roundRectangle2D.getWidth(), roundRectangle2D.getHeight(), roundRectangle2D.getArcWidth(), roundRectangle2D.getArcHeight());
    }

    protected void fillArc(Arc2D arc2D) {
        this.fillArcPW(arc2D.getX(), arc2D.getY(), arc2D.getWidth(), arc2D.getHeight(), arc2D.getAngleStart(), arc2D.getAngleExtent(), arc2D.getArcType());
    }

    protected void fillRect(Rectangle2D rectangle2D) {
        this.fillRectPW(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    protected void fillRoundRect(RoundRectangle2D roundRectangle2D) {
        this.fillRoundRectPW(roundRectangle2D.getX(), roundRectangle2D.getY(), roundRectangle2D.getWidth(), roundRectangle2D.getHeight(), roundRectangle2D.getArcWidth(), roundRectangle2D.getArcHeight());
    }

    protected void doAttributes(AttributedCharacterIterator attributedCharacterIterator) {
        this.underline = false;
        this.subscript = false;
        Set<AttributedCharacterIterator.Attribute> set = attributedCharacterIterator.getAttributes().keySet();
        for (AttributedCharacterIterator.Attribute attribute : set) {
            Object object;
            TextAttribute textAttribute = (TextAttribute)attribute;
            if (textAttribute.equals(TextAttribute.FONT)) {
                object = (Font)attributedCharacterIterator.getAttributes().get(textAttribute);
                this.setFont((Font)object);
                continue;
            }
            if (textAttribute.equals(TextAttribute.UNDERLINE)) {
                object = attributedCharacterIterator.getAttributes().get(textAttribute);
                if (object != TextAttribute.UNDERLINE_ON) continue;
                this.underline = true;
                continue;
            }
            if (textAttribute.equals(TextAttribute.SUPERSCRIPT)) {
                object = attributedCharacterIterator.getAttributes().get(textAttribute);
                if (object == TextAttribute.SUPERSCRIPT_SUPER) {
                    // empty if block
                }
                this.subscript = true;
                continue;
            }
            if (textAttribute.equals(TextAttribute.SIZE)) {
                Font font;
                object = attributedCharacterIterator.getAttributes().get(textAttribute);
                if (object instanceof Integer) {
                    int n2 = (Integer)object;
                    font = this.getFont().deriveFont(this.getFont().getStyle(), n2);
                } else if (object instanceof Float) {
                    float f2 = ((Float)object).floatValue();
                    font = this.getFont().deriveFont(this.getFont().getStyle(), f2);
                } else {
                    System.out.println("Unknown type for attribute SIZE");
                    return;
                }
                this.setFont(font);
                continue;
            }
            object = "only FONT/SIZE/UNDERLINE/SUPERSCRIPT supported";
            throw new RuntimeException((String)object);
        }
    }

    protected void doString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        StringBuffer stringBuffer = new StringBuffer(attributedCharacterIterator.getEndIndex());
        char c2 = attributedCharacterIterator.first();
        while (c2 != '\uffff') {
            if (attributedCharacterIterator.getIndex() == attributedCharacterIterator.getRunStart()) {
                if (stringBuffer.length() > 0) {
                    this.drawString(stringBuffer.toString(), f2, f3);
                    FontMetrics fontMetrics = this.getFontMetrics();
                    f2 = (float)((double)f2 + fontMetrics.getStringBounds(stringBuffer.toString(), this).getWidth());
                    stringBuffer.delete(0, stringBuffer.length());
                }
                this.doAttributes(attributedCharacterIterator);
            }
            stringBuffer.append(c2);
            c2 = attributedCharacterIterator.next();
        }
        this.drawString(stringBuffer.toString(), f2, f3);
        this.underline = false;
        this.subscript = false;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.os = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public void setMaxDecimalDigits(int n2) {
        this.maxDecimalDigits = n2;
    }

    public int getMaxDecimalDigits() {
        return this.maxDecimalDigits;
    }

    public String truncateDecimalDigits(double d2) {
        this.decimalFormat.setMaximumFractionDigits(this.maxDecimalDigits);
        String string = this.decimalFormat.format(d2);
        return "-0.".equals(string) ? "0." : string;
    }

    public String truncateDecimalDigits(float f2) {
        this.decimalFormat.setMaximumFractionDigits(this.maxDecimalDigits);
        String string = this.decimalFormat.format(f2);
        return "-0.".equals(string) ? "0." : string;
    }

    protected void setWindingRule(int n2) {
        this.windingRule = n2;
    }

    protected int getWindingRule() {
        return this.windingRule;
    }

    protected Graphics getPageRoot() {
        if (this.parent == null) {
            return this;
        }
        return ((Graphics2DBase)this.parent).getPageRoot();
    }

    protected Graphics getFrameRoot() {
        if (this.isFrameGraphics) {
            return this;
        }
        if (this.parent == null) {
            throw new IllegalArgumentException("no frame root for graphics");
        }
        return ((Graphics2DBase)this.parent).getFrameRoot();
    }

    public void setFrameRoot() {
        this.isFrameGraphics = true;
    }

    public boolean isFrameRoot() {
        return this.isFrameGraphics;
    }

    public boolean isContextUsed() {
        return this.contextUsed;
    }

    public void setContextUsed(boolean bl) {
        this.contextUsed = bl;
    }

    protected boolean isContextCurrent() {
        Graphics graphics = this.getPageRoot();
        Graphics graphics2 = this.getFrameRoot();
        if (!contextMap.containsKey(graphics)) {
            return false;
        }
        if (!contextMap.containsKey(graphics2)) {
            return false;
        }
        Graphics graphics3 = contextMap.get(graphics2);
        Graphics graphics4 = contextMap.get(graphics);
        return graphics3 == this && graphics4 == graphics2;
    }

    protected void updateContext() {
        if (!this.isContextUsed()) {
            return;
        }
        Graphics graphics = this.getPageRoot();
        Graphics graphics2 = this.getFrameRoot();
        Graphics graphics3 = null;
        Graphics graphics4 = null;
        if (contextMap.containsKey(graphics) && graphics != (graphics3 = contextMap.get(graphics)) && contextMap.containsKey(graphics3)) {
            graphics4 = contextMap.get(graphics3);
        }
        if (this == graphics4 && graphics2 == graphics3) {
            return;
        }
        if (graphics3 == null) {
            contextMap.put(graphics, graphics2);
            if (this != graphics2) {
                ((Graphics2DBase)graphics2).startContext();
            }
        } else if (graphics2 == graphics3) {
            if (graphics4 != graphics3 && graphics4 != null) {
                ((Graphics2DBase)graphics4).endContext();
            }
        } else {
            if (graphics3 != graphics) {
                int n2;
                int n3;
                Graphics[] graphicsArray = ((Graphics2DBase)graphics2).buildParentArray();
                Graphics[] graphicsArray2 = ((Graphics2DBase)graphics3).buildParentArray();
                for (n3 = 0; n3 < graphicsArray.length && n3 < graphicsArray2.length && graphicsArray[n3] == graphicsArray2[n3]; ++n3) {
                }
                --n3;
                if (graphics4 != graphics3 && graphics4 != null) {
                    ((Graphics2DBase)graphics4).endContext();
                }
                for (n2 = graphicsArray2.length - 1; n2 > n3; --n2) {
                    ((Graphics2DBase)graphicsArray2[n2]).endContext();
                }
                for (n2 = n3 + 1; n2 < graphicsArray.length - 1; ++n2) {
                    ((Graphics2DBase)graphicsArray[n2]).startContext();
                }
            }
            contextMap.put(graphics, graphics2);
        }
        contextMap.put(graphics2, this);
        this.startContext();
        this.colorChanged = true;
        this.fontChanged = true;
        this.strokeChanged = true;
    }

    protected Graphics[] buildParentArray() {
        return this.buildParentArray(1);
    }

    protected Graphics[] buildParentArray(int n2) {
        Graphics[] graphicsArray;
        if (this.parent != null) {
            graphicsArray = ((Graphics2DBase)this.parent).buildParentArray(n2 + 1);
            graphicsArray[graphicsArray.length - n2] = this;
        } else {
            graphicsArray = new Graphics[n2];
            graphicsArray[0] = this;
        }
        return graphicsArray;
    }

    public boolean isFinishedOutput() {
        return this.finished;
    }

    public void setFinishedOutput(boolean bl) {
        this.finished = bl;
    }

    public abstract Graphics newGraphics();

    public abstract void setClipPW(double var1, double var3, double var5, double var7);

    public abstract void drawLinePW(double var1, double var3, double var5, double var7);

    public void drawQuadraticPW(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.drawLinePW(d2, d3, d6, d7);
    }

    public abstract void drawRectPW(double var1, double var3, double var5, double var7);

    public abstract void fillRectPW(double var1, double var3, double var5, double var7);

    public abstract void drawRoundRectPW(double var1, double var3, double var5, double var7, double var9, double var11);

    public abstract void fillRoundRectPW(double var1, double var3, double var5, double var7, double var9, double var11);

    public abstract void fillArcPW(double var1, double var3, double var5, double var7, double var9, double var11, int var13);

    public abstract void drawArcPW(double var1, double var3, double var5, double var7, double var9, double var11, int var13);

    public abstract void startContext();

    public abstract void endContext();

    static {
        int n2 = JCEnvironment.getJavaVersion();
        storeFontMetricInfo = n2 >= 150 ? 2 : 0;
    }

    protected class Buffer {
        public StringBuffer text = new StringBuffer();
        public int size;
        public double width;
        public double x;
        public double y;

        protected Buffer() {
        }
    }
}

