/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;

public class MathVector
extends MathValue {
    protected Number[] realValues = null;
    protected int size = 0;

    public MathVector() {
        int n2;
        this.size = n2 = 3;
        this.realValues = new Number[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.realValues[i2] = new Double(0.0);
        }
    }

    public MathVector(double[] dArray) {
        this.size = dArray.length;
        this.realValues = new Number[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.realValues[i2] = new Double(dArray[i2]);
        }
    }

    public MathVector(int[] nArray) {
        this.size = nArray.length;
        this.realValues = new Number[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.realValues[i2] = new Integer(nArray[i2]);
        }
    }

    public MathVector(Number[] numberArray) {
        this.size = numberArray.length;
        this.realValues = new Number[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.realValues[i2] = this.cloneNumber(numberArray[i2]);
        }
    }

    public Number numberValue() {
        throw new UnsupportedOperationException("Can't return a vector as a scalar");
    }

    public Number[] vectorValue() {
        return this.realValues;
    }

    public Number[][] matrixValue() {
        throw new UnsupportedOperationException("Can't return a vector as a matrix");
    }

    public Expression getValueAt(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new ArrayIndexOutOfBoundsException("MathVector index " + n2 + " is out of range [0.." + (this.size - 1) + "]");
        }
        return new MathScalar(this.realValues[n2]);
    }

    public void setValueAt(int n2, Number number) {
        if (n2 < 0 || n2 >= this.size) {
            throw new ArrayIndexOutOfBoundsException("MathVector index " + n2 + " is out of range [0.." + (this.size - 1) + "]");
        }
        this.realValues[n2] = this.cloneNumber(number);
    }

    private Number cloneNumber(Number number) {
        if (number instanceof Integer) {
            return new Integer(number.intValue());
        }
        return new Double(number.doubleValue());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("( ");
        for (int i2 = 0; i2 < this.size; ++i2) {
            stringBuffer.append(this.realValues[i2].toString());
            stringBuffer.append(" ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

