/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;

public class MathMatrix
extends MathValue {
    protected Number[][] realValues = null;
    protected int rows = 0;
    protected int columns = 0;

    public MathMatrix() {
        int n2;
        this.rows = n2 = 3;
        this.columns = n2;
        this.realValues = new Number[n2][n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                this.realValues[i2][i3] = new Double(0.0);
            }
        }
    }

    public MathMatrix(double[][] dArray) {
        int n2;
        this.rows = dArray.length;
        for (n2 = 0; n2 < this.rows; ++n2) {
            if (dArray[n2].length <= this.columns) continue;
            this.columns = dArray[n2].length;
        }
        this.realValues = new Number[this.rows][this.columns];
        for (n2 = 0; n2 < this.rows; ++n2) {
            int n3;
            for (n3 = 0; n3 < dArray[n2].length; ++n3) {
                this.realValues[n2][n3] = new Double(dArray[n2][n3]);
            }
            if (dArray[n2].length >= this.columns) continue;
            for (n3 = dArray[n2].length; n3 < this.columns; ++n3) {
                this.realValues[n2][n3] = new Double(0.0);
            }
        }
    }

    public MathMatrix(int[][] nArray) {
        int n2;
        this.rows = nArray.length;
        for (n2 = 0; n2 < this.rows; ++n2) {
            if (nArray[n2].length <= this.columns) continue;
            this.columns = nArray[n2].length;
        }
        this.realValues = new Number[this.rows][this.columns];
        for (n2 = 0; n2 < this.rows; ++n2) {
            int n3;
            for (n3 = 0; n3 < nArray[n2].length; ++n3) {
                this.realValues[n2][n3] = new Integer(nArray[n2][n3]);
            }
            if (nArray[n2].length >= this.columns) continue;
            for (n3 = nArray[n2].length; n3 < this.columns; ++n3) {
                this.realValues[n2][n3] = new Integer(0);
            }
        }
    }

    public MathMatrix(Number[][] numberArray) {
        int n2;
        this.rows = numberArray.length;
        for (n2 = 0; n2 < this.rows; ++n2) {
            if (numberArray[n2].length <= this.columns) continue;
            this.columns = numberArray[n2].length;
        }
        this.realValues = new Number[this.rows][this.columns];
        for (n2 = 0; n2 < this.rows; ++n2) {
            int n3;
            for (n3 = 0; n3 < numberArray[n2].length; ++n3) {
                this.realValues[n2][n3] = this.cloneNumber(numberArray[n2][n3]);
            }
            if (numberArray[n2].length >= this.columns) continue;
            for (n3 = numberArray[n2].length; n3 < this.columns; ++n3) {
                this.realValues[n2][n3] = new Integer(0);
            }
        }
    }

    public Number numberValue() {
        throw new UnsupportedOperationException("Can't return a matrix as a scalar");
    }

    public Number[] vectorValue() {
        throw new UnsupportedOperationException("Can't return a matrix as a vector");
    }

    public Number[][] matrixValue() {
        return this.realValues;
    }

    public Expression getValueAt(int n2, int n3) {
        if (n2 < 0 || n2 >= this.rows) {
            throw new ArrayIndexOutOfBoundsException("MathMatrix index " + n2 + " is out of range [0.." + (this.rows - 1) + "]");
        }
        if (n3 < 0 || n3 >= this.columns) {
            throw new ArrayIndexOutOfBoundsException("MathMatrix index " + n3 + " is out of range [0.." + (this.columns - 1) + "]");
        }
        return new MathScalar(this.realValues[n2][n3]);
    }

    public void setValueAt(int n2, int n3, Number number) {
        if (n2 < 0 || n2 >= this.rows) {
            throw new ArrayIndexOutOfBoundsException("MathMatrix index " + n2 + " is out of range [0.." + (this.rows - 1) + "]");
        }
        if (n3 < 0 || n3 >= this.columns) {
            throw new ArrayIndexOutOfBoundsException("MathMatrix index " + n3 + " is out of range [0.." + (this.columns - 1) + "]");
        }
        this.realValues[n2][n3] = this.cloneNumber(number);
    }

    private Number cloneNumber(Number number) {
        if (number instanceof Integer) {
            return new Integer(number.intValue());
        }
        return new Double(number.doubleValue());
    }

    public String toString() {
        int n2;
        int n3 = 0;
        int[] nArray = new int[this.rows];
        String string = "                         ";
        StringBuffer[] stringBufferArray = new StringBuffer[this.rows];
        for (n2 = 0; n2 < this.rows; ++n2) {
            stringBufferArray[n2] = new StringBuffer();
        }
        for (int i2 = this.columns - 1; i2 >= 0; --i2) {
            for (n2 = 0; n2 < this.rows; ++n2) {
                stringBufferArray[n2].insert(0, this.realValues[n2][i2].toString());
                nArray[n2] = stringBufferArray[n2].length();
                if (nArray[n2] <= n3) continue;
                n3 = nArray[n2];
            }
            for (n2 = 0; n2 < this.rows; ++n2) {
                int n4 = n3 - nArray[n2] + 1;
                stringBufferArray[n2].insert(0, string.substring(0, n4));
            }
        }
        for (n2 = 0; n2 < this.rows; ++n2) {
            stringBufferArray[n2].insert(0, "|");
            stringBufferArray[n2].append(" |\n");
        }
        StringBuffer stringBuffer = new StringBuffer("--");
        while (stringBuffer.length() + string.length() < n3 + 2) {
            stringBuffer.append(string);
        }
        stringBuffer.append(string.substring(0, n3 + 2 - stringBuffer.length()));
        stringBuffer.append("--");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(stringBuffer);
        stringBuffer2.append("\n");
        for (n2 = 0; n2 < this.rows; ++n2) {
            stringBuffer2.append(stringBufferArray[n2]);
        }
        stringBuffer2.append(stringBuffer);
        return stringBuffer2.toString();
    }
}

