/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.Result;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.WeakHashMap;

public class ExpressionVariable
implements Expression,
Cloneable {
    protected String name;
    private WeakReference ctxRef;
    protected Expression value;
    private static WeakHashMap contextMap = new WeakHashMap();

    private ExpressionVariable(Object object, String string, Expression expression) {
        this.ctxRef = new WeakReference<Object>(object);
        this.name = new String(string);
        this.value = expression;
    }

    public static ExpressionVariable createVariable(Object object, String string) {
        return ExpressionVariable.getVariable(object, string);
    }

    private static HashMap getContextMap(Object object) {
        HashMap hashMap = (HashMap)contextMap.get(object);
        if (hashMap == null) {
            hashMap = new HashMap();
            contextMap.put(object, hashMap);
        }
        return hashMap;
    }

    public static ExpressionVariable setVariable(Object object, String string, Expression expression) {
        ExpressionVariable expressionVariable = ExpressionVariable.getVariable(object, string);
        expressionVariable.setValue(expression);
        return expressionVariable;
    }

    public static ExpressionVariable getVariable(Object object, String string) {
        HashMap hashMap = ExpressionVariable.getContextMap(object);
        ExpressionVariable expressionVariable = (ExpressionVariable)hashMap.get(string);
        if (expressionVariable == null) {
            expressionVariable = new ExpressionVariable(object, string, null);
            hashMap.put(string, expressionVariable);
        }
        return expressionVariable;
    }

    public Result evaluate() {
        if (this.value == null) {
            throw new ArithmeticException("Undefined variable \"" + this.name + "\" in context " + this.getContext());
        }
        return this.value.evaluate();
    }

    public void setValue(Expression expression) {
        this.value = expression;
    }

    public Expression getValue() {
        return this.value;
    }

    public Object getContext() {
        return this.ctxRef.get();
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.getContext().hashCode() * 31 + this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ExpressionVariable)) {
            return false;
        }
        ExpressionVariable expressionVariable = (ExpressionVariable)object;
        return expressionVariable.getContext() == this.getContext() && this.name.equals(expressionVariable.name);
    }

    public Object clone() {
        return this;
    }
}

