/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.JCLocaleManager;
import com.klg.jclass.util.calendar.CalendarComponent;
import com.klg.jclass.util.calendar.JCCalendar;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class MonthTable
extends JTable
implements CalendarComponent,
MouseListener {
    transient JCLocaleManager li = JCLocaleManager.getDefault();
    protected Locale locale = null;
    protected int tableCellWidth = 0;
    protected JCValueModel calendarModel;
    protected MonthModel monthModel;
    protected int selectedMonth = 0;
    protected String[] months = null;
    protected boolean userSetMonths = false;
    protected JCListenerList actionListeners = null;

    public MonthTable(JCValueModel jCValueModel, Locale locale) {
        this(jCValueModel, locale, null);
    }

    public MonthTable(JCValueModel jCValueModel, Locale locale, String[] stringArray) {
        this.months = stringArray;
        if (this.months != null) {
            this.userSetMonths = true;
        }
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setDefaultRenderer(String.class, new Renderer());
        this.setLocale(locale);
        this.setCalendarModel(jCValueModel);
        this.addMouseListener(this);
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.locale == locale) {
            return;
        }
        this.firePropertyChange("locale", this.locale, locale);
        this.locale = locale;
        if (this.monthModel != null && this.calendarModel != null) {
            this.calendarModel.removeValueListener(this.monthModel);
        }
        this.monthModel = new MonthModel(this.locale);
        if (this.calendarModel != null) {
            this.calendarModel.addValueListener(this.monthModel);
        }
        this.setModel(this.monthModel);
        this.adjustSize();
        this.repaint();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.adjustSize();
    }

    public void setCalendarModel(JCValueModel jCValueModel) {
        if (jCValueModel == null || jCValueModel.getValueClass() != Calendar.class) {
            throw new IllegalArgumentException("Model's value class must be of type Calendar.");
        }
        if (this.monthModel != null && this.calendarModel != null) {
            this.calendarModel.removeValueListener(this.monthModel);
        }
        this.calendarModel = jCValueModel;
        this.calendarModel.addValueListener(this.monthModel);
        this.repaint();
    }

    public JCValueModel getCalendarModel() {
        return this.calendarModel;
    }

    public void setSpecialDates(JCCalendar jCCalendar) {
    }

    public JCCalendar getSpecialDates(JCCalendar jCCalendar) {
        return this.getSpecialDates();
    }

    public JCCalendar getSpecialDates() {
        return null;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.add(this.actionListeners, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.remove(this.actionListeners, actionListener);
    }

    public void addNotify() {
        super.addNotify();
        this.adjustSize();
    }

    protected void adjustSize() {
        this.calculateCellSize();
        this.setPreferredSize(new Dimension(this.tableCellWidth * 6, this.getRowHeight() * 2));
    }

    protected void calculateCellSize() {
        TableColumn tableColumn;
        TableModel tableModel = this.getModel();
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (tableModel == null || tableColumnModel == null || this.calendarModel == null) {
            return;
        }
        this.tableCellWidth = 0;
        int n2 = 0;
        for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
            tableColumn = tableColumnModel.getColumn(i2);
            TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
            if (tableCellRenderer == null) {
                Class<?> clazz = tableModel.getColumnClass(i2);
                tableCellRenderer = this.getDefaultRenderer(clazz);
            }
            for (int i3 = 0; i3 < this.getRowCount(); ++i3) {
                Object object = tableModel.getValueAt(i3, i2);
                Component component = tableCellRenderer.getTableCellRendererComponent(this, object, false, false, i3, i2);
                Dimension dimension = component.getPreferredSize();
                this.tableCellWidth = Math.max(this.tableCellWidth, dimension.width);
                n2 = Math.max(n2, dimension.height);
            }
        }
        this.setRowHeight(n2);
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            tableColumn = enumeration.nextElement();
            tableColumn.setMinWidth(this.tableCellWidth);
            if (JCEnvironment.getJavaVersion() >= 130) continue;
            tableColumn.setWidth(this.tableCellWidth);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.tableCellWidth * 6, this.getRowHeight() * 2);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n2 = this.rowAtPoint(mouseEvent.getPoint());
        int n3 = this.columnAtPoint(mouseEvent.getPoint());
        int n4 = n2 * 6 + n3;
        Calendar calendar = JCCalendar.copyCalendar((Calendar)this.calendarModel.getValue());
        calendar.set(2, n4);
        this.calendarModel.setValue(calendar);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MonthModel
    implements TableModel,
    JCValueListener,
    Serializable {
        protected JCListenerList tableListeners = null;
        protected int numRows = 2;

        public MonthModel(Locale locale) {
            if (!MonthTable.this.userSetMonths) {
                MonthTable.this.months = JCCalendar.getMonths(locale, true);
            }
        }

        @Override
        public int getRowCount() {
            return this.numRows;
        }

        @Override
        public int getColumnCount() {
            return MonthTable.this.months.length / this.numRows;
        }

        @Override
        public String getColumnName(int n2) {
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n2) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            return false;
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            return MonthTable.this.months[n3 + n2 * this.getColumnCount()];
        }

        @Override
        public void setValueAt(Object object, int n2, int n3) {
            throw new IllegalArgumentException("This TableModel is READ ONLY");
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
            this.tableListeners = JCListenerList.add(this.tableListeners, tableModelListener);
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.tableListeners = JCListenerList.remove(this.tableListeners, tableModelListener);
        }

        @Override
        public void valueChanging(JCValueEvent jCValueEvent) {
        }

        @Override
        public void valueChanged(JCValueEvent jCValueEvent) {
            if (jCValueEvent == null) {
                return;
            }
            TableModelEvent tableModelEvent = new TableModelEvent(this);
            Enumeration<Object> enumeration = JCListenerList.elements(this.tableListeners);
            while (enumeration.hasMoreElements()) {
                TableModelListener tableModelListener = (TableModelListener)enumeration.nextElement();
                tableModelListener.tableChanged(tableModelEvent);
            }
        }
    }

    protected class Renderer
    extends JLabel
    implements TableCellRenderer {
        protected Border bevel = new SoftBevelBorder(1);
        protected Border empty = new EmptyBorder(0, 0, 0, 0);

        protected Renderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
            this.setHorizontalAlignment(0);
            this.setFont(jTable.getFont());
            Calendar calendar = (Calendar)MonthTable.this.calendarModel.getValue();
            int n4 = calendar.get(2);
            if (n4 == n3 + n2 * MonthTable.this.getColumnCount()) {
                this.setForeground(UIManager.getColor("TextField.selectionForeground"));
                this.setBackground(UIManager.getColor("TextField.selectionBackground"));
                this.setBorder(this.bevel);
                this.setOpaque(true);
            } else {
                this.setBackground(UIManager.getColor("Label.background"));
                this.setForeground(UIManager.getColor("Label.foreground"));
                this.setBorder(this.empty);
                this.setOpaque(true);
            }
            this.setText((String)object);
            return this;
        }
    }
}

