/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.calendar.SpecialDate;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCCalendar {
    protected Vector<SpecialDate> specialDates = new Vector(0);
    protected static final byte[][] daytable = new byte[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};

    public static boolean isLeapYear(int n2) {
        boolean bl = false;
        if (n2 % 100 == 0) {
            if (n2 % 400 == 0) {
                bl = true;
            }
        } else if (n2 % 4 == 0) {
            bl = true;
        }
        return bl;
    }

    public static int dayOfWeek(int n2, int n3, int n4) {
        if (n3 == 0 || n3 == 1) {
            --n4;
        }
        int n5 = n4 % 100;
        int n6 = n4 / 100;
        int n7 = (n3 + 10) % 12 + 1;
        int n8 = (int)((double)n2 + Math.floor(2.6 * (double)n7 - 0.2) - (double)(2 * n6) + (double)n5 + Math.floor(n5 / 4) + Math.floor(n6 / 4)) % 7;
        n8 = (n8 + 7) % 7;
        return n8;
    }

    public static int daysInMonth(int n2, int n3) {
        int n4 = JCCalendar.isLeapYear(n3) ? 1 : 0;
        return daytable[n4][n2];
    }

    protected static String[] processArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n2 = 0;
        for (String string : stringArray) {
            if (string == null || string.length() <= 0) continue;
            ++n2;
        }
        String[] stringArray2 = new String[n2];
        n2 = 0;
        for (String string : stringArray) {
            if (string == null || string.length() <= 0) continue;
            stringArray2[n2] = string;
            ++n2;
        }
        return stringArray2;
    }

    public static String[] getDays(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        return JCCalendar.processArray(dateFormatSymbols.getShortWeekdays());
    }

    public static String[] getMonths(Locale locale, boolean bl) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        String[] stringArray = bl ? dateFormatSymbols.getShortMonths() : dateFormatSymbols.getMonths();
        return JCCalendar.processArray(stringArray);
    }

    public void addSpecialDate(SpecialDate specialDate) {
        this.specialDates.add(specialDate);
    }

    public void removeSpecialDate(SpecialDate specialDate) {
        this.specialDates.remove(specialDate);
    }

    public boolean isSpecialDate(int n2, int n3, int n4, int n5) {
        return this.isInSpecialDateList(n2, n3, n4, n5) >= 0;
    }

    public boolean isSpecialDate(Calendar calendar) {
        return this.isSpecialDate(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(4));
    }

    protected int isInSpecialDateList(int n2, int n3, int n4, int n5) {
        for (int i2 = 0; i2 < this.specialDates.size(); ++i2) {
            SpecialDate specialDate = this.specialDates.elementAt(i2);
            if (!specialDate.isSpecialDate(n2, n3, n4, n5)) continue;
            return i2;
        }
        return -1;
    }

    public static Calendar copyCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return (Calendar)calendar.clone();
    }

    public static Calendar convertObjectToCalendar(Object object, Locale locale) {
        if (object instanceof Calendar) {
            return (Calendar)object;
        }
        if (object instanceof Date) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            Calendar calendar = Calendar.getInstance(locale);
            calendar.setTime((Date)object);
            return calendar;
        }
        return null;
    }

    public static Object convertCalendarToObject(Calendar calendar, Class<?> clazz) {
        if (calendar == null || clazz == null) {
            return null;
        }
        String string = clazz.getName();
        long l2 = calendar.getTime().getTime();
        if (string.equals("java.util.Date")) {
            return new Date(l2);
        }
        if (string.equals("java.sql.Time")) {
            return new Time(l2);
        }
        if (string.equals("java.sql.Timestamp")) {
            return new Timestamp(l2);
        }
        if (string.equals("java.sql.Date")) {
            return new java.sql.Date(l2);
        }
        if (string.equals("java.util.Calendar") || string.equals("java.util.GregorianCalendar")) {
            return calendar;
        }
        return null;
    }

    public class MonthWeekDayOfWeek
    implements SpecialDate {
        public int month;
        public int week;
        public int day_of_week;

        public MonthWeekDayOfWeek(int n2, int n3, int n4) {
            this.month = n2;
            this.week = n3;
            this.day_of_week = n4;
        }

        public boolean isSpecialDate(int n2, int n3, int n4, int n5) {
            int n6 = JCCalendar.dayOfWeek(n4, n3, n2);
            return this.month == n3 && this.day_of_week == n6 && this.week == n5;
        }
    }

    public static class MonthDayOfMonth
    implements SpecialDate {
        public int month;
        public int day_of_month;

        public MonthDayOfMonth(int n2, int n3) {
            this.month = n2;
            this.day_of_month = n3;
        }

        public boolean isSpecialDate(int n2, int n3, int n4, int n5) {
            return this.month == n3 && this.day_of_month == n4;
        }
    }

    public static class DayOfWeek
    implements SpecialDate {
        public int day_of_week;

        public DayOfWeek(int n2) {
            if (n2 < 0 || n2 > 6) {
                throw new IllegalArgumentException("invalid value for dayOfWeek");
            }
            this.day_of_week = n2;
        }

        public boolean isSpecialDate(int n2, int n3, int n4, int n5) {
            int n6 = JCCalendar.dayOfWeek(n4, n3, n2);
            return this.day_of_week == n6;
        }
    }

    public static class DateMonthYear
    implements SpecialDate {
        public int year;
        public int month;
        public int date;

        public DateMonthYear(int n2, int n3, int n4) {
            this.year = n4;
            this.month = n3;
            this.date = n2;
        }

        public DateMonthYear(Calendar calendar) {
            this(calendar.get(5), calendar.get(2), calendar.get(1));
        }

        public DateMonthYear(Date date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            this.year = calendar.get(1);
            this.month = calendar.get(2);
            this.date = calendar.get(5);
        }

        public boolean isSpecialDate(int n2, int n3, int n4, int n5) {
            return this.year == n2 && this.month == n3 && this.date == n4;
        }
    }
}

