/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.calendar.CalendarComponent;
import com.klg.jclass.util.calendar.JCCalendar;
import com.klg.jclass.util.value.CalendarValueModel;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.JPanel;

public class CalendarContainer
extends JPanel
implements CalendarComponent,
ContainerListener,
ActionListener {
    protected boolean initialized = true;
    protected JCValueModel model;
    protected JCCalendar specialDates;
    protected Locale locale;
    protected JCListenerList actionListeners = null;
    protected Font userFont = null;

    public CalendarContainer() {
        this.setLocale(Locale.getDefault());
        this.addContainerListener(this);
    }

    public void setCalendarModel(JCValueModel jCValueModel) {
        Component[] componentArray;
        if (this.model == jCValueModel) {
            return;
        }
        this.firePropertyChange("calendarmodel", this.model, jCValueModel);
        this.model = jCValueModel;
        for (Component component : componentArray = this.getComponents()) {
            if (!(component instanceof CalendarComponent)) continue;
            ((CalendarComponent)((Object)component)).setCalendarModel(jCValueModel);
        }
    }

    public JCValueModel getCalendarModel() {
        return this.model;
    }

    public void setSpecialDates(JCCalendar jCCalendar) {
        Component[] componentArray;
        if (this.specialDates == jCCalendar) {
            return;
        }
        this.firePropertyChange("specialdates", this.specialDates, jCCalendar);
        this.specialDates = jCCalendar;
        for (Component component : componentArray = this.getComponents()) {
            if (!(component instanceof CalendarComponent)) continue;
            ((CalendarComponent)((Object)component)).setSpecialDates(jCCalendar);
        }
    }

    public void setLocale(Locale locale) {
        Component[] componentArray;
        if (this.locale == locale) {
            return;
        }
        if (locale == null) {
            throw new IllegalArgumentException("null is an invalid value for locale");
        }
        this.firePropertyChange("locale", this.locale, locale);
        this.locale = locale;
        for (Component component : componentArray = this.getComponents()) {
            if (!(component instanceof CalendarComponent)) continue;
            component.setLocale(locale);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.userFont = font;
        if (this.initialized) {
            Component[] componentArray;
            for (Component component : componentArray = this.getComponents()) {
                if (!(component instanceof CalendarComponent)) continue;
                component.setFont(font);
            }
        }
    }

    public Font getUserFont() {
        return this.userFont;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.add(this.actionListeners, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.remove(this.actionListeners, actionListener);
    }

    public void componentAdded(ContainerEvent containerEvent) {
        if (containerEvent.getChild() instanceof CalendarComponent) {
            CalendarComponent calendarComponent = (CalendarComponent)((Object)containerEvent.getChild());
            calendarComponent.setLocale(this.locale);
            calendarComponent.addActionListener(this);
            if (this.model == null) {
                this.model = new CalendarValueModel(Calendar.getInstance(this.locale));
            }
            calendarComponent.setCalendarModel(this.model);
            calendarComponent.setSpecialDates(this.specialDates);
        }
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        if (containerEvent.getChild() instanceof CalendarComponent) {
            CalendarComponent calendarComponent = (CalendarComponent)((Object)containerEvent.getChild());
            calendarComponent.removeActionListener(this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ActionEvent actionEvent2 = new ActionEvent(this, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getModifiers());
        Enumeration<Object> enumeration = JCListenerList.elements(this.actionListeners);
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed(actionEvent2);
        }
    }
}

