/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

public abstract class OS {
    private static final OS[] list = new OS[]{new Windows(), new Windows9x(), new Solaris(), new Linux(), new AIX(), new HPUX(), new OS390(), new MacOsX()};
    private static final OS unsupported = new Unsupported();

    public static OS getCurrent() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.version").toLowerCase();
        for (OS oS : list) {
            if (!oS.matches(string, string2)) continue;
            return oS;
        }
        return unsupported;
    }

    public abstract String getName();

    public abstract boolean matches(String var1, String var2);

    public abstract String[] getCopyCommandArray(String var1, String var2);

    public abstract String[] getPrnFileCommandArray(String var1, String var2);

    public String toString() {
        return this.getName();
    }

    static class MacOsX
    extends Unix {
        MacOsX() {
        }

        public String getName() {
            return "macosx";
        }

        public boolean matches(String string, String string2) {
            if (string.indexOf("mac") != -1) {
                try {
                    int n2 = Integer.parseInt(string2.substring(0, string2.indexOf(46)));
                    if (n2 >= 10) {
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    static class OS390
    extends Unix {
        OS390() {
        }

        public String getName() {
            return "os/390";
        }

        public boolean matches(String string, String string2) {
            return string.indexOf("z/os") != -1 || string.indexOf("os/390") != -1;
        }
    }

    static class HPUX
    extends Unix {
        HPUX() {
        }

        public String getName() {
            return "hpux";
        }

        public boolean matches(String string, String string2) {
            return string.indexOf("hpux") != -1 || string.indexOf("hp-ux") != -1;
        }
    }

    static class AIX
    extends Unix {
        AIX() {
        }

        public String getName() {
            return "aix";
        }

        public boolean matches(String string, String string2) {
            return string.indexOf("aix") != -1;
        }
    }

    static class Linux
    extends Unix {
        Linux() {
        }

        public String getName() {
            return "linux";
        }

        public boolean matches(String string, String string2) {
            return string.indexOf("linux") != -1;
        }
    }

    static class Solaris
    extends Unix {
        Solaris() {
        }

        public String getName() {
            return "solaris";
        }

        public boolean matches(String string, String string2) {
            return string.indexOf("sunos") != -1 || string.indexOf("solaris") != -1;
        }
    }

    static abstract class Unix
    extends OS {
        Unix() {
        }

        public String[] getCopyCommandArray(String string, String string2) {
            String[] stringArray = new String[]{"/bin/sh", "-c", "cp " + string + " " + string2};
            return stringArray;
        }

        public String[] getPrnFileCommandArray(String string, String string2) {
            String[] stringArray = new String[]{"/bin/sh", "-c", "lpr -P " + string2 + " " + string};
            return stringArray;
        }
    }

    static class Windows9x
    extends OS {
        Windows9x() {
        }

        public String getName() {
            return "windows9x";
        }

        public boolean matches(String string, String string2) {
            return string.indexOf("windows") != -1;
        }

        public String[] getCopyCommandArray(String string, String string2) {
            String[] stringArray = new String[]{"command.com", "/C", "COPY \"" + string + "\" /B \"" + string2 + "\""};
            return stringArray;
        }

        public String[] getPrnFileCommandArray(String string, String string2) {
            return this.getCopyCommandArray(string, string2);
        }
    }

    static class Windows
    extends OS {
        Windows() {
        }

        public String getName() {
            return "windows";
        }

        public boolean matches(String string, String string2) {
            return string.indexOf("windows") != -1 && (string.indexOf("nt") != -1 || string.indexOf("200") != -1 || string.indexOf("xp") != -1);
        }

        public String[] getCopyCommandArray(String string, String string2) {
            String[] stringArray = new String[]{"cmd.exe", "/C", "COPY \"" + string + "\" /B \"" + string2 + "\""};
            return stringArray;
        }

        public String[] getPrnFileCommandArray(String string, String string2) {
            return this.getCopyCommandArray(string, string2);
        }
    }

    static class Unsupported
    extends OS {
        Unsupported() {
        }

        public String getName() {
            return null;
        }

        public boolean matches(String string, String string2) {
            return false;
        }

        public String[] getCopyCommandArray(String string, String string2) {
            return null;
        }

        public String[] getPrnFileCommandArray(String string, String string2) {
            return null;
        }
    }
}

