/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import com.klg.jclass.util.LocaleHandler;
import com.klg.jclass.util.ServerResourceBundle;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleBundle
implements LocaleHandler,
Serializable {
    private ResourceBundle bundle = null;

    public LocaleBundle(String string, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            this.bundle = ResourceBundle.getBundle(string, locale);
        }
        catch (Exception exception) {
            String string2 = string + "_" + locale.toString() + ".properties";
            InputStream inputStream = this.getClass().getResourceAsStream(string2);
            if (inputStream == null) {
                string2 = string + "_" + locale.getLanguage() + ".properties";
                inputStream = this.getClass().getResourceAsStream(string2);
                if (inputStream == null) {
                    string2 = string + ".properties";
                    inputStream = this.getClass().getResourceAsStream(string2);
                }
            }
            if (inputStream == null) {
                throw new IllegalArgumentException("Cannot create resource bundle from path: " + string);
            }
            try {
                this.bundle = new PropertyResourceBundle(inputStream);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public LocaleBundle(Map<String, ? extends Object> map) {
        this.bundle = new ServerResourceBundle(map);
    }

    public LocaleBundle(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    @Override
    public String string(String string) {
        if (this.bundle != null) {
            return this.bundle.getString(string);
        }
        return string;
    }

    @Override
    public ResourceBundle getBundle() {
        return this.bundle;
    }
}

