/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import com.klg.jclass.util.JCLocaleManager;
import com.klg.jclass.util.codec.ICodec;
import com.klg.jclass.util.graphics.JCFontMetrics;
import com.klg.jclass.util.swing.encode.PNGImageIOEncoder;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCUtil {
    public static final int TRUNCATE_LEFT = 0;
    public static final int TRUNCATE_RIGHT = 1;
    public static final int TRUNCATE_MIDDLE = 2;
    public static final int TRUNCATE_END = 3;
    public static final int TRUNCATE_LEADING = 4;
    public static final int TRUNCATE_TRAILING = 5;
    public static final String ELLIPSIS = "" + JCLocaleManager.getDefault().getString("...");
    public static final String THREE_DOTS = "...";
    public static final String TWO_DOTS = "..";
    public static final String ONE_DOT = ".";
    public static final String DATA_IMAGE_STRING = "data:image/";
    public static final String BASE64_STRING = ";base64";

    public static String getComponentName(Component component) {
        if (component == null) {
            return "null";
        }
        return component.getClass().getName();
    }

    public static URL createURLFromString(String string, String string2) throws MalformedURLException {
        URL uRL;
        if (string == null) {
            return null;
        }
        String string3 = JCUtil.getScheme(string);
        if (string3 != null) {
            uRL = new URL(string);
        } else {
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            uRL = new URL(string2 + string);
        }
        return uRL;
    }

    public static String getScheme(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        int n3 = JCUtil.scan(string, 0, n2, "/?#", ":");
        if (n3 >= 0 && n3 < n2 && string.charAt(n3) == ':') {
            if (n3 == 0 || !Character.isLetter(string.charAt(0))) {
                return null;
            }
            for (int i2 = 1; i2 < n3; ++i2) {
                char c2 = string.charAt(i2);
                if (Character.isLetterOrDigit(c2) || c2 == '+' || c2 == '-' || c2 == '.') continue;
                return null;
            }
            return string.substring(0, n3);
        }
        return null;
    }

    protected static int scan(String string, int n2, int n3, String string2, String string3) {
        int n4;
        for (n4 = n2; n4 < n3; ++n4) {
            char c2 = string.charAt(n4);
            if (string2.indexOf(c2) >= 0) {
                return -1;
            }
            if (string3.indexOf(c2) >= 0) break;
        }
        return n4;
    }

    protected static int calcTruncateMode(Component component, int n2) {
        boolean bl = true;
        if (!component.getComponentOrientation().isLeftToRight()) {
            bl = false;
        }
        switch (n2) {
            case 4: {
                n2 = bl ? 0 : 1;
                break;
            }
            case 5: {
                n2 = bl ? 1 : 0;
            }
        }
        return n2;
    }

    protected static String ellipsisCheck(String string, String string2, int n2, FontMetrics fontMetrics) {
        if (string == null || string2 == null || n2 <= 0 || fontMetrics == null) {
            return string;
        }
        String string3 = string + string2;
        double d2 = JCUtil.getStringWidth(string3, fontMetrics);
        if (d2 <= (double)n2) {
            return string3;
        }
        string3 = string + TWO_DOTS;
        d2 = JCUtil.getStringWidth(string3, fontMetrics);
        if (d2 <= (double)n2) {
            return string3;
        }
        string3 = string + ONE_DOT;
        d2 = JCUtil.getStringWidth(string3, fontMetrics);
        if (d2 <= (double)n2) {
            return string3;
        }
        return string;
    }

    public static String truncateString(Graphics graphics, Component component, String string, int n2, int n3, boolean bl, boolean bl2) {
        if (string == null) {
            String string2 = "Cannot truncate null string.";
            throw new IllegalArgumentException(string2);
        }
        int n4 = string.length();
        if (n4 == 0) {
            return string;
        }
        if (bl2) {
            return string;
        }
        if (graphics == null) {
            return string;
        }
        Font font = graphics.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n5 = fontMetrics.stringWidth(string);
        if (n5 <= n2) {
            return string;
        }
        if (n2 == 0) {
            return "";
        }
        boolean bl3 = component.getComponentOrientation().isLeftToRight();
        n3 = JCUtil.calcTruncateMode(component, n3);
        double d2 = 0.0;
        String string3 = "";
        if (bl) {
            string3 = font.canDisplayUpTo(ELLIPSIS) == -1 ? ELLIPSIS : THREE_DOTS;
            String string4 = JCUtil.ellipsisCheck("", string3, n2, fontMetrics);
            if (!string4.equals(string3)) {
                return string4;
            }
            if (n3 == 3 && !(string4 = JCUtil.ellipsisCheck(string3, string3, n2, fontMetrics)).equals(string3 + string3)) {
                return string4;
            }
            d2 = JCUtil.getStringWidth(string4, fontMetrics);
        }
        switch (n3) {
            case 0: {
                int n6;
                for (n6 = n4 - 1; n6 >= 0 && !((d2 += JCUtil.getCharWidth(string.charAt(n6), fontMetrics)) > (double)n2); --n6) {
                }
                string = string3 + string.substring(n6 + 1, n4);
                break;
            }
            case 1: {
                char c2;
                int n7;
                for (n7 = 0; n7 < n4 && !((d2 += JCUtil.getCharWidth(c2 = string.charAt(n7), fontMetrics)) > (double)n2); ++n7) {
                }
                string = string.substring(0, n7) + string3;
                break;
            }
            case 2: {
                int n8;
                int n9 = 0;
                int n10 = n4 - 1;
                while (n9 <= n10 && !((d2 += JCUtil.getCharWidth(string.charAt(n8 = bl3 ? n9 : n10), fontMetrics)) > (double)n2)) {
                    if (bl3) {
                        ++n9;
                    } else {
                        --n10;
                    }
                    if (n9 > n10 || (d2 += JCUtil.getCharWidth(string.charAt(n8 = bl3 ? n10 : n9), fontMetrics)) > (double)n2) break;
                    if (bl3) {
                        --n10;
                        continue;
                    }
                    ++n9;
                }
                string = string.substring(0, n9) + string3 + string.substring(n10 + 1, n4);
                break;
            }
            case 3: {
                int n11;
                int n12;
                int n13 = (n4 - 1) / 2;
                boolean bl4 = false;
                for (n12 = n4 / 2; n13 >= 0 && n12 < n4 && !((d2 += JCUtil.getCharWidth(string.charAt(n11 = bl3 ? n13 : n12), fontMetrics)) > (double)n2); --n13, ++n12) {
                    bl4 = true;
                    if (n13 != n12 && (d2 += JCUtil.getCharWidth(string.charAt(n11 = bl3 ? n12 : n13), fontMetrics)) > (double)n2) break;
                    bl4 = false;
                }
                if (bl4) {
                    if (bl3) {
                        --n13;
                    } else {
                        ++n12;
                    }
                }
                if (n13 == n12) {
                    --n13;
                }
                string = string3 + string.substring(n13 + 1, n12) + string3;
                break;
            }
            default: {
                String string5 = "Invalid truncate mode.";
                throw new IllegalArgumentException(string5);
            }
        }
        return string;
    }

    public static double getCharWidth(char c2, FontMetrics fontMetrics) {
        double d2 = fontMetrics instanceof JCFontMetrics ? ((JCFontMetrics)((Object)fontMetrics)).charWidthDouble(c2) : (double)fontMetrics.charWidth(c2);
        return d2;
    }

    public static double getStringWidth(String string, FontMetrics fontMetrics) {
        double d2 = fontMetrics instanceof JCFontMetrics ? ((JCFontMetrics)((Object)fontMetrics)).stringWidthDouble(string, true) : (double)fontMetrics.stringWidth(string);
        return d2;
    }

    public static boolean isBase64Data(String string) {
        return string != null && string.toLowerCase().indexOf(DATA_IMAGE_STRING) > -1 && string.toLowerCase().indexOf(BASE64_STRING) > -1;
    }

    public static String extractBase64Data(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        int n2 = string.lastIndexOf(BASE64_STRING);
        return string.substring(n2 + BASE64_STRING.length() + 1);
    }

    protected static Class<?> getBase64Class() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.klg.jclass.util.codec.JCBase64");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return clazz;
    }

    public static ICodec getBase64Codec() {
        ICodec iCodec = null;
        try {
            Class<?> clazz = JCUtil.getBase64Class();
            if (clazz != null) {
                iCodec = (ICodec)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return iCodec;
    }

    public static String createDataUrl(String string, byte[] byArray) {
        String string2 = "";
        if (byArray != null) {
            try {
                ICodec iCodec = JCUtil.getBase64Codec();
                if (iCodec != null) {
                    byte[] byArray2 = iCodec.encode(byArray);
                    string2 = DATA_IMAGE_STRING + string + ";base64," + new String(byArray2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string2;
    }

    public static String createDataUrl(Image image) {
        String string = "";
        if (image != null) {
            try {
                ICodec iCodec = JCUtil.getBase64Codec();
                if (iCodec != null) {
                    PNGImageIOEncoder pNGImageIOEncoder = new PNGImageIOEncoder();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    pNGImageIOEncoder.saveImage(image, byteArrayOutputStream);
                    byte[] byArray = iCodec.encode(byteArrayOutputStream.toByteArray());
                    string = "data:image/png;base64," + new String(byArray);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImageFromBase64Data(String string) {
        BufferedImage bufferedImage = null;
        InputStream inputStream = null;
        try {
            ICodec iCodec = JCUtil.getBase64Codec();
            if (iCodec != null) {
                byte[] byArray = iCodec.decode(string.getBytes());
                inputStream = new ByteArrayInputStream(byArray);
                bufferedImage = ImageIO.read(inputStream);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bufferedImage;
    }

    public static boolean equalStrings(String string, String string2) {
        boolean bl = false;
        if (string == null) {
            if (string2 == null) {
                bl = true;
            }
        } else if (string2 != null) {
            bl = string.equals(string2);
        }
        return bl;
    }

    public static int getMapHashCode(LinkedHashMap<String, String> linkedHashMap) {
        int n2 = 17;
        if (linkedHashMap != null) {
            Set<Map.Entry<String, String>> set = linkedHashMap.entrySet();
            for (Map.Entry<String, String> entry : set) {
                n2 = 37 * n2 + ((Object)entry).hashCode();
            }
        }
        return n2;
    }

    public static String xmlToString(Node node) {
        try {
            DOMSource dOMSource = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(dOMSource, streamResult);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        return null;
    }
}

