/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import com.klg.jclass.util.swing.TextRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class JCGraphicsUtil {
    public static final int DEGREES = 1;
    public static final int RADIANS = 2;
    public static final int GRADS = 3;
    public static final int XINSIDE = 1;
    public static final int XBYX1 = 2;
    public static final int XBYX2 = 3;
    public static final int YINSIDE = 10;
    public static final int YBYTOP = 11;
    public static final int YBYORIGIN = 12;
    private static final Color WHITE_BRIGHTER = new Color(200, 200, 200);
    private static final Color WHITE_DARKER = new Color(140, 140, 140);
    private static final Color BLACK_BRIGHTER = new Color(125, 125, 125);
    private static final Color BLACK_DARKER = new Color(75, 75, 75);
    private static final double FACTOR = 0.5;

    public static double degToRad(double d2) {
        return d2 * Math.PI / 180.0;
    }

    public static double radToDeg(double d2) {
        return d2 * 180.0 / Math.PI;
    }

    public static double convertAngle(int n2, int n3, double d2) {
        double d3;
        block0 : switch (n3) {
            case 1: {
                switch (n2) {
                    case 2: {
                        d3 = d2 * 180.0 / Math.PI;
                        break block0;
                    }
                    case 3: {
                        d3 = d2 * 0.9;
                        break block0;
                    }
                }
                d3 = d2;
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: {
                        d3 = d2 * 200.0 / Math.PI;
                        break block0;
                    }
                    case 1: {
                        d3 = d2 / 0.9;
                        break block0;
                    }
                }
                d3 = d2;
                break;
            }
            default: {
                switch (n2) {
                    case 1: {
                        d3 = d2 * Math.PI / 180.0;
                        break block0;
                    }
                    case 3: {
                        d3 = d2 * Math.PI / 200.0;
                        break block0;
                    }
                }
                d3 = d2;
            }
        }
        return d3;
    }

    public static int distance(int n2, int n3, int n4, int n5) {
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        return (int)Math.sqrt(n6 * n6 + n7 * n7);
    }

    public static int distance(int n2, int n3, Rectangle rectangle) {
        int n4;
        int n5 = JCGraphicsUtil.distance(n2, rectangle.x, rectangle.width);
        int n6 = n5 * n5 + (n4 = JCGraphicsUtil.distance(n3, rectangle.y, rectangle.height)) * n4;
        if (n6 <= 0) {
            return 0;
        }
        return (int)Math.sqrt(n6);
    }

    public static double distance(double d2, double d3, double d4, double d5) {
        double d6 = d4 - d2;
        double d7 = d5 - d3;
        return Math.sqrt(d6 * d6 + d7 * d7);
    }

    public static int distance(int n2, int n3, int n4) {
        if (n2 < n3) {
            return n3 - n2;
        }
        if (n2 > n3 + n4) {
            return n2 - (n3 + n4);
        }
        return 0;
    }

    public static long distTrap(int n2, int n3, int n4, double d2, double d3, double d4, double d5) {
        long l2 = d2 == d3 ? 32000L : (long)(d4 + ((double)n2 - d2) * ((d4 - d5) / (d2 - d3)));
        long l3 = d2 <= (double)n2 && (double)n2 <= d3 || d3 <= (double)n2 && (double)n2 <= d2 ? 1L : ((double)n2 <= d2 && d2 <= d3 || (double)n2 >= d2 && d2 >= d3 ? 2L : 3L);
        long l4 = l2 <= (long)n3 && n3 <= n4 || n4 <= n3 && (long)n3 <= l2 ? 10L : (l2 <= (long)n4 && n4 <= n3 || n3 <= n4 && (long)n4 <= l2 ? 12L : 11L);
        double d6 = 0.0;
        block0 : switch ((int)l4) {
            case 10: {
                switch ((int)l3) {
                    case 1: {
                        d6 = 0.0;
                        break;
                    }
                    case 2: {
                        if (n4 <= n3 && (double)n3 <= d4 || d4 <= (double)n3 && n3 <= n4) {
                            d6 = Math.abs(n2 - (int)d2);
                            break;
                        }
                        d6 = ((double)n3 - d4) * ((double)n3 - d4) + ((double)n2 - d2) * ((double)n2 - d2);
                        d6 = Math.sqrt(d6);
                        break;
                    }
                    case 3: {
                        if (n4 <= n3 && (double)n3 <= d5 || d5 <= (double)n3 && n3 <= n4) {
                            d6 = Math.abs(n2 - (int)d3);
                            break;
                        }
                        d6 = ((double)n3 - d5) * ((double)n3 - d5) + ((double)n2 - d3) * ((double)n2 - d3);
                        d6 = Math.sqrt(d6);
                    }
                }
                break;
            }
            case 11: {
                switch ((int)l3) {
                    case 1: {
                        d6 = Math.abs(n3 - (int)l2);
                        break;
                    }
                    case 2: {
                        d6 = ((double)n3 - d4) * ((double)n3 - d4) + ((double)n2 - d2) * ((double)n2 - d2);
                        d6 = Math.sqrt(d6);
                        break;
                    }
                    case 3: {
                        d6 = ((double)n3 - d5) * ((double)n3 - d5) + ((double)n2 - d3) * ((double)n2 - d3);
                        d6 = Math.sqrt(d6);
                    }
                }
                break;
            }
            case 12: {
                switch ((int)l3) {
                    case 1: {
                        d6 = Math.abs(n3 - n4);
                        break block0;
                    }
                    case 2: {
                        d6 = (double)((n3 - n4) * (n3 - n4)) + ((double)n2 - d2) * ((double)n2 - d2);
                        d6 = Math.sqrt(d6);
                        break block0;
                    }
                    case 3: {
                        d6 = (double)((n3 - n4) * (n3 - n4)) + ((double)n2 - d3) * ((double)n2 - d3);
                        d6 = Math.sqrt(d6);
                    }
                }
            }
        }
        return (long)d6;
    }

    public static Polygon pointsToPolygon(Point[] pointArray) {
        Polygon polygon = new Polygon();
        for (int i2 = 0; i2 < pointArray.length; ++i2) {
            if (i2 == 0) {
                polygon.addPoint(pointArray[i2].x, pointArray[i2].y);
                continue;
            }
            polygon.addPoint(polygon.xpoints[i2 - 1] + pointArray[i2].x, polygon.ypoints[i2 - 1] + pointArray[i2].y);
        }
        return polygon;
    }

    public static Point2D.Double getIntersection(Line2D line2D, Line2D line2D2) {
        double d2 = line2D.getX1();
        double d3 = line2D.getY1();
        double d4 = line2D.getX2();
        double d5 = line2D.getY2();
        double d6 = line2D2.getX1();
        double d7 = line2D2.getY1();
        double d8 = line2D2.getX2();
        double d9 = line2D2.getY2();
        double d10 = (d5 - d3) * (d2 - d6) - (d4 - d2) * (d3 - d7);
        double d11 = (d5 - d3) * (d8 - d6) - (d4 - d2) * (d9 - d7);
        Point2D.Double double_ = null;
        if (d11 != 0.0) {
            double_ = new Point2D.Double(d6 + (d8 - d6) * d10 / d11, d7 + (d9 - d7) * d10 / d11);
        }
        return double_;
    }

    public static boolean isTransparentColor(Color color) {
        return color != null && color.getAlpha() != 255;
    }

    public static Color brighter(Color color) {
        if (color == null) {
            return null;
        }
        if (color.equals(Color.white)) {
            return WHITE_BRIGHTER;
        }
        if (color.equals(Color.black)) {
            return BLACK_BRIGHTER;
        }
        int n2 = color.getRed();
        n2 += (int)((double)(255 - n2) * 0.5);
        int n3 = color.getBlue();
        n3 += (int)((double)(255 - n3) * 0.5);
        int n4 = color.getGreen();
        n4 += (int)((double)(255 - n4) * 0.5);
        return new Color(Math.min(n2, 255), Math.min(n4, 255), Math.min(n3, 255), color.getAlpha());
    }

    public static Color darker(Color color) {
        if (color == null) {
            return null;
        }
        if (color.equals(Color.white)) {
            return WHITE_DARKER;
        }
        if (color.equals(Color.black)) {
            return BLACK_DARKER;
        }
        Color color2 = color.darker();
        return new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), color.getAlpha());
    }

    public static boolean colorsNear(Color color, Color color2) {
        return color != null && color2 != null && Math.abs(color.getRed() - color2.getRed()) <= 15 && Math.abs(color.getGreen() - color2.getGreen()) <= 15 && Math.abs(color.getBlue() - color2.getBlue()) <= 15 && Math.abs(color.getAlpha() - color2.getAlpha()) <= 15;
    }

    public static int locateX(double d2, double d3, double d4) {
        int n2 = (d2 > d4 ? 1 : 0) << 1;
        int n3 = d2 < d3 ? 1 : 0;
        return n2 | n3;
    }

    public static int locateY(double d2, double d3, double d4) {
        int n2 = (d2 > d4 ? 1 : 0) << 3;
        int n3 = (d2 < d3 ? 1 : 0) << 2;
        return n2 | n3;
    }

    public static int locateXY(double d2, double d3, double d4, double d5, double d6, double d7) {
        return JCGraphicsUtil.locateY(d3, d6, d7) | JCGraphicsUtil.locateX(d2, d4, d5);
    }

    public static boolean isHTML(String string) {
        return TextRenderer.isHTML(string);
    }

    public static int countInString(String string, String string2) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        while ((n2 = string2.indexOf(string, n4)) >= 0) {
            ++n3;
            n4 = n2 + 1;
        }
        return n3;
    }

    public static void fudgeItalicLabel(Font font, Dimension dimension) {
        int n2 = font.getStyle();
        if ((n2 | 2) > 0) {
            int n3 = font.getSize();
            dimension.width += Math.max(1, n3 / 6);
        }
    }
}

