/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.data;

import com.klg.jclass.table.JCTableDataEvent;
import com.klg.jclass.table.JCTableDataListener;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.table.data.AbstractVectorDataSource;
import java.util.Vector;

public class JCCachedDataSource
extends AbstractVectorDataSource
implements JCTableDataListener {
    protected TableDataModel dataSource;
    protected Vector cached_row_labels = JCCachedDataSource.createVector();
    protected Vector cached_column_labels = JCCachedDataSource.createVector();
    protected Vector cached_cells = JCCachedDataSource.createVector();

    public JCCachedDataSource(TableDataModel tableDataModel) {
        this.dataSource = tableDataModel;
        this.dataSource.addTableDataListener(this);
    }

    public int getNumRows() {
        return this.dataSource.getNumRows();
    }

    public int getNumColumns() {
        return this.dataSource.getNumColumns();
    }

    public Object getTableDataItem(int n2, int n3) {
        if (n2 > this.cached_cells.size() - 1) {
            Object object = this.dataSource.getTableDataItem(n2, n3);
            Vector vector = JCCachedDataSource.createVector();
            JCCachedDataSource.setElementAt(vector, n3, object);
            JCCachedDataSource.setElementAt(this.cached_cells, n2, vector);
            return object;
        }
        Vector vector = (Vector)this.cached_cells.elementAt(n2);
        if (vector == null) {
            vector = JCCachedDataSource.createVector();
        }
        if (n3 > vector.size() - 1 || vector.elementAt(n3) == null) {
            Object object = this.dataSource.getTableDataItem(n2, n3);
            JCCachedDataSource.setElementAt(vector, n3, object);
            JCCachedDataSource.setElementAt(this.cached_cells, n2, vector);
            return object;
        }
        return ((Vector)this.cached_cells.elementAt(n2)).elementAt(n3);
    }

    public Object getTableRowLabel(int n2) {
        if (n2 > this.cached_row_labels.size() - 1 || this.cached_row_labels.elementAt(n2) == null) {
            Object object = this.dataSource.getTableRowLabel(n2);
            JCCachedDataSource.setElementAt(this.cached_row_labels, n2, object);
            return object;
        }
        return this.cached_row_labels.elementAt(n2);
    }

    public Object getTableColumnLabel(int n2) {
        if (n2 > this.cached_column_labels.size() - 1 || this.cached_column_labels.elementAt(n2) == null) {
            Object object = this.dataSource.getTableColumnLabel(n2);
            JCCachedDataSource.setElementAt(this.cached_column_labels, n2, object);
            return object;
        }
        return this.cached_column_labels.elementAt(n2);
    }

    public void dataChanged(JCTableDataEvent jCTableDataEvent) {
        int n2 = jCTableDataEvent.getRow();
        int n3 = jCTableDataEvent.getColumn();
        switch (jCTableDataEvent.getCommand()) {
            case 1: {
                try {
                    JCCachedDataSource.setElementAt((Vector)this.cached_cells.elementAt(n2), n3, null);
                }
                catch (Exception exception) {
                    System.out.println("An error in JCCachedDataSource.dataChanged()");
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: {
                this.cached_row_labels = JCCachedDataSource.createVector();
                this.cached_cells = JCCachedDataSource.createVector();
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: {
                this.cached_column_labels = JCCachedDataSource.createVector();
                this.cached_cells = JCCachedDataSource.createVector();
                break;
            }
            case 8: {
                JCCachedDataSource.setElementAt(this.cached_row_labels, n2, null);
                break;
            }
            case 9: {
                JCCachedDataSource.setElementAt(this.cached_column_labels, n3, null);
                break;
            }
            case 14: {
                this.cached_row_labels = JCCachedDataSource.createVector();
                this.cached_column_labels = JCCachedDataSource.createVector();
                this.cached_cells = JCCachedDataSource.createVector();
            }
        }
        this.fireTableDataEvent(jCTableDataEvent);
    }
}

