/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.JCTable;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import javax.swing.JScrollBar;

public class TableMouseWheelListener
implements MouseWheelListener,
Serializable {
    protected JCTable table;

    public TableMouseWheelListener(JCTable jCTable) {
        this.setTable(jCTable);
    }

    public void setTable(JCTable jCTable) {
        this.table = jCTable;
    }

    public JCTable getTable() {
        return this.table;
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.table == null || mouseWheelEvent == null) {
            return;
        }
        if (mouseWheelEvent.getScrollAmount() != 0) {
            JScrollBar jScrollBar = this.table.getVertSB();
            int n2 = 0;
            if (!(jScrollBar != null && jScrollBar.isVisible() || (jScrollBar = this.table.getHorizSB()) != null && jScrollBar.isVisible())) {
                return;
            }
            int n3 = n2 = mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1;
            if (mouseWheelEvent.getScrollType() == 0) {
                this.scrollByUnits(jScrollBar, n2, mouseWheelEvent.getScrollAmount());
            } else if (mouseWheelEvent.getScrollType() == 1) {
                this.scrollByBlock(jScrollBar, n2);
            }
        }
    }

    protected void scrollByBlock(JScrollBar jScrollBar, int n2) {
        int n3 = jScrollBar.getValue();
        int n4 = jScrollBar.getBlockIncrement(n2);
        int n5 = n4 * (n2 > 0 ? 1 : -1);
        jScrollBar.setValue(n3 + n5);
    }

    protected void scrollByUnits(JScrollBar jScrollBar, int n2, int n3) {
        int n4 = n3;
        n4 = n2 > 0 ? (n4 *= jScrollBar.getUnitIncrement(n2)) : (n4 *= -jScrollBar.getUnitIncrement(n2));
        int n5 = jScrollBar.getValue();
        int n6 = n5 + n4;
        if (n4 > 0 && n6 < n5) {
            n6 = jScrollBar.getMaximum();
        } else if (n4 < 0 && n6 > n5) {
            n6 = jScrollBar.getMinimum();
        }
        jScrollBar.setValue(n6);
    }
}

