/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.BaseDataView;
import com.klg.jclass.table.CellAreaRenderer;
import com.klg.jclass.table.DataViewSupport;
import com.klg.jclass.table.EditTraverseHandler;
import com.klg.jclass.table.EditableTableDataModel;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.JCTableDataEvent;
import com.klg.jclass.table.JCTableDataListener;
import com.klg.jclass.table.SortableDataViewModel;
import com.klg.jclass.table.TableDataModel;
import java.io.Serializable;

public class TableDataView
extends BaseDataView
implements SortableDataViewModel,
Serializable {
    protected TableDataModel dataSource;
    protected boolean isEditable = false;
    private int[] column_map;
    private int[] row_map;
    private boolean needs_column_map = false;
    private boolean needs_row_map = false;

    public TableDataView() {
    }

    public TableDataView(JCTable jCTable) {
        super(jCTable);
    }

    public void dataChanged(JCTableDataEvent jCTableDataEvent) {
        int n2;
        int n3 = 0;
        int n4 = jCTableDataEvent.getRow();
        if (n4 >= 0) {
            n4 = this.getViewRow(n4);
        }
        if ((n2 = jCTableDataEvent.getColumn()) >= 0) {
            n2 = this.getViewColumn(n2);
        }
        EditTraverseHandler editTraverseHandler = this.table.getEditTraverseHandler();
        switch (jCTableDataEvent.getCommand()) {
            case 1: {
                int n5;
                n3 = 0;
                int n6 = this.table.getPixelWidth(n2);
                if (n6 == 33001 || n6 == 33002) {
                    n3 |= 0x80;
                }
                if ((n5 = this.table.getPixelHeight(n4)) == 33001 || n5 == 33002) {
                    n3 |= 0x40;
                }
                if (n3 != 0) {
                    this.table.requestChange(n3, n4, n2);
                }
                this.repaintRange(n4, n2, n4, n2);
                break;
            }
            case 2: {
                if (editTraverseHandler.getCellEditor() != null && n4 == this.table.current_row) {
                    this.table.cancelEdit(true);
                }
                this.repaintRange(n4, -1, n4, this.getNumColumns());
                break;
            }
            case 3: {
                if (editTraverseHandler.getCellEditor() != null) {
                    this.table.cancelEdit(true);
                }
                DataViewSupport.addRow(this.table, n4, 1, this.getNumRows(), this.getNumColumns());
                this.repaintRange(jCTableDataEvent.getRow(), -1, this.getNumRows(), this.getNumColumns());
                break;
            }
            case 4: {
                if (editTraverseHandler.getCellEditor() != null) {
                    this.table.cancelEdit(true);
                }
                if (this.needs_row_map) {
                    for (int i2 = 0; i2 < jCTableDataEvent.getNumAffected(); ++i2) {
                        int n7 = this.getViewRow(jCTableDataEvent.getRow() + i2);
                        this.row_map = this.removeMapElement(this.row_map, n7);
                        DataViewSupport.deleteRow(this.table, n7, 1, this.getNumRows(), this.getNumColumns());
                    }
                } else {
                    DataViewSupport.deleteRow(this.table, jCTableDataEvent.getRow(), jCTableDataEvent.getNumAffected(), this.getNumRows(), this.getNumColumns());
                }
                this.table.doLayout();
                break;
            }
            case 5: {
                if (editTraverseHandler.getCellEditor() != null && n2 == this.table.current_column) {
                    this.table.cancelEdit(true);
                }
                this.repaintRange(-1, n2, this.getNumRows(), jCTableDataEvent.getColumn());
                break;
            }
            case 6: {
                if (editTraverseHandler.getCellEditor() != null) {
                    this.table.cancelEdit(true);
                }
                DataViewSupport.addColumn(this.table, n2, 1, this.getNumRows(), this.getNumColumns());
                this.repaintRange(-1, n2, this.getNumRows(), this.getNumColumns());
                break;
            }
            case 7: {
                if (editTraverseHandler.getCellEditor() != null) {
                    this.table.cancelEdit(true);
                }
                if (this.needs_column_map) {
                    for (int i3 = 0; i3 < jCTableDataEvent.getNumAffected(); ++i3) {
                        int n8 = this.getViewColumn(jCTableDataEvent.getColumn() + i3);
                        this.column_map = this.removeMapElement(this.column_map, n8);
                        DataViewSupport.deleteColumn(this.table, n8, 1, this.getNumRows(), this.getNumColumns());
                    }
                } else {
                    DataViewSupport.deleteColumn(this.table, jCTableDataEvent.getColumn(), jCTableDataEvent.getNumAffected(), this.getNumRows(), this.getNumColumns());
                }
                this.table.doLayout();
                break;
            }
            case 8: {
                int n9;
                n3 = 0;
                int n10 = this.table.getPixelWidth(-1);
                if (n10 == 33001 || n10 == 33002) {
                    n3 |= 0x80;
                }
                if ((n9 = this.table.getPixelHeight(n4)) == 33001 || n9 == 33002) {
                    n3 |= 0x40;
                }
                if (n3 != 0) {
                    this.table.requestChange(n3, n4, -1);
                }
                this.repaintRange(n4, -1, n4, -1);
                break;
            }
            case 9: {
                int n11;
                n3 = 0;
                int n12 = this.table.getPixelWidth(n2);
                if (n12 == 33001 || n12 == 33002) {
                    n3 |= 0x80;
                }
                if ((n11 = this.table.getPixelHeight(-1)) == 33001 || n11 == 33002) {
                    n3 |= 0x40;
                }
                if (n3 != 0) {
                    this.table.requestChange(n3, -1, n2);
                }
                this.repaintRange(-1, n2, -1, n2);
                break;
            }
            case 10: {
                if (editTraverseHandler.getCellEditor() != null) {
                    this.table.cancelEdit(true);
                }
                this.resetRowMap();
                DataViewSupport.moveRows(this.table, jCTableDataEvent.getRow(), jCTableDataEvent.getNumAffected(), jCTableDataEvent.getDestination());
                this.table.doLayout();
                this.table.repaint();
                break;
            }
            case 11: {
                if (editTraverseHandler.getCellEditor() != null) {
                    this.table.cancelEdit(true);
                }
                this.resetColumnMap();
                DataViewSupport.moveColumns(this.table, jCTableDataEvent.getColumn(), jCTableDataEvent.getNumAffected(), jCTableDataEvent.getDestination());
                this.table.doLayout();
                this.table.repaint();
                break;
            }
            case 12: {
                int n13 = this.dataSource.getNumRows();
                if (editTraverseHandler.getCellEditor() != null && n13 <= this.table.current_row) {
                    this.table.cancelEdit(true);
                }
                if (this.table.current_row >= n13) {
                    this.table.setCurrentCell(n13 - 1, this.table.current_column, 2);
                }
                this.resetRowMap();
                this.table.requestChange(2);
                break;
            }
            case 13: {
                int n14 = this.dataSource.getNumColumns();
                if (editTraverseHandler.getCellEditor() != null && n14 <= this.table.current_column) {
                    this.table.cancelEdit(true);
                }
                if (this.table.current_column >= n14) {
                    this.table.setCurrentCell(this.table.current_row, n14 - 1, 3);
                }
                this.resetColumnMap();
                this.table.requestChange(2);
                break;
            }
            case 14: {
                this.table.requestChange(2);
            }
        }
    }

    public TableDataModel getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(TableDataModel tableDataModel) {
        EditTraverseHandler editTraverseHandler;
        boolean bl = false;
        if (tableDataModel == null) {
            return;
        }
        boolean bl2 = this.table.isRepaintEnabled();
        this.table.setRepaintEnabled(false);
        if (this.dataSource != null) {
            bl = true;
            this.dataSource.removeTableDataListener(this);
        }
        if ((editTraverseHandler = this.table.getEditTraverseHandler()) != null) {
            editTraverseHandler.cancel(true);
        }
        this.dataSource = tableDataModel;
        this.dataSource.addTableDataListener(this);
        this.isEditable = this.dataSource instanceof EditableTableDataModel;
        if (bl) {
            // empty if block
        }
        if (bl && editTraverseHandler != null) {
            editTraverseHandler.traverseInitial();
        }
        this.resetColumnMap();
        this.resetRowMap();
        this.table.setRecalcRequired(true);
        if (bl2) {
            this.table.setRepaintEnabled(true);
        }
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public Object getObject(int n2, int n3) {
        if (this.dataSource == null) {
            return null;
        }
        if (n2 >= 0 && n3 >= 0) {
            return this.dataSource.getTableDataItem(this.getDataRow(n2), this.getDataColumn(n3));
        }
        if (n2 == -1) {
            return this.dataSource.getTableColumnLabel(this.getDataColumn(n3));
        }
        return this.dataSource.getTableRowLabel(this.getDataRow(n2));
    }

    public boolean setTableDataItem(Object object, int n2, int n3) {
        if (this.dataSource == null) {
            return false;
        }
        if (this.isEditable) {
            EditableTableDataModel editableTableDataModel = (EditableTableDataModel)this.dataSource;
            return editableTableDataModel.setTableDataItem(object, this.getDataRow(n2), this.getDataColumn(n3));
        }
        return true;
    }

    public Object getTableDataItem(int n2, int n3) {
        if (this.dataSource == null) {
            return null;
        }
        return this.dataSource.getTableDataItem(this.getDataRow(n2), this.getDataColumn(n3));
    }

    public int getNumRows() {
        if (this.dataSource == null) {
            return 0;
        }
        return this.dataSource.getNumRows();
    }

    public int getNumColumns() {
        if (this.dataSource == null) {
            return 0;
        }
        return this.dataSource.getNumColumns();
    }

    public Object getTableRowLabel(int n2) {
        if (this.dataSource == null) {
            return null;
        }
        return this.dataSource.getTableRowLabel(this.getDataRow(n2));
    }

    public Object getTableColumnLabel(int n2) {
        if (this.dataSource == null) {
            return null;
        }
        return this.dataSource.getTableColumnLabel(this.getDataColumn(n2));
    }

    public void addTableDataListener(JCTableDataListener jCTableDataListener) {
        if (this.dataSource == null) {
            return;
        }
        this.dataSource.addTableDataListener(jCTableDataListener);
    }

    public void removeTableDataListener(JCTableDataListener jCTableDataListener) {
        if (this.dataSource == null) {
            return;
        }
        this.dataSource.removeTableDataListener(jCTableDataListener);
    }

    public int[] getColumnMap() {
        int n2 = this.dataSource.getNumColumns();
        if (this.column_map == null || this.column_map.length < n2) {
            this.resizeColumnMap();
        }
        return this.column_map;
    }

    public int[] getRowMap() {
        int n2 = this.dataSource.getNumRows();
        if (this.row_map == null || this.row_map.length < n2) {
            this.resizeRowMap();
        }
        return this.row_map;
    }

    public int getDataColumn(int n2) {
        if (this.column_map == null) {
            return n2;
        }
        int n3 = this.dataSource.getNumColumns();
        if (this.column_map.length < n3) {
            this.resizeColumnMap();
        }
        if (n2 >= 0 && n2 < n3) {
            return this.column_map[n2];
        }
        return -999;
    }

    public int getDataRow(int n2) {
        if (this.row_map == null) {
            return n2;
        }
        int n3 = this.dataSource.getNumRows();
        if (this.row_map.length < n3) {
            this.resizeRowMap();
        }
        if (n2 >= 0 && n2 < n3) {
            return this.row_map[n2];
        }
        return -999;
    }

    public int getViewColumn(int n2) {
        if (this.column_map == null) {
            return n2;
        }
        int n3 = this.dataSource.getNumColumns();
        if (this.column_map == null || this.column_map.length < n3) {
            this.resizeColumnMap();
        }
        if (n2 < n3) {
            if (this.column_map[n2] == n2) {
                return n2;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                if (this.column_map[i2] != n2) continue;
                return i2;
            }
        }
        return -999;
    }

    public int getViewRow(int n2) {
        if (this.row_map == null) {
            return n2;
        }
        int n3 = this.dataSource.getNumRows();
        if (this.row_map == null || this.row_map.length < n3) {
            this.resizeRowMap();
        }
        if (n2 < n3) {
            if (this.row_map[n2] == n2) {
                return n2;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                if (this.row_map[i2] != n2) continue;
                return i2;
            }
        }
        return -999;
    }

    protected void resizeColumnMap() {
        if (!this.needs_column_map) {
            return;
        }
        int n2 = this.dataSource.getNumColumns();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.column_map == null || i2 >= this.column_map.length ? i2 : this.column_map[i2];
        }
        this.column_map = nArray;
    }

    protected void resizeRowMap() {
        if (!this.needs_row_map) {
            return;
        }
        int n2 = this.dataSource.getNumRows();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.row_map == null || i2 >= this.row_map.length ? i2 : this.row_map[i2];
        }
        this.row_map = nArray;
    }

    public void resetColumnMap() {
        this.needs_column_map = false;
        if (this.column_map != null) {
            int n2 = this.column_map.length;
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = i2;
            }
            this.setColumnMap(nArray);
        }
        this.column_map = null;
        this.table.sort_column = -999;
        this.table.sort_direction = -999;
    }

    public void resetRowMap() {
        this.needs_row_map = false;
        if (this.row_map != null) {
            int n2 = this.row_map.length;
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = i2;
            }
            this.setRowMap(nArray);
        }
        this.row_map = null;
        this.table.sort_column = -999;
        this.table.sort_direction = -999;
    }

    protected int[] shiftMappedArray(int[] nArray, int n2, int n3) {
        int n4 = nArray.length;
        int[] nArray2 = new int[n4];
        if (n3 == Integer.MAX_VALUE) {
            int n5;
            for (n5 = 0; n5 < n2; ++n5) {
                nArray2[n5] = nArray[n5];
            }
            for (n5 = n2 + 1; n5 < n4; ++n5) {
                nArray2[n5 - 1] = nArray[n5];
            }
            nArray2[n4 - 1] = nArray[n2];
        } else if (n2 < n3) {
            int n6;
            for (n6 = 0; n6 < n4; ++n6) {
                nArray2[n6] = nArray[n6];
            }
            for (n6 = n2 + 1; n6 < n3; ++n6) {
                nArray2[n6 - 1] = nArray[n6];
            }
            nArray2[n3 - 1] = nArray[n2];
        } else if (n2 > n3) {
            int n7;
            for (n7 = 0; n7 < n4; ++n7) {
                nArray2[n7] = nArray[n7];
            }
            for (n7 = n3; n7 < n2; ++n7) {
                nArray2[n7 + 1] = nArray[n7];
            }
            nArray2[n3] = nArray[n2];
        }
        return nArray2;
    }

    protected int[] removeMapElement(int[] nArray, int n2) {
        if (nArray == null) {
            return null;
        }
        int n3 = nArray.length;
        int[] nArray2 = new int[n3 - 1];
        for (int i2 = 0; i2 < n3; ++i2) {
            if (i2 < n2) {
                nArray2[i2] = nArray[i2];
                continue;
            }
            if (i2 <= n2) continue;
            nArray2[i2 - 1] = nArray[i2];
        }
        return nArray2;
    }

    public boolean swapColumns(int n2, int n3) {
        int n4 = this.dataSource.getNumColumns();
        if (n2 < 0 || n2 > n4) {
            return false;
        }
        if (n3 < 0 || n3 > n4) {
            return false;
        }
        if (n2 == n3) {
            return true;
        }
        this.table.cancelEdit(true);
        this.needs_column_map = true;
        if (this.column_map == null || this.column_map.length < n4) {
            this.resizeColumnMap();
        }
        int n5 = this.column_map[n2];
        this.column_map[n2] = this.column_map[n3];
        this.column_map[n3] = n5;
        DataViewSupport.swapColumns(this.table, n2, n3);
        this.table.doLayout();
        this.table.repaint();
        return true;
    }

    public boolean swapRows(int n2, int n3) {
        int n4 = this.dataSource.getNumRows();
        if (n2 < 0 || n2 > n4) {
            return false;
        }
        if (n3 < 0 || n3 > n4) {
            return false;
        }
        if (n2 == n3) {
            return true;
        }
        this.table.cancelEdit(true);
        this.needs_row_map = true;
        if (this.row_map == null || this.row_map.length < n4) {
            this.resizeRowMap();
        }
        int n5 = this.row_map[n2];
        this.row_map[n2] = this.row_map[n3];
        this.row_map[n3] = n5;
        DataViewSupport.swapRows(this.table, n2, n3);
        this.table.doLayout();
        this.table.repaint();
        return true;
    }

    public boolean setColumnMap(int[] nArray) {
        int n2 = this.dataSource.getNumColumns();
        if (nArray.length != n2) {
            return false;
        }
        this.table.cancelEdit(true);
        this.needs_column_map = true;
        if (this.column_map == null || this.column_map.length < n2) {
            this.resizeColumnMap();
        }
        if (this.table.isSeriesDataSorted()) {
            if (DataViewSupport.swapColumnArrays(this.table, this.column_map, nArray)) {
                this.column_map = nArray;
            }
        } else {
            this.column_map = nArray;
        }
        this.table.repaint();
        return true;
    }

    public boolean setRowMap(int[] nArray) {
        int n2 = this.dataSource.getNumRows();
        if (nArray.length != n2) {
            return false;
        }
        this.table.cancelEdit(true);
        this.needs_row_map = true;
        if (this.row_map == null || this.row_map.length < n2) {
            this.resizeRowMap();
        }
        if (this.table.isSeriesDataSorted()) {
            if (DataViewSupport.swapRowArrays(this.table, this.row_map, nArray)) {
                this.row_map = nArray;
            }
        } else {
            this.row_map = nArray;
        }
        this.table.repaint();
        return true;
    }

    public boolean dragColumn(int n2, int n3) {
        int n4 = this.dataSource.getNumColumns();
        int n5 = this.table.getFrozenColumns();
        if (n2 < 0 || n2 > n4) {
            return false;
        }
        if (n3 < 0) {
            return false;
        }
        if (n2 < n5 || n3 < n5) {
            return false;
        }
        if (n2 == n3) {
            return true;
        }
        this.needs_column_map = true;
        if (this.column_map == null || this.column_map.length < n4) {
            this.resizeColumnMap();
        }
        this.column_map = this.shiftMappedArray(this.column_map, n2, n3);
        boolean bl = DataViewSupport.dragColumn(this.table, n2, n3);
        this.table.doLayout();
        this.table.repaint();
        return bl;
    }

    public boolean dragRow(int n2, int n3) {
        int n4 = this.dataSource.getNumRows();
        int n5 = this.table.getFrozenRows();
        if (n2 < 0 || n2 > n4) {
            return false;
        }
        if (n3 < 0) {
            return false;
        }
        if (n2 < n5 || n3 < n5) {
            return false;
        }
        if (n2 == n3) {
            return true;
        }
        this.needs_row_map = true;
        if (this.row_map == null || this.row_map.length < n4) {
            this.resizeRowMap();
        }
        this.row_map = this.shiftMappedArray(this.row_map, n2, n3);
        boolean bl = DataViewSupport.dragRow(this.table, n2, n3);
        this.table.doLayout();
        this.table.repaint();
        return bl;
    }

    protected void repaintRange(int n2, int n3, int n4, int n5) {
        CellAreaRenderer cellAreaRenderer = this.table.getCellAreaHandler().getCellAreaRenderer();
        cellAreaRenderer.repaintRange(n2, n3, n4, n5);
    }

    public void dispose() {
        if (this.dataSource != null) {
            this.dataSource.removeTableDataListener(this);
        }
    }
}

