/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellLayoutModel;
import com.klg.jclass.table.JCTable;
import java.awt.Rectangle;

public class PrintCellLayout
implements CellLayoutModel {
    protected JCTable table;
    protected int[] columnWidth;
    protected int[] columnPosition;
    protected int[] rowHeight;
    protected int[] rowPosition;
    protected int labelWidth = -999;
    protected int labelHeight = -999;
    protected int rows = 0;
    protected int columns = 0;

    public PrintCellLayout(int n2, int n3) {
        int n4;
        this.rows = n2 = Math.max(1, n2);
        this.columns = n3;
        this.rowHeight = new int[n2];
        this.rowPosition = new int[n2];
        for (n4 = 0; n4 < n2; ++n4) {
            this.rowHeight[n4] = 21;
        }
        this.calcPositions(this.rowPosition, this.labelHeight, this.rowHeight);
        this.columnWidth = new int[n3];
        this.columnPosition = new int[n3];
        for (n4 = 0; n4 < n3; ++n4) {
            this.columnWidth[n4] = -999;
        }
        this.calcPositions(this.columnPosition, this.labelWidth, this.columnWidth);
    }

    protected void calcPositions(int[] nArray, int n2, int[] nArray2) {
        int n3 = nArray2.length;
        if (n3 == 0) {
            return;
        }
        nArray[0] = n2;
        for (int i2 = 1; i2 < n3; ++i2) {
            nArray[i2] = nArray[i2 - 1] + nArray2[i2 - 1];
        }
    }

    public JCTable getTable() {
        return this.table;
    }

    public void setTable(JCTable jCTable) {
        this.table = jCTable;
    }

    public int getHeight(int n2) {
        if (n2 == -1) {
            return this.labelHeight;
        }
        return this.rowHeight[n2];
    }

    public void setHeight(int n2, int n3) {
        if (n2 == -1) {
            this.labelHeight = Math.max(0, n3);
            int n4 = 2 * this.table.getFrameBorderWidth();
            int n5 = this.table != null ? this.table.getColumnLabelOffset() + n4 : 0;
            this.calcPositions(this.rowPosition, this.labelHeight + n5, this.rowHeight);
        } else {
            int n6 = n3 - this.rowHeight[n2];
            this.rowHeight[n2] = Math.max(0, n3);
            int n7 = n2 + 1;
            while (n7 < this.rows) {
                int n8 = n7++;
                this.rowPosition[n8] = this.rowPosition[n8] + n6;
            }
        }
    }

    public void setHeight(int n2, int n3, int n4) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            this.setHeight(i2, n4);
        }
    }

    public int getWidth(int n2) {
        if (n2 == -1) {
            return this.labelWidth;
        }
        return this.columnWidth[n2];
    }

    public void setWidth(int n2, int n3) {
        if (n2 == -1) {
            this.labelWidth = Math.max(0, n3);
            int n4 = 2 * this.table.getFrameBorderWidth();
            int n5 = this.table != null ? this.table.getRowLabelOffset() + n4 : 0;
            this.calcPositions(this.columnPosition, this.labelWidth + n5, this.columnWidth);
        } else {
            int n6 = n3 - this.columnWidth[n2];
            this.columnWidth[n2] = Math.max(0, n3);
            int n7 = n2 + 1;
            while (n7 < this.columns) {
                int n8 = n7++;
                this.columnPosition[n8] = this.columnPosition[n8] + n6;
            }
        }
    }

    public void setWidth(int n2, int n3, int n4) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            this.setWidth(i2, n4);
        }
    }

    public int getRowPosition(int n2) {
        if (n2 == -1) {
            return 0;
        }
        return this.rowPosition[n2];
    }

    public int getColumnPosition(int n2) {
        if (n2 == -1) {
            return 0;
        }
        return this.columnPosition[n2];
    }

    public Rectangle getBounds(int n2, int n3) {
        return this.getBounds(n2, n3, new Rectangle());
    }

    public Rectangle getBounds(int n2, int n3, Rectangle rectangle) {
        rectangle.setBounds(this.getColumnPosition(n3), this.getRowPosition(n2), this.getWidth(n3), this.getHeight(n2));
        return rectangle;
    }

    public Rectangle getBounds(int n2, int n3, int n4, int n5) {
        return this.getBounds(n2, n3, n4, n5, new Rectangle());
    }

    public Rectangle getBounds(int n2, int n3, int n4, int n5, Rectangle rectangle) {
        int n6 = this.getColumnPosition(n3);
        int n7 = this.getRowPosition(n2);
        rectangle.setBounds(n6, n7, this.getColumnPosition(n5) + this.getWidth(n5) - n6, this.getRowPosition(n4) + this.getHeight(n4) - n7);
        return rectangle;
    }

    public int getColumn(int n2, int n3) {
        int n4;
        if (n2 < this.labelWidth) {
            return -1;
        }
        for (n4 = this.columns - 1; n4 > 0 && n2 < this.columnPosition[n4]; --n4) {
        }
        return n4;
    }

    public int getRow(int n2, int n3) {
        int n4;
        if (n3 < this.labelHeight) {
            return -1;
        }
        for (n4 = this.rows - 1; n4 > 0 && n3 < this.rowPosition[n4]; --n4) {
        }
        return n4;
    }

    public void addRows(int n2, int n3) {
    }

    public void addColumns(int n2, int n3) {
    }

    public void moveRows(int n2, int n3, int n4) {
    }

    public void moveColumns(int n2, int n3, int n4) {
    }

    public void deleteRows(int n2, int n3) {
    }

    public void deleteColumns(int n2, int n3) {
    }

    public void remapRows(int[] nArray, int[] nArray2) {
    }

    public void remapColumns(int[] nArray, int[] nArray2) {
    }

    public void resetRows() {
    }

    public void resetColumns() {
    }
}

