/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellRangeValue;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.SeriesModel;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class JCSeries
extends Vector
implements SeriesModel,
Serializable {
    protected int last_index = -999;

    public JCSeries() {
    }

    public JCSeries(Object object) {
        this.setDefault(object);
    }

    public Object getDefault() {
        return this.getValue(-998, -998);
    }

    public void setDefault(Object object) {
        this.last_index = this.find(-998, -998);
        if (this.last_index == -999) {
            SeriesValue seriesValue = new SeriesValue(-998, -998, object);
            this.insertElementAt(seriesValue, 0);
        } else {
            ((SeriesValue)this.elementAt((int)this.last_index)).value = object;
        }
    }

    public Collection getUniqueValues() {
        Vector<Object> vector = new Vector<Object>();
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            Object object = ((SeriesValue)this.elementAt((int)i2)).value;
            if (vector.contains(object)) continue;
            vector.addElement(object);
        }
        return vector;
    }

    public Collection getCellRanges(Object object) {
        Vector vector = new Vector();
        int n2 = -999;
        int n3 = -999;
        int n4 = -999;
        int n5 = -999;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            SeriesValue seriesValue = (SeriesValue)this.elementAt(i2);
            if (seriesValue.value != object) continue;
            if (seriesValue.row == -998) {
                n2 = -1;
                n4 = Integer.MAX_VALUE;
            } else if (seriesValue.row == -997) {
                n2 = 0;
                n4 = Integer.MAX_VALUE;
            } else {
                n2 = seriesValue.row;
                n4 = seriesValue.row;
            }
            if (seriesValue.column == -998) {
                n3 = -1;
                n5 = Integer.MAX_VALUE;
            } else if (seriesValue.column == -997) {
                n3 = 0;
                n5 = Integer.MAX_VALUE;
            } else {
                n3 = seriesValue.column;
                n5 = seriesValue.column;
            }
            vector.addElement(new CellRangeValue(n2, n3, n4, n5, seriesValue.value));
        }
        vector = this.compressRanges(vector);
        return vector;
    }

    public List getSeriesValues() {
        Vector<CellRangeValue> vector = new Vector<CellRangeValue>();
        int n2 = -999;
        int n3 = -999;
        int n4 = -999;
        int n5 = -999;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            SeriesValue seriesValue = (SeriesValue)this.elementAt(i2);
            if (seriesValue.row == -998) {
                n2 = -1;
                n4 = Integer.MAX_VALUE;
            } else if (seriesValue.row == -997) {
                n2 = 0;
                n4 = Integer.MAX_VALUE;
            } else {
                n2 = seriesValue.row;
                n4 = seriesValue.row;
            }
            if (seriesValue.column == -998) {
                n3 = -1;
                n5 = Integer.MAX_VALUE;
            } else if (seriesValue.column == -997) {
                n3 = 0;
                n5 = Integer.MAX_VALUE;
            } else {
                n3 = seriesValue.column;
                n5 = seriesValue.column;
            }
            vector.addElement(new CellRangeValue(n2, n3, n4, n5, seriesValue.value));
        }
        return this.compressRanges(vector);
    }

    private Vector compressRanges(Vector vector) {
        if (vector.size() == 1) {
            return vector;
        }
        for (int i2 = vector.size() - 1; i2 > 0; --i2) {
            CellRangeValue cellRangeValue = (CellRangeValue)vector.elementAt(i2);
            for (int i3 = i2; i3 > 0; --i3) {
                CellRangeValue cellRangeValue2 = (CellRangeValue)vector.elementAt(i3 - 1);
                if (!this.isCombinable(cellRangeValue2, cellRangeValue)) continue;
                this.addRange(cellRangeValue2, cellRangeValue);
                vector.removeElementAt(i2);
                return this.compressRanges(vector);
            }
        }
        return vector;
    }

    private boolean isCombinable(CellRangeValue cellRangeValue, CellRangeValue cellRangeValue2) {
        if (cellRangeValue.value != cellRangeValue2.value) {
            return false;
        }
        if (cellRangeValue.start_row == cellRangeValue2.start_row && cellRangeValue.end_row == cellRangeValue2.end_row && (cellRangeValue.end_column + 1 == cellRangeValue2.start_column || cellRangeValue2.end_column + 1 == cellRangeValue.start_column)) {
            return true;
        }
        return cellRangeValue.start_column == cellRangeValue2.start_column && cellRangeValue.end_column == cellRangeValue2.end_column && (cellRangeValue.end_row + 1 == cellRangeValue2.start_row || cellRangeValue2.end_row + 1 == cellRangeValue.start_row);
    }

    private void addRange(CellRangeValue cellRangeValue, CellRangeValue cellRangeValue2) {
        cellRangeValue.start_row = Math.min(cellRangeValue.start_row, cellRangeValue2.start_row);
        cellRangeValue.start_column = Math.min(cellRangeValue.start_column, cellRangeValue2.start_column);
        cellRangeValue.end_row = Math.max(cellRangeValue.end_row, cellRangeValue2.end_row);
        cellRangeValue.end_column = Math.max(cellRangeValue.end_column, cellRangeValue2.end_column);
    }

    public Object getValue(int n2, int n3) {
        int n4 = this.find(n2, n3);
        return n4 == -999 ? null : ((SeriesValue)this.elementAt((int)n4)).value;
    }

    public boolean setValue(int n2, int n3, Object object) {
        SeriesValue seriesValue;
        int n4;
        if (n2 == -1 && n3 == -1) {
            boolean bl = this.setValue(-998, -1, object);
            boolean bl2 = this.setValue(-1, -998, object);
            return bl & bl2;
        }
        if (n2 == -998 && n3 == -998) {
            this.removeAllElements();
            this.last_index = -999;
        } else if (n2 == -997 && n3 == -997) {
            for (n4 = this.size() - 1; n4 >= 0; --n4) {
                seriesValue = (SeriesValue)this.elementAt(n4);
                if (seriesValue.column != -997 && seriesValue.column <= -1 || seriesValue.row != -997 && seriesValue.row <= -1) continue;
                this.removeElementAt(n4);
            }
            this.last_index = -999;
        } else if (n2 == -998) {
            for (n4 = this.size() - 1; n4 >= 0; --n4) {
                seriesValue = (SeriesValue)this.elementAt(n4);
                if (seriesValue.column != n3) continue;
                this.removeElementAt(n4);
            }
            this.last_index = -999;
        } else if (n2 == -997) {
            for (n4 = this.size() - 1; n4 >= 0; --n4) {
                seriesValue = (SeriesValue)this.elementAt(n4);
                if (seriesValue.row == -1 || seriesValue.column != n3) continue;
                this.removeElementAt(n4);
            }
            this.last_index = -999;
        } else if (n3 == -998) {
            for (n4 = this.size() - 1; n4 >= 0; --n4) {
                seriesValue = (SeriesValue)this.elementAt(n4);
                if (seriesValue.row != n2) continue;
                this.removeElementAt(n4);
            }
            this.last_index = -999;
        } else if (n3 == -997) {
            for (n4 = this.size() - 1; n4 >= 0; --n4) {
                seriesValue = (SeriesValue)this.elementAt(n4);
                if (seriesValue.row != n2 || seriesValue.column == -1) continue;
                this.removeElementAt(n4);
            }
            this.last_index = -999;
        }
        n4 = this.findExact(n2, n3);
        if (n4 >= 0 && n4 < this.size()) {
            Object object2;
            seriesValue = (SeriesValue)this.elementAt(n4);
            if (n4 < this.size() - 1) {
                object2 = this.elementAt(n4);
                this.removeElementAt(n4);
                this.addElement(object2);
            } else if (seriesValue.eqValue(object)) {
                return false;
            }
            object2 = (SeriesValue)this.elementAt(this.size() - 1);
            ((SeriesValue)object2).value = object;
        } else {
            this.addElement(new SeriesValue(n2, n3, object));
        }
        this.last_index = -999;
        return true;
    }

    public boolean setValue(int n2, int n3, int n4, int n5, Object object) {
        int n6 = n2;
        int n7 = n4;
        if (n6 == -1 && n7 == Integer.MAX_VALUE) {
            n7 = -998;
            n6 = -998;
        } else if (n6 == 0 && n7 == Integer.MAX_VALUE) {
            n7 = -997;
            n6 = -997;
        }
        int n8 = n3;
        int n9 = n5;
        if (n8 == -1 && n9 == Integer.MAX_VALUE) {
            n9 = -998;
            n8 = -998;
        } else if (n8 == 0 && n9 == Integer.MAX_VALUE) {
            n9 = -997;
            n8 = -997;
        }
        boolean bl = false;
        if (n6 == -1 && n8 == -1 && n7 != -1 && n9 != -1) {
            bl = true;
        }
        for (int i2 = n6; i2 <= n7; ++i2) {
            for (int i3 = n8; i3 <= n9; ++i3) {
                if (i2 == -1 && i3 == -1 && bl) continue;
                this.setValue(i2, i3, object);
            }
        }
        return true;
    }

    public boolean setValue(JCCellRange jCCellRange, Object object) {
        return this.setValue(jCCellRange.start_row, jCCellRange.start_column, jCCellRange.end_row, jCCellRange.end_column, object);
    }

    private static boolean eqCell(Object object, int n2, int n3) {
        return object != null && ((SeriesValue)object).row == n2 && ((SeriesValue)object).column == n3;
    }

    private boolean eqCell(int n2, int n3, int n4) {
        SeriesValue seriesValue = (SeriesValue)this.elementAt(n2);
        return (seriesValue.row == n3 || seriesValue.row == -998 || n3 >= 0 && seriesValue.row == -997) && (seriesValue.column == n4 || seriesValue.column == -998 || n4 >= 0 && seriesValue.column == -997);
    }

    private int findExact(int n2, int n3) {
        int n4 = this.last_index;
        if (n4 != -999 && JCSeries.eqCell(this.elementAt(n4), n2, n3)) {
            return n4;
        }
        for (n4 = this.size() - 1; n4 >= 0; --n4) {
            if (!JCSeries.eqCell(this.elementAt(n4), n2, n3)) continue;
            return n4;
        }
        return -999;
    }

    protected void remove(int n2, int n3) {
        int n4 = this.findExact(n2, n3);
        if (n4 != -999) {
            this.removeAt(n4);
        }
    }

    private void removeAt(int n2) {
        if (n2 < this.size()) {
            this.removeElementAt(n2);
            this.last_index = -999;
        }
    }

    private int find(int n2, int n3) {
        int n4 = this.last_index;
        if (n4 != -999 && n4 < this.size()) {
            SeriesValue seriesValue = (SeriesValue)this.elementAt(n4);
            if (seriesValue.row == n2 && seriesValue.column == n3) {
                return n4;
            }
        }
        for (n4 = this.size() - 1; n4 >= 0; --n4) {
            if (!this.eqCell(n4, n2, n3)) continue;
            this.last_index = n4;
            return n4;
        }
        this.last_index = -999;
        return -999;
    }

    private boolean containsValue(Object object) {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (!((SeriesValue)this.elementAt((int)i2)).value.equals(object)) continue;
            return true;
        }
        return false;
    }

    private Object getValue(int n2) {
        if (n2 >= this.size()) {
            return null;
        }
        return ((SeriesValue)this.elementAt((int)n2)).value;
    }

    public void moveColumns(int n2, int n3, int n4) {
        this.last_index = -999;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            SeriesValue seriesValue = (SeriesValue)this.elementAt(i2);
            seriesValue.column = this.adjust(seriesValue.column, n2, n3, n4);
        }
    }

    public void moveRows(int n2, int n3, int n4) {
        this.last_index = -999;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            SeriesValue seriesValue = (SeriesValue)this.elementAt(i2);
            seriesValue.row = this.adjust(seriesValue.row, n2, n3, n4);
        }
    }

    public void remapColumns(int[] nArray) {
        this.last_index = -999;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            SeriesValue seriesValue = (SeriesValue)this.elementAt(i2);
            if (seriesValue.column < 0 || seriesValue.column >= nArray.length) continue;
            seriesValue.column = nArray[seriesValue.column];
        }
    }

    public void remapRows(int[] nArray) {
        this.last_index = -999;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            SeriesValue seriesValue = (SeriesValue)this.elementAt(i2);
            if (seriesValue.row < 0 || seriesValue.row >= nArray.length) continue;
            seriesValue.row = nArray[seriesValue.row];
        }
    }

    public void shiftColumn(int n2, int n3, int n4) {
        this.last_index = -999;
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            SeriesValue seriesValue = (SeriesValue)this.elementAt(i2);
            if (n4 > 0) {
                if (seriesValue.column < n2) continue;
                seriesValue.column += n3;
                continue;
            }
            if (seriesValue.column >= n2 && seriesValue.column < n2 + n3) {
                this.removeElementAt(i2);
                continue;
            }
            if (seriesValue.column < n2 + n3) continue;
            seriesValue.column -= n3;
        }
    }

    public void shiftRow(int n2, int n3, int n4) {
        this.last_index = -999;
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            SeriesValue seriesValue = (SeriesValue)this.elementAt(i2);
            if (n4 > 0) {
                if (seriesValue.row < n2) continue;
                seriesValue.row += n3;
                continue;
            }
            if (seriesValue.row >= n2 && seriesValue.row < n2 + n3) {
                this.removeElementAt(i2);
                continue;
            }
            if (seriesValue.row < n2 + n3) continue;
            seriesValue.row -= n3;
        }
    }

    public void swapColumns(int n2, int n3) {
        this.last_index = -999;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            SeriesValue seriesValue = (SeriesValue)this.elementAt(i2);
            seriesValue.column = this.swap(seriesValue.column, n2, n3);
        }
    }

    public void swapRows(int n2, int n3) {
        this.last_index = -999;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            SeriesValue seriesValue = (SeriesValue)this.elementAt(i2);
            seriesValue.row = this.swap(seriesValue.row, n2, n3);
        }
    }

    private int adjust(int n2, int n3, int n4, int n5) {
        if (n3 > n5) {
            if (n2 >= n5 && n2 < n3) {
                n2 += n4;
            } else if (n2 >= n3 && n2 < n3 + n4) {
                n2 -= n3 - n5;
            }
        } else if (n2 >= n3 + n4 && n2 < n5) {
            n2 -= n4;
        } else if (n2 >= n3 && n2 < n3 + n4) {
            n2 += n5 - n3 - n4;
        }
        return n2;
    }

    private int swap(int n2, int n3, int n4) {
        if (n2 == n3) {
            return n4;
        }
        if (n2 == n4) {
            return n3;
        }
        return n2;
    }

    class SeriesValue
    implements Serializable {
        int row;
        int column;
        Object value;

        SeriesValue(int n2, int n3, Object object) {
            this.row = n2;
            this.column = n3;
            this.value = object;
        }

        boolean eqValue(Object object) {
            if (this.value != null) {
                return object != null ? this.value.equals(object) : false;
            }
            return object == null;
        }

        public String toString() {
            return "R" + this.row + "C" + this.column + " value=" + this.value;
        }
    }
}

