/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellLayoutModel;
import com.klg.jclass.table.ComponentModel;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCPrintEvent;
import com.klg.jclass.table.JCPrintListener;
import com.klg.jclass.table.JCPrintPreview;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.PrintCellAreaHandler;
import com.klg.jclass.table.PrintCellAreaRenderer;
import com.klg.jclass.table.PrintCellLayout;
import com.klg.jclass.table.SpanHandler;
import com.klg.jclass.table.TableLayout;
import com.klg.jclass.table.resources.LocaleBundle;
import com.klg.jclass.util.JCListenerList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

public class JCPrintTable
extends JCTable
implements Printable {
    public static final int MARGIN_IN_INCHES = 0;
    public static final int MARGIN_IN_PIXELS = 1;
    protected JCTable table;
    protected int page_width = 0;
    protected int page_height = 0;
    protected int page_resolution = 72;
    protected int table_width = 0;
    protected int table_height = 0;
    protected Insets margin = new Insets(72, 72, 72, 72);
    protected int margin_unit = 1;
    protected int current_page;
    public static final int ALL_PAGES = -1;
    protected int print_page = -1;
    protected PageFormat page_format;
    protected JCListenerList printListeners = null;

    public JCPrintTable(JCTable jCTable) {
        this.table = jCTable;
        this.loadSettings(jCTable);
    }

    public void showPrintPreview(String string) {
        JCPrintPreview jCPrintPreview = new JCPrintPreview(string, this);
        jCPrintPreview.showPage(0);
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (printerJob != null) {
            try {
                if (this.page_format == null) {
                    this.setPageFormat(printerJob.defaultPage());
                }
                printerJob.setPrintable(this, this.page_format);
                this.setPageDimensions((int)this.page_format.getWidth(), (int)this.page_format.getHeight());
                this.setPrintPage(-1);
                printerJob.print();
            }
            catch (PrinterException printerException) {
                System.out.println(printerException.getMessage());
            }
        }
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.page_format = pageFormat;
    }

    public void setPrintPage(int n2) {
        this.print_page = n2;
    }

    public PageFormat getPageFormat() {
        return this.page_format;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n2) throws PrinterException {
        if (n2 >= this.getNumPages() || this.print_page != -1 && n2 > 0) {
            return 1;
        }
        if (this.print_page == -1) {
            this.printPage(graphics, n2);
        } else {
            this.printPage(graphics, this.print_page);
        }
        return 0;
    }

    protected void loadSettings(JCTable jCTable) {
        int n2;
        this.columnWidths = jCTable.columnWidths;
        this.cellStyles = jCTable.cellStyles;
        this.rowHeights = jCTable.rowHeights;
        if (this.cellRendererPane != null && this.cellRendererPane.getParent() == this) {
            this.remove(this.cellRendererPane);
        }
        this.cellRendererPane = jCTable.cellRendererPane;
        this.cellAreaHandler = new PrintCellAreaHandler(this);
        this.cellAreaHandler.cellAreaRenderer = new PrintCellAreaRenderer(this.cellAreaHandler);
        this.cellAreaHandler.cellAreaRenderer.borderColor = jCTable.cellAreaHandler.cellAreaRenderer.borderColor;
        this.cellAreaHandler.cellAreaRenderer.borderHighlightColor = jCTable.cellAreaHandler.cellAreaRenderer.borderHighlightColor;
        this.cellAreaHandler.cellAreaRenderer.borderShadowColor = jCTable.cellAreaHandler.cellAreaRenderer.borderShadowColor;
        this.cellAreaHandler.cellArea = jCTable.cellAreaHandler.cellArea;
        this.cellAreaHandler.frozenRowArea = jCTable.cellAreaHandler.frozenRowArea;
        this.cellAreaHandler.columnLabelArea = jCTable.cellAreaHandler.columnLabelArea;
        this.cellAreaHandler.frozenColumnArea = jCTable.cellAreaHandler.frozenColumnArea;
        this.cellAreaHandler.frozenCellArea = jCTable.cellAreaHandler.frozenCellArea;
        this.cellAreaHandler.frozenColumnLabelArea = jCTable.cellAreaHandler.frozenColumnLabelArea;
        this.cellAreaHandler.rowLabelArea = jCTable.cellAreaHandler.rowLabelArea;
        this.cellAreaHandler.frozenRowLabelArea = jCTable.cellAreaHandler.frozenRowLabelArea;
        this.cellAreaHandler.areas = jCTable.cellAreaHandler.areas;
        this.cellAreaHandler.cellInfo = jCTable.cellAreaHandler.cellInfo;
        this.cellAreaHandler.cellOrigin = jCTable.cellAreaHandler.cellOrigin;
        this.dataView = jCTable.dataView;
        int n3 = this.getNumRows();
        int n4 = this.getNumColumns();
        this.column_label_offset = jCTable.column_label_offset;
        this.row_label_offset = jCTable.row_label_offset;
        this.cellLayout = new PrintCellLayout(n3, n4);
        this.cellLayout.setTable(this);
        for (n2 = -1; n2 < n3; ++n2) {
            this.cellLayout.setHeight(n2, jCTable.cellLayout.getHeight(n2));
        }
        for (n2 = -1; n2 < n4; ++n2) {
            this.cellLayout.setWidth(n2, jCTable.cellLayout.getWidth(n2));
        }
        this.tableLayout = new TableLayout(this.cellAreaHandler);
        this.hsb_display = 2;
        this.vsb_display = 2;
        this.component_border_width = jCTable.component_border_width;
        ComponentModel componentModel = jCTable.getFocusManager().getComponentModel();
        this.getFocusManager().setComponentModel(componentModel);
        this.cell_border_width = jCTable.cell_border_width;
        this.column_label_display = jCTable.column_label_display;
        this.column_label_placement = jCTable.column_label_placement;
        this.focus_color = jCTable.focus_color;
        this.focus_indicator = jCTable.focus_indicator;
        this.frame_border = jCTable.frame_border;
        this.frame_border_width = jCTable.frame_border_width;
        this.frozen_columns = jCTable.frozen_columns;
        this.frozen_column_placement = jCTable.frozen_column_placement;
        this.frozen_rows = jCTable.frozen_rows;
        this.frozen_row_placement = jCTable.frozen_row_placement;
        this.margin_height = jCTable.margin_height;
        this.margin_width = jCTable.margin_width;
        this.row_label_display = jCTable.row_label_display;
        this.row_label_placement = jCTable.row_label_placement;
        this.selected_background = jCTable.selected_background;
        this.selected_foreground = jCTable.selected_foreground;
    }

    public void printPage(Graphics graphics, int n2) {
        JCCellRange jCCellRange;
        this.current_page = n2;
        try {
            jCCellRange = this.getPageCellRange(n2);
        }
        catch (IllegalSizeException illegalSizeException) {
            System.out.println(illegalSizeException.getMessage());
            return;
        }
        if (jCCellRange == null) {
            return;
        }
        this.printPage(graphics, jCCellRange);
    }

    public void printPage(Graphics graphics, JCCellRange jCCellRange) {
        int n2;
        int n3;
        int n4;
        ((PrintCellAreaHandler)this.cellAreaHandler).page_range = jCCellRange;
        CellLayoutModel cellLayoutModel = this.table.getCellLayout();
        Dimension dimension = new Dimension(0, 0);
        dimension.width = cellLayoutModel.getWidth(-1) + this.getRowLabelOffset() + this.getFrozenColumnWidth() + this.getColumnPosition(jCCellRange.end_column) - this.getColumnPosition(jCCellRange.start_column) + cellLayoutModel.getWidth(jCCellRange.end_column);
        dimension.height = cellLayoutModel.getHeight(-1) + this.getColumnLabelOffset() + this.getFrozenRowHeight() + this.getRowPosition(jCCellRange.end_row) - this.getRowPosition(jCCellRange.start_row) + cellLayoutModel.getHeight(jCCellRange.end_row);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.page_width, this.page_height);
        Point point = this.getTableOffset();
        graphics.setClip(point.x, point.y, this.table_width, this.table_height);
        if (this.table.spanHandler != null) {
            this.spanHandler = new SpanHandler();
            this.spanHandler.setTable(this);
            Collection collection = this.table.getSpannedRanges();
            try {
                if (collection != null) {
                    for (JCCellRange jCCellRange2 : collection) {
                        JCCellRange jCCellRange3 = new JCCellRange(jCCellRange2.start_row, jCCellRange2.start_column, jCCellRange2.end_row, jCCellRange2.end_column);
                        this.spanHandler.addSpannedRange(jCCellRange3);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.splitSpans(jCCellRange);
        }
        if ((n4 = this.getFrozenColumns()) > 0) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.cellAreaHandler.cellAreaRenderer.paintCell(graphics, -1, i2);
            }
        }
        for (n3 = jCCellRange.start_column; n3 <= jCCellRange.end_column; ++n3) {
            this.cellAreaHandler.cellAreaRenderer.paintCell(graphics, -1, n3);
        }
        n3 = this.getFrozenRows();
        if (n3 > 0) {
            for (int i3 = 0; i3 < n3; ++i3) {
                this.cellAreaHandler.cellAreaRenderer.paintCell(graphics, i3, -1);
            }
        }
        for (n2 = jCCellRange.start_row; n2 <= jCCellRange.end_row; ++n2) {
            this.cellAreaHandler.cellAreaRenderer.paintCell(graphics, n2, -1);
        }
        if (n4 > 0 && n3 > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                for (int i4 = 0; i4 < n4; ++i4) {
                    this.cellAreaHandler.cellAreaRenderer.paintCell(graphics, n2, i4);
                }
            }
        }
        if (n4 > 0) {
            for (n2 = jCCellRange.start_row; n2 <= jCCellRange.end_row; ++n2) {
                for (int i5 = 0; i5 < n4; ++i5) {
                    this.cellAreaHandler.cellAreaRenderer.paintCell(graphics, n2, i5);
                }
            }
        }
        if (n3 > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                for (int i6 = jCCellRange.start_column; i6 <= jCCellRange.end_column; ++i6) {
                    this.cellAreaHandler.cellAreaRenderer.paintCell(graphics, n2, i6);
                }
            }
        }
        for (n2 = jCCellRange.start_row; n2 <= jCCellRange.end_row; ++n2) {
            for (int i7 = jCCellRange.start_column; i7 <= jCCellRange.end_column; ++i7) {
                this.cellAreaHandler.cellAreaRenderer.paintCell(graphics, n2, i7);
            }
        }
        if (this.getFrameBorderWidth() > 0) {
            Serializable serializable;
            Object object;
            Rectangle rectangle;
            Rectangle rectangle2;
            Rectangle rectangle3 = this.cellAreaHandler.getBounds(jCCellRange.start_row, -1);
            Rectangle rectangle4 = this.cellAreaHandler.getBounds(jCCellRange.end_row, -1);
            Rectangle rectangle5 = new Rectangle(rectangle3.x, rectangle3.y, rectangle3.width, rectangle4.y + rectangle4.height - rectangle3.y);
            if (n3 > 0) {
                rectangle2 = this.cellAreaHandler.getBounds(0, -1);
                rectangle = this.cellAreaHandler.getBounds(n3 - 1, -1);
                object = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle.y + rectangle.height - rectangle2.y);
                rectangle5 = new Rectangle(Math.min(rectangle5.x, ((Rectangle)object).x), Math.min(rectangle5.y, ((Rectangle)object).y), Math.max(rectangle5.width, ((Rectangle)object).width), rectangle5.height + ((Rectangle)object).height);
            }
            rectangle3 = this.cellAreaHandler.getBounds(-1, jCCellRange.start_column);
            rectangle4 = this.cellAreaHandler.getBounds(-1, jCCellRange.end_column);
            rectangle2 = new Rectangle(rectangle3.x, rectangle3.y, rectangle4.x + rectangle4.width - rectangle3.x, rectangle3.height);
            if (n4 > 0) {
                rectangle = this.cellAreaHandler.getBounds(-1, 0);
                object = this.cellAreaHandler.getBounds(-1, n4 - 1);
                serializable = new Rectangle(rectangle.x, rectangle.y, ((Rectangle)object).x + ((Rectangle)object).width - rectangle.x, rectangle.height);
                rectangle2 = new Rectangle(Math.min(rectangle2.x, ((Rectangle)serializable).x), Math.min(rectangle2.y, ((Rectangle)serializable).y), rectangle2.width + ((Rectangle)serializable).width, Math.max(rectangle2.height, ((Rectangle)serializable).height));
            }
            rectangle = new Rectangle(rectangle2.x, rectangle5.y, rectangle2.width, rectangle5.height);
            object = this.table.getFrameBorder();
            serializable = this.table.getBackground();
            object.drawBackground(graphics, this.frame_border_width, 15, rectangle5.x - this.frame_border_width, rectangle5.y - this.frame_border_width, rectangle5.width + 2 * this.frame_border_width, rectangle5.height + 2 * this.frame_border_width, ((Color)serializable).brighter(), ((Color)serializable).darker(), (Color)serializable);
            object.drawBackground(graphics, this.frame_border_width, 15, rectangle2.x - this.frame_border_width, rectangle2.y - this.frame_border_width, rectangle2.width + 2 * this.frame_border_width, rectangle2.height + 2 * this.frame_border_width, ((Color)serializable).brighter(), ((Color)serializable).darker(), (Color)serializable);
            object.drawBackground(graphics, this.frame_border_width, 15, rectangle.x - this.frame_border_width, rectangle.y - this.frame_border_width, rectangle.width + 2 * this.frame_border_width, rectangle.height + 2 * this.frame_border_width, ((Color)serializable).brighter(), ((Color)serializable).darker(), (Color)serializable);
        }
        this.doPrintPageHeader(graphics, this.current_page);
        this.doPrintBody(graphics, this.current_page);
        this.doPrintPageFooter(graphics, this.current_page);
        ((PrintCellAreaHandler)this.cellAreaHandler).page_range = null;
    }

    public int getMarginUnits() {
        return this.margin_unit;
    }

    public void setMarginUnits(int n2) {
        this.margin_unit = n2 == 0 ? 0 : 1;
    }

    public int getNumHorizontalPages() throws IllegalSizeException {
        return this.getNumColumnPages();
    }

    public int getNumPages() throws IllegalSizeException {
        if (this.page_width * this.page_height == 0) {
            return 0;
        }
        return this.getNumColumnPages() * this.getNumRowPages();
    }

    public int getNumVerticalPages() {
        return this.getNumRowPages();
    }

    public JCCellRange getPageCellRange(int n2) throws IllegalSizeException {
        if (this.getNumPages() == 0) {
            return null;
        }
        JCCellPosition jCCellPosition = this.getPageStartCell(n2);
        JCCellPosition jCCellPosition2 = this.getPageEndCell(n2);
        return new JCCellRange(jCCellPosition.row, jCCellPosition.column, jCCellPosition2.row, jCCellPosition2.column);
    }

    public Dimension getPageDimensions() {
        return new Dimension(this.page_width, this.page_height);
    }

    public void setPageDimensions(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            n2 = 612;
            n3 = 792;
            this.page_resolution = 72;
        }
        this.page_width = n2;
        this.page_height = n3;
        this.setInternalDimensions();
    }

    public int getPageHeight() {
        return this.page_height;
    }

    public void setPageHeight(int n2) {
        this.page_height = n2;
        this.setInternalDimensions();
    }

    public Insets getPageMargins() {
        return this.margin;
    }

    public Insets getDefaultPageMargins() {
        this.margin_unit = 1;
        this.margin = new Insets(72, 72, 72, 72);
        return this.margin;
    }

    public void setPageMargins(Insets insets) {
        if (insets == null) {
            insets = this.getDefaultPageMargins();
        } else {
            this.margin = insets;
        }
        this.setInternalDimensions();
    }

    public int getPageResolution() {
        return this.page_resolution;
    }

    public void setPageResolution(int n2) {
        this.page_resolution = n2;
        this.setInternalDimensions();
    }

    public int getPageWidth() {
        return this.page_width;
    }

    public void setPageWidth(int n2) {
        this.page_width = n2;
        this.setInternalDimensions();
    }

    public Point getBounds(int n2, int n3) {
        Point point = new Point(0, 0);
        JCCellRange jCCellRange = this.getPageCellRange(this.current_page);
        if (n2 == -1) {
            if (n3 < this.frozen_columns) {
                point.x = this.getRowLabelPlacement() == 2 ? (this.getFrozenColumnPlacement() == 2 ? this.getRowLabelWidth() + this.getRowLabelOffset() + 3 * this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).width - this.getFrozenColumnWidth() - this.getFrameBorderWidth()) : (this.getFrozenColumnPlacement() == 2 ? this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).width - this.getRowLabelWidth() - this.getRowLabelOffset() - this.getFrozenColumnWidth() - 3 * this.getFrameBorderWidth());
                point.x += this.getColumnPosition(n3) - this.getColumnPosition(0);
            } else {
                point.x = this.getRowLabelPlacement() == 2 ? this.getRowLabelWidth() + this.getRowLabelOffset() + 3 * this.getFrameBorderWidth() : this.getFrameBorderWidth();
                if (this.frozen_columns > 0 && this.getFrozenColumnPlacement() == 2) {
                    point.x += this.getFrozenColumnWidth();
                }
                point.x += this.getColumnPosition(n3) - this.getColumnPosition(jCCellRange.start_column);
            }
            point.y = this.getColumnLabelPlacement() == 1 ? this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).height - this.getColumnLabelHeight() - this.getColumnLabelOffset() - 2 * this.getFrameBorderWidth();
        } else if (n3 == -1) {
            point.x = this.getRowLabelPlacement() == 2 ? this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).width - this.getRowLabelWidth() - this.getRowLabelOffset() - 2 * this.getFrameBorderWidth();
            if (n2 < this.frozen_rows) {
                point.y = this.getColumnLabelPlacement() == 1 ? (this.getFrozenRowPlacement() == 1 ? this.getColumnLabelHeight() + this.getColumnLabelOffset() + 3 * this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).height - this.getFrozenRowHeight() - this.getFrameBorderWidth()) : (this.getFrozenRowPlacement() == 1 ? this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).height - this.getColumnLabelHeight() - this.getColumnLabelOffset() - this.getFrozenRowHeight() - 3 * this.getFrameBorderWidth());
                point.y += this.getRowPosition(n2) - this.getRowPosition(0);
            } else {
                point.y = this.getColumnLabelPlacement() == 1 ? this.getColumnLabelHeight() + this.getColumnLabelOffset() + 3 * this.getFrameBorderWidth() : this.getFrameBorderWidth();
                if (this.frozen_rows > 0 && this.getFrozenRowPlacement() == 1) {
                    point.y += this.getFrozenRowHeight();
                }
                point.y += this.getRowPosition(n2) - this.getRowPosition(jCCellRange.start_row);
            }
        } else {
            if (n3 < this.frozen_columns) {
                point.x = this.getRowLabelPlacement() == 2 ? (this.getFrozenColumnPlacement() == 2 ? this.getRowLabelWidth() + this.getRowLabelOffset() + 3 * this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).width - this.getFrozenColumnWidth() - this.getFrameBorderWidth()) : (this.getFrozenColumnPlacement() == 2 ? this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).width - this.getRowLabelWidth() - this.getRowLabelOffset() - this.getFrozenColumnWidth() - 3 * this.getFrameBorderWidth());
                point.x += this.getColumnPosition(n3) - this.getColumnPosition(0);
            } else {
                point.x = this.getRowLabelPlacement() == 2 ? this.getRowLabelWidth() + this.getRowLabelOffset() + 3 * this.getFrameBorderWidth() : this.getFrameBorderWidth();
                if (this.frozen_columns > 0 && this.getFrozenColumnPlacement() == 2) {
                    point.x += this.getFrozenColumnWidth();
                }
                point.x += this.getColumnPosition(n3) - this.getColumnPosition(jCCellRange.start_column);
            }
            if (n2 < this.frozen_rows) {
                point.y = this.getColumnLabelPlacement() == 1 ? (this.getFrozenRowPlacement() == 1 ? this.getColumnLabelHeight() + this.getColumnLabelOffset() + 3 * this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).height - this.getFrozenRowHeight() - this.getFrameBorderWidth()) : (this.getFrozenRowPlacement() == 1 ? this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).height - this.getColumnLabelHeight() - this.getColumnLabelOffset() - this.getFrozenRowHeight() - 3 * this.getFrameBorderWidth());
                point.y += this.getRowPosition(n2) - this.getRowPosition(0);
            } else {
                point.y = this.getColumnLabelPlacement() == 1 ? this.getColumnLabelHeight() + this.getColumnLabelOffset() + 3 * this.getFrameBorderWidth() : this.getFrameBorderWidth();
                if (this.frozen_rows > 0 && this.getFrozenRowPlacement() == 1) {
                    point.y += this.getFrozenRowHeight();
                }
                point.y += this.getRowPosition(n2) - this.getRowPosition(jCCellRange.start_row);
            }
        }
        Point point2 = this.getTableOffset();
        point.x += point2.x;
        point.y += point2.y;
        return point;
    }

    public Dimension getTableDimensions(int n2) {
        return this.getTablePageDimension(this.getPageCellRange(n2));
    }

    private Rectangle getCellRangeBounds(JCCellRange jCCellRange) {
        return this.getCellLayout().getBounds(jCCellRange.start_row, jCCellRange.start_column, jCCellRange.end_row, jCCellRange.end_column);
    }

    private int getColumnLabelHeight() {
        if (this.column_label_display) {
            return this.getCellLayout().getHeight(-1);
        }
        return 0;
    }

    private int getColumnPosition(int n2) {
        CellLayoutModel cellLayoutModel = this.getCellLayout();
        return cellLayoutModel.getColumnPosition(n2);
    }

    private int getFrozenColumnWidth() {
        CellLayoutModel cellLayoutModel = this.getCellLayout();
        int n2 = 0;
        for (int i2 = 0; i2 < this.getFrozenColumns(); ++i2) {
            n2 += cellLayoutModel.getWidth(i2);
        }
        return n2;
    }

    private int getFrozenRowHeight() {
        CellLayoutModel cellLayoutModel = this.getCellLayout();
        int n2 = 0;
        for (int i2 = 0; i2 < this.getFrozenRows(); ++i2) {
            n2 += cellLayoutModel.getHeight(i2);
        }
        return n2;
    }

    private void setInternalDimensions() {
        int n2;
        if (this.page_width == 0 || this.page_height == 0) {
            return;
        }
        int n3 = this.margin_unit == 0 ? this.page_resolution : 1;
        this.table_width = this.page_width - n3 * (this.margin.left + this.margin.right);
        this.table_height = this.page_height - n3 * (this.margin.top + this.margin.bottom);
        CellLayoutModel cellLayoutModel = this.getCellLayout();
        int n4 = this.table_width - this.getRowLabelWidth() - this.getRowLabelOffset() - this.getFrozenColumnWidth() - 4 * this.getFrameBorderWidth();
        for (n2 = this.getFrozenColumns(); n2 < this.getNumColumns(); ++n2) {
            if (cellLayoutModel.getWidth(n2) <= n4) continue;
            cellLayoutModel.setWidth(n2, n4);
        }
        n2 = this.table_height - this.getColumnLabelHeight() - this.getColumnLabelOffset() - this.getFrozenRowHeight() - 4 * this.getFrameBorderWidth();
        for (int i2 = this.getFrozenRows(); i2 < this.getNumRows(); ++i2) {
            if (cellLayoutModel.getHeight(i2) <= n2) continue;
            cellLayoutModel.setHeight(i2, n2);
        }
    }

    private int getNumColumnPages() throws IllegalSizeException {
        int n2;
        int n3 = 1;
        int n4 = this.getRowLabelWidth();
        if (n4 + this.row_label_offset + (n2 = this.getFrozenColumnWidth()) + 4 * this.frame_border_width > this.table_width) {
            throw new IllegalSizeException("The total width of row labels and frozen columns is larger than the page width.");
        }
        CellLayoutModel cellLayoutModel = this.getCellLayout();
        int n5 = n4 + this.row_label_offset + n2 + 4 * this.frame_border_width;
        for (int i2 = this.frozen_columns; i2 < this.getNumColumns(); ++i2) {
            if ((n5 += cellLayoutModel.getWidth(i2)) <= this.table_width) continue;
            n5 = n4 + this.row_label_offset + n2 + 4 * this.frame_border_width + cellLayoutModel.getWidth(i2);
            ++n3;
        }
        return n3;
    }

    private int getNumRowPages() throws IllegalSizeException {
        int n2;
        int n3 = 1;
        int n4 = this.getColumnLabelHeight();
        if (n4 + this.column_label_offset + (n2 = this.getFrozenRowHeight()) + 4 * this.frame_border_width > this.table_height) {
            throw new IllegalSizeException("The total height of column labels and frozen rows is larger than the page height.");
        }
        CellLayoutModel cellLayoutModel = this.getCellLayout();
        int n5 = n4 + this.column_label_offset + n2 + 4 * this.frame_border_width;
        for (int i2 = this.getFrozenRows(); i2 < this.getNumRows(); ++i2) {
            if ((n5 += cellLayoutModel.getHeight(i2)) <= this.table_height) continue;
            n5 = n4 + this.column_label_offset + n2 + 4 * this.frame_border_width + cellLayoutModel.getHeight(i2);
            ++n3;
        }
        return n3;
    }

    private JCCellPosition getPageStartCell(int n2) throws IllegalSizeException {
        int n3 = this.getNumColumnPages();
        int n4 = n2 / n3 + 1;
        int n5 = n2 % n3 + 1;
        int n6 = this.frozen_columns;
        n6 = n5 == 1 ? this.frozen_columns : this.getPageEndCell((int)(n2 - 1)).column + 1;
        int n7 = this.frozen_rows;
        n7 = n4 == 1 ? this.frozen_rows : (n5 == 1 ? this.getPageEndCell((int)(n2 - 1)).row + 1 : this.getPageEndCell((int)(n3 * (n4 - 1) - 1)).row + 1);
        return new JCCellPosition(n7, n6);
    }

    private JCCellPosition getPageEndCell(int n2) throws IllegalSizeException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.getNumColumnPages();
        int n8 = this.getNumRowPages();
        int n9 = n2 / n7 + 1;
        int n10 = n2 % n7 + 1;
        CellLayoutModel cellLayoutModel = this.getCellLayout();
        int n11 = this.frozen_columns;
        if (n10 == n7) {
            n11 = this.getNumColumns() - 1;
        } else {
            n6 = this.frozen_columns;
            if (n10 > 1) {
                n6 = this.getPageEndCell((int)(n2 - 1)).column + 1;
            }
            n5 = this.table_width - this.getRowLabelWidth() - this.getRowLabelOffset() - this.getFrozenColumnWidth() - 4 * this.getFrameBorderWidth();
            n4 = 0;
            for (n3 = n6; n3 < this.getNumColumns(); ++n3) {
                if ((n4 += cellLayoutModel.getWidth(n3)) > n5) continue;
                n11 = n3;
            }
        }
        n6 = this.frozen_rows;
        if (n9 == n8) {
            n6 = this.getNumRows() - 1;
        } else {
            n5 = this.frozen_rows;
            if (n9 > 1 && n10 == 1) {
                n5 = this.getPageEndCell((int)(n2 - 1)).row + 1;
            } else if (n9 > 1 && n10 != 1) {
                n5 = this.getPageEndCell((int)(n7 * (n9 - 1) - 1)).row + 1;
            }
            n3 = this.table_height - this.getColumnLabelHeight() - this.getColumnLabelOffset() - this.getFrozenRowHeight() - 4 * this.getFrameBorderWidth();
            n4 = 0;
            for (int i2 = n5; i2 < this.getNumRows(); ++i2) {
                if ((n4 += cellLayoutModel.getHeight(i2)) > n3) continue;
                n6 = i2;
            }
        }
        return new JCCellPosition(n6, n11);
    }

    private int getRowLabelWidth() {
        if (this.row_label_display) {
            return this.getCellLayout().getWidth(-1);
        }
        return 0;
    }

    private int getRowPosition(int n2) {
        CellLayoutModel cellLayoutModel = this.getCellLayout();
        return cellLayoutModel.getRowPosition(n2);
    }

    private Point getTableOffset() {
        int n2 = 1;
        if (this.margin_unit == 0) {
            n2 = this.page_resolution;
        }
        return new Point(n2 * this.margin.left, n2 * this.margin.top);
    }

    private Dimension getTablePageDimension(JCCellRange jCCellRange) {
        Rectangle rectangle = this.getCellRangeBounds(jCCellRange);
        return new Dimension(this.getRowLabelWidth() + this.getRowLabelOffset() + 4 * this.getFrameBorderWidth() + this.getFrozenColumnWidth() + rectangle.width, this.getColumnLabelHeight() + this.getColumnLabelOffset() + 4 * this.getFrameBorderWidth() + this.getFrozenRowHeight() + rectangle.height);
    }

    private void splitSpans(JCCellRange jCCellRange) {
        if (this.spanHandler != null) {
            Vector<JCCellRange> vector = new Vector<JCCellRange>();
            Collection collection = this.spanHandler.getSpannedRanges();
            if (collection != null) {
                for (JCCellRange jCCellRange2 : collection) {
                    JCCellRange jCCellRange3 = new JCCellRange(jCCellRange2.start_row, jCCellRange2.start_column, jCCellRange2.end_row, jCCellRange2.end_column);
                    if (jCCellRange2.start_row < jCCellRange.start_row && jCCellRange2.end_row >= jCCellRange.end_row) {
                        jCCellRange3.reshape(jCCellRange3.start_row, jCCellRange3.start_column, jCCellRange.start_row - 1, jCCellRange3.end_column);
                    }
                    if (jCCellRange2.start_row <= jCCellRange.end_row && jCCellRange2.end_row > jCCellRange.end_row) {
                        jCCellRange3.reshape(jCCellRange3.start_row, jCCellRange3.start_column, jCCellRange.end_row, jCCellRange3.end_column);
                    }
                    if (jCCellRange2.start_column < jCCellRange.start_column && jCCellRange2.end_column >= jCCellRange.start_column) {
                        jCCellRange3.reshape(jCCellRange3.start_row, jCCellRange.start_column, jCCellRange3.end_row, jCCellRange3.end_column);
                    }
                    if (jCCellRange2.start_column <= jCCellRange.end_column && jCCellRange2.end_column > jCCellRange.end_column) {
                        jCCellRange3.reshape(jCCellRange3.start_row, jCCellRange3.start_column, jCCellRange3.end_row, jCCellRange.end_column);
                    }
                    vector.addElement(jCCellRange3);
                }
            }
            try {
                this.spanHandler.setSpannedRanges(vector);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void doPrintPageHeader(Graphics graphics, int n2) {
        if (this.printListeners != null) {
            Graphics graphics2 = graphics.create();
            graphics2.setColor(Color.black);
            graphics2.setFont(this.getFont());
            int n3 = this.margin_unit == 0 ? this.page_resolution : 1;
            graphics2.setClip(n3 * this.margin.left, 0, this.table_width, n3 * this.margin.top);
            graphics2.translate(n3 * this.margin.left, 0);
            JCPrintEvent jCPrintEvent = new JCPrintEvent(this, graphics2, n2 + 1, this.getNumPages(), 1, this);
            this.fireJCPrintEvent(jCPrintEvent);
            graphics2.dispose();
        }
    }

    private void doPrintBody(Graphics graphics, int n2) {
        if (this.printListeners != null) {
            Graphics graphics2 = graphics.create();
            graphics2.setColor(Color.black);
            graphics2.setFont(this.getFont());
            JCPrintEvent jCPrintEvent = new JCPrintEvent(this, graphics2, n2 + 1, this.getNumPages(), 2, this);
            this.fireJCPrintEvent(jCPrintEvent);
            graphics2.dispose();
        }
    }

    private void doPrintPageFooter(Graphics graphics, int n2) {
        Graphics graphics2 = graphics.create();
        graphics2.setColor(Color.black);
        graphics2.setFont(this.getFont());
        int n3 = this.margin_unit == 0 ? this.page_resolution : 1;
        graphics2.setClip(n3 * this.margin.left, this.page_height - n3 * this.margin.bottom, this.table_width, n3 * this.margin.bottom);
        graphics2.translate(n3 * this.margin.left, this.page_height - n3 * this.margin.bottom);
        if (this.printListeners != null) {
            JCPrintEvent jCPrintEvent = new JCPrintEvent(this, graphics2, n2 + 1, this.getNumPages(), 3, this);
            this.fireJCPrintEvent(jCPrintEvent);
        } else {
            this.printPageFooter(graphics, n2 + 1);
        }
        graphics2.dispose();
    }

    private void printPageFooter(Graphics graphics, int n2) {
        Graphics graphics2 = graphics.create();
        int n3 = this.margin_unit == 0 ? this.page_resolution : 1;
        graphics2.setClip(n3 * this.margin.left, this.page_height - n3 * this.margin.bottom, this.table_width, n3 * this.margin.bottom);
        graphics2.translate(n3 * this.margin.left, this.page_height - n3 * this.margin.bottom);
        Rectangle rectangle = graphics2.getClipBounds();
        graphics2.setColor(Color.black);
        graphics2.setFont(this.getFont());
        String string = LocaleBundle.string("Page ") + n2 + LocaleBundle.string(" of ") + this.getNumPages();
        graphics2.drawString(string, 0, rectangle.height / 2);
    }

    protected void fireJCPrintEvent(JCPrintEvent jCPrintEvent) {
        Enumeration<Object> enumeration = JCListenerList.elements(this.printListeners);
        while (enumeration.hasMoreElements()) {
            JCPrintListener jCPrintListener = (JCPrintListener)enumeration.nextElement();
            switch (jCPrintEvent.getType()) {
                case 1: {
                    jCPrintListener.printPageHeader(jCPrintEvent);
                    break;
                }
                case 2: {
                    jCPrintListener.printPageBody(jCPrintEvent);
                    break;
                }
                case 3: {
                    jCPrintListener.printPageFooter(jCPrintEvent);
                }
            }
        }
    }

    public void addPrintListener(JCPrintListener jCPrintListener) {
        this.printListeners = JCListenerList.add(this.printListeners, jCPrintListener);
    }

    public void removePrintListener(JCPrintListener jCPrintListener) {
        this.printListeners = JCListenerList.remove(this.printListeners, jCPrintListener);
    }

    class IllegalSizeException
    extends IllegalStateException {
        protected IllegalSizeException(String string) {
            super(string);
        }
    }
}

