/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;

public class JCCellRange
implements Serializable {
    public int start_row;
    public int start_column;
    public int end_row;
    public int end_column;

    public JCCellRange() {
        this.reshape(-999, -999, -999, -999);
    }

    public JCCellRange(int n2, int n3, int n4, int n5) {
        this.reshape(n2, n3, n4, n5);
    }

    public JCCellRange(Rectangle rectangle) {
        this.reshape(rectangle.y, rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width);
    }

    private static int min(int n2, int n3) {
        return n2 < n3 ? n2 : n3;
    }

    private static int max(int n2, int n3) {
        return n2 > n3 ? n2 : n3;
    }

    private void validate() {
        int n2;
        if (this.start_row >= -1 && this.end_row >= -1 && this.start_row > this.end_row) {
            n2 = this.start_row;
            this.start_row = this.end_row;
            this.end_row = n2;
        }
        if (this.start_column >= -1 && this.end_column >= -1 && this.start_column > this.end_column) {
            n2 = this.start_column;
            this.start_column = this.end_column;
            this.end_column = n2;
        }
    }

    public final JCCellRange reshape(int n2, int n3, int n4, int n5) {
        this.start_row = n2;
        this.start_column = n3;
        this.end_row = n4;
        this.end_column = n5;
        this.validate();
        return this;
    }

    public final JCCellRange reshape(int n2, int n3) {
        this.start_row = this.end_row = n2;
        this.start_column = this.end_column = n3;
        return this;
    }

    public final JCCellRange reshape(JCCellRange jCCellRange) {
        this.start_row = jCCellRange.start_row;
        this.start_column = jCCellRange.start_column;
        this.end_row = jCCellRange.end_row;
        this.end_column = jCCellRange.end_column;
        this.validate();
        return this;
    }

    public final JCCellRange reshape(Rectangle rectangle) {
        this.start_row = rectangle.y;
        this.start_column = rectangle.x;
        this.end_row = rectangle.y + rectangle.height;
        this.end_column = rectangle.x + rectangle.width;
        return this;
    }

    public final boolean equals(JCCellRange jCCellRange) {
        return jCCellRange.start_row == this.start_row && jCCellRange.start_column == this.start_column && jCCellRange.end_row == this.end_row && jCCellRange.end_column == this.end_column;
    }

    public final boolean intersects(JCCellRange jCCellRange) {
        return jCCellRange.end_column >= this.start_column && jCCellRange.end_row >= this.start_row && jCCellRange.start_column <= this.end_column && jCCellRange.start_row <= this.end_row;
    }

    public final boolean overlaps(JCCellRange jCCellRange) {
        return this.end_row >= jCCellRange.start_row && this.start_row <= jCCellRange.end_row && this.end_column >= jCCellRange.start_column && this.start_column <= jCCellRange.end_column;
    }

    public final JCCellRange intersection(JCCellRange jCCellRange) {
        if (!this.intersects(jCCellRange)) {
            return null;
        }
        return new JCCellRange(JCCellRange.max(this.start_row, jCCellRange.start_row), JCCellRange.max(this.start_column, jCCellRange.start_column), JCCellRange.min(this.end_row, jCCellRange.end_row), JCCellRange.min(this.end_column, jCCellRange.end_column));
    }

    public final void intersection(JCCellRange jCCellRange, JCCellRange jCCellRange2) {
        if (!this.intersects(jCCellRange)) {
            return;
        }
        if (jCCellRange2 == null) {
            throw new IllegalArgumentException("Range to store result cannot be null");
        }
        jCCellRange2.reshape(JCCellRange.max(this.start_row, jCCellRange.start_row), JCCellRange.max(this.start_column, jCCellRange.start_column), JCCellRange.min(this.end_row, jCCellRange.end_row), JCCellRange.min(this.end_column, jCCellRange.end_column));
    }

    public final JCCellRange combination(JCCellRange jCCellRange) {
        return new JCCellRange(JCCellRange.min(this.start_row, jCCellRange.start_row), JCCellRange.min(this.start_column, jCCellRange.start_column), JCCellRange.max(this.end_row, jCCellRange.end_row), JCCellRange.max(this.end_column, jCCellRange.end_column));
    }

    public final boolean inside(int n2, int n3) {
        return this.start_row != -999 && (this.start_row < this.end_row ? this.start_row : this.end_row) <= n2 && (this.start_row > this.end_row ? this.start_row : this.end_row) >= n2 && (this.start_column < this.end_column ? this.start_column : this.end_column) <= n3 && (this.start_column > this.end_column ? this.start_column : this.end_column) >= n3;
    }

    public final boolean inRowRange(int n2) {
        return this.start_row != -999 && n2 >= this.start_row && n2 <= this.end_row;
    }

    public final boolean inRowRange2(int n2) {
        return JCCellRange.min(this.start_row, this.end_row) <= n2 && (this.start_row > this.end_row ? this.start_row : this.end_row) >= n2;
    }

    public final boolean inColumnRange(int n2) {
        return this.start_row != -999 && n2 >= this.start_column && n2 <= this.end_column;
    }

    public final boolean inColumnRange2(int n2) {
        return JCCellRange.min(this.start_column, this.end_column) <= n2 && JCCellRange.max(this.start_column, this.end_column) >= n2;
    }

    public String toString() {
        return "R" + this.start_row + "C" + this.start_column + ":R" + this.end_row + ":C" + this.end_column;
    }

    public static void main(String[] stringArray) {
        JCCellRange jCCellRange = new JCCellRange(-1, -1, -1, -1);
        JCCellRange jCCellRange2 = new JCCellRange(4, 7, 10, 15);
        JCCellRange jCCellRange3 = new JCCellRange(3, 5, 4, 7);
        JCCellRange jCCellRange4 = new JCCellRange(1, 0, 3, 5);
        System.out.println("test1:");
        JCCellRange.testIntersection(jCCellRange, jCCellRange2, jCCellRange3, jCCellRange4);
        JCCellRange.testCombination(jCCellRange, jCCellRange2, jCCellRange3, jCCellRange4);
        JCCellRange.testSpans(jCCellRange, jCCellRange2, jCCellRange3, jCCellRange4, 6, 13, 6, 13);
        jCCellRange = new JCCellRange(-1, 1, -1, 2);
        jCCellRange2 = new JCCellRange(3, 1, 3, 2);
        jCCellRange3 = new JCCellRange(-1, 5, -1, 7);
        jCCellRange4 = new JCCellRange(3, 5, 3, 7);
        System.out.println("test2:");
        JCCellRange.testIntersection(jCCellRange, jCCellRange2, jCCellRange3, jCCellRange4);
        JCCellRange.testCombination(jCCellRange, jCCellRange2, jCCellRange3, jCCellRange4);
        JCCellRange.testSpans(jCCellRange, jCCellRange2, jCCellRange3, jCCellRange4, -1, 2, 3, 3);
    }

    private static void testIntersection(JCCellRange jCCellRange, JCCellRange jCCellRange2, JCCellRange jCCellRange3, JCCellRange jCCellRange4) {
        System.out.println("c1 vs c2:" + jCCellRange.intersects(jCCellRange2) + " " + jCCellRange2.intersects(jCCellRange));
        System.out.println("c1 vs c3:" + jCCellRange.intersects(jCCellRange3) + " " + jCCellRange3.intersects(jCCellRange));
        System.out.println("c2 vs c3:" + jCCellRange2.intersects(jCCellRange3) + " " + jCCellRange3.intersects(jCCellRange2));
        System.out.println("c1 vs c4:" + jCCellRange.intersects(jCCellRange4) + " " + jCCellRange4.intersects(jCCellRange));
        System.out.println("c2 vs c4:" + jCCellRange2.intersects(jCCellRange4) + " " + jCCellRange4.intersects(jCCellRange2));
        System.out.println("c3 vs c4:" + jCCellRange3.intersects(jCCellRange4) + " " + jCCellRange4.intersects(jCCellRange3));
    }

    private static void testCombination(JCCellRange jCCellRange, JCCellRange jCCellRange2, JCCellRange jCCellRange3, JCCellRange jCCellRange4) {
        System.out.println("c1 vs c2:" + jCCellRange.combination(jCCellRange2));
        System.out.println("c1 vs c3:" + jCCellRange.combination(jCCellRange3));
        System.out.println("c2 vs c3:" + jCCellRange2.combination(jCCellRange3));
        System.out.println("c1 vs c4:" + jCCellRange.combination(jCCellRange4));
        System.out.println("c2 vs c4:" + jCCellRange2.combination(jCCellRange4));
        System.out.println("c3 vs c4:" + jCCellRange3.combination(jCCellRange4));
    }

    private static void testSpans(JCCellRange jCCellRange, JCCellRange jCCellRange2, JCCellRange jCCellRange3, JCCellRange jCCellRange4, int n2, int n3, int n4, int n5) {
        Vector<JCCellRange> vector = new Vector<JCCellRange>();
        vector.add(jCCellRange);
        vector.add(jCCellRange2);
        vector.add(jCCellRange3);
        vector.add(jCCellRange4);
        JCCellRange jCCellRange5 = JCCellRange.getCompleteRange(vector, n2, n3, n4, n5);
        System.out.println("completeRange:" + jCCellRange5);
    }

    private static JCCellRange getCompleteRange(Vector vector, int n2, int n3, int n4, int n5) {
        JCCellRange jCCellRange = new JCCellRange(n2, n3, n4, n5);
        if (vector != null && vector.size() > 0) {
            JCCellRange jCCellRange2;
            do {
                jCCellRange2 = jCCellRange;
                for (int i2 = 0; i2 < vector.size(); ++i2) {
                    JCCellRange jCCellRange3 = (JCCellRange)vector.elementAt(i2);
                    if (!jCCellRange.intersects(jCCellRange3)) continue;
                    jCCellRange = jCCellRange.combination(jCCellRange3);
                }
            } while (!jCCellRange2.equals(jCCellRange));
        }
        return jCCellRange;
    }
}

