/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.Moveable;

class DataViewSupport {
    DataViewSupport() {
    }

    protected static boolean dragColumn(JCTable jCTable, int n2, int n3) {
        return DataViewSupport.moveColumns(jCTable, n2, 1, n3);
    }

    protected static boolean moveColumns(JCTable jCTable, int n2, int n3, int n4) {
        if (!DataViewSupport.validateMoveColumns(jCTable, n2, n3, n4)) {
            return false;
        }
        if (n2 + n3 == n4) {
            return true;
        }
        DataViewSupport.moveColumnSeries(jCTable, n2, n3, n4);
        return true;
    }

    protected static void moveColumnSeries(JCTable jCTable, int n2, int n3, int n4) {
        if (jCTable.moveables != null) {
            for (int i2 = 0; i2 < jCTable.moveables.size(); ++i2) {
                Moveable moveable = (Moveable)jCTable.moveables.elementAt(i2);
                moveable.moveColumns(n2, n3, n4);
            }
        }
        if (jCTable.columnWidths != null) {
            jCTable.columnWidths.move(n2, n3, n4);
            if (jCTable.cellLayout != null) {
                jCTable.cellLayout.moveColumns(n2, n3, n4);
            }
        }
    }

    static boolean swapColumnArrays(JCTable jCTable, int[] nArray, int[] nArray2) {
        int n2;
        int[] nArray3 = new int[nArray2.length];
        int[] nArray4 = new int[nArray2.length];
        int[] nArray5 = new int[nArray2.length];
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            nArray4[nArray[n2]] = n2;
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            nArray3[nArray2[n2]] = n2;
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            nArray5[n2] = nArray3[nArray[n2]];
        }
        if (jCTable.moveables != null) {
            for (n2 = 0; n2 < jCTable.moveables.size(); ++n2) {
                Moveable moveable = (Moveable)jCTable.moveables.elementAt(n2);
                moveable.remapColumns(nArray5);
            }
        }
        if (jCTable.columnWidths != null) {
            jCTable.columnWidths.remap(nArray5);
            if (jCTable.cellLayout != null) {
                jCTable.cellLayout.remapColumns(nArray4, nArray2);
            }
        }
        return true;
    }

    protected static boolean swapColumns(JCTable jCTable, int n2, int n3) {
        DataViewSupport.swapColumnSeries(jCTable, n2, n3);
        if (jCTable.cellLayout != null) {
            int n4 = jCTable.cellLayout.getWidth(n2);
            int n5 = jCTable.cellLayout.getWidth(n3);
            jCTable.cellLayout.setWidth(n2, n5);
            jCTable.cellLayout.setWidth(n3, n4);
        }
        return true;
    }

    protected static void swapColumnSeries(JCTable jCTable, int n2, int n3) {
        if (jCTable.moveables != null) {
            for (int i2 = 0; i2 < jCTable.moveables.size(); ++i2) {
                Moveable moveable = (Moveable)jCTable.moveables.elementAt(i2);
                moveable.swapColumns(n2, n3);
            }
        }
        if (jCTable.columnWidths != null) {
            jCTable.columnWidths.swap(n2, n3);
        }
    }

    protected static boolean validateMoveColumns(JCTable jCTable, int n2, int n3, int n4) {
        int n5 = jCTable.getNumColumns();
        if (n3 <= 0) {
            return false;
        }
        if (n2 < 0 || n2 + n3 > n5) {
            return false;
        }
        if (n4 < 0 || n4 > n5 || n2 <= n4 && n4 < n2 + n3) {
            return false;
        }
        return n3 < n5;
    }

    protected static void addColumn(JCTable jCTable, int n2, int n3, int n4, int n5) {
        if (n2 < n5 - n3) {
            DataViewSupport.shiftColumnSeries(jCTable, n2, n3, 1);
        }
        if (jCTable.cellLayout != null) {
            jCTable.cellLayout.addColumns(n2, n3);
        }
        for (int i2 = n2; i2 < n2 + n4; ++i2) {
            jCTable.requestChange(32, -999, i2);
        }
    }

    static void deleteColumn(JCTable jCTable, int n2, int n3, int n4, int n5) {
        DataViewSupport.shiftColumnSeries(jCTable, n2, n3, -1);
        if (jCTable.cellLayout != null) {
            jCTable.cellLayout.deleteColumns(n2, n3);
        }
    }

    protected static void shiftColumnSeries(JCTable jCTable, int n2, int n3, int n4) {
        if (jCTable.moveables != null) {
            for (int i2 = 0; i2 < jCTable.moveables.size(); ++i2) {
                Moveable moveable = (Moveable)jCTable.moveables.elementAt(i2);
                moveable.shiftColumn(n2, n3, n4);
            }
        }
        if (jCTable.columnWidths != null) {
            jCTable.columnWidths.shift(n2, n3, n4);
        }
    }

    protected static boolean dragRow(JCTable jCTable, int n2, int n3) {
        return DataViewSupport.moveRows(jCTable, n2, 1, n3);
    }

    protected static boolean moveRows(JCTable jCTable, int n2, int n3, int n4) {
        if (!DataViewSupport.validateMoveRows(jCTable, n2, n3, n4)) {
            return false;
        }
        if (n2 + n3 == n4) {
            return true;
        }
        DataViewSupport.moveRowSeries(jCTable, n2, n3, n4);
        return true;
    }

    protected static void moveRowSeries(JCTable jCTable, int n2, int n3, int n4) {
        if (jCTable.moveables != null) {
            for (int i2 = 0; i2 < jCTable.moveables.size(); ++i2) {
                Moveable moveable = (Moveable)jCTable.moveables.elementAt(i2);
                moveable.moveRows(n2, n3, n4);
            }
        }
        if (jCTable.rowHeights != null) {
            jCTable.rowHeights.move(n2, n3, n4);
            if (jCTable.cellLayout != null) {
                jCTable.cellLayout.moveRows(n2, n3, n4);
            }
        }
    }

    protected static boolean swapRows(JCTable jCTable, int n2, int n3) {
        DataViewSupport.swapRowSeries(jCTable, n2, n3);
        if (jCTable.cellLayout != null) {
            int n4 = jCTable.cellLayout.getHeight(n2);
            int n5 = jCTable.cellLayout.getHeight(n3);
            jCTable.cellLayout.setHeight(n2, n5);
            jCTable.cellLayout.setHeight(n3, n4);
        }
        return true;
    }

    protected static boolean swapRowArrays(JCTable jCTable, int[] nArray, int[] nArray2) {
        int n2;
        int[] nArray3 = new int[nArray2.length];
        int[] nArray4 = new int[nArray2.length];
        int[] nArray5 = new int[nArray2.length];
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            nArray4[nArray[n2]] = n2;
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            nArray3[nArray2[n2]] = n2;
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            nArray5[n2] = nArray3[nArray[n2]];
        }
        if (jCTable.moveables != null) {
            for (n2 = 0; n2 < jCTable.moveables.size(); ++n2) {
                Moveable moveable = (Moveable)jCTable.moveables.elementAt(n2);
                moveable.remapRows(nArray5);
            }
        }
        if (jCTable.rowHeights != null) {
            jCTable.rowHeights.remap(nArray5);
            if (jCTable.cellLayout != null) {
                jCTable.cellLayout.remapRows(nArray4, nArray2);
            }
        }
        return true;
    }

    protected static void swapRowSeries(JCTable jCTable, int n2, int n3) {
        if (jCTable.moveables != null) {
            for (int i2 = 0; i2 < jCTable.moveables.size(); ++i2) {
                Moveable moveable = (Moveable)jCTable.moveables.elementAt(i2);
                moveable.swapRows(n2, n3);
            }
        }
        if (jCTable.rowHeights != null) {
            jCTable.rowHeights.swap(n2, n3);
        }
    }

    protected static boolean validateMoveRows(JCTable jCTable, int n2, int n3, int n4) {
        int n5 = jCTable.getNumRows();
        if (n3 <= 0) {
            return false;
        }
        if (n2 < 0 || n2 + n3 > n5) {
            return false;
        }
        if (n4 < 0 || n4 > n5 || n2 <= n4 && n4 < n2 + n3) {
            return false;
        }
        return n3 < n5;
    }

    protected static void addRow(JCTable jCTable, int n2, int n3, int n4, int n5) {
        if (n2 < n4 - n3) {
            DataViewSupport.shiftRowSeries(jCTable, n2, n3, 1);
        }
        if (jCTable.cellLayout != null) {
            jCTable.cellLayout.addRows(n2, n3);
        }
        for (int i2 = n2; i2 < n4 - n2; ++i2) {
            jCTable.requestChange(16, i2, -999);
        }
    }

    static void deleteRow(JCTable jCTable, int n2, int n3, int n4, int n5) {
        DataViewSupport.shiftRowSeries(jCTable, n2, n3, -1);
        if (jCTable.cellLayout != null) {
            jCTable.cellLayout.deleteRows(n2, n3);
        }
    }

    protected static void shiftRowSeries(JCTable jCTable, int n2, int n3, int n4) {
        if (jCTable.moveables != null) {
            for (int i2 = 0; i2 < jCTable.moveables.size(); ++i2) {
                Moveable moveable = (Moveable)jCTable.moveables.elementAt(i2);
                moveable.shiftRow(n2, n3, n4);
            }
        }
        if (jCTable.rowHeights != null) {
            jCTable.rowHeights.shift(n2, n3, n4);
        }
    }
}

