/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.JCCellRenderer;
import com.klg.jclass.cell.JCComponentCellRenderer;
import com.klg.jclass.cell.JCLightCellRenderer;
import com.klg.jclass.table.CellArea;
import com.klg.jclass.table.CellAreaHandler;
import com.klg.jclass.table.CellBorderModel;
import com.klg.jclass.table.JCCellBorder;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCPaintEvent;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.SpanHandler;
import com.klg.jclass.table.TableCellInfoModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class CellAreaRenderer
implements Serializable {
    protected JCTable table;
    protected CellAreaHandler cellAreaHandler;
    protected Color borderColor;
    protected Color borderShadowColor;
    protected Color borderHighlightColor;
    protected transient BasicStroke dashedStroke = null;

    public CellAreaRenderer(CellAreaHandler cellAreaHandler) {
        this.cellAreaHandler = cellAreaHandler;
        this.table = cellAreaHandler.getTable();
    }

    public void paintComponent(Graphics graphics) {
        Component component;
        this.drawFrameBorder(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        for (int i2 = 0; i2 < this.cellAreaHandler.areas.size(); ++i2) {
            CellArea cellArea = (CellArea)this.cellAreaHandler.areas.elementAt(i2);
            if (!cellArea.isVisible() || !cellArea.intersects(rectangle)) continue;
            this.paintArea(graphics, cellArea);
        }
        if (this.table.getEditWidthPolicy() == 2 && (component = this.table.getEditingComponent()) != null) {
            component.repaint();
        }
    }

    protected void paintArea(Graphics graphics, CellArea cellArea) {
        if (!cellArea.isVisible()) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = cellArea.getBounds();
        if (rectangle2.width <= 0 || rectangle2.height <= 0) {
            return;
        }
        graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        Rectangle rectangle3 = graphics.getClipBounds();
        int n2 = cellArea.getEndRow();
        int n3 = cellArea.getEndColumn();
        int n4 = this.cellAreaHandler.getRow(rectangle3.x + 1, rectangle3.y + 1);
        int n5 = this.cellAreaHandler.getColumn(rectangle3.x + 1, rectangle3.y + 1);
        int n6 = this.cellAreaHandler.getRow(rectangle3.x + rectangle3.width - 1, rectangle3.y + rectangle3.height - 1);
        int n7 = this.cellAreaHandler.getColumn(rectangle3.x + rectangle3.width - 1, rectangle3.y + rectangle3.height - 1);
        if (n4 == -999 || n5 == -999) {
            graphics.setClip(rectangle);
            return;
        }
        if (n6 == -999 || n6 == Integer.MAX_VALUE) {
            n6 = n2;
        }
        if (n7 == -999 || n7 == Integer.MAX_VALUE) {
            n7 = n3;
        }
        if (cellArea.getType() == 0) {
            graphics.translate(this.cellAreaHandler.cellOrigin.x, this.cellAreaHandler.cellOrigin.y);
        } else if (cellArea.getType() == 3 || cellArea.getType() == 6) {
            graphics.translate(0, this.cellAreaHandler.cellOrigin.y);
        } else if (cellArea.getType() == 1 || cellArea.getType() == 2) {
            graphics.translate(this.cellAreaHandler.cellOrigin.x, 0);
        }
        this.paintRange(graphics, n4, n5, n6, n7);
        if (this.cellAreaHandler.DRAGGING) {
            if (this.cellAreaHandler.drag_row != -999 && this.cellAreaHandler.drag_row != -1 && (this.cellAreaHandler.drag_row < n4 || this.cellAreaHandler.drag_row > n6)) {
                this.paintRange(graphics, this.cellAreaHandler.drag_row, n5, this.cellAreaHandler.drag_row, n7);
            } else if (this.cellAreaHandler.drag_column != -999 && this.cellAreaHandler.drag_column != -1 && (this.cellAreaHandler.drag_column < n5 || this.cellAreaHandler.drag_column > n7)) {
                this.paintRange(graphics, n4, this.cellAreaHandler.drag_column, n6, this.cellAreaHandler.drag_column);
            }
        }
        if (cellArea.getType() == 0) {
            graphics.translate(-this.cellAreaHandler.cellOrigin.x, -this.cellAreaHandler.cellOrigin.y);
        } else if (cellArea.getType() == 3 || cellArea.getType() == 6) {
            graphics.translate(0, -this.cellAreaHandler.cellOrigin.y);
        } else if (cellArea.getType() == 1 || cellArea.getType() == 2) {
            graphics.translate(-this.cellAreaHandler.cellOrigin.x, 0);
        }
        graphics.setClip(rectangle);
    }

    protected void paintRange(Graphics graphics, int n2, int n3, int n4, int n5) {
        if (graphics == null) {
            return;
        }
        if (this.table.paintListeners != null) {
            this.table.fireJCPaintEvent(new JCPaintEvent(this.table, 0, n2, n3, n4, n5));
        }
        Rectangle rectangle = new Rectangle();
        for (int i2 = n2; i2 <= n4; ++i2) {
            for (int i3 = n3; i3 <= n5; ++i3) {
                this.paintCell(graphics, i2, i3, false, rectangle);
            }
        }
        if (this.table.paintListeners != null) {
            this.table.fireJCPaintEvent(new JCPaintEvent(this.table, 1, n2, n3, n4, n5));
        }
    }

    protected void paintCell(Graphics graphics, int n2, int n3) {
        this.paintCell(graphics, n2, n3, true, new Rectangle());
    }

    protected void paintCell(Graphics graphics, int n2, int n3, boolean bl) {
        this.paintCell(graphics, n2, n3, bl, new Rectangle());
    }

    protected void paintCell(Graphics graphics, int n2, int n3, boolean bl, Rectangle rectangle) {
        Component component;
        Serializable serializable;
        Serializable serializable2;
        if (this.table.isRowHidden(n2) || this.table.isColumnHidden(n3)) {
            return;
        }
        Rectangle rectangle2 = graphics.getClipBounds();
        if ((rectangle = this.cellAreaHandler.getBounds(n2, n3, rectangle)) == null) {
            return;
        }
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        JCCellRange jCCellRange = null;
        SpanHandler spanHandler = this.table.spanHandler;
        if (spanHandler != null && (jCCellRange = spanHandler.getSpannedRange(n2, n3)) != null && !spanHandler.isControllingCell(jCCellRange, n2, n3)) {
            Rectangle rectangle3 = this.table.getCellLayout().getBounds(jCCellRange.start_row, jCCellRange.start_column);
            CellArea cellArea = this.cellAreaHandler.find(jCCellRange.start_row, jCCellRange.start_column);
            if (cellArea != null) {
                JCCellPosition jCCellPosition;
                rectangle3.x += cellArea.getX() - cellArea.getStandardOffsetX();
                rectangle3.y += cellArea.getY() - cellArea.getStandardOffsetY();
                if ((rectangle3.x < rectangle2.x || rectangle3.y < rectangle2.y) && (jCCellPosition = spanHandler.getControllingCell(jCCellRange)) != null) {
                    this.paintCell(graphics, jCCellPosition.row, jCCellPosition.column);
                }
            }
            return;
        }
        Object object = this.table.getDataView().getObject(n2, n3);
        if (this.table.cellDisplayListeners != null) {
            serializable2 = new JCCellDisplayEvent(this.table, n2, n3, object);
            this.table.fireJCCellDisplayEvent((JCCellDisplayEvent)serializable2);
            object = ((JCCellDisplayEvent)serializable2).getDisplayData();
        }
        if (bl) {
            this.table.fireJCPaintEvent(new JCPaintEvent(this.table, 0, n2, n3, n2, n3));
        }
        serializable2 = this.cellAreaHandler.getTableCellInfo();
        serializable2.initialize(this.table, object, n2, n3);
        JCCellRenderer jCCellRenderer = this.table.getDataView().getCellRenderer(n2, n3, object);
        boolean bl2 = this.table.isSelected(n2, n3);
        int n8 = this.table.getFocusIndicator();
        int n9 = jCCellRange == null ? this.cellAreaHandler.determineThinSides(n2, n3) : this.cellAreaHandler.determineThinSides(jCCellRange.end_row, jCCellRange.end_column);
        if (this.table.isCurrentCell(n2, n3) && n8 == 1 && this.table.getFocusColor() != null) {
            graphics.setColor(this.table.getFocusColor());
        } else if (bl2) {
            graphics.setColor(serializable2.getSelectedBackground());
        } else {
            graphics.setColor(serializable2.getBackground());
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n10 = serializable2.getCellBorderSides();
        CellBorderModel cellBorderModel = serializable2.getCellBorder();
        if (cellBorderModel != null) {
            int n11 = serializable2.getCellStyle().getCellBorderColorMode();
            serializable = serializable2.getCellStyle().getCellBorderColor();
            if (serializable == null && n11 == 0 || n11 == 1) {
                serializable = bl2 ? serializable2.getSelectedBackground() : serializable2.getBackground();
            } else if (n11 == 2) {
                serializable = bl2 ? serializable2.getSelectedForeground() : serializable2.getForeground();
            }
            if (serializable != this.borderColor) {
                if (((Color)serializable).equals(Color.white)) {
                    this.borderHighlightColor = TableCellInfoModel.WHITE_BRIGHTER;
                    this.borderShadowColor = TableCellInfoModel.WHITE_DARKER;
                } else if (((Color)serializable).equals(Color.black)) {
                    this.borderHighlightColor = TableCellInfoModel.BLACK_BRIGHTER;
                    this.borderShadowColor = TableCellInfoModel.BLACK_DARKER;
                } else {
                    this.borderHighlightColor = ((Color)serializable).brighter();
                    this.borderShadowColor = ((Color)serializable).darker();
                }
                this.borderColor = serializable;
            }
            cellBorderModel.drawBackground(graphics, this.table.getCellBorderWidth(), n10 | n9, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.borderHighlightColor, this.borderShadowColor, this.borderColor);
        }
        if ((component = this.table.getComponent(n2, n3)) != null) {
            serializable = this.table.getCellAreaHandler().find(n2, n3);
            if (serializable != component.getParent()) {
                ((Container)serializable).add(component);
            }
            if (!component.isVisible()) {
                component.setVisible(true);
            }
            Rectangle rectangle4 = new Rectangle();
            int n12 = this.cellAreaHandler.DRAGGING && this.cellAreaHandler.drag_rows != null ? this.cellAreaHandler.drag_rows[((CellArea)serializable).getStartRow()] : ((CellArea)serializable).getStartRow();
            int n13 = this.cellAreaHandler.DRAGGING && this.cellAreaHandler.drag_columns != null ? this.cellAreaHandler.drag_columns[((CellArea)serializable).getStartColumn()] : ((CellArea)serializable).getStartColumn();
            rectangle4 = this.cellAreaHandler.getBounds(n12, n13, rectangle4);
            int n14 = rectangle.x;
            int n15 = rectangle.y;
            if (((CellArea)serializable).isHorizontalScrollable()) {
                n14 -= ((CellArea)serializable).getStandardOffsetX() - this.cellAreaHandler.cellOrigin.x;
                rectangle4.x -= ((CellArea)serializable).getStandardOffsetX();
            }
            if (((CellArea)serializable).isVerticalScrollable()) {
                n15 -= ((CellArea)serializable).getStandardOffsetY() - this.cellAreaHandler.cellOrigin.y;
                rectangle4.y -= ((CellArea)serializable).getStandardOffsetY();
            }
            int n16 = rectangle4.x;
            int n17 = rectangle4.y;
            int n18 = this.table.getComponentBorderWidth();
            component.setBounds(n14 + n18 - n16, n15 + n18 - n17, rectangle.width - 2 * n18, rectangle.height - 2 * n18);
            component.validate();
            this.forcePaintComponent(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            serializable = serializable2.getDrawingArea();
            rectangle.x += ((Rectangle)serializable).x;
            rectangle.y += ((Rectangle)serializable).y;
            rectangle.width = ((Rectangle)serializable).width;
            rectangle.height = ((Rectangle)serializable).height;
            boolean bl3 = false;
            if (cellBorderModel instanceof JCCellBorder) {
                JCCellBorder jCCellBorder = (JCCellBorder)cellBorderModel;
                bl3 = jCCellBorder.borderType == 8;
            }
            int n19 = rectangle.width;
            int n20 = rectangle.height;
            if (bl3 && (n10 & 8) != 0 && (n9 & 0x10) == 0) {
                ++n19;
            }
            if (bl3 && (n10 & 8) != 0 && (n9 & 0x20) == 0) {
                ++n20;
            }
            graphics.clipRect(rectangle.x, rectangle.y, n19, n20);
            if (jCCellRenderer instanceof JCLightCellRenderer) {
                graphics.translate(rectangle.x, rectangle.y);
                try {
                    ((JCLightCellRenderer)jCCellRenderer).draw(graphics, (JCCellInfo)serializable2, object, bl2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                graphics.translate(-rectangle.x, -rectangle.y);
            } else if (jCCellRenderer instanceof JCComponentCellRenderer) {
                JCComponentCellRenderer jCComponentCellRenderer = (JCComponentCellRenderer)jCCellRenderer;
                Component component2 = jCComponentCellRenderer.getRendererComponent((JCCellInfo)serializable2, object, bl2);
                try {
                    this.table.cellRendererPane.paintComponent(graphics, component2, this.table, rectangle.x, rectangle.y, n19, n20, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl) {
                this.table.fireJCPaintEvent(new JCPaintEvent(this.table, 1, n2, n3, n2, n3));
            }
            graphics.setClip(rectangle2);
        }
        if ((n9 & 0x10) == 0) {
            ++n6;
        }
        if ((n9 & 0x20) == 0) {
            ++n7;
        }
        if (this.table.isCurrentCell(n2, n3)) {
            if (n8 == 2) {
                this.drawTable3FocusRectangle(graphics, n4, n5, n6, n7);
            } else if (n8 == 3) {
                this.drawThinFocusRectangle(graphics, n4, n5, n6, n7);
            } else if (n8 == 4) {
                this.drawDashedFocusRectangle(graphics, n4, n5, n6, n7);
            }
        }
    }

    protected void forcePaintComponent(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
    }

    public void drawFrameBorder(Graphics graphics) {
        Rectangle rectangle;
        Rectangle rectangle2;
        Color color = this.table.getBackground();
        CellBorderModel cellBorderModel = this.table.getFrameBorder();
        if (cellBorderModel == null) {
            return;
        }
        int n2 = this.table.getFrameBorderWidth();
        int n3 = 2 * n2;
        Rectangle rectangle3 = this.cellAreaHandler.rowLabelRect;
        if (rectangle3 != null) {
            cellBorderModel.drawBackground(graphics, n2, 15, rectangle3.x - n2, rectangle3.y - n2, rectangle3.width + n3, rectangle3.height + n3, color.brighter(), color.darker(), color);
        }
        if ((rectangle2 = this.cellAreaHandler.columnLabelRect) != null) {
            cellBorderModel.drawBackground(graphics, n2, 15, rectangle2.x - n2, rectangle2.y - n2, rectangle2.width + n3, rectangle2.height + n3, color.brighter(), color.darker(), color);
        }
        if ((rectangle = this.cellAreaHandler.cellRect) != null) {
            cellBorderModel.drawBackground(graphics, n2, 15, rectangle.x - n2, rectangle.y - n2, rectangle.width + n3, rectangle.height + n3, color.brighter(), color.darker(), color);
        }
    }

    public void drawTable3FocusRectangle(Graphics graphics, int n2, int n3, int n4, int n5) {
        Color color = this.table.getFocusColor();
        if (color == null) {
            color = this.cellAreaHandler.getTableCellInfo().getForeground().darker();
        }
        graphics.setColor(color);
        graphics.drawRect(n2 + 1, n3 + 1, n4 - 3, n5 - 3);
        graphics.drawRect(n2 + 2, n3 + 2, n4 - 5, n5 - 5);
    }

    public void drawThinFocusRectangle(Graphics graphics, int n2, int n3, int n4, int n5) {
        Color color = this.table.getFocusColor();
        if (color == null) {
            color = this.cellAreaHandler.getTableCellInfo().getForeground().darker();
        }
        graphics.setColor(color);
        graphics.drawRect(n2 + 1, n3 + 1, n4 - 3, n5 - 3);
    }

    public void drawDashedFocusRectangle(Graphics graphics, int n2, int n3, int n4, int n5) {
        Object object;
        Color color = this.table.getFocusColor();
        if (color == null) {
            color = this.cellAreaHandler.getTableCellInfo().getForeground().darker();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(color);
        Stroke stroke = graphics2D.getStroke();
        if (this.dashedStroke == null) {
            object = new float[]{1.0f, 3.0f};
            this.dashedStroke = new BasicStroke(1.0f, 0, 0, 1.0f, (float[])object, 0.0f);
        }
        graphics2D.setStroke(this.dashedStroke);
        object = new Rectangle2D.Float(n2 + 1, n3 + 1, n4 - 3, n5 - 3);
        graphics2D.draw((Shape)object);
        graphics2D.setStroke(stroke);
    }

    public void drawSelectionBorder(Graphics graphics) {
    }

    public void repaintRange(JCCellRange jCCellRange) {
        this.repaintRange(jCCellRange.start_row, jCCellRange.start_column, jCCellRange.end_row, jCCellRange.end_column);
    }

    public void repaintRange(int n2, int n3, int n4, int n5) {
        Serializable serializable;
        if (n4 == Integer.MAX_VALUE) {
            n4 = this.table.getNumRows() - 1;
        }
        if (n5 == Integer.MAX_VALUE) {
            n5 = this.table.getNumColumns() - 1;
        }
        if (this.table.spanHandler != null && this.table.resize_interactive) {
            serializable = this.table.spanHandler.getCompleteRange(n2, n3, n4, n5);
            n2 = serializable.start_row;
            n3 = serializable.start_column;
            n4 = serializable.end_row;
            n5 = serializable.end_column;
        }
        for (int i2 = 0; i2 < this.cellAreaHandler.areas.size(); ++i2) {
            CellArea cellArea = (CellArea)this.cellAreaHandler.areas.elementAt(i2);
            if (n2 > cellArea.end_row || n4 < cellArea.start_row || n3 > cellArea.end_column || n5 < cellArea.start_column) continue;
            int n6 = Math.max(cellArea.start_row, n2);
            int n7 = Math.max(cellArea.start_column, n3);
            int n8 = Math.min(cellArea.end_row, n4);
            int n9 = Math.min(cellArea.end_column, n5);
            serializable = this.cellAreaHandler.getBounds(n6, n7);
            if (serializable == null) {
                serializable = new Rectangle(0, 0, 0, 0);
            }
            Rectangle rectangle = this.cellAreaHandler.getBounds(n8, n9);
            int n10 = Math.min(((Rectangle)serializable).x, rectangle.x);
            int n11 = Math.min(((Rectangle)serializable).y, rectangle.y);
            int n12 = Math.max(((Rectangle)serializable).x + ((Rectangle)serializable).width, rectangle.x + rectangle.width) - n10;
            int n13 = Math.max(((Rectangle)serializable).y + ((Rectangle)serializable).height, rectangle.y + rectangle.height) - n11;
            if (cellArea.isHorizontalScrollable()) {
                n10 += this.cellAreaHandler.cellOrigin.x;
            }
            if (cellArea.isVerticalScrollable()) {
                n11 += this.cellAreaHandler.cellOrigin.y;
            }
            this.table.repaint(n10, n11, n12, n13);
        }
    }

    public void repaintCell(int n2, int n3) {
        this.repaintCell(n2, n3, false);
    }

    public void repaintCell(int n2, int n3, boolean bl) {
        Serializable serializable;
        if (this.table.spanHandler != null && (serializable = this.table.spanHandler.getSpannedRange(n2, n3)) != null) {
            this.repaintRange((JCCellRange)serializable);
            return;
        }
        serializable = this.cellAreaHandler.getBounds(n2, n3);
        CellArea cellArea = this.cellAreaHandler.find(n2, n3);
        if (cellArea == null) {
            return;
        }
        if (cellArea.isHorizontalScrollable()) {
            serializable.x += this.cellAreaHandler.cellOrigin.x;
        }
        if (cellArea.isVerticalScrollable()) {
            serializable.y += this.cellAreaHandler.cellOrigin.y;
        }
        if (bl && this.table.store_image_enabled && this.table.store_image != null) {
            Graphics graphics = this.table.store_image.getGraphics();
            int n4 = 0;
            int n5 = 0;
            if (cellArea.getType() == 0) {
                n4 = this.table.cellAreaHandler.cellOrigin.x;
                n5 = this.table.cellAreaHandler.cellOrigin.y;
            } else if (cellArea.getType() == 3 || cellArea.getType() == 6) {
                n5 = this.table.cellAreaHandler.cellOrigin.y;
            } else if (cellArea.getType() == 1 || cellArea.getType() == 2) {
                n4 = this.table.cellAreaHandler.cellOrigin.x;
            }
            graphics.translate(n4, n5);
            this.paintCell(graphics, n2, n3, false);
            graphics.translate(-n4, -n5);
        }
        this.table.repaint(serializable.x, serializable.y, serializable.width, serializable.height);
    }
}

