/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.cell.JCCellRenderer;
import com.klg.jclass.cell.JCComponentCellRenderer;
import com.klg.jclass.cell.JCLightCellRenderer;
import com.klg.jclass.table.CellArea;
import com.klg.jclass.table.CellAreaRenderer;
import com.klg.jclass.table.CellBorderModel;
import com.klg.jclass.table.CellLayoutModel;
import com.klg.jclass.table.JCCellBorder;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.JCTableCellInfo;
import com.klg.jclass.table.TableCellInfoModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;

public class CellAreaHandler
implements Serializable {
    protected JCTable table;
    protected CellArea cellArea;
    protected CellArea frozenRowArea;
    protected CellArea columnLabelArea;
    protected CellArea frozenColumnArea;
    protected CellArea frozenCellArea;
    protected CellArea frozenColumnLabelArea;
    protected CellArea rowLabelArea;
    protected CellArea frozenRowLabelArea;
    protected Vector areas = new Vector();
    protected CellAreaRenderer cellAreaRenderer;
    protected TableCellInfoModel cellInfo;
    protected Point cellOrigin = new Point(0, 0);
    protected boolean isStandardLayout = true;
    protected Rectangle rowLabelRect = null;
    protected Rectangle columnLabelRect = null;
    protected Rectangle cellRect = null;
    protected boolean DRAGGING = false;
    protected int drag_row = -999;
    protected int drag_column = -999;
    protected int drop_row = -999;
    protected int drop_column = -999;
    protected int[] drag_columns;
    protected int[] drag_rows;

    public CellAreaHandler(JCTable jCTable) {
        this.table = jCTable;
        this.cellAreaRenderer = new CellAreaRenderer(this);
        this.cellInfo = new JCTableCellInfo();
    }

    public CellAreaRenderer getCellAreaRenderer() {
        return this.cellAreaRenderer;
    }

    public JCTable getTable() {
        return this.table;
    }

    public CellArea createCellArea(int n2) {
        switch (n2) {
            case 0: {
                if (this.cellArea == null) {
                    this.cellArea = new CellArea(n2);
                    this.areas.addElement(this.cellArea);
                    this.table.add(this.cellArea);
                }
                return this.cellArea;
            }
            case 2: {
                if (this.columnLabelArea == null) {
                    this.columnLabelArea = new CellArea(n2);
                    this.areas.addElement(this.columnLabelArea);
                    this.table.add(this.columnLabelArea);
                }
                return this.columnLabelArea;
            }
            case 4: {
                if (this.frozenCellArea == null) {
                    this.frozenCellArea = new CellArea(n2);
                    this.areas.addElement(this.frozenCellArea);
                    this.table.add(this.frozenCellArea);
                }
                return this.frozenCellArea;
            }
            case 3: {
                if (this.frozenColumnArea == null) {
                    this.frozenColumnArea = new CellArea(n2);
                    this.areas.addElement(this.frozenColumnArea);
                    this.table.add(this.frozenColumnArea);
                }
                return this.frozenColumnArea;
            }
            case 5: {
                if (this.frozenColumnLabelArea == null) {
                    this.frozenColumnLabelArea = new CellArea(n2);
                    this.areas.addElement(this.frozenColumnLabelArea);
                    this.table.add(this.frozenColumnLabelArea);
                }
                return this.frozenColumnLabelArea;
            }
            case 1: {
                if (this.frozenRowArea == null) {
                    this.frozenRowArea = new CellArea(n2);
                    this.areas.addElement(this.frozenRowArea);
                    this.table.add(this.frozenRowArea);
                }
                return this.frozenRowArea;
            }
            case 7: {
                if (this.frozenRowLabelArea == null) {
                    this.frozenRowLabelArea = new CellArea(n2);
                    this.areas.addElement(this.frozenRowLabelArea);
                    this.table.add(this.frozenRowLabelArea);
                }
                return this.frozenRowLabelArea;
            }
            case 6: {
                if (this.rowLabelArea == null) {
                    this.rowLabelArea = new CellArea(n2);
                    this.areas.addElement(this.rowLabelArea);
                    this.table.add(this.rowLabelArea);
                }
                return this.rowLabelArea;
            }
        }
        return null;
    }

    public CellArea findByType(int n2) {
        switch (n2) {
            case 0: {
                return this.cellArea;
            }
            case 2: {
                return this.columnLabelArea;
            }
            case 4: {
                return this.frozenCellArea;
            }
            case 3: {
                return this.frozenColumnArea;
            }
            case 5: {
                return this.frozenColumnLabelArea;
            }
            case 1: {
                return this.frozenRowArea;
            }
            case 7: {
                return this.frozenRowLabelArea;
            }
            case 6: {
                return this.rowLabelArea;
            }
        }
        return null;
    }

    public CellArea find(int n2, int n3) {
        for (int i2 = 0; i2 < this.areas.size(); ++i2) {
            CellArea cellArea = (CellArea)this.areas.elementAt(i2);
            if (!cellArea.containsCell(n2, n3)) continue;
            return cellArea;
        }
        return null;
    }

    public Vector getCellAreas() {
        return this.areas;
    }

    public void createRequiredCellAreas() {
        int n2 = this.table.getDataView().getNumColumns();
        int n3 = this.table.getDataView().getNumRows();
        int n4 = this.table.getFrozenColumns();
        int n5 = this.table.getFrozenRows();
        CellArea cellArea = null;
        if (n2 > 0 && n3 > 0) {
            cellArea = this.createCellArea(0);
            this.setAreaCellRange(cellArea);
            cellArea.setVisible(true);
        } else {
            cellArea = this.findByType(0);
            if (cellArea != null) {
                this.areas.removeElement(cellArea);
                this.table.remove(cellArea);
                this.cellArea = null;
            }
        }
        if (n5 > 0 && n4 > 0) {
            cellArea = this.createCellArea(4);
            this.setAreaCellRange(cellArea);
            cellArea.setVisible(true);
        } else {
            cellArea = this.findByType(4);
            if (cellArea != null) {
                this.areas.removeElement(cellArea);
                this.table.remove(cellArea);
                this.frozenCellArea = null;
            }
        }
        if (n5 > 0 && n3 > 0 && n2 > 0) {
            cellArea = this.createCellArea(1);
            this.setAreaCellRange(cellArea);
            cellArea.setVisible(true);
        } else {
            cellArea = this.findByType(1);
            if (cellArea != null) {
                this.areas.removeElement(cellArea);
                this.table.remove(cellArea);
                this.frozenRowArea = null;
            }
        }
        if (n4 > 0 && n3 > 0 && n2 > 0) {
            cellArea = this.createCellArea(3);
            this.setAreaCellRange(cellArea);
            cellArea.setVisible(true);
        } else {
            cellArea = this.findByType(3);
            if (cellArea != null) {
                this.areas.removeElement(cellArea);
                this.table.remove(cellArea);
                this.frozenColumnArea = null;
            }
        }
        if (n5 > 0 && n3 > 0 && this.table.isRowLabelDisplay()) {
            cellArea = this.createCellArea(7);
            this.setAreaCellRange(cellArea);
            cellArea.setVisible(true);
        } else {
            cellArea = this.findByType(7);
            if (cellArea != null) {
                this.areas.removeElement(cellArea);
                this.table.remove(cellArea);
                this.frozenRowLabelArea = null;
            }
        }
        if (n3 > 0 && this.table.isRowLabelDisplay()) {
            cellArea = this.createCellArea(6);
            this.setAreaCellRange(cellArea);
            cellArea.setVisible(true);
        } else {
            cellArea = this.findByType(6);
            if (cellArea != null) {
                this.areas.removeElement(cellArea);
                this.table.remove(cellArea);
                this.rowLabelArea = null;
            }
        }
        if (n4 > 0 && n2 > 0 && this.table.isColumnLabelDisplay()) {
            cellArea = this.createCellArea(5);
            this.setAreaCellRange(cellArea);
            cellArea.setVisible(true);
        } else {
            cellArea = this.findByType(5);
            if (cellArea != null) {
                this.areas.removeElement(cellArea);
                this.table.remove(cellArea);
                this.frozenColumnLabelArea = null;
            }
        }
        if (n2 > 0 && this.table.isColumnLabelDisplay()) {
            cellArea = this.createCellArea(2);
            this.setAreaCellRange(cellArea);
            cellArea.setVisible(true);
        } else {
            cellArea = this.findByType(2);
            if (cellArea != null) {
                this.areas.removeElement(cellArea);
                this.table.remove(cellArea);
                this.columnLabelArea = null;
            }
        }
    }

    public void setAreaCellRange(CellArea cellArea) {
        int n2 = cellArea.getType();
        int n3 = -999;
        int n4 = -999;
        int n5 = -999;
        int n6 = -999;
        int n7 = this.table.getDataView().getNumRows();
        int n8 = this.table.getDataView().getNumColumns();
        int n9 = this.table.getFrozenRows();
        int n10 = this.table.getFrozenColumns();
        switch (n2) {
            case 0: {
                if (n7 > 0) {
                    n3 = n9;
                    n5 = n7 - 1;
                }
                if (n8 <= 0) break;
                n4 = n10;
                n6 = n8 - 1;
                break;
            }
            case 4: {
                if (n9 <= 0 || n10 <= 0) break;
                n3 = 0;
                n4 = 0;
                n5 = Math.min(n9, n7) - 1;
                n6 = Math.min(n10, n8) - 1;
                break;
            }
            case 3: {
                if (n7 <= 0 || n8 <= 0 || n10 <= 0) break;
                n3 = n9;
                n4 = 0;
                n5 = n7 - 1;
                n6 = Math.min(n10, n8) - 1;
                break;
            }
            case 1: {
                if (n7 <= 0 || n8 <= 0 || n9 <= 0) break;
                n3 = 0;
                n4 = n10;
                n5 = Math.min(n9, n7) - 1;
                n6 = n8 - 1;
                break;
            }
            case 7: {
                if (n9 <= 0) break;
                n3 = 0;
                n4 = -1;
                n5 = Math.min(n9, n7) - 1;
                n6 = -1;
                break;
            }
            case 6: {
                if (n7 <= 0) break;
                n3 = n9;
                n4 = -1;
                n5 = n7 - 1;
                n6 = -1;
                break;
            }
            case 5: {
                if (n10 <= 0) break;
                n3 = -1;
                n4 = 0;
                n5 = -1;
                n6 = Math.min(n10, n8) - 1;
                break;
            }
            case 2: {
                if (n8 <= 0) break;
                n3 = -1;
                n4 = Math.min(n10, n8 - 1);
                n5 = -1;
                n6 = n8 - 1;
            }
        }
        cellArea.setCellRange(n3, n4, n5, n6);
        Rectangle rectangle = this.getBounds(n3, n4, n5, n6);
        if (n2 == 0) {
            if (n7 > 0 && n9 >= n7 && n8 > 0 && n10 >= n8) {
                cellArea.setCellSize(0, 0);
            } else if (n7 > 0 && n9 >= n7) {
                cellArea.setCellSize(rectangle.width, 0);
            } else if (n8 > 0 && n10 >= n8) {
                cellArea.setCellSize(0, rectangle.height);
            } else {
                cellArea.setCellSize(rectangle.width, rectangle.height);
            }
        } else if (n2 == 2 && n8 > 0 && n10 >= n8) {
            cellArea.setCellSize(0, rectangle.height);
        } else if (n2 == 6 && n7 > 0 && n9 >= n7) {
            cellArea.setCellSize(rectangle.width, 0);
        } else {
            cellArea.setCellSize(rectangle.width, rectangle.height);
        }
    }

    public Point getCellOrigin() {
        return this.cellOrigin;
    }

    public void setCellOrigin(Point point) {
        this.setCellOrigin(point.x, point.y);
    }

    public void setCellOrigin(int n2, int n3) {
        this.cellOrigin.x = n2;
        this.cellOrigin.y = n3;
        this.table.layoutAreas();
    }

    public void setCellOriginX(int n2) {
        this.cellOrigin.x = n2;
        this.table.layoutAreas();
    }

    public void setCellOriginY(int n2) {
        this.cellOrigin.y = n2;
        this.table.layoutAreas();
    }

    public boolean isStandardLayout() {
        return this.isStandardLayout;
    }

    public void setStandardLayout(boolean bl) {
        this.isStandardLayout = bl;
    }

    public TableCellInfoModel getTableCellInfo() {
        return this.cellInfo;
    }

    public void setTableCellInfo(TableCellInfoModel tableCellInfoModel) {
        this.cellInfo = tableCellInfoModel;
    }

    public int getRow(int n2, int n3) {
        CellArea cellArea = this.contains(n2, n3);
        if (cellArea == null) {
            return -999;
        }
        n2 += -cellArea.getX() + cellArea.getStandardOffsetX();
        n3 += -cellArea.getY() + cellArea.getStandardOffsetY();
        if (cellArea.isHorizontalScrollable()) {
            n2 -= this.cellOrigin.x;
        }
        if (cellArea.isVerticalScrollable()) {
            n3 -= this.cellOrigin.y;
        }
        return this.table.getCellLayout().getRow(n2, n3);
    }

    public int getColumn(int n2, int n3) {
        CellArea cellArea = this.contains(n2, n3);
        if (cellArea == null) {
            return -999;
        }
        n2 += -cellArea.getX() + cellArea.getStandardOffsetX();
        n3 += -cellArea.getY() + cellArea.getStandardOffsetY();
        if (cellArea.isHorizontalScrollable()) {
            n2 -= this.cellOrigin.x;
        }
        if (cellArea.isVerticalScrollable()) {
            n3 -= this.cellOrigin.y;
        }
        return this.table.getCellLayout().getColumn(n2, n3);
    }

    protected CellArea contains(int n2, int n3) {
        for (int i2 = 0; i2 < this.areas.size(); ++i2) {
            CellArea cellArea = (CellArea)this.areas.elementAt(i2);
            if (!cellArea.getBounds().contains(n2, n3)) continue;
            return cellArea;
        }
        return null;
    }

    public Rectangle getBounds(int n2, int n3) {
        return this.getBounds(n2, n3, new Rectangle());
    }

    public Rectangle getBounds(int n2, int n3, Rectangle rectangle) {
        Serializable serializable;
        rectangle = !this.DRAGGING ? this.table.getCellLayout().getBounds(n2, n3, rectangle) : this.getDragBounds(n2, n3);
        if (this.table.spanHandler != null && (serializable = this.table.spanHandler.getSpannedRange(n2, n3)) != null && this.table.spanHandler.isControllingCell((JCCellRange)serializable, n2, n3)) {
            int n4;
            int n5 = Math.min(((JCCellRange)serializable).end_row, this.table.getNumRows() - 1);
            for (n4 = n2 + 1; n4 <= n5; ++n4) {
                rectangle.height += this.getBounds((int)n4, (int)n3).height;
            }
            n4 = Math.min(((JCCellRange)serializable).end_column, this.table.getNumColumns() - 1);
            for (int i2 = n3 + 1; i2 <= n4; ++i2) {
                rectangle.width += this.getBounds((int)n2, (int)i2).width;
            }
        }
        if ((serializable = this.find(n2, n3)) == null) {
            return rectangle;
        }
        rectangle.x += ((JComponent)serializable).getX() - ((CellArea)serializable).getStandardOffsetX();
        rectangle.y += ((JComponent)serializable).getY() - ((CellArea)serializable).getStandardOffsetY();
        return rectangle;
    }

    public Rectangle getBounds(int n2, int n3, int n4, int n5) {
        if (!this.DRAGGING) {
            Rectangle rectangle = new Rectangle();
            rectangle = this.table.getCellLayout().getBounds(n2, n3, n4, n5, rectangle);
            CellArea cellArea = this.find(n2, n3);
            if (cellArea == null) {
                return rectangle;
            }
            rectangle.x += cellArea.getX() - cellArea.getStandardOffsetX();
            rectangle.y += cellArea.getY() - cellArea.getStandardOffsetY();
            return rectangle;
        }
        Rectangle rectangle = new Rectangle();
        rectangle = this.getBounds(n2, n3, rectangle);
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        rectangle = this.getBounds(n4, n5, rectangle);
        rectangle.width = rectangle.x + rectangle.width - n6;
        rectangle.height = rectangle.y + rectangle.height - n7;
        rectangle.x = n6;
        rectangle.y = n7;
        return rectangle;
    }

    public Rectangle getDragBounds(int n2, int n3) {
        if (this.drag_row == -1 && n3 != -1) {
            if (this.drag_columns != null) {
                if (n3 == this.drag_columns[n3]) {
                    return this.table.getCellLayout().getBounds(n2, n3);
                }
                Rectangle rectangle = this.table.getCellLayout().getBounds(n2, n3);
                rectangle.x = this.getTransposedX(n3, this.drag_column, this.drop_column);
                return rectangle;
            }
            return this.table.getCellLayout().getBounds(n2, n3);
        }
        if (this.drag_column == -1 && n2 != -1) {
            if (this.drag_rows != null) {
                if (n2 == this.drag_rows[n2]) {
                    return this.table.getCellLayout().getBounds(n2, n3);
                }
                Rectangle rectangle = this.table.getCellLayout().getBounds(n2, n3);
                rectangle.y = this.getTransposedY(n2, this.drag_row, this.drop_row);
                return rectangle;
            }
            return this.table.getCellLayout().getBounds(n2, n3);
        }
        return this.table.getCellLayout().getBounds(n2, n3);
    }

    public boolean isContentClipped(int n2, int n3) {
        Serializable serializable;
        Object object = this.table.getDataView().getObject(n2, n3);
        JCCellRenderer jCCellRenderer = this.table.getDataView().getCellRenderer(n2, n3, object);
        this.cellInfo.initialize(this.table, object, n2, n3);
        Dimension dimension = null;
        if (jCCellRenderer instanceof JCLightCellRenderer) {
            serializable = (JCLightCellRenderer)jCCellRenderer;
            dimension = serializable.getPreferredSize(this.table.getGraphics(), this.cellInfo, object);
        } else {
            serializable = (JCComponentCellRenderer)jCCellRenderer;
            Component component = serializable.getRendererComponent(this.cellInfo, object, this.table.isSelected(n2, n3));
            dimension = component.getPreferredSize();
        }
        serializable = this.getBounds(n2, n3);
        return dimension.width > ((Rectangle)serializable).width || dimension.height > ((Rectangle)serializable).height;
    }

    public JCCellRange getVisibleCells() {
        CellArea cellArea = this.findByType(0);
        if (cellArea == null) {
            return new JCCellRange();
        }
        int n2 = cellArea.getX();
        int n3 = cellArea.getY();
        int n4 = cellArea.getWidth();
        int n5 = cellArea.getHeight();
        int n6 = this.getRow(n2 + 1, n3 + 1);
        int n7 = this.getColumn(n2 + 1, n3 + 1);
        int n8 = this.getRow(n2 + n4 - 1, n3 + n5 - 1);
        int n9 = this.getColumn(n2 + n4 - 1, n3 + n5 - 1);
        if (n8 == -999) {
            n8 = cellArea.getEndRow();
        }
        if (n9 == -999) {
            n9 = cellArea.getEndColumn();
        }
        return new JCCellRange(n6, n7, n8, n9);
    }

    protected void performDrag(int n2, int n3, int n4, int n5) {
        this.DRAGGING = true;
        if (this.drag_row == n2 && this.drag_column == n3 && this.drop_row == n4 && this.drop_column == n5) {
            return;
        }
        if (n2 == -1) {
            if (n3 != n5) {
                int n6 = this.table.getNumColumns();
                this.drag_columns = new int[n6];
                for (int i2 = 0; i2 < n6; ++i2) {
                    this.drag_columns[i2] = i2;
                }
                this.drag_columns = this.shiftArray(this.drag_columns, n3, n5);
            } else {
                this.drag_columns = null;
            }
            this.drag_rows = null;
            this.drag_row = n2;
            this.drag_column = n3;
            this.drop_row = n4;
            this.drop_column = n5;
            this.table.repaint();
        } else if (n3 == -1) {
            if (n2 != n4) {
                int n7 = this.table.getNumRows();
                this.drag_rows = new int[n7];
                for (int i3 = 0; i3 < n7; ++i3) {
                    this.drag_rows[i3] = i3;
                }
                this.drag_rows = this.shiftArray(this.drag_rows, n2, n4);
            } else {
                this.drag_rows = null;
            }
            this.drag_columns = null;
            this.drag_row = n2;
            this.drag_column = n3;
            this.drop_row = n4;
            this.drop_column = n5;
            this.table.repaint();
        } else {
            this.drag_row = n2;
            this.drag_column = n3;
            this.drop_row = n4;
            this.drop_column = n5;
            this.table.repaint();
        }
    }

    protected void cancelDrag() {
        this.DRAGGING = false;
        this.drag_row = -999;
        this.drag_column = -999;
        this.drop_row = -999;
        this.drop_column = -999;
    }

    protected void endDrag() {
        this.DRAGGING = false;
        this.drag_row = -999;
        this.drag_column = -999;
        this.drop_row = -999;
        this.drop_column = -999;
    }

    protected int getTransposedY(int n2, int n3, int n4) {
        CellLayoutModel cellLayoutModel = this.table.getCellLayout();
        if (n3 < n4) {
            if (n2 < n3) {
                return cellLayoutModel.getBounds((int)n2, (int)-1).y;
            }
            if (n2 == n3) {
                if (n4 >= this.table.getNumRows()) {
                    Rectangle rectangle = cellLayoutModel.getBounds(this.table.getNumRows() - 1, -1);
                    Rectangle rectangle2 = cellLayoutModel.getBounds(n2, -1);
                    return rectangle.y + rectangle.height - rectangle2.height;
                }
                return cellLayoutModel.getBounds((int)n4, (int)-1).y - cellLayoutModel.getBounds((int)n2, (int)-1).height;
            }
            if (n2 < n4) {
                return cellLayoutModel.getBounds((int)n2, (int)-1).y - cellLayoutModel.getBounds((int)n3, (int)-1).height;
            }
        } else if (n3 > n4) {
            if (n2 < n4) {
                return cellLayoutModel.getBounds((int)n2, (int)-1).y;
            }
            if (n2 == n3) {
                return cellLayoutModel.getBounds((int)n4, (int)-1).y;
            }
            if (n2 >= n4) {
                return cellLayoutModel.getBounds((int)n2, (int)-1).y + cellLayoutModel.getBounds((int)n3, (int)-1).height;
            }
        }
        return cellLayoutModel.getBounds((int)n2, (int)-1).y;
    }

    protected int getTransposedX(int n2, int n3, int n4) {
        CellLayoutModel cellLayoutModel = this.table.getCellLayout();
        if (n3 < n4) {
            if (n2 < n3) {
                return cellLayoutModel.getBounds((int)-1, (int)n2).x;
            }
            if (n2 == n3) {
                if (n4 >= this.table.getNumColumns()) {
                    Rectangle rectangle = cellLayoutModel.getBounds(-1, this.table.getNumColumns() - 1);
                    Rectangle rectangle2 = cellLayoutModel.getBounds(-1, n2);
                    return rectangle.x + rectangle.width - rectangle2.width;
                }
                return cellLayoutModel.getBounds((int)-1, (int)n4).x - cellLayoutModel.getBounds((int)-1, (int)n2).width;
            }
            if (n2 < n4) {
                return cellLayoutModel.getBounds((int)-1, (int)n2).x - cellLayoutModel.getBounds((int)-1, (int)n3).width;
            }
        } else if (n3 > n4) {
            if (n2 < n4) {
                return cellLayoutModel.getBounds((int)-1, (int)n2).x;
            }
            if (n2 == n3) {
                return cellLayoutModel.getBounds((int)-1, (int)n4).x;
            }
            if (n2 >= n4) {
                return cellLayoutModel.getBounds((int)-1, (int)n2).x + cellLayoutModel.getBounds((int)-1, (int)n3).width;
            }
        }
        return cellLayoutModel.getBounds((int)-1, (int)n2).x;
    }

    protected int[] shiftArray(int[] nArray, int n2, int n3) {
        int n4 = nArray.length;
        int[] nArray2 = new int[n4];
        if (n3 == Integer.MAX_VALUE) {
            int n5;
            for (n5 = 0; n5 < n2; ++n5) {
                nArray2[n5] = nArray[n5];
            }
            for (n5 = n2 + 1; n5 < n4; ++n5) {
                nArray2[n5 - 1] = nArray[n5];
            }
            nArray2[n4 - 1] = nArray[n2];
        } else if (n2 < n3) {
            int n6;
            for (n6 = 0; n6 < n4; ++n6) {
                nArray2[n6] = nArray[n6];
            }
            for (n6 = n2 + 1; n6 < n3; ++n6) {
                nArray2[n6 - 1] = nArray[n6];
            }
            nArray2[n3 - 1] = nArray[n2];
        } else if (n2 > n3) {
            int n7;
            for (n7 = 0; n7 < n4; ++n7) {
                nArray2[n7] = nArray[n7];
            }
            for (n7 = n3; n7 < n2; ++n7) {
                nArray2[n7 + 1] = nArray[n7];
            }
            nArray2[n3] = nArray[n2];
        }
        return nArray2;
    }

    public CellArea getCellArea() {
        return this.cellArea;
    }

    protected int determineThinSides(int n2, int n3) {
        CellArea cellArea = this.table.getCellAreaHandler().find(n2, n3);
        if (cellArea == null) {
            return 0;
        }
        return this.determineThinSides(n2, n3, cellArea.getEndRow(), cellArea.getEndColumn());
    }

    protected int determineThinSides(int n2, int n3, int n4, int n5) {
        int n6 = 0;
        TableCellInfoModel tableCellInfoModel = this.getTableCellInfo();
        CellBorderModel cellBorderModel = tableCellInfoModel.getCellBorder();
        if (cellBorderModel != null && cellBorderModel instanceof JCCellBorder) {
            JCCellBorder jCCellBorder = (JCCellBorder)cellBorderModel;
            if (jCCellBorder.borderType == 8) {
                int n7 = this.table.getFrozenColumns();
                int n8 = this.table.getFrozenColumnPlacement();
                if ((n7 <= 0 || n3 >= n7 && n8 == 2 || n3 < n7 && n8 == 4) && n3 == n5) {
                    n6 |= 0x10;
                }
                int n9 = this.table.getFrozenRows();
                int n10 = this.table.getFrozenRowPlacement();
                if ((n9 <= 0 || n2 >= n9 && n10 == 1 || n2 < n9 && n10 == 3) && n2 == n4) {
                    n6 |= 0x20;
                }
            }
        }
        return n6;
    }
}

