/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCTable;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class CellArea
extends JComponent {
    public static final int CELL = 0;
    public static final int FROZENROW = 1;
    public static final int COLUMNLABEL = 2;
    public static final int FROZENCOLUMN = 3;
    public static final int FROZENCELL = 4;
    public static final int FROZENCOLUMNLABEL = 5;
    public static final int ROWLABEL = 6;
    public static final int FROZENROWLABEL = 7;
    protected int standard_offset_x;
    protected int standard_offset_y;
    protected Dimension cell_size;
    protected int start_row;
    protected int start_column;
    protected int end_row;
    protected int end_column;
    protected int type;

    protected CellArea(int n2) {
        this.type = n2;
        this.cell_size = new Dimension(0, 0);
        this.setCellRange(-999, -999, -999, -999);
        this.standard_offset_x = 0;
        this.standard_offset_y = 0;
        this.enableEvents(56L);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2 = this.translateMouseEventToParent(mouseEvent);
        super.processMouseEvent(mouseEvent);
        JCTable jCTable = (JCTable)this.getParent();
        jCTable.processMouseEvent(mouseEvent2);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2 = this.translateMouseEventToParent(mouseEvent);
        JCTable jCTable = (JCTable)this.getParent();
        jCTable.processMouseMotionEvent(mouseEvent2);
        super.processMouseMotionEvent(mouseEvent);
    }

    protected MouseEvent translateMouseEventToParent(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getX() + this.getLocation().x;
        int n3 = mouseEvent.getY() + this.getLocation().y;
        int n4 = mouseEvent.getModifiers() | mouseEvent.getModifiersEx();
        return new MouseEvent(this.getParent(), mouseEvent.getID(), mouseEvent.getWhen(), n4, n2, n3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        int n2 = keyEvent.getModifiers() | keyEvent.getModifiersEx();
        KeyEvent keyEvent2 = new KeyEvent(this.getParent(), keyEvent.getID(), keyEvent.getWhen(), n2, keyEvent.getKeyCode(), keyEvent.getKeyChar());
        JCTable jCTable = (JCTable)this.getParent();
        jCTable.processKeyEvent(keyEvent2);
        super.processKeyEvent(keyEvent);
    }

    public JCCellRange getCellRange() {
        return new JCCellRange(this.start_row, this.start_column, this.end_row, this.end_column);
    }

    public void setCellRange(JCCellRange jCCellRange) {
        this.setCellRange(jCCellRange.start_row, jCCellRange.start_column, jCCellRange.end_row, jCCellRange.end_column);
    }

    public void setCellRange(int n2, int n3, int n4, int n5) {
        this.start_row = n2;
        this.start_column = n3;
        this.end_row = n4;
        this.end_column = n5;
    }

    public Dimension getCellSize() {
        return this.cell_size;
    }

    public void setCellSize(Dimension dimension) {
        this.cell_size.height = dimension.height;
        this.cell_size.width = dimension.width;
    }

    public void setCellSize(int n2, int n3) {
        this.cell_size.height = n3;
        this.cell_size.width = n2;
    }

    public boolean containsCell(int n2, int n3) {
        return this.start_row != -999 && this.start_row <= n2 && this.end_row >= n2 && this.start_column <= n3 && this.end_column >= n3;
    }

    public boolean intersects(Rectangle rectangle) {
        return rectangle.x + rectangle.width > this.getX() && rectangle.y + rectangle.height > this.getY() && rectangle.x < this.getX() + this.getWidth() && rectangle.y < this.getY() + this.getHeight();
    }

    public Dimension getMinimumSize() {
        switch (this.type) {
            case 0: {
                return new Dimension(1, 1);
            }
            case 1: 
            case 2: {
                return new Dimension(1, this.getPreferredSize().height);
            }
            case 3: 
            case 6: {
                return new Dimension(this.getPreferredSize().width, 1);
            }
        }
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return this.cell_size;
    }

    public int getStandardOffsetX() {
        return this.standard_offset_x;
    }

    public int getStandardOffsetY() {
        return this.standard_offset_y;
    }

    public void setStandardOffset(int n2, int n3) {
        this.standard_offset_x = n2;
        this.standard_offset_y = n3;
    }

    public void setStandardOffsetX(int n2) {
        this.standard_offset_x = n2;
    }

    public void setStandardOffsetY(int n2) {
        this.standard_offset_y = n2;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n2) {
        this.type = n2;
    }

    public String getTypeString() {
        switch (this.type) {
            case 0: {
                return "CELL";
            }
            case 1: {
                return "FROZEN_ROW";
            }
            case 2: {
                return "COLUMN_LABEL";
            }
            case 3: {
                return "FROZEN_COLUMN";
            }
            case 4: {
                return "FROZEN_CELL";
            }
            case 5: {
                return "FROZEN_COLUMN_LABEL";
            }
            case 6: {
                return "ROW_LABEL";
            }
            case 7: {
                return "FROZEN_ROW_LABEL";
            }
        }
        return "UNKNOWN";
    }

    public boolean isHorizontalScrollable() {
        return this.type == 2 || this.type == 1 || this.type == 0;
    }

    public boolean isVerticalScrollable() {
        return this.type == 6 || this.type == 3 || this.type == 0;
    }

    public int getStartRow() {
        return this.start_row;
    }

    public int getStartColumn() {
        return this.start_column;
    }

    public int getEndRow() {
        return this.end_row;
    }

    public int getEndColumn() {
        return this.end_column;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public String toString() {
        return "CellArea type=" + this.getTypeString() + ", " + "r" + this.start_row + "c" + this.start_column + ":r" + this.end_row + "c" + this.end_column + ", [x" + this.getX() + " y" + this.getY() + " w" + this.getWidth() + " h" + this.getHeight() + "]" + ", visible " + this.isVisible();
    }
}

