/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing;

import com.klg.jclass.swing.JCVersion;
import com.klg.jclass.swing.resources.LocaleBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;

public class JCMultiSelectList
extends JComponent
implements Serializable {
    protected static final String SELECT_ITEM = ">";
    protected static final String SELECT_ALL = ">>";
    protected static final String DESELECT_ITEM = "<";
    protected static final String DESELECT_ALL = "<<";
    protected JList mainList = null;
    protected JList sourceList = null;
    protected JList selectionList = null;
    protected JScrollPane sourcePane = null;
    protected JScrollPane selectionPane = null;
    protected SelectionButton selectItemButton = null;
    protected SelectionButton selectAllButton = null;
    protected SelectionButton deselectItemButton = null;
    protected SelectionButton deselectAllButton = null;
    protected JPanel buttonPanel = null;
    protected EventHandler eventHandler = new EventHandler();
    protected Dimension defaultListSize = new Dimension(100, 200);
    protected FontMetrics lastFontMetrics = null;
    private static final String uiClassID = "MultiSelectListUI";

    public JCMultiSelectList(ListModel listModel) {
        this();
        this.mainList.setModel(listModel);
        this.init();
    }

    public JCMultiSelectList(Object[] objectArray) {
        this();
        this.mainList.setListData(objectArray);
        this.init();
    }

    public JCMultiSelectList(Vector vector) {
        this();
        this.mainList.setListData(vector);
        this.init();
    }

    public JCMultiSelectList() {
        this(4);
    }

    public JCMultiSelectList(int n2) {
        this.mainList = new JList();
        this.mainList.addListSelectionListener(this.eventHandler);
        this.sourceList = new JList();
        this.sourceList.setSelectionMode(2);
        this.sourceList.addListSelectionListener(this.eventHandler);
        this.sourceList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    JCMultiSelectList.this.selectItem();
                }
            }
        });
        this.selectionList = new JList();
        this.selectionList.setSelectionMode(2);
        this.selectionList.addListSelectionListener(this.eventHandler);
        this.selectionList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    JCMultiSelectList.this.deselectItem();
                }
            }
        });
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.selectItemButton = this.initButton(new SelectionButton(SELECT_ITEM), LocaleBundle.string("Add selected"));
        this.selectAllButton = this.initButton(new SelectionButton(SELECT_ALL), LocaleBundle.string("Add all"));
        this.deselectItemButton = this.initButton(new SelectionButton(DESELECT_ITEM), LocaleBundle.string("Remove selected"));
        this.deselectAllButton = this.initButton(new SelectionButton(DESELECT_ALL), LocaleBundle.string("Remove all"));
        Dimension dimension = JCMultiSelectList.getButtonSize();
        this.buttonPanel.setPreferredSize(new Dimension(dimension.width, 4 * dimension.height));
        this.setLayout(new JCFixedCenterLayout(n2));
        this.sourcePane = new JScrollPane(this.sourceList);
        this.sourcePane.setPreferredSize(this.defaultListSize);
        this.selectionPane = new JScrollPane(this.selectionList);
        this.selectionPane.setPreferredSize(this.defaultListSize);
        this.add((Component)this.sourcePane, "West");
        this.add((Component)this.selectionPane, "East");
        this.add((Component)this.buttonPanel, "Center");
        this.setUI(new MultiSelectListUI());
    }

    public void updateUI() {
        this.setUI(new MultiSelectListUI());
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setAbout(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public Object getPrototypeCellValue() {
        return this.mainList.getPrototypeCellValue();
    }

    public void setPrototypeCellValue(Object object) {
        this.mainList.setPrototypeCellValue(object);
        this.sourceList.setPrototypeCellValue(object);
        this.selectionList.setPrototypeCellValue(object);
    }

    public int getFixedCellWidth() {
        return this.mainList.getFixedCellWidth();
    }

    public void setFixedCellWidth(int n2) {
        this.mainList.setFixedCellWidth(n2);
        this.sourceList.setFixedCellWidth(n2);
        this.selectionList.setFixedCellWidth(n2);
    }

    public int getFixedCellHeight() {
        return this.mainList.getFixedCellHeight();
    }

    public void setFixedCellHeight(int n2) {
        this.mainList.setFixedCellHeight(n2);
        this.sourceList.setFixedCellHeight(n2);
        this.selectionList.setFixedCellHeight(n2);
    }

    public ListCellRenderer getCellRenderer() {
        return this.mainList.getCellRenderer();
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        this.mainList.setCellRenderer(listCellRenderer);
        this.sourceList.setCellRenderer(listCellRenderer);
        this.selectionList.setCellRenderer(listCellRenderer);
    }

    public Color getSelectionForeground() {
        return this.mainList.getSelectionForeground();
    }

    public void setSelectionForeground(Color color) {
        this.mainList.setSelectionForeground(color);
        this.sourceList.setSelectionForeground(color);
        this.selectionList.setSelectionForeground(color);
    }

    public Color getSelectionBackground() {
        return this.mainList.getSelectionBackground();
    }

    public void setSelectionBackground(Color color) {
        this.mainList.setSelectionBackground(color);
        this.sourceList.setSelectionBackground(color);
        this.selectionList.setSelectionBackground(color);
    }

    public ListModel getModel() {
        return this.mainList.getModel();
    }

    public void setModel(ListModel listModel) {
        this.mainList.setModel(listModel);
        this.updateView();
    }

    public void setListData(Object[] objectArray) {
        this.mainList.setListData(objectArray);
        this.updateView();
    }

    public void setListData(Vector vector) {
        this.mainList.setListData(vector);
        this.updateView();
    }

    public ListSelectionModel getSelectionModel() {
        return this.mainList.getSelectionModel();
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.add(ListSelectionListener.class, listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(ListSelectionListener.class, listSelectionListener);
    }

    protected void fireSelectionValueChanged(int n2, int n3, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListSelectionEvent listSelectionEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != ListSelectionListener.class) continue;
            if (listSelectionEvent == null) {
                listSelectionEvent = new ListSelectionEvent(this, n2, n3, bl);
            }
            ((ListSelectionListener)objectArray[i2 + 1]).valueChanged(listSelectionEvent);
        }
    }

    public int getSelectionMode() {
        return this.mainList.getSelectionMode();
    }

    public int getAnchorSelectionIndex() {
        return this.getSelectionModel().getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.mainList.getLeadSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.mainList.getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.mainList.getMaxSelectionIndex();
    }

    public boolean isSelectedIndex(int n2) {
        return this.mainList.isSelectedIndex(n2);
    }

    public boolean isSelectionEmpty() {
        return this.mainList.isSelectionEmpty();
    }

    public void clearSelection() {
        this.mainList.clearSelection();
        this.updateView();
    }

    public void setSelectionInterval(int n2, int n3) {
        this.mainList.setSelectionInterval(n2, n3);
        this.updateView();
    }

    public void addSelectionInterval(int n2, int n3) {
        this.mainList.addSelectionInterval(n2, n3);
        this.updateView();
    }

    public void removeSelectionInterval(int n2, int n3) {
        this.mainList.removeSelectionInterval(n2, n3);
        this.updateView();
    }

    public int getSelectedIndex() {
        return this.mainList.getSelectedIndex();
    }

    public void setSelectedIndex(int n2) {
        this.mainList.setSelectedIndex(n2);
        this.updateView();
    }

    public int[] getSelectedIndices() {
        return this.mainList.getSelectedIndices();
    }

    public void setSelectedIndices(int[] nArray) {
        this.mainList.setSelectedIndices(nArray);
        this.updateView();
    }

    public Object[] getSelectedValues() {
        return this.mainList.getSelectedValues();
    }

    public Object getSelectedValue() {
        return this.mainList.getSelectedValue();
    }

    public void setSelectedValue(Object object, boolean bl) {
        this.mainList.setSelectedValue(object, bl);
        this.updateView();
    }

    protected String paramString() {
        return super.paramString() + LocaleBundle.string(", the list is: ") + this.mainList;
    }

    protected SelectionButton initButton(SelectionButton selectionButton, String string) {
        if (selectionButton != null) {
            this.buttonPanel.add(selectionButton);
            selectionButton.addActionListener(this.eventHandler);
            selectionButton.setToolTipText(string);
        }
        return selectionButton;
    }

    protected void init() {
        this.updateView();
    }

    protected void updateView() {
        ListModel listModel = this.mainList.getModel();
        int[] nArray = this.mainList.getSelectedIndices();
        Vector vector = new Vector(listModel.getSize() - nArray.length);
        Vector vector2 = new Vector(nArray.length);
        for (int i2 = 0; i2 < listModel.getSize(); ++i2) {
            if (this.mainList.isSelectedIndex(i2)) {
                vector2.addElement(listModel.getElementAt(i2));
                continue;
            }
            vector.addElement(listModel.getElementAt(i2));
        }
        this.sourceList.setListData(vector);
        this.selectionList.setListData(vector2);
        this.updateButtons();
    }

    public void updateButtons() {
        this.selectItemButton.setEnabled(!this.sourceList.isSelectionEmpty());
        this.selectAllButton.setEnabled(this.sourceList.getModel().getSize() > 0);
        this.deselectItemButton.setEnabled(!this.selectionList.isSelectionEmpty());
        this.deselectAllButton.setEnabled(this.selectionList.getModel().getSize() > 0);
    }

    public static final Dimension getButtonSize() {
        return new Dimension(32, 32);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.sourcePane.getPreferredSize();
        Dimension dimension2 = this.selectionPane.getPreferredSize();
        Dimension dimension3 = this.buttonPanel.getPreferredSize();
        int n2 = dimension3.width + 2 * this.getListPreferredWidth();
        int n3 = Math.max(dimension3.height, Math.max(dimension.height, dimension2.height));
        return new Dimension(n2, n3);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.sourceList.getMinimumSize();
        Dimension dimension2 = this.selectionList.getMinimumSize();
        Dimension dimension3 = this.buttonPanel.getMinimumSize();
        int n2 = dimension3.width + dimension.width + dimension2.width;
        int n3 = Math.max(dimension3.height, Math.max(dimension.height, dimension2.height));
        return new Dimension(n2, n3);
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.sourceList.getMaximumSize();
        Dimension dimension2 = this.selectionList.getMaximumSize();
        Dimension dimension3 = this.buttonPanel.getMaximumSize();
        int n2 = dimension3.width + dimension.width + dimension2.width;
        int n3 = Math.max(dimension3.height, Math.max(dimension.height, dimension2.height));
        return new Dimension(n2, n3);
    }

    public void paint(Graphics graphics) {
        this.lastFontMetrics = graphics.getFontMetrics();
        super.paint(graphics);
    }

    public int getListPreferredWidth() {
        ListModel listModel = this.mainList.getModel();
        int n2 = 0;
        if (this.lastFontMetrics != null) {
            for (int i2 = 0; i2 < listModel.getSize(); ++i2) {
                Object e2 = listModel.getElementAt(i2);
                if (!(e2 instanceof String)) continue;
                Math.max(this.lastFontMetrics.stringWidth((String)e2), n2);
            }
        }
        return n2 == 0 ? this.defaultListSize.width : n2;
    }

    protected void selectItem() {
        if (this.isEnabled()) {
            int[] nArray = this.mainList.getSelectedIndices();
            Object[] objectArray = this.sourceList.getSelectedValues();
            int[] nArray2 = new int[nArray.length + objectArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            ListModel listModel = this.mainList.getModel();
            int n2 = nArray.length;
            for (int i2 = 0; i2 < listModel.getSize(); ++i2) {
                Object e2 = listModel.getElementAt(i2);
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    if (e2 != objectArray[i3]) continue;
                    nArray2[n2++] = i2;
                }
            }
            this.doUpdate(this.sourceList, objectArray, nArray2);
        }
    }

    protected void selectAll() {
        this.addSelectionInterval(0, this.mainList.getModel().getSize() - 1);
        this.updateView();
    }

    protected void deselectItem() {
        if (this.isEnabled()) {
            int[] nArray = this.mainList.getSelectedIndices();
            Object[] objectArray = this.selectionList.getSelectedValues();
            int[] nArray2 = new int[nArray.length - objectArray.length];
            ListModel listModel = this.mainList.getModel();
            int n2 = 0;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                Object e2 = listModel.getElementAt(nArray[i2]);
                boolean bl = false;
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    if (e2 != objectArray[i3]) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                nArray2[n2++] = nArray[i2];
            }
            this.doUpdate(this.selectionList, objectArray, nArray2);
        }
    }

    protected void doUpdate(JList jList, Object[] objectArray, int[] nArray) {
        if (objectArray == null || objectArray.length < 1) {
            return;
        }
        int n2 = this.getIndexFromItem(jList, objectArray[objectArray.length - 1]);
        this.mainList.setSelectedIndices(nArray);
        this.updateView();
        if ((n2 -= objectArray.length - 1) < jList.getModel().getSize()) {
            jList.setSelectedIndex(n2);
        } else {
            jList.setSelectedIndex(jList.getModel().getSize() - 1);
        }
    }

    public int getIndexFromItem(JList jList, Object object) {
        ListModel listModel = jList.getModel();
        for (int i2 = 0; i2 < listModel.getSize(); ++i2) {
            Object e2 = listModel.getElementAt(i2);
            if (!e2.equals(object)) continue;
            return i2;
        }
        return -1;
    }

    protected void deselectAll() {
        this.mainList.clearSelection();
        this.updateView();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.sourceList.setEnabled(bl);
        this.selectionList.setEnabled(bl);
        if (bl) {
            this.updateButtons();
        } else {
            this.disableButtons();
        }
    }

    protected void disableButtons() {
        this.selectItemButton.setEnabled(false);
        this.selectAllButton.setEnabled(false);
        this.deselectItemButton.setEnabled(false);
        this.deselectAllButton.setEnabled(false);
    }

    protected class MultiSelectListUI
    extends ComponentUI {
        protected MultiSelectListUI() {
        }
    }

    protected class JCFixedCenterLayout
    implements LayoutManager2,
    Serializable {
        protected int hgap;
        protected Component west;
        protected Component east;
        protected Component center;

        public JCFixedCenterLayout() {
            this(0);
        }

        public JCFixedCenterLayout(int n2) {
            this.hgap = n2;
        }

        public int getHgap() {
            return this.hgap;
        }

        public void setHgap(int n2) {
            this.hgap = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLayoutComponent(Component component, Object object) {
            Object object2 = component.getTreeLock();
            synchronized (object2) {
                if (object != null && !(object instanceof String)) {
                    throw new IllegalArgumentException(LocaleBundle.string("Cannot add to layout: constraint must be a string or null"));
                }
                this.addLayoutComponent((String)object, component);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLayoutComponent(String string, Component component) {
            Object object = component.getTreeLock();
            synchronized (object) {
                if (string == null || "Center".equals(string)) {
                    this.center = component;
                } else if ("East".equals(string)) {
                    this.east = component;
                } else if ("West".equals(string)) {
                    this.west = component;
                } else {
                    throw new IllegalArgumentException(LocaleBundle.string("Cannot add to layout: unknown constraint: ") + string);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLayoutComponent(Component component) {
            Object object = component.getTreeLock();
            synchronized (object) {
                if (component == this.center) {
                    this.center = null;
                } else if (component == this.east) {
                    this.east = null;
                } else if (component == this.west) {
                    this.west = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension minimumLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension = new Dimension(0, 0);
                this.addMinimumSize(dimension, this.east);
                this.addMinimumSize(dimension, this.west);
                this.addMinimumSize(dimension, this.center);
                Insets insets = container.getInsets();
                dimension.width += insets.left + insets.right;
                dimension.height += insets.top + insets.bottom;
                return dimension;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension = new Dimension(0, 0);
                this.addPreferredSize(dimension, this.east);
                this.addPreferredSize(dimension, this.west);
                this.addPreferredSize(dimension, this.center);
                Insets insets = container.getInsets();
                dimension.width += insets.left + insets.right;
                dimension.height += insets.top + insets.bottom;
                return dimension;
            }
        }

        public Dimension maximumLayoutSize(Container container) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.5f;
        }

        public void invalidateLayout(Container container) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n2;
                Insets insets = container.getInsets();
                int n3 = insets.top;
                int n4 = container.getBounds().height - insets.bottom;
                int n5 = insets.left;
                int n6 = container.getBounds().width - insets.right;
                int n7 = n2 = (n6 - n5) / 2;
                if (this.center != null) {
                    Dimension dimension = this.center.getPreferredSize();
                    n2 = (n6 - n5 - dimension.width) / 2;
                    n7 = n2 + dimension.width;
                    this.center.setBounds(n2, n3, dimension.width, n4 - n3);
                }
                if (this.west != null) {
                    this.west.setBounds(n5, n3, n2 - n5 - this.hgap, n4 - n3);
                }
                if (this.east != null) {
                    this.east.setBounds(n7 + this.hgap, n3, n6 - n7 - 2 * this.hgap, n4 - n3);
                }
            }
        }

        private void addMinimumSize(Dimension dimension, Component component) {
            if (component != null) {
                this.addSize(dimension, component.getMinimumSize());
            }
        }

        private void addPreferredSize(Dimension dimension, Component component) {
            if (component != null) {
                this.addSize(dimension, component.getPreferredSize());
            }
        }

        private void addSize(Dimension dimension, Dimension dimension2) {
            dimension.width += dimension2.width + this.hgap;
            dimension.height = Math.max(dimension2.height, dimension.height);
        }

        public String toString() {
            return this.getClass().getName() + "[hgap=" + this.hgap + "]";
        }
    }

    protected class SelectionButton
    extends JButton
    implements Serializable {
        SelectionButton(String string) {
            super(string);
            this.setEnabled(false);
            this.setMargin(new Insets(2, 2, 2, 2));
        }

        public Dimension getPreferredSize() {
            return JCMultiSelectList.getButtonSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    private class EventHandler
    implements ActionListener,
    ListSelectionListener,
    Serializable {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof SelectionButton) {
                SelectionButton selectionButton = (SelectionButton)actionEvent.getSource();
                if (selectionButton.equals(JCMultiSelectList.this.selectItemButton)) {
                    JCMultiSelectList.this.selectItem();
                } else if (selectionButton.equals(JCMultiSelectList.this.selectAllButton)) {
                    JCMultiSelectList.this.selectAll();
                } else if (selectionButton.equals(JCMultiSelectList.this.deselectItemButton)) {
                    JCMultiSelectList.this.deselectItem();
                } else if (selectionButton.equals(JCMultiSelectList.this.deselectAllButton)) {
                    JCMultiSelectList.this.deselectAll();
                }
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == JCMultiSelectList.this.mainList) {
                JCMultiSelectList.this.fireSelectionValueChanged(listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex(), listSelectionEvent.getValueIsAdjusting());
            }
            JCMultiSelectList.this.updateButtons();
        }
    }
}

