/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing;

import com.klg.jclass.swing.JCMDIFrame;
import com.klg.jclass.swing.JCMDIWindowMenu;
import com.klg.jclass.swing.JCVersion;
import com.klg.jclass.swing.resources.LocaleBundle;
import com.klg.jclass.swing.util.LayoutButton;
import com.klg.jclass.swing.util.LayoutButtonBox;
import com.klg.jclass.swing.util.ShrinkWrapLayout;
import com.klg.jclass.swing.util.UserMenuItem;
import com.klg.jclass.swing.util.WindowMenuItem;
import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCLocaleManager;
import com.klg.jclass.util.swing.JCAction;
import com.klg.jclass.util.swing.JCIconCreator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.DesktopManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class JCMDIPane
extends JDesktopPane {
    public static final int WIREFRAME = 1;
    public static final int DEFAULT = 2;
    public static final int TILE_HORIZONTAL = 1;
    public static final int TILE_VERTICAL = 2;
    public static final int CASCADE = 3;
    protected static JCLocaleManager li = JCLocaleManager.getDefault();
    protected int initialLayout = 0;
    protected JMenuBar menubar = null;
    protected JToolBar toolbar = null;
    protected Listener listener = new Listener();
    protected FrameListener frameListener = new FrameListener();
    protected ActionListener menuListener = new WindowsMenuListener();
    protected boolean maximized = false;
    protected LayoutButtonBox layoutButtonBox = null;
    protected String savedTitle = null;
    protected boolean titleIsSaved = false;
    protected JCAction maxMinAction = null;
    protected JMenuItem maxMinItem = null;
    protected JCAction cascadeAction = null;
    protected JCAction tileHorizAction = null;
    protected JCAction tileVertAction = null;
    protected JCAction arrangeIconsAction = null;
    protected int frameManipulationStyle = 1;
    protected JToolBar lastToolBarSetToRoot = null;
    protected Icon selectedIcon;
    protected Icon nonSelectedIcon;
    protected JInternalFrame activeFrame = null;
    protected JPanel maximizedPanel = new JPanel(new ShrinkWrapLayout());
    protected JInternalFrame maximizedFrame = null;
    protected JInternalFrame maximizingFrame = null;
    protected boolean considerIconsWhenTiling = false;
    protected JMenuBar currentMenuBar = null;
    protected JInternalFrame activatingFrame = null;
    private static final String[] selectedIconPixels = new String[]{"             ", "             ", "         bbb ", "        bbb  ", "       bbb   ", "bbbb  bbb    ", " bbb bbb     ", "  bbbbb      ", "   bbb       ", "    b        ", "             ", "             ", "             "};
    private static final String[] nonSelectedIconPixels = new String[]{"             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             "};
    protected int cascadeX = -1;
    protected int cascadeY = -1;
    protected int cascadeXStart = 0;
    protected int cascadeYStart = 0;
    protected int cascadeXIncrement = 20;
    protected int cascadeYIncrement = 25;
    protected int cascadeStartIncrement = 100;
    protected int cascadeTolerance = 50;
    private Dimension cascadeSize = new Dimension(0, 0);
    private int fudge2 = 0;
    private int fudge1 = 0;

    public JCMDIPane() {
        this.setMinimumSize(new Dimension(300, 200));
        this.addContainerListener(this.listener);
        this.setSelectedIcon(JCMDIPane.makeImage(selectedIconPixels));
        this.setNonSelectedIcon(JCMDIPane.makeImage(nonSelectedIconPixels));
    }

    public void setAbout(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public int getFrameManipulationStyle() {
        return this.frameManipulationStyle;
    }

    public void setFrameManipulationStyle(int n2) {
        if (n2 < 1 || n2 > 2) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid parameter: ") + n2);
        }
        if (n2 == this.frameManipulationStyle) {
            return;
        }
        this.frameManipulationStyle = n2;
    }

    public void setDragMode(int n2) {
        if (JCEnvironment.getJavaVersion() >= 130) {
            super.setDragMode(n2);
        }
        if (n2 == 0) {
            this.setFrameManipulationStyle(2);
        } else {
            this.setFrameManipulationStyle(1);
        }
    }

    public int getDragMode() {
        if (JCEnvironment.getJavaVersion() >= 130) {
            return super.getDragMode();
        }
        if (this.frameManipulationStyle == 2) {
            return 0;
        }
        return 1;
    }

    public boolean isConsiderIconsWhenTiling() {
        return this.considerIconsWhenTiling;
    }

    public void setConsiderIconsWhenTiling(boolean bl) {
        this.considerIconsWhenTiling = bl;
    }

    public JToolBar getMDIToolBar() {
        return this.toolbar;
    }

    protected void checkIfMenuOrToolBarsNeeded() {
        JToolBar jToolBar = null;
        JMenuBar jMenuBar = null;
        if (this.isDisplayable()) {
            Component[] componentArray = this.getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                JInternalFrame.JDesktopIcon jDesktopIcon;
                JInternalFrame jInternalFrame;
                JCMDIFrame jCMDIFrame = null;
                if (componentArray[i2] instanceof JCMDIFrame) {
                    jCMDIFrame = (JCMDIFrame)componentArray[i2];
                } else if (componentArray[i2] instanceof JInternalFrame.JDesktopIcon && (jInternalFrame = (jDesktopIcon = (JInternalFrame.JDesktopIcon)componentArray[i2]).getInternalFrame()) instanceof JCMDIFrame) {
                    jCMDIFrame = (JCMDIFrame)jInternalFrame;
                }
                if (jCMDIFrame == null || !jCMDIFrame.isSelected()) continue;
                jMenuBar = jCMDIFrame.getMDIMenuBar();
                jToolBar = jCMDIFrame.getMDIToolBar();
                break;
            }
            if (jMenuBar == null) {
                jMenuBar = this.menubar;
            }
            if (jToolBar == null) {
                jToolBar = this.toolbar;
            }
            this.setMenuAndToolBarsToRootPane(null, jMenuBar, jToolBar);
        }
    }

    public JToolBar getMDIToolBar(JInternalFrame jInternalFrame) {
        JToolBar jToolBar;
        if (jInternalFrame != null && jInternalFrame instanceof JCMDIFrame && (jToolBar = ((JCMDIFrame)jInternalFrame).getMDIToolBar()) != null) {
            return jToolBar;
        }
        return this.toolbar;
    }

    public void setMDIToolBar(JToolBar jToolBar) {
        this.toolbar = jToolBar;
        this.checkIfMenuOrToolBarsNeeded();
    }

    public JMenuBar getMDIMenuBar() {
        return this.menubar;
    }

    public JMenuBar getMDIMenuBar(JInternalFrame jInternalFrame) {
        JMenuBar jMenuBar;
        if (jInternalFrame != null && jInternalFrame instanceof JCMDIFrame && (jMenuBar = ((JCMDIFrame)jInternalFrame).getMDIMenuBar()) != null) {
            return jMenuBar;
        }
        return this.menubar;
    }

    public void setMDIMenuBar(JMenuBar jMenuBar) {
        this.menubar = jMenuBar;
        this.checkIfMenuOrToolBarsNeeded();
    }

    public void setLayout() {
    }

    public void addNotify() {
        this.selectNextFrame();
        super.addNotify();
        this.checkIfMenuOrToolBarsNeeded();
        this.updateWindowsMenu();
    }

    public JInternalFrame getTopFrame() {
        JInternalFrame[] jInternalFrameArray = this.getAllFramesInLayer(DEFAULT_LAYER);
        return jInternalFrameArray.length > 0 ? jInternalFrameArray[0] : null;
    }

    public Dimension getPreferredSize() {
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        int n2 = this.getComponentCount();
        if (jScrollPane == null || n2 == 0) {
            return this.getMinimumSize();
        }
        Rectangle rectangle = new Rectangle();
        for (int i2 = 0; i2 < n2; ++i2) {
            rectangle = rectangle.union(this.getComponent(i2).getBounds());
        }
        return rectangle.getSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(100, 100);
    }

    protected void updateWindowsMenu() {
        JMenu jMenu = this.getWindowsMenuFromMenuBar();
        if (jMenu != null) {
            this.buildWindowsMenu(jMenu);
        }
    }

    protected JMenuBar getJMenuBar() {
        if (this.currentMenuBar != null) {
            return this.currentMenuBar;
        }
        JMenuBar jMenuBar = null;
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane == null) {
            return null;
        }
        this.currentMenuBar = jMenuBar = jRootPane.getJMenuBar();
        return jMenuBar;
    }

    public JMenu getWindowsMenuFromMenuBar() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return null;
        }
        MenuElement[] menuElementArray = jMenuBar.getSubElements();
        for (int i2 = 0; i2 < menuElementArray.length; ++i2) {
            if (!(menuElementArray[i2] instanceof JCMDIWindowMenu)) continue;
            return (JMenu)menuElementArray[i2];
        }
        JCMDIWindowMenu jCMDIWindowMenu = new JCMDIWindowMenu();
        jMenuBar.add(jCMDIWindowMenu);
        return jCMDIWindowMenu;
    }

    protected void buildWindowsMenu(JMenu jMenu) {
        JInternalFrame jInternalFrame;
        if (jMenu.getMenuComponentCount() != 0) {
            jMenu.removeAll();
        }
        int n2 = this.getOpenInternalFrameCount();
        this.cascadeAction = new CascadeAction();
        JMenuItem jMenuItem = this.cascadeAction.createMenuItem();
        jMenu.add(jMenuItem);
        if (n2 == 0) {
            jMenuItem.setEnabled(false);
        }
        this.maxMinAction = new MaxMinAction();
        jMenuItem = this.maxMinAction.createMenuItem();
        if (this.maximized) {
            jMenuItem.setText(li.getString("ActionUndomax"));
        } else {
            jMenuItem.setText(li.getString("ActionMaximize"));
        }
        this.maxMinItem = jMenuItem;
        jMenu.add(jMenuItem);
        JInternalFrame jInternalFrame2 = jInternalFrame = this.activatingFrame == null ? this.activeFrame : this.activatingFrame;
        if (n2 == 0 || jInternalFrame != null && !jInternalFrame.isMaximizable()) {
            jMenuItem.setEnabled(false);
        }
        this.tileHorizAction = new TileHAction();
        jMenuItem = this.tileHorizAction.createMenuItem();
        jMenu.add(jMenuItem);
        if (n2 == 0) {
            jMenuItem.setEnabled(false);
        }
        this.tileVertAction = new TileVAction();
        jMenuItem = this.tileVertAction.createMenuItem();
        jMenu.add(jMenuItem);
        if (n2 == 0) {
            jMenuItem.setEnabled(false);
        }
        this.arrangeIconsAction = new ArrangeAction();
        jMenuItem = this.arrangeIconsAction.createMenuItem();
        jMenu.add(jMenuItem);
        if (this.getIconifiedFrameCount() == 0) {
            jMenuItem.setEnabled(false);
        }
        jMenu.add(new JSeparator());
        Component[] componentArray = this.getComponents();
        int n3 = 0;
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            JInternalFrame jInternalFrame3 = null;
            if (componentArray[i2] instanceof JInternalFrame) {
                jInternalFrame3 = (JInternalFrame)componentArray[i2];
            } else if (componentArray[i2] instanceof JInternalFrame.JDesktopIcon && (jInternalFrame3 = ((JInternalFrame.JDesktopIcon)componentArray[i2]).getInternalFrame()).getParent() != null) {
                jInternalFrame3 = null;
            }
            if (jInternalFrame3 == null || !jInternalFrame3.isVisible()) continue;
            char c2 = Integer.toString(i2).charAt(0);
            WindowMenuItem windowMenuItem = new WindowMenuItem("" + n3++ + " ", c2, (Object)jInternalFrame3);
            if (n3 == 1) {
                windowMenuItem.setIcon(this.getSelectedIcon());
            } else {
                windowMenuItem.setIcon(this.getNonSelectedIcon());
            }
            windowMenuItem.addActionListener(this.menuListener);
            jMenu.add(windowMenuItem);
        }
    }

    protected void moveChildren(Container container, Container container2) {
        Component component;
        if (container instanceof JCMDIFrame) {
            component = ((JCMDIFrame)container).getContentPane();
        } else {
            if (container instanceof RootPaneContainer) {
                container = ((RootPaneContainer)((Object)container)).getContentPane();
            }
            if (container.getComponentCount() < 1) {
                return;
            }
            component = container.getComponent(0);
        }
        if (container2 instanceof JCMDIFrame) {
            ((JCMDIFrame)container2).restoreContainer((Container)component);
        } else {
            if (container2 instanceof RootPaneContainer) {
                container2 = ((RootPaneContainer)((Object)container2)).getContentPane();
            }
            container2.add(component);
        }
        container2.invalidate();
        container2.validate();
    }

    protected void maximizeFrame(JInternalFrame jInternalFrame) {
        Object object;
        Frame frame;
        if (this.maximizingFrame != null) {
            return;
        }
        this.activeFrame = jInternalFrame;
        if (this.maximizedFrame == jInternalFrame) {
            return;
        }
        this.maximizingFrame = jInternalFrame;
        if (this.maximizedFrame != null) {
            try {
                this.maximizedFrame.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (jInternalFrame != null) {
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if ((frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this)) != null && !this.titleIsSaved) {
            this.savedTitle = frame.getTitle();
            this.titleIsSaved = true;
        }
        if (this.maximizedFrame != null && this.maximizedPanel.getComponentCount() != 0) {
            this.moveChildren(this.maximizedPanel, this.maximizedFrame);
        }
        if (jInternalFrame != null) {
            this.moveChildren(jInternalFrame, this.maximizedPanel);
            if (this.maximizedPanel.getParent() == null) {
                object = this.getParent();
                if (object != null && ((Component)object).getParent() != null && ((Component)object).getParent() instanceof JScrollPane) {
                    JScrollPane jScrollPane = (JScrollPane)((Component)object).getParent();
                    jScrollPane.setHorizontalScrollBarPolicy(31);
                    jScrollPane.setVerticalScrollBarPolicy(21);
                    jScrollPane.revalidate();
                }
                this.add(this.maximizedPanel);
            }
            this.maximizedPanel.setBounds(0, 0, this.getVisibleSize().width, this.getVisibleSize().height);
            this.moveToFront(this.maximizedPanel);
        } else if (this.maximizedPanel.getParent() != null) {
            this.remove(this.maximizedPanel);
        }
        if (jInternalFrame == null) {
            // empty if block
        }
        this.maximizedFrame = jInternalFrame;
        if (this.titleIsSaved) {
            object = this.savedTitle == null ? "" : this.savedTitle;
            if (this.maximizedFrame != null) {
                object = (String)object + " - " + this.maximizedFrame.getTitle();
            }
            frame.setTitle((String)object);
        }
        this.checkIfMenuOrToolBarsNeeded();
        this.updateIconsInMenuBar(jInternalFrame);
        if (this.maximizedFrame != null) {
            this.maximizedFrame.grabFocus();
        }
        this.maximizingFrame = null;
    }

    protected void unmaximizeFrame() {
        Container container;
        if (this.maximizedFrame == null) {
            return;
        }
        if (this.maximizedPanel.getParent() != null) {
            container = this.getParent();
            if (container != null && container.getParent() != null && container.getParent() instanceof JScrollPane) {
                JScrollPane jScrollPane = (JScrollPane)container.getParent();
                jScrollPane.setHorizontalScrollBarPolicy(30);
                jScrollPane.setVerticalScrollBarPolicy(20);
                jScrollPane.revalidate();
            }
            this.remove(this.maximizedPanel);
        }
        this.moveChildren(this.maximizedPanel, this.maximizedFrame);
        if (this.maximizedFrame != null) {
            this.maximizedFrame.grabFocus();
        }
        this.maximizedFrame = null;
        container = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        if (container != null && this.titleIsSaved) {
            ((Frame)container).setTitle(this.savedTitle);
        }
    }

    public void unmaximize() {
        this.maximized = false;
        if (this.maximizedFrame != null) {
            try {
                this.maximizedFrame.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.unmaximizeFrame();
        if (this.maxMinItem != null) {
            this.maxMinItem.setText(li.getString("ActionMaximize"));
        }
        this.updateIconsInMenuBar(null);
        this.repaint();
    }

    protected void updateIconsInMenuBar(JInternalFrame jInternalFrame) {
        LayoutButtonBox layoutButtonBox = this.getLayoutButtonBox();
        if (jInternalFrame == null || !this.maximized) {
            Container container = layoutButtonBox.getParent();
            if (container != null) {
                container.remove(layoutButtonBox);
                container.repaint();
            }
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return;
        }
        layoutButtonBox.setMaximizedFrame(jInternalFrame);
        if (layoutButtonBox.getParent() != jMenuBar) {
            jMenuBar.add(layoutButtonBox);
            jMenuBar.validate();
            jMenuBar.repaint();
        }
    }

    public void doLayout() {
        if (this.maximized) {
            this.maximizedPanel.setBounds(0, 0, this.getVisibleSize().width, this.getVisibleSize().height);
        }
        Component[] componentArray = this.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (!(componentArray[i2] instanceof JInternalFrame)) continue;
        }
        super.doLayout();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        switch (this.initialLayout) {
            case 1: {
                this.tileWindowsHorizontally();
                break;
            }
            case 2: {
                this.tileWindowsVertically();
                break;
            }
            case 3: {
                this.cascadeWindows();
                break;
            }
        }
        this.initialLayout = 0;
    }

    public void setMaximized(boolean bl) {
        if (this.maximized == bl) {
            return;
        }
        if (bl) {
            if (this.activeFrame != null) {
                this.maximize(this.activeFrame);
            } else {
                this.maximized = true;
            }
        } else {
            this.unmaximize();
        }
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void maximize(JInternalFrame jInternalFrame) {
        if (jInternalFrame != null && jInternalFrame.isMaximizable() && jInternalFrame.isVisible()) {
            this.maximized = true;
            this.maximizeFrame(jInternalFrame);
        }
    }

    public void setInitialLayout(int n2) {
        this.initialLayout = n2;
    }

    protected void setTitleBar() {
        String string;
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        if (frame == null) {
            return;
        }
        if (this.maximized) {
            this.savedTitle = frame.getTitle();
            string = this.savedTitle == null ? "" : this.savedTitle;
            string = string + " - " + this.maximizedFrame.getTitle();
        } else {
            string = this.savedTitle;
        }
        frame.setTitle(string);
    }

    protected LayoutButtonBox getLayoutButtonBox() {
        if (this.layoutButtonBox == null) {
            this.layoutButtonBox = new LayoutButtonBox(new LayoutListener());
        }
        return this.layoutButtonBox;
    }

    public JInternalFrame[] getAllNonIconifiedAndNonPaletteFrames() {
        Vector<JInternalFrame> vector = new Vector<JInternalFrame>(this.getComponentCount());
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            JInternalFrame jInternalFrame;
            if (!(this.getComponent(i2) instanceof JInternalFrame) || !(jInternalFrame = (JInternalFrame)this.getComponent(i2)).isVisible() || jInternalFrame.getLayer() == JLayeredPane.PALETTE_LAYER.intValue()) continue;
            vector.addElement(jInternalFrame);
        }
        Object[] objectArray = new JInternalFrame[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public JInternalFrame.JDesktopIcon[] getAllIconifiedFrames() {
        Vector<Component> vector = new Vector<Component>(this.getComponentCount());
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            JInternalFrame.JDesktopIcon jDesktopIcon;
            JInternalFrame jInternalFrame;
            Component component = this.getComponent(i2);
            if (!(component instanceof JInternalFrame.JDesktopIcon) || (jInternalFrame = (jDesktopIcon = (JInternalFrame.JDesktopIcon)component).getInternalFrame()) == null || !jInternalFrame.isVisible()) continue;
            vector.addElement(component);
        }
        Object[] objectArray = new JInternalFrame.JDesktopIcon[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected Dimension calcCascadeSize() {
        this.cascadeSize.width = (int)(0.8 * (double)this.getSize().width);
        this.cascadeSize.height = (int)(0.8 * (double)this.getSize().height);
        return this.cascadeSize;
    }

    protected void cascadeReset() {
        this.cascadeX = -1;
        this.cascadeY = -1;
        this.cascadeXStart = 0;
        this.cascadeYStart = 0;
    }

    protected void calcNewCascadePosition(Dimension dimension) {
        if (this.cascadeX < 0 || this.cascadeY < 0) {
            this.cascadeX = this.cascadeXStart;
            this.cascadeY = this.cascadeYStart;
            return;
        }
        int n2 = this.getVisibleSize().width;
        int n3 = this.getVisibleSize().height;
        this.cascadeX += this.cascadeXIncrement;
        this.cascadeY += this.cascadeYIncrement;
        if (this.cascadeY > n3 - this.cascadeTolerance || this.cascadeX > n2 - this.cascadeTolerance) {
            this.cascadeXStart += this.cascadeStartIncrement;
            if (this.cascadeXStart > n2 - this.cascadeTolerance) {
                this.cascadeXStart = 0;
                this.cascadeYStart += this.cascadeStartIncrement;
                if (this.cascadeYStart > n3 - this.cascadeTolerance) {
                    this.cascadeYStart = 0;
                }
            }
            this.cascadeX = this.cascadeXStart;
            this.cascadeY = this.cascadeYStart;
        }
    }

    protected void cascadeFrame(JInternalFrame jInternalFrame) {
        if (!this.isDisplayable()) {
            return;
        }
        Dimension dimension = this.calcCascadeSize();
        this.calcNewCascadePosition(dimension);
        if (jInternalFrame.isResizable()) {
            jInternalFrame.setBounds(this.cascadeX, this.cascadeY, dimension.width, dimension.height);
        } else {
            jInternalFrame.setLocation(this.cascadeX, this.cascadeY);
        }
    }

    protected void cascadeFrameByPreferredSize(JInternalFrame jInternalFrame) {
        Dimension dimension = jInternalFrame.getPreferredSize();
        this.calcNewCascadePosition(dimension);
        if (jInternalFrame.isResizable()) {
            jInternalFrame.setBounds(this.cascadeX, this.cascadeY, dimension.width, dimension.height);
        } else {
            jInternalFrame.setLocation(this.cascadeX, this.cascadeY);
        }
    }

    protected void resizingScrollPane() {
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        if (jScrollPane != null) {
            this.revalidate();
        }
    }

    protected void sizingToScrollPane() {
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        if (jScrollPane != null) {
            this.revalidate();
        }
    }

    public void cascadeWindows() {
        JInternalFrame[] jInternalFrameArray = this.getAllNonIconifiedAndNonPaletteFrames();
        if (jInternalFrameArray.length == 0) {
            return;
        }
        this.moveIconsToBack(this.getAllIconifiedFrames());
        this.cascadeReset();
        for (int i2 = jInternalFrameArray.length - 1; i2 >= 0; --i2) {
            this.cascadeFrame(jInternalFrameArray[i2]);
        }
        this.sizingToScrollPane();
    }

    protected Dimension getVisibleSize() {
        Container container = this.getParent();
        if (container != null && container.getParent() instanceof JScrollPane) {
            this.fudge1 = 3;
            this.fudge2 = 1;
            return container.getParent().getSize();
        }
        this.fudge1 = 0;
        this.fudge2 = 0;
        return this.getSize();
    }

    protected void moveIconsToBack(JInternalFrame.JDesktopIcon[] jDesktopIconArray) {
        if (jDesktopIconArray != null) {
            for (int i2 = 0; i2 < jDesktopIconArray.length; ++i2) {
                this.moveToBack(jDesktopIconArray[i2]);
            }
        }
    }

    protected int getIconsHeight(JInternalFrame.JDesktopIcon[] jDesktopIconArray) {
        int n2;
        int n3 = n2 = this.getVisibleSize().height;
        for (int i2 = 0; i2 < jDesktopIconArray.length; ++i2) {
            Point point = jDesktopIconArray[i2].getLocation();
            n3 = Math.min(n3, (int)point.getY());
        }
        return n2 - n3;
    }

    public void tileWindowsHorizontally() {
        int n2;
        JInternalFrame[] jInternalFrameArray = this.getAllNonIconifiedAndNonPaletteFrames();
        int n3 = jInternalFrameArray.length;
        if (n3 == 0) {
            return;
        }
        int n4 = this.getVisibleSize().width - this.fudge1;
        int n5 = this.getVisibleSize().height - this.fudge2;
        JInternalFrame.JDesktopIcon[] jDesktopIconArray = this.getAllIconifiedFrames();
        if (this.considerIconsWhenTiling) {
            this.arrangeIcons();
            n2 = this.getIconsHeight(jDesktopIconArray);
            if (n5 > n2) {
                n5 -= n2;
            }
        }
        this.moveIconsToBack(jDesktopIconArray);
        n2 = n5 / n3;
        int n6 = n5 % n3;
        int n7 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n8;
            int n9 = n8 = i2 < n6 ? n2 + 1 : n2;
            if (jInternalFrameArray[i2].isResizable()) {
                jInternalFrameArray[i2].setBounds(0, n7, n4, n8);
            } else {
                jInternalFrameArray[i2].setLocation(0, n7);
            }
            n7 += n8;
        }
        this.repaint();
        this.sizingToScrollPane();
    }

    public void tileWindowsVertically() {
        int n2;
        JInternalFrame[] jInternalFrameArray = this.getAllNonIconifiedAndNonPaletteFrames();
        int n3 = jInternalFrameArray.length;
        if (n3 == 0) {
            return;
        }
        int n4 = this.getVisibleSize().width - this.fudge2;
        int n5 = this.getVisibleSize().height - this.fudge1;
        JInternalFrame.JDesktopIcon[] jDesktopIconArray = this.getAllIconifiedFrames();
        if (this.considerIconsWhenTiling) {
            this.arrangeIcons();
            n2 = this.getIconsHeight(jDesktopIconArray);
            if (n5 > n2) {
                n5 -= n2;
            }
        }
        this.moveIconsToBack(jDesktopIconArray);
        n2 = n4 / n3;
        int n6 = n4 % n3;
        int n7 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n8;
            int n9 = n8 = i2 < n6 ? n2 + 1 : n2;
            if (jInternalFrameArray[i2].isResizable()) {
                jInternalFrameArray[i2].setBounds(n7, 0, n8, n5);
            } else {
                jInternalFrameArray[i2].setLocation(n7, 0);
            }
            n7 += n8;
        }
        this.sizingToScrollPane();
        this.repaint();
    }

    public void arrangeIcons() {
        JInternalFrame.JDesktopIcon[] jDesktopIconArray = this.getAllIconifiedFrames();
        if (jDesktopIconArray.length == 0) {
            return;
        }
        int n2 = this.getVisibleSize().width;
        int n3 = this.getVisibleSize().height;
        int n4 = 0;
        int n5 = n3;
        int n6 = 0;
        for (int i2 = 0; i2 < jDesktopIconArray.length; ++i2) {
            int n7 = jDesktopIconArray[i2].getWidth();
            int n8 = jDesktopIconArray[i2].getHeight();
            if (n4 + n7 > n2 && n6 > 0) {
                n4 = 0;
                n5 -= n6;
                n6 = 0;
            }
            n6 = Math.max(n6, n8);
            jDesktopIconArray[i2].setBounds(n4, n5 - n8, n7, n8);
            n4 += n7;
        }
        this.repaint();
    }

    protected int getOpenInternalFrameCount() {
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            JInternalFrame jInternalFrame;
            if (!(componentArray[i2] instanceof JInternalFrame) || (jInternalFrame = (JInternalFrame)componentArray[i2]).isClosed() || !jInternalFrame.isVisible() || jInternalFrame.getLayer() == JLayeredPane.PALETTE_LAYER.intValue()) continue;
            ++n2;
        }
        return n2;
    }

    protected int getIconifiedFrameCount() {
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            JInternalFrame.JDesktopIcon jDesktopIcon;
            JInternalFrame jInternalFrame;
            if (!(componentArray[i2] instanceof JInternalFrame.JDesktopIcon) || (jInternalFrame = (jDesktopIcon = (JInternalFrame.JDesktopIcon)componentArray[i2]).getInternalFrame()) == null || !jInternalFrame.isVisible()) continue;
            ++n2;
        }
        return n2;
    }

    protected void selectNextFrame() {
        if (this.activatingFrame != null) {
            return;
        }
        Component[] componentArray = this.getComponents();
        JInternalFrame jInternalFrame = null;
        if (componentArray.length != 0) {
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                JInternalFrame jInternalFrame2;
                if (!(componentArray[i2] instanceof JInternalFrame) || !(jInternalFrame2 = (JInternalFrame)componentArray[i2]).isMaximizable() || !jInternalFrame2.isVisible()) continue;
                jInternalFrame = (JInternalFrame)componentArray[i2];
                break;
            }
        } else {
            this.activateFrame(null);
        }
        if (jInternalFrame != null) {
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            this.setMenuAndToolBarsToRootPane(null, this.menubar, this.toolbar);
        }
    }

    protected void setMenuAndToolBarsToRootPane(JInternalFrame jInternalFrame, JMenuBar jMenuBar, JToolBar jToolBar) {
        if (jMenuBar == null && jToolBar == null) {
            return;
        }
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane == null) {
            return;
        }
        if (jMenuBar != null) {
            this.currentMenuBar = jMenuBar;
            this.updateWindowsMenu();
            this.updateIconsInMenuBar(jInternalFrame);
            jRootPane.setJMenuBar(jMenuBar);
        }
        if (jToolBar != null && jToolBar != this.lastToolBarSetToRoot) {
            Container container;
            Container container2;
            if (this.lastToolBarSetToRoot != null && (container2 = SwingUtilities.getAncestorOfClass(JFrame.class, jRootPane)) == (container = SwingUtilities.getAncestorOfClass(JFrame.class, this.lastToolBarSetToRoot))) {
                this.lastToolBarSetToRoot.getParent().remove(this.lastToolBarSetToRoot);
            }
            jRootPane.getContentPane().add((Component)jToolBar, "North");
            this.lastToolBarSetToRoot = jToolBar;
        }
        jRootPane.invalidate();
        jRootPane.validate();
        jRootPane.repaint();
    }

    public void activateFrame(JInternalFrame jInternalFrame) {
        if (this.activeFrame == jInternalFrame) {
            return;
        }
        this.activatingFrame = jInternalFrame;
        if (jInternalFrame instanceof JCMDIFrame) {
            JCMDIFrame jCMDIFrame = (JCMDIFrame)jInternalFrame;
            this.setMenuAndToolBarsToRootPane(jCMDIFrame, this.getMDIMenuBar(jCMDIFrame), this.getMDIToolBar(jCMDIFrame));
        }
        if (this.maximized) {
            this.updateIconsInMenuBar(jInternalFrame);
        }
        this.updateWindowsMenu();
        this.activeFrame = jInternalFrame;
        this.activatingFrame = null;
    }

    public void deactivateFrame(JInternalFrame jInternalFrame) {
        this.activeFrame = null;
    }

    public void closeFrame(JInternalFrame jInternalFrame) {
        if (jInternalFrame == null) {
            return;
        }
        int n2 = this.getOpenInternalFrameCount();
        if (jInternalFrame != this.maximizedFrame) {
            JInternalFrame jInternalFrame2;
            JInternalFrame jInternalFrame3 = jInternalFrame2 = this.activatingFrame == null ? this.activeFrame : this.activatingFrame;
            if (n2 == 0 && jInternalFrame2 == null) {
                this.checkIfMenuOrToolBarsNeeded();
            }
            return;
        }
        if (n2 < 1) {
            this.maximizeFrame(null);
        } else {
            Component[] componentArray = this.getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (componentArray[i2] == jInternalFrame || !(componentArray[i2] instanceof JInternalFrame)) continue;
                try {
                    JInternalFrame jInternalFrame4 = (JInternalFrame)componentArray[i2];
                    if (!jInternalFrame4.isVisible()) continue;
                    jInternalFrame4.setSelected(true);
                    this.updateIconsInMenuBar(jInternalFrame4);
                    if (!jInternalFrame4.isMaximizable()) break;
                    this.maximizeFrame(jInternalFrame4);
                    break;
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
        this.repaint();
    }

    public void setSelectedIcon(Icon icon) {
        this.selectedIcon = icon;
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setNonSelectedIcon(Icon icon) {
        this.nonSelectedIcon = icon;
    }

    public Icon getNonSelectedIcon() {
        return this.nonSelectedIcon;
    }

    protected static Icon makeImage(String[] stringArray) {
        JCIconCreator jCIconCreator = new JCIconCreator(13, 13);
        jCIconCreator.setColor('g', Color.green);
        jCIconCreator.setColor('l', Color.blue);
        jCIconCreator.setColor('X', Color.lightGray);
        jCIconCreator.setColor('w', Color.white);
        jCIconCreator.setColor('b', Color.black);
        jCIconCreator.setColor('r', new Color(220, 50, 0));
        jCIconCreator.setPixels(stringArray);
        ImageIcon imageIcon = jCIconCreator.getIcon();
        jCIconCreator.clear();
        return imageIcon;
    }

    public class MDIDesktopManager
    implements DesktopManager,
    Serializable {
        protected DesktopManager manager;
        final int INVALID_X = -999;
        private Rectangle rect = new Rectangle(-999, 0, 0, 0);
        boolean dragging = false;

        public MDIDesktopManager(DesktopManager desktopManager) {
            this.setDesktopManager(desktopManager);
        }

        public DesktopManager getDesktopManager() {
            return this.manager;
        }

        public void setDesktopManager(DesktopManager desktopManager) {
            this.manager = desktopManager;
        }

        public void openFrame(JInternalFrame jInternalFrame) {
            this.manager.openFrame(jInternalFrame);
        }

        public void closeFrame(JInternalFrame jInternalFrame) {
            JCMDIPane.this.closeFrame(jInternalFrame);
            this.manager.closeFrame(jInternalFrame);
        }

        public void maximizeFrame(JInternalFrame jInternalFrame) {
        }

        public void minimizeFrame(JInternalFrame jInternalFrame) {
            this.manager.minimizeFrame(jInternalFrame);
        }

        public void iconifyFrame(JInternalFrame jInternalFrame) {
            this.manager.iconifyFrame(jInternalFrame);
        }

        public void deiconifyFrame(JInternalFrame jInternalFrame) {
            this.manager.deiconifyFrame(jInternalFrame);
        }

        public void activateFrame(JInternalFrame jInternalFrame) {
            if (jInternalFrame != null && !jInternalFrame.isVisible()) {
                return;
            }
            JCMDIPane.this.activateFrame(jInternalFrame);
            this.manager.activateFrame(jInternalFrame);
            if (JCMDIPane.this.maximized && jInternalFrame != null && jInternalFrame.isMaximizable() && jInternalFrame != JCMDIPane.this.maximizingFrame) {
                try {
                    jInternalFrame.setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public void deactivateFrame(JInternalFrame jInternalFrame) {
            JCMDIPane.this.deactivateFrame(jInternalFrame);
            this.manager.deactivateFrame(jInternalFrame);
        }

        private void drawRect(boolean bl, JComponent jComponent, int n2, int n3, int n4, int n5) {
            JDesktopPane jDesktopPane;
            if (!bl) {
                this.rect.setBounds(n2, n3, n4, n5);
            } else if (this.rect.x == -999) {
                return;
            }
            if (jComponent instanceof JInternalFrame) {
                jDesktopPane = ((JInternalFrame)jComponent).getDesktopPane();
            } else if (jComponent instanceof JInternalFrame.JDesktopIcon) {
                jDesktopPane = ((JInternalFrame.JDesktopIcon)jComponent).getDesktopPane();
            } else {
                return;
            }
            Graphics graphics = jDesktopPane.getGraphics();
            graphics.setXORMode(jDesktopPane.getBackground());
            graphics.drawRect(this.rect.x, this.rect.y, this.rect.width - 1, this.rect.height - 1);
            graphics.dispose();
        }

        private void setBounds(JComponent jComponent, int n2, int n3, int n4, int n5) {
            this.drawRect(true, jComponent, 0, 0, 0, 0);
            this.drawRect(false, jComponent, n2, n3, n4, n5);
        }

        public void beginDraggingFrame(JComponent jComponent) {
            if (JCMDIPane.this.frameManipulationStyle != 1) {
                this.manager.beginDraggingFrame(jComponent);
            }
        }

        public void dragFrame(JComponent jComponent, int n2, int n3) {
            if (JCMDIPane.this.frameManipulationStyle != 1) {
                this.manager.dragFrame(jComponent, n2, n3);
            } else {
                this.dragging = true;
                this.setBounds(jComponent, n2, n3, jComponent.getWidth(), jComponent.getHeight());
            }
        }

        public void endDraggingFrame(JComponent jComponent) {
            if (JCMDIPane.this.frameManipulationStyle != 1) {
                this.manager.endDraggingFrame(jComponent);
            } else if (this.dragging) {
                this.drawRect(true, jComponent, 0, 0, 0, 0);
                this.dragging = false;
                this.setBoundsForFrame(jComponent, this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            }
            JCMDIPane.this.resizingScrollPane();
        }

        public void beginResizingFrame(JComponent jComponent, int n2) {
            if (JCMDIPane.this.frameManipulationStyle != 1) {
                this.manager.beginResizingFrame(jComponent, n2);
            }
        }

        public void resizeFrame(JComponent jComponent, int n2, int n3, int n4, int n5) {
            if (JCMDIPane.this.frameManipulationStyle != 1) {
                this.manager.resizeFrame(jComponent, n2, n3, n4, n5);
            } else {
                this.dragging = true;
                this.setBounds(jComponent, n2, n3, n4, n5);
            }
        }

        public void endResizingFrame(JComponent jComponent) {
            if (JCMDIPane.this.frameManipulationStyle != 1) {
                this.manager.endResizingFrame(jComponent);
            } else if (this.dragging) {
                this.drawRect(true, jComponent, 0, 0, 0, 0);
                this.dragging = false;
                this.setBoundsForFrame(jComponent, this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            }
        }

        public void setBoundsForFrame(JComponent jComponent, int n2, int n3, int n4, int n5) {
            this.manager.setBoundsForFrame(jComponent, n2, n3, n4, n5);
            this.rect.x = -999;
            if (JCMDIPane.this.frameManipulationStyle == 1) {
                return;
            }
            JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, jComponent);
            if (jScrollPane != null) {
                jComponent.revalidate();
            }
        }
    }

    protected class LayoutListener
    implements ActionListener,
    Serializable {
        protected LayoutListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = JCMDIPane.this.maximizedFrame;
            LayoutButton layoutButton = (LayoutButton)actionEvent.getSource();
            switch (layoutButton.getControlType()) {
                case 3: {
                    int n2;
                    if (jInternalFrame == null || !jInternalFrame.isClosable() || (n2 = jInternalFrame.getDefaultCloseOperation()) == 0) break;
                    try {
                        jInternalFrame.setClosed(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
                case 1: {
                    JCMDIPane.this.unmaximize();
                    break;
                }
                case 2: {
                    JCMDIPane.this.unmaximize();
                    if (jInternalFrame == null || !jInternalFrame.isIconifiable()) break;
                    try {
                        jInternalFrame.setIcon(true);
                        break;
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected class ArrangeAction
    extends JCAction
    implements Serializable {
        public ArrangeAction() {
            super(li.getString("ActionArrange"), li.getMnemonic("ActionArrangeMnemonic"), (KeyStroke)null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCMDIPane.this.arrangeIcons();
        }
    }

    protected class TileVAction
    extends JCAction
    implements Serializable {
        public TileVAction() {
            super(li.getString("ActionTilev"), li.getMnemonic("ActionTilevMnemonic"), (KeyStroke)null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JCMDIPane.this.maximized) {
                JCMDIPane.this.unmaximize();
            }
            JCMDIPane.this.tileWindowsVertically();
        }
    }

    protected class TileHAction
    extends JCAction
    implements Serializable {
        public TileHAction() {
            super(li.getString("ActionTileh"), li.getMnemonic("ActionTilehMnemonic"), (KeyStroke)null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JCMDIPane.this.maximized) {
                JCMDIPane.this.unmaximize();
            }
            JCMDIPane.this.tileWindowsHorizontally();
        }
    }

    protected class CascadeAction
    extends JCAction
    implements Serializable {
        public CascadeAction() {
            super(li.getString("ActionCascade"), li.getMnemonic("ActionCascadeMnemonic"), (KeyStroke)null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JCMDIPane.this.maximized) {
                JCMDIPane.this.unmaximize();
            }
            JCMDIPane.this.cascadeWindows();
        }
    }

    protected class MaxMinAction
    extends JCAction
    implements Serializable {
        public MaxMinAction() {
            super(li.getString("ActionMaximize"), li.getMnemonic("ActionMaximizeMnemonic"), (KeyStroke)null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JCMDIPane.this.maximized) {
                JCMDIPane.this.unmaximize();
            } else if (JCMDIPane.this.activeFrame != null) {
                JCMDIPane.this.maximize(JCMDIPane.this.activeFrame);
            }
        }
    }

    protected class WindowsMenuListener
    implements ActionListener,
    Serializable {
        protected WindowsMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = (JInternalFrame)((UserMenuItem)actionEvent.getSource()).getUserData();
            if (JCMDIPane.this.maximized && jInternalFrame.isMaximizable()) {
                try {
                    jInternalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                JCMDIPane.this.maximizeFrame(jInternalFrame);
            } else {
                if (jInternalFrame.isIcon()) {
                    try {
                        jInternalFrame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                try {
                    jInternalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    protected class FrameListener
    implements InternalFrameListener,
    VetoableChangeListener,
    Serializable {
        protected FrameListener() {
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
            JCMDIPane.this.updateWindowsMenu();
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            JCMDIPane.this.updateWindowsMenu();
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            ((JInternalFrame)internalFrameEvent.getSource()).moveToFront();
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            JInternalFrame jInternalFrame = (JInternalFrame)internalFrameEvent.getSource();
            if (jInternalFrame != null && !jInternalFrame.isVisible()) {
                return;
            }
            JCMDIPane.this.activateFrame(jInternalFrame);
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Object object;
            if (propertyChangeEvent.getPropertyName().equals("maximum") && (object = propertyChangeEvent.getSource()) instanceof JInternalFrame) {
                JCMDIPane.this.maximize((JInternalFrame)object);
                throw new PropertyVetoException("MDI Override", propertyChangeEvent);
            }
        }
    }

    class Listener
    implements ContainerListener,
    Serializable {
        Listener() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            if (containerEvent.getChild() instanceof JInternalFrame) {
                JInternalFrame jInternalFrame = (JInternalFrame)containerEvent.getChild();
                jInternalFrame.addInternalFrameListener(JCMDIPane.this.frameListener);
                jInternalFrame.addVetoableChangeListener(JCMDIPane.this.frameListener);
                DesktopManager desktopManager = jInternalFrame.getDesktopPane().getDesktopManager();
                if (!(desktopManager instanceof MDIDesktopManager)) {
                    jInternalFrame.getDesktopPane().setDesktopManager(new MDIDesktopManager(desktopManager));
                }
                Rectangle rectangle = jInternalFrame.getBounds();
                if (rectangle.x == 0 && rectangle.y == 0 && rectangle.width == 0 && rectangle.height == 0) {
                    JCMDIPane.this.cascadeFrameByPreferredSize(jInternalFrame);
                }
                if (JCMDIPane.this.isDisplayable() && jInternalFrame.isVisible()) {
                    try {
                        jInternalFrame.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
            JCMDIPane.this.updateWindowsMenu();
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            if (containerEvent.getChild() instanceof JInternalFrame) {
                JCMDIPane.this.closeFrame((JInternalFrame)containerEvent.getChild());
                JCMDIPane.this.selectNextFrame();
            }
            JCMDIPane.this.updateWindowsMenu();
        }
    }
}

