/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.ttf;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FontFileReader {
    private int fsize;
    private int current;
    private byte[] file;

    private void init(InputStream inputStream, int n2, int n3) throws IOException {
        this.fsize = 0;
        this.current = 0;
        int n4 = n2;
        this.file = new byte[n2];
        int n5 = inputStream.read(this.file, 0, n2);
        if (n5 > 0) {
            this.fsize += n5;
        }
        while (n5 > 0) {
            if (n5 == n4) {
                byte[] byArray = new byte[this.file.length + n3];
                System.arraycopy(this.file, 0, byArray, 0, this.file.length);
                n4 = n3;
                n5 = inputStream.read(byArray, this.file.length, n4);
                if (n5 > 0) {
                    this.fsize += n5;
                }
                this.file = byArray;
                continue;
            }
            if (n5 >= n4 || (n5 = inputStream.read(this.file, this.fsize, n4 -= n5)) <= 0) continue;
            this.fsize += n5;
        }
    }

    public FontFileReader(String string) throws IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(string);
        this.init(fileInputStream, (int)(file.length() + 1L), (int)(file.length() / 10L));
        fileInputStream.close();
    }

    public FontFileReader(InputStream inputStream) throws IOException {
        this(inputStream, -1);
    }

    public FontFileReader(InputStream inputStream, int n2) throws IOException {
        if (n2 < 0) {
            n2 = 50000;
        }
        this.init(inputStream, n2 + 1, n2 / 10);
    }

    public FontFileReader(byte[] byArray) throws IOException {
        this.file = byArray;
        this.fsize = byArray.length;
        this.current = 0;
    }

    public void seek_set(long l2) throws IOException {
        if (l2 > (long)this.fsize || l2 < 0L) {
            throw new EOFException("Reached EOF, file size=" + this.fsize + " offset=" + l2);
        }
        this.current = (int)l2;
    }

    public void seek_add(long l2) throws IOException {
        this.seek_set((long)this.current + l2);
    }

    public void skip(long l2) throws IOException {
        this.seek_add(l2);
    }

    public int getCurrentPos() {
        return this.current;
    }

    public int getFileSize() {
        return this.fsize;
    }

    public byte read() throws IOException {
        if (this.current > this.fsize) {
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte by = this.file[this.current++];
        return by;
    }

    public final byte readTTFByte() throws IOException {
        return this.read();
    }

    public final int readTTFUByte() throws IOException {
        byte by = this.read();
        if (by < 0) {
            return 256 + by;
        }
        return by;
    }

    public final short readTTFShort() throws IOException {
        int n2 = (this.readTTFUByte() << 8) + this.readTTFUByte();
        short s = (short)n2;
        return s;
    }

    public final int readTTFUShort() throws IOException {
        int n2 = (this.readTTFUByte() << 8) + this.readTTFUByte();
        return n2;
    }

    public final void writeTTFUShort(int n2, int n3) throws IOException {
        if (n2 + 2 > this.fsize) {
            throw new EOFException("Reached EOF");
        }
        byte by = (byte)(n3 >> 8 & 0xFF);
        byte by2 = (byte)(n3 & 0xFF);
        this.file[n2] = by;
        this.file[n2 + 1] = by2;
    }

    public final short readTTFShort(long l2) throws IOException {
        long l3 = this.getCurrentPos();
        this.seek_set(l2);
        short s = this.readTTFShort();
        this.seek_set(l3);
        return s;
    }

    public final int readTTFUShort(long l2) throws IOException {
        long l3 = this.getCurrentPos();
        this.seek_set(l2);
        int n2 = this.readTTFUShort();
        this.seek_set(l3);
        return n2;
    }

    public final int readTTFLong() throws IOException {
        long l2 = this.readTTFUByte();
        l2 = (l2 << 8) + (long)this.readTTFUByte();
        l2 = (l2 << 8) + (long)this.readTTFUByte();
        l2 = (l2 << 8) + (long)this.readTTFUByte();
        return (int)l2;
    }

    public final long readTTFULong() throws IOException {
        long l2 = this.readTTFUByte();
        l2 = (l2 << 8) + (long)this.readTTFUByte();
        l2 = (l2 << 8) + (long)this.readTTFUByte();
        l2 = (l2 << 8) + (long)this.readTTFUByte();
        return l2;
    }

    public final double readTTFFixedDecimal() throws IOException {
        short s = this.readTTFShort();
        int n2 = this.readTTFUShort();
        double d2 = (double)s + (double)n2 / 65536.0;
        return d2;
    }

    public final String readTTFString() throws IOException {
        return this.readTTFString("ISO-8859-1");
    }

    public final String readTTFString(String string) throws IOException {
        int n2 = this.current;
        while (this.file[n2++] != 0) {
            if (n2 <= this.fsize) continue;
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte[] byArray = new byte[n2 - this.current];
        System.arraycopy(this.file, this.current, byArray, 0, n2 - this.current);
        return new String(byArray, string);
    }

    public final String readTTFString(int n2) throws IOException {
        return this.readTTFString(n2, "ISO-8859-1");
    }

    public final String readTTFString(int n2, String string) throws IOException {
        if (n2 + this.current > this.fsize) {
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.file, this.current, byArray, 0, n2);
        this.current += n2;
        return new String(byArray, string);
    }

    public byte[] readBytes(int n2) throws IOException {
        if (this.current + n2 > this.fsize) {
            throw new IOException("Reached EOF");
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.file, this.current, byArray, 0, n2);
        this.current += n2;
        return byArray;
    }

    public byte[] getBytes(int n2, int n3) throws IOException {
        if (n2 + n3 > this.fsize) {
            throw new IOException("Reached EOF");
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.file, n2, byArray, 0, n3);
        return byArray;
    }
}

