/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.render;

import com.klg.jclass.page.JCDrawStyle;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.render.Render;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;

public class LineRender
extends Render
implements Cloneable {
    protected JCUnit.Point[] points;
    protected JCDrawStyle style;
    protected boolean fill;

    public LineRender() {
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS);
        this.origin = new JCUnit.Point(JCUnit.POINTS);
        this.points = null;
        this.style = null;
    }

    public LineRender(JCUnit.Point point, JCUnit.Point point2, JCDrawStyle jCDrawStyle) {
        JCUnit.Point[] pointArray = new JCUnit.Point[2];
        this.style = jCDrawStyle;
        pointArray[0] = point;
        pointArray[1] = point2;
        this.setPoints(pointArray);
    }

    public LineRender(JCUnit.Point[] pointArray, JCDrawStyle jCDrawStyle) {
        this.style = jCDrawStyle;
        this.setPoints(pointArray);
    }

    public JCUnit.Point[] getPoints() {
        return this.points;
    }

    public void setPoints(JCUnit.Point[] pointArray) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 100000.0;
        double d5 = 100000.0;
        this.points = new JCUnit.Point[pointArray.length];
        for (int i2 = 0; i2 < pointArray.length; ++i2) {
            JCUnit.Point point = pointArray[i2];
            double d6 = point.xInt();
            double d7 = point.yInt();
            if (d6 < d5) {
                d5 = d6;
            }
            if (d7 < d4) {
                d4 = d7;
            }
            if (d6 < d3) {
                d3 = d6;
            }
            if (d7 < d2) {
                d2 = d7;
            }
            this.points[i2] = (JCUnit.Point)point.clone();
        }
        this.origin = new JCUnit.Point(JCUnit.INTERNAL, d5, d4);
        this.bounds = new JCUnit.Dimension(JCUnit.INTERNAL, d3 - d5, d2 - d4);
    }

    public JCDrawStyle getStyle() {
        return this.style;
    }

    public void setStyle(JCDrawStyle jCDrawStyle) {
        this.style = jCDrawStyle;
    }

    public boolean isFilled() {
        return this.fill;
    }

    public void setFilled(boolean bl) {
        this.fill = bl;
    }

    public boolean isAtomic() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(Graphics2D graphics2D) {
        BasicStroke basicStroke;
        block14: {
            Color color;
            if (this.fill) {
                color = this.style.getFillForegroundColor();
                if (color == null) {
                    color = this.style.getForegroundColor();
                }
            } else {
                color = this.style.getForegroundColor();
            }
            if (color == null) {
                return;
            }
            graphics2D.setColor(color);
            double d2 = this.style.getLineWidth().getAs(JCUnit.POINTS);
            int n2 = this.style.getLineType();
            if (n2 == 3) {
                float[] fArray = new float[2];
                double d3 = this.style.getDashLength().getAs(JCUnit.POINTS);
                fArray[0] = (float)d3;
                fArray[1] = (float)d3;
                basicStroke = new BasicStroke((float)d2, 0, 0, 10.0f, fArray, 0.0f);
            } else {
                if (n2 == 4) {
                    double d4 = this.style.getLineSpacing().getAs(JCUnit.POINTS);
                    if (this.points.length != 2 || !this.points[0].getX().equals(this.points[1].getX()) && !this.points[0].getY().equals(this.points[1].getY())) {
                        d2 = d2 * 2.0 + d4;
                        basicStroke = new BasicStroke((float)d2, 0, 0);
                        break block14;
                    } else {
                        double d5;
                        double d6;
                        if (this.points[0].getY().equals(this.points[1].getY())) {
                            d6 = 0.0;
                            d5 = (d4 + d2) / 2.0;
                        } else {
                            d6 = (d4 + d2) / 2.0;
                            d5 = 0.0;
                        }
                        double d7 = JCUnit.getAsPoints(this.points[0].units, this.points[0].x);
                        double d8 = JCUnit.getAsPoints(this.points[0].units, this.points[0].y);
                        double d9 = JCUnit.getAsPoints(this.points[1].units, this.points[1].x);
                        double d10 = JCUnit.getAsPoints(this.points[1].units, this.points[1].y);
                        BasicStroke basicStroke2 = new BasicStroke((float)d2, 0, 0);
                        graphics2D.setStroke(basicStroke2);
                        GeneralPath generalPath = new GeneralPath(this.style.getFillRule(), 2);
                        generalPath.moveTo((float)(d7 + d6), (float)(d8 + d5));
                        generalPath.lineTo((float)(d9 + d6), (float)(d10 + d5));
                        graphics2D.draw(generalPath);
                        generalPath.reset();
                        generalPath.moveTo((float)(d7 - d6), (float)(d8 - d5));
                        generalPath.lineTo((float)(d9 - d6), (float)(d10 - d5));
                        graphics2D.draw(generalPath);
                        return;
                    }
                }
                if (n2 != 2) {
                    if (n2 != 2) return;
                }
                basicStroke = new BasicStroke((float)d2, 0, 0);
            }
        }
        GeneralPath generalPath = new GeneralPath(this.style.getFillRule(), this.points.length);
        generalPath.moveTo((float)JCUnit.getAsPoints(this.points[0].units, this.points[0].x), (float)JCUnit.getAsPoints(this.points[0].units, this.points[0].y));
        for (int i2 = 1; i2 < this.points.length; ++i2) {
            generalPath.lineTo((float)JCUnit.getAsPoints(this.points[i2].units, this.points[i2].x), (float)JCUnit.getAsPoints(this.points[i2].units, this.points[i2].y));
        }
        if (this.fill) {
            graphics2D.fill(generalPath);
            return;
        }
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(generalPath);
    }

    public Object clone() {
        LineRender lineRender = (LineRender)super.clone();
        lineRender.points = new JCUnit.Point[this.points.length];
        System.arraycopy(this.points, 0, lineRender.points, 0, this.points.length);
        return lineRender;
    }
}

