/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.render;

import com.klg.jclass.page.JCDrawStyle;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.render.Render;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;

public class ArcRender
extends Render
implements Cloneable {
    protected JCUnit.Point center;
    protected JCUnit.Measure radius;
    protected double theta1;
    protected double theta2;
    protected JCDrawStyle style;
    protected boolean fill;

    public ArcRender() {
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS);
        this.origin = new JCUnit.Point(JCUnit.POINTS);
        this.radius = new JCUnit.Measure(JCUnit.POINTS);
        this.center = new JCUnit.Point(JCUnit.POINTS);
        this.theta1 = 0.0;
        this.theta2 = 360.0;
        this.style = null;
    }

    public ArcRender(JCUnit.Point point, JCUnit.Measure measure, double d2, double d3, JCDrawStyle jCDrawStyle) {
        this.center = (JCUnit.Point)point.clone();
        this.radius = (JCUnit.Measure)measure.clone();
        this.theta1 = d2;
        this.theta2 = d3;
        this.style = jCDrawStyle;
        JCUnit.Measure measure2 = point.getX();
        measure2.subtract(measure);
        JCUnit.Measure measure3 = point.getY();
        measure3.subtract(measure);
        this.origin = new JCUnit.Point(measure2.units, measure2.distance, measure3.distance);
        measure2.assign(measure);
        measure2.multiply(2.0);
        this.bounds = new JCUnit.Dimension(measure2.units, measure2.distance, measure2.distance);
    }

    public JCUnit.Point getCenter() {
        return this.center;
    }

    public void setCenter(JCUnit.Point point) {
        this.center = point;
        JCUnit.Measure measure = this.center.getX();
        measure.subtract(this.radius);
        JCUnit.Measure measure2 = this.center.getY();
        measure2.subtract(this.radius);
        this.origin.setX(measure);
        this.origin.setY(measure2);
    }

    public JCUnit.Measure getRadius() {
        return this.radius;
    }

    public void setRadius(JCUnit.Measure measure) {
        this.radius.assign(measure);
        JCUnit.Measure measure2 = this.center.getX();
        measure2.subtract(measure);
        JCUnit.Measure measure3 = this.center.getY();
        measure3.subtract(measure);
        this.origin.setX(measure2);
        this.origin.setY(measure3);
        measure2.assign(measure);
        measure2.multiply(2.0);
        this.bounds.setWidth(measure2);
        this.bounds.setHeight(measure2);
    }

    public double getStartAngle() {
        return this.theta1;
    }

    public void setStartAngle(double d2) {
        this.theta1 = d2;
    }

    public double getEndAngle() {
        return this.theta1;
    }

    public void setEndAngle(double d2) {
        this.theta2 = d2;
    }

    public JCDrawStyle getStyle() {
        return this.style;
    }

    public void setStyle(JCDrawStyle jCDrawStyle) {
        this.style = jCDrawStyle;
    }

    public boolean isFilled() {
        return this.fill;
    }

    public void setFilled(boolean bl) {
        this.fill = bl;
    }

    public boolean isAtomic() {
        return true;
    }

    public void draw(Graphics2D graphics2D) {
        BasicStroke basicStroke;
        Color color;
        if (this.fill) {
            color = this.style.getFillForegroundColor();
            if (color == null) {
                color = this.style.getForegroundColor();
            }
        } else {
            color = this.style.getForegroundColor();
        }
        if (color == null) {
            return;
        }
        graphics2D.setColor(color);
        double d2 = this.style.getLineWidth().getAs(JCUnit.POINTS);
        int n2 = this.style.getLineType();
        if (n2 == 3) {
            float[] fArray = new float[2];
            double d3 = this.style.getDashLength().getAs(JCUnit.POINTS);
            fArray[0] = (float)d3;
            fArray[1] = (float)d3;
            basicStroke = new BasicStroke((float)d2, 2, 0, 10.0f, fArray, 0.0f);
        } else if (n2 == 4) {
            double d4 = this.style.getLineSpacing().getAs(JCUnit.POINTS);
            d2 = d2 * 2.0 + d4;
            basicStroke = new BasicStroke((float)d2, 2, 0);
        } else if (n2 == 2 || n2 == 2) {
            basicStroke = this.theta2 >= 360.0 ? new BasicStroke((float)d2, 0, 0) : new BasicStroke((float)d2, 2, 0);
        } else {
            return;
        }
        graphics2D.setStroke(basicStroke);
        int n3 = (int)JCUnit.getAsPoints(this.origin.units, this.origin.x);
        int n4 = (int)JCUnit.getAsPoints(this.origin.units, this.origin.y);
        int n5 = (int)JCUnit.getAsPoints(this.bounds.units, this.bounds.width);
        int n6 = (int)JCUnit.getAsPoints(this.bounds.units, this.bounds.height);
        if (this.fill) {
            graphics2D.fillArc(n3, n4, n5, n6, (int)this.theta1, (int)this.theta2);
        } else {
            graphics2D.drawArc(n3, n4, n5, n6, (int)this.theta1, (int)this.theta2);
        }
    }

    public Object clone() {
        ArcRender arcRender = (ArcRender)super.clone();
        arcRender.radius = (JCUnit.Measure)this.radius.clone();
        arcRender.center = (JCUnit.Point)this.center.clone();
        return arcRender;
    }
}

