/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.adobe.postscript;

import com.klg.jclass.page.FontParser;
import com.klg.jclass.page.adobe.postscript.CharMetricPS;
import com.klg.jclass.page.adobe.postscript.CompCharPS;
import com.klg.jclass.page.adobe.postscript.CompPiecePS;
import com.klg.jclass.page.adobe.postscript.FontPS;
import com.klg.jclass.page.adobe.postscript.LigaturePS;
import com.klg.jclass.page.adobe.postscript.PairKern;
import com.klg.jclass.page.adobe.postscript.TrackKern;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class AFMParser
implements FontParser {
    public static final int ASCENDER = 0;
    public static final int CHARBBOX = 1;
    public static final int CODE = 2;
    public static final int COMPCHAR = 3;
    public static final int CAPHEIGHT = 4;
    public static final int COMMENT = 5;
    public static final int DESCENDER = 6;
    public static final int ENCODINGSCHEME = 7;
    public static final int ENDCHARMETRICS = 8;
    public static final int ENDCOMPOSITES = 9;
    public static final int ENDFONTMETRICS = 10;
    public static final int ENDKERNDATA = 11;
    public static final int ENDKERNPAIRS = 12;
    public static final int ENDTRACKKERN = 13;
    public static final int FAMILYNAME = 14;
    public static final int FONTBBOX = 15;
    public static final int FONTNAME = 16;
    public static final int FULLNAME = 17;
    public static final int ISFIXEDPITCH = 18;
    public static final int ITALICANGLE = 19;
    public static final int KERNPAIR = 20;
    public static final int KERNPAIRXAMT = 21;
    public static final int LIGATURE = 22;
    public static final int CHARNAME = 23;
    public static final int NOTICE = 24;
    public static final int COMPCHARPIECE = 25;
    public static final int STARTCHARMETRICS = 26;
    public static final int STARTCOMPOSITES = 27;
    public static final int STARTFONTMETRICS = 28;
    public static final int STARTKERNDATA = 29;
    public static final int STARTKERNPAIRS = 30;
    public static final int STARTTRACKKERN = 31;
    public static final int STDHW = 32;
    public static final int STDVW = 33;
    public static final int TRACKKERN = 34;
    public static final int UNDERLINEPOSITION = 35;
    public static final int UNDERLINETHICKNESS = 36;
    public static final int VERSION = 37;
    public static final int XYWIDTH = 38;
    public static final int XWIDTH = 39;
    public static final int WEIGHT = 40;
    public static final int XHEIGHT = 41;
    public static final int NOPE = 42;
    public static String[] keyStrings = new String[]{"Ascender", "B", "C", "CC", "CapHeight", "Comment", "Descender", "EncodingScheme", "EndCharMetrics", "EndComposites", "EndFontMetrics", "EndKernData", "EndKernPairs", "EndTrackKern", "FamilyName", "FontBBox", "FontName", "FullName", "IsFixedPitch", "ItalicAngle", "KP", "KPX", "L", "N", "Notice", "PCC", "StartCharMetrics", "StartComposites", "StartFontMetrics", "StartKernData", "StartKernPairs", "StartTrackKern", "StdHW", "StdVW", "TrackKern", "UnderlinePosition", "UnderlineThickness", "Version", "W", "WX", "Weight", "XHeight", null};
    protected String currentLine;
    protected static final int EOF = -1;
    protected static final int NOT_FOUND = -1;
    protected BufferedReader reader;
    protected String DELIMITERS = "    ;";
    protected StringTokenizer tokenizer = new StringTokenizer("", this.DELIMITERS);

    public AFMParser() {
    }

    public AFMParser(String string) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.parse(fileInputStream);
        fileInputStream.close();
    }

    public Vector parse(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("parse(): Input stream is null");
        }
        this.reader = new BufferedReader(new InputStreamReader(inputStream, "ASCII"));
        FontPS fontPS = new FontPS("uninitialized", 0, 1);
        boolean bl = true;
        this.parseGlobals(fontPS);
        this.parseCharMetrics(fontPS);
        block8: while (bl) {
            String string = this.token();
            if (string == null) {
                bl = false;
                break;
            }
            switch (this.recognize(string)) {
                case 29: {
                    continue block8;
                }
                case 11: {
                    continue block8;
                }
                case 31: {
                    this.parseTrackKernData(fontPS);
                    continue block8;
                }
                case 30: {
                    this.parsePairKernData(fontPS);
                    continue block8;
                }
                case 27: {
                    this.parseCompCharData();
                    continue block8;
                }
                case 10: {
                    bl = false;
                    continue block8;
                }
            }
        }
        Vector<FontPS> vector = new Vector<FontPS>(1);
        vector.addElement(fontPS);
        return vector;
    }

    protected String token() throws IOException {
        String string = null;
        if (this.tokenizer != null && this.reader != null) {
            if (this.tokenizer.hasMoreTokens()) {
                string = this.tokenizer.nextToken();
            } else {
                this.getLine();
                if (this.tokenizer.hasMoreTokens()) {
                    string = this.tokenizer.nextToken();
                } else if (this.currentLine != null) {
                    string = "";
                }
            }
        }
        return string;
    }

    protected String getLine() throws IOException {
        String string = "";
        while (this.tokenizer.hasMoreTokens()) {
            string = string + this.tokenizer.nextToken() + " ";
        }
        if (this.tokenizer != null && this.reader != null) {
            this.currentLine = this.reader.readLine();
            if (this.currentLine != null) {
                this.tokenizer = new StringTokenizer(this.currentLine, this.DELIMITERS);
            }
        }
        return string.trim();
    }

    protected void parseCompCharData() throws IOException {
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        CompCharPS compCharPS = null;
        int n4 = this.atoi(this.token());
        block7: while (bl) {
            String string = this.token();
            if (string == null) {
                throw new RuntimeException("");
            }
            if (n2 > n4) {
                throw new RuntimeException("");
            }
            switch (this.recognize(string)) {
                case 5: {
                    string = this.getLine();
                    continue block7;
                }
                case 3: {
                    if (n2 < n4) {
                        if (n2 > 0 && n3 != compCharPS.numPieces) {
                            throw new RuntimeException("");
                        }
                        n3 = 0;
                        compCharPS = new CompCharPS();
                        compCharPS.name = this.token();
                        compCharPS.numPieces = this.atoi(this.token());
                        compCharPS.pieces = new CompPiecePS[compCharPS.numPieces];
                        ++n2;
                        continue block7;
                    }
                    throw new RuntimeException("");
                }
                case 25: {
                    if (n3 < compCharPS.numPieces) {
                        CompPiecePS compPiecePS = new CompPiecePS();
                        compPiecePS.name = this.token();
                        compPiecePS.deltaX = this.atoi(this.token());
                        compPiecePS.deltaY = this.atoi(this.token());
                        compCharPS.pieces[n3] = compPiecePS;
                        ++n3;
                        continue block7;
                    }
                    throw new RuntimeException("");
                }
                case 9: {
                    bl = false;
                    continue block7;
                }
                case 10: {
                    bl = false;
                    continue block7;
                }
            }
        }
    }

    protected void parsePairKernData(FontPS fontPS) throws IOException {
        int n2 = 0;
        boolean bl = true;
        int n3 = this.atoi(this.token());
        block7: while (bl) {
            String string = this.token();
            if (string == null) {
                // empty if block
            }
            switch (this.recognize(string)) {
                case 5: {
                    this.getLine();
                    continue block7;
                }
                case 20: {
                    CharMetricPS charMetricPS;
                    PairKern pairKern;
                    if (n2 < n3) {
                        pairKern = new PairKern();
                        pairKern.name1 = this.token();
                        pairKern.name2 = this.token();
                        pairKern.xAmount = this.atoi(this.token());
                        pairKern.yAmount = this.atoi(this.token());
                        ++n2;
                        charMetricPS = fontPS.getCharByName(pairKern.name1);
                        charMetricPS.getKernPairs().put(pairKern.name2, pairKern);
                        continue block7;
                    }
                    throw new RuntimeException("");
                }
                case 21: {
                    CharMetricPS charMetricPS;
                    PairKern pairKern;
                    if (n2 < n3) {
                        pairKern = new PairKern();
                        pairKern.name1 = this.token();
                        pairKern.name2 = this.token();
                        pairKern.xAmount = this.atoi(this.token());
                        pairKern.yAmount = 0;
                        ++n2;
                        charMetricPS = fontPS.getCharByName(pairKern.name1);
                        charMetricPS.getKernPairs().put(pairKern.name2, pairKern);
                        continue block7;
                    }
                    throw new RuntimeException("");
                }
                case 11: 
                case 12: {
                    bl = false;
                    continue block7;
                }
                case 10: {
                    bl = false;
                    continue block7;
                }
            }
        }
    }

    protected void parseTrackKernData(FontPS fontPS) throws IOException {
        String string;
        boolean bl = true;
        int n2 = 0;
        int n3 = this.atoi(this.token());
        block6: while (bl && (string = this.token()) != null) {
            switch (this.recognize(string)) {
                case 5: {
                    this.getLine();
                    continue block6;
                }
                case 34: {
                    if (n2 < n3) {
                        TrackKern trackKern = new TrackKern();
                        trackKern.degree = this.atoi(this.token());
                        trackKern.minPtSize = this.atof(this.token());
                        trackKern.minKernAmount = this.atof(this.token());
                        trackKern.maxPtSize = this.atof(this.token());
                        trackKern.maxKernAmount = this.atof(this.token());
                        fontPS.getTrackKerning().put(new Integer(trackKern.degree), trackKern);
                        ++n2;
                        continue block6;
                    }
                    bl = false;
                    continue block6;
                }
                case 11: 
                case 13: {
                    bl = false;
                    continue block6;
                }
                case 10: {
                    bl = false;
                    continue block6;
                }
            }
        }
    }

    protected void parseCharMetrics(FontPS fontPS) throws IOException {
        String string;
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        int n4 = this.atoi(this.token());
        fontPS.charMetricList = new CharMetricPS[n4];
        CharMetricPS charMetricPS = null;
        block11: while (bl && (string = this.token()) != null) {
            switch (this.recognize(string)) {
                case 5: {
                    this.getLine();
                    continue block11;
                }
                case 2: {
                    if (n2 < n4) {
                        charMetricPS = new CharMetricPS();
                        charMetricPS.setWx(0);
                        charMetricPS.setWy(0);
                        charMetricPS.getCharBBox().llx = 0;
                        charMetricPS.getCharBBox().lly = 0;
                        charMetricPS.getCharBBox().urx = 0;
                        charMetricPS.getCharBBox().ury = 0;
                        charMetricPS.setCode(this.atoi(this.token()));
                        ++n2;
                        continue block11;
                    }
                    bl = false;
                    continue block11;
                }
                case 38: {
                    charMetricPS.setWx(this.atoi(this.token()));
                    charMetricPS.setWy(this.atoi(this.token()));
                    continue block11;
                }
                case 39: {
                    charMetricPS.setWx(this.atoi(this.token()));
                    continue block11;
                }
                case 23: {
                    charMetricPS.setName(this.token());
                    fontPS.getCharMetrics().put(charMetricPS.getName(), charMetricPS);
                    fontPS.charMetricList[n3++] = charMetricPS;
                    continue block11;
                }
                case 1: {
                    charMetricPS.getCharBBox().llx = this.atoi(this.token());
                    charMetricPS.getCharBBox().lly = this.atoi(this.token());
                    charMetricPS.getCharBBox().urx = this.atoi(this.token());
                    charMetricPS.getCharBBox().ury = this.atoi(this.token());
                    continue block11;
                }
                case 22: {
                    LigaturePS ligaturePS = new LigaturePS();
                    ligaturePS.setSuccessor(this.token());
                    ligaturePS.setLigature(this.token());
                    charMetricPS.getLigatures().put(ligaturePS.getLigature(), ligaturePS.getLigature());
                    continue block11;
                }
                case 8: {
                    bl = false;
                    continue block11;
                }
                case 10: {
                    bl = false;
                    continue block11;
                }
            }
        }
    }

    protected void parseGlobals(FontPS fontPS) throws IOException {
        String string;
        boolean bl = true;
        block24: while (bl && (string = this.token()) != null) {
            switch (this.recognize(string)) {
                case 28: {
                    fontPS.setAfmVersion(this.token());
                    continue block24;
                }
                case 5: {
                    this.getLine();
                    continue block24;
                }
                case 16: {
                    fontPS.setFontName(this.token());
                    continue block24;
                }
                case 7: {
                    fontPS.setEncodingScheme(this.token());
                    continue block24;
                }
                case 17: {
                    fontPS.setFullName(this.getLine());
                    continue block24;
                }
                case 14: {
                    fontPS.setFamilyName(this.getLine());
                    continue block24;
                }
                case 40: {
                    fontPS.setWeight(this.token());
                    continue block24;
                }
                case 19: {
                    fontPS.setItalicAngle(Float.valueOf(this.token()).floatValue());
                    continue block24;
                }
                case 18: {
                    if (this.token().equals("false")) {
                        fontPS.setFixedPitch(false);
                        continue block24;
                    }
                    fontPS.setFixedPitch(true);
                    continue block24;
                }
                case 35: {
                    fontPS.setUnderlinePosition(this.atoi(this.token()));
                    continue block24;
                }
                case 36: {
                    fontPS.setUnderlineThickness(this.atoi(this.token()));
                    continue block24;
                }
                case 37: {
                    fontPS.setVersion(this.token());
                    continue block24;
                }
                case 24: {
                    fontPS.setNotice(this.getLine());
                    continue block24;
                }
                case 15: {
                    fontPS.getFontBBox().llx = this.atoi(this.token());
                    fontPS.getFontBBox().lly = this.atoi(this.token());
                    fontPS.getFontBBox().urx = this.atoi(this.token());
                    fontPS.getFontBBox().ury = this.atoi(this.token());
                    continue block24;
                }
                case 4: {
                    fontPS.setCapHeight(this.atoi(this.token()));
                    continue block24;
                }
                case 41: {
                    fontPS.setXHeight(this.atoi(this.token()));
                    continue block24;
                }
                case 6: {
                    fontPS.setDescender(this.atoi(this.token()));
                    continue block24;
                }
                case 0: {
                    fontPS.setAscender(this.atoi(this.token()));
                    continue block24;
                }
                case 32: {
                    fontPS.setStdHW(this.atoi(this.token()));
                    continue block24;
                }
                case 33: {
                    fontPS.setStdVW(this.atoi(this.token()));
                    continue block24;
                }
                case 26: {
                    bl = false;
                    continue block24;
                }
                case 10: {
                    bl = false;
                    continue block24;
                }
            }
            this.getLine();
        }
    }

    protected int atoi(String string) {
        return Integer.valueOf(string);
    }

    protected float atof(String string) {
        return Float.valueOf(string).floatValue();
    }

    protected int recognize(String string) {
        int n2 = 0;
        int n3 = 42;
        int n4 = 0;
        boolean bl = false;
        while (n3 >= n2 && !bl && keyStrings[n4 = (n2 + n3) / 2] != null) {
            int n5 = string.compareTo(keyStrings[n4]);
            if (n5 == 0) {
                bl = true;
                continue;
            }
            if (n5 < 0) {
                n3 = n4 - 1;
                continue;
            }
            n2 = n4 + 1;
        }
        if (bl) {
            return n4;
        }
        return 42;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            try {
                new AFMParser(stringArray[0]);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        } else {
            System.out.println("Usage: AFMParser <fileName>");
        }
        System.exit(0);
    }
}

