/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.JCUnit;

public class JCTab
implements Cloneable {
    protected JCUnit.Measure position;
    protected int tabAlignment;
    protected int tabFill;
    public static final int TAB_ALIGNMENT_LEFT = 1;
    public static final int TAB_ALIGNMENT_RIGHT = 2;
    public static final int TAB_ALIGNMENT_CENTER = 3;
    public static final int TAB_ALIGNMENT_DECIMAL = 4;
    public static final int TAB_FILL_NONE = 1;
    public static final int TAB_FILL_UNDERLINE = 2;
    public static final int TAB_FILL_DOTS = 3;

    public JCTab() {
        this(new JCUnit.Measure(), 1);
    }

    public JCTab(JCUnit.Measure measure) {
        this(measure, 1);
    }

    public JCTab(JCUnit.Measure measure, int n2) {
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Tab position must be >= 0");
        }
        this.position = (JCUnit.Measure)measure.clone();
        this.tabAlignment = n2;
        this.tabFill = 1;
    }

    public JCUnit.Measure getPosition() {
        return this.position;
    }

    public void setPosition(JCUnit.Measure measure) {
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Tab position must be >= 0");
        }
        this.position = measure;
    }

    public int getTabAlignment() {
        return this.tabAlignment;
    }

    public void setTabAlignment(int n2) {
        if (n2 <= 0 || n2 > 4) {
            throw new IllegalArgumentException("Unknown tab alignment");
        }
        this.tabAlignment = n2;
    }

    public int getTabFill() {
        return this.tabFill;
    }

    public void setTabFill(int n2) {
        if (n2 <= 0 || n2 > 3) {
            throw new IllegalArgumentException("Unknown tab fill type");
        }
        this.tabFill = n2;
    }

    public int comparePosition(JCTab jCTab) {
        double d2 = this.position.internal() - jCTab.position.internal();
        if (d2 < 0.0) {
            return -1;
        }
        if (d2 > 0.0) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JCTab)) {
            return false;
        }
        JCTab jCTab = (JCTab)object;
        if (this.tabAlignment != jCTab.tabAlignment) {
            return false;
        }
        if (this.tabFill != jCTab.tabFill) {
            return false;
        }
        return !(this.position != null ? !this.position.equals(jCTab.position) : jCTab.position != null);
    }

    public int hashCode() {
        int n2 = this.position != null ? this.position.hashCode() : 0;
        n2 = 29 * n2 + this.tabAlignment;
        n2 = 29 * n2 + this.tabFill;
        return n2;
    }

    public Object clone() {
        JCTab jCTab;
        try {
            jCTab = (JCTab)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        jCTab.position = (JCUnit.Measure)this.position.clone();
        return jCTab;
    }
}

