/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.FontLibrary;
import com.klg.jclass.page.JCFlow;
import com.klg.jclass.page.JCFrame;
import com.klg.jclass.page.JCPage;
import com.klg.jclass.page.JCPageTable;
import com.klg.jclass.page.JCPrinter;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.awt.JCAWTPrinter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;

public class JCDocument {
    protected String name = null;
    protected JCPrinter printer = null;
    protected List templatePages;
    protected List pageList;
    protected int pageCount = 0;
    protected List tableList;
    protected JCFlow flow;
    protected int flushPolicy;
    protected int outputPolicy;
    protected int startPage = 1;
    protected int lastPage;
    public static final int FLUSH_POLICY_ALWAYS_SAVE = 1;
    public static final int FLUSH_POLICY_ON_OUTPUT = 2;
    public static final int OUTPUT_POLICY_ON_REQUEST = 1;
    public static final int OUTPUT_POLICY_IMMEDIATE = 2;
    public static final List BLANK_8p5X11 = new BlankTemplate(JCUnit.INCHES, 8.5, 11.0, 0.75);
    public static final List BLANK_8p5X14 = new BlankTemplate(JCUnit.INCHES, 8.5, 14.0, 0.75);
    public static final List BLANK_11X17 = new BlankTemplate(JCUnit.INCHES, 11.0, 17.0, 0.75);
    public static final List BLANK_A3 = new BlankTemplate(JCUnit.CM, 29.7, 42.0, 1.5);
    public static final List BLANK_A4 = new BlankTemplate(JCUnit.CM, 21.0, 29.7, 1.5);
    public static final List BLANK_A5 = new BlankTemplate(JCUnit.CM, 14.8, 21.0, 1.5);
    public static final List BLANK_11X8p5 = new BlankTemplate(JCUnit.INCHES, 11.0, 8.5, 0.75);

    public JCDocument(String string) {
        this(string, null, null);
    }

    public JCDocument(JCPrinter jCPrinter) {
        this(null, jCPrinter, null);
    }

    public JCDocument(JCPrinter jCPrinter, List list) {
        this(null, jCPrinter, list);
    }

    public JCDocument(List list) {
        this(null, null, list);
    }

    private JCDocument(String string, JCPrinter jCPrinter, List list) {
        if (string != null) {
            this.name = new String(string);
        }
        this.pageList = new Vector();
        this.pageCount = 0;
        this.flushPolicy = 1;
        this.outputPolicy = 1;
        if (list != null) {
            this.setTemplates(list);
        } else {
            this.templatePages = new ArrayList();
        }
        this.tableList = new Vector();
        this.flow = null;
        this.printer = jCPrinter;
    }

    public String getName() {
        return this.name;
    }

    public JCPrinter getPrinter() {
        return this.printer;
    }

    public void setPrinter(JCPrinter jCPrinter) {
        this.printer = jCPrinter;
    }

    public Graphics getPrinterGraphics() {
        return this.printer.getGraphics();
    }

    public List getTemplates() {
        return this.templatePages;
    }

    public void setTemplates(List list) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("templates list may not be null");
        }
        this.templatePages = list;
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                JCPage jCPage = (JCPage)list.get(i2);
                jCPage.setDocument(this);
            }
        }
    }

    public void dispose() {
        if (this.templatePages != null) {
            int n2 = this.templatePages.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                JCPage jCPage = (JCPage)this.templatePages.get(i2);
                jCPage.setDocument(null);
            }
            this.templatePages = null;
        }
    }

    public JCPage findFirstTemplate() {
        JCPage jCPage = null;
        for (int i2 = 0; i2 < this.templatePages.size(); ++i2) {
            jCPage = (JCPage)this.templatePages.get(i2);
            if (!jCPage.isFirstTemplate()) continue;
            return jCPage;
        }
        return (JCPage)this.templatePages.get(0);
    }

    public void setStartingPageNumber(int n2) {
        this.startPage = n2;
    }

    public int getStartingPageNumber() {
        return this.startPage;
    }

    public void addPage(JCPage jCPage) {
        this.addPage(jCPage, true, false);
    }

    public void addPage(JCPage jCPage, boolean bl, boolean bl2) {
        this.pageList.add(jCPage);
        if (this.flow != null && bl) {
            if (!bl2) {
                this.flow.deferCountingNewPage(jCPage);
            } else {
                this.flow.updatePageNumbers(jCPage);
            }
        }
        ++this.pageCount;
        jCPage.setDocument(this);
    }

    public void addFontPackage(String string) {
        FontLibrary.addFontPackage(string);
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public List getPages() {
        return this.pageList;
    }

    public JCFlow getFlow() {
        return this.flow;
    }

    public void setFlow(JCFlow jCFlow) {
        this.flow = jCFlow;
    }

    public int getFlushPolicy() {
        return this.flushPolicy;
    }

    public void setFlushPolicy(int n2) {
        if (n2 <= 0 || n2 > 2) {
            throw new IllegalArgumentException("Unrecognised document flush policy");
        }
        this.flushPolicy = n2;
    }

    public int getOutputPolicy() {
        return this.outputPolicy;
    }

    public void setOutputPolicy(int n2) {
        if (n2 <= 0 || n2 > 2) {
            throw new IllegalArgumentException("Unrecognised document output policy");
        }
        this.outputPolicy = n2;
    }

    public JCPage stringToTemplate(String string) {
        for (JCPage jCPage : this.templatePages) {
            if (!jCPage.getName().equals(string)) continue;
            return jCPage;
        }
        throw new NoSuchElementException("Page Template not Found: " + string);
    }

    public List getTables() {
        return this.tableList;
    }

    public void addTable(JCPageTable jCPageTable) {
        this.tableList.add(jCPageTable);
    }

    public void print() {
        this.print(this.printer);
    }

    public void print(JCPrinter jCPrinter) {
        int n2 = jCPrinter.getOutputPageStart();
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = this.pageList.size();
        int n4 = jCPrinter.getOutputPageEnd();
        if (n4 == -1 || n4 >= n3) {
            n4 = n3 - 1;
        }
        if (n2 > n4) {
            return;
        }
        this.print(jCPrinter, n2, n4);
    }

    public void print(int n2, int n3) {
        this.print(this.printer, n2, n3);
    }

    public void print(JCPrinter jCPrinter, int n2, int n3) {
        int n4 = 1;
        if (this.flow.isFlowActive()) {
            this.flow.endFlow();
        }
        if (this.outputPolicy == 2 && jCPrinter.isDocumentOpen()) {
            Rectangle2D rectangle2D = ((JCPage)this.pageList.get(this.lastPage < 0 ? 0 : this.lastPage)).getPageSize();
            while (++this.lastPage < this.pageCount) {
                JCPage jCPage = (JCPage)this.pageList.get(this.lastPage);
                rectangle2D = jCPage.getPageSize();
                for (int i2 = jCPrinter.getNumCopies(); i2 > 0; --i2) {
                    jCPrinter.beginPage(rectangle2D, jCPage.getPageNumber());
                    jCPage.draw((Graphics2D)jCPrinter.getGraphics());
                    jCPrinter.endPage(rectangle2D);
                }
                this.checkFlushPage(jCPage);
            }
            jCPrinter.closeDocument(rectangle2D);
            return;
        }
        int n5 = this.pageList.size();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 >= n5) {
            n3 = n5 - 1;
        }
        if (n3 < n2 && n5 > 0) {
            return;
        }
        boolean bl = jCPrinter.getCollate();
        boolean bl2 = jCPrinter.getReverseOrder();
        int n6 = jCPrinter.getNumCopies();
        if (bl2) {
            int n7 = n2;
            n2 = n3;
            n3 = n7;
            n4 = -1;
        }
        if (jCPrinter instanceof JCAWTPrinter) {
            ((JCAWTPrinter)jCPrinter).registerDocument(this);
            ((JCAWTPrinter)jCPrinter).registerFirstLast(n2, n3);
        }
        JCPage jCPage = (JCPage)this.pageList.get(n2);
        Rectangle2D rectangle2D = jCPage.getPageSize();
        jCPrinter.setOrientation(jCPage.getOrientation());
        jCPrinter.openDocument(rectangle2D);
        if (jCPrinter instanceof JCAWTPrinter) {
            n6 = -1;
        }
        for (int i3 = 0; (bl || i3 == 0) && i3 < n6; ++i3) {
            int n8 = n2;
            while (n4 > 0 ? n8 <= n3 : n8 >= n3) {
                JCPage jCPage2 = (JCPage)this.pageList.get(n8);
                rectangle2D = jCPage2.getPageSize();
                jCPrinter.setOrientation(jCPage2.getOrientation());
                for (int i4 = 0; !(i4 != 0 && bl || i4 >= n6); ++i4) {
                    jCPrinter.beginPage(rectangle2D, jCPage2.getPageNumber());
                    jCPage2.draw((Graphics2D)jCPrinter.getGraphics());
                    jCPrinter.endPage(rectangle2D);
                }
                if (!bl || i3 + 1 == n6) {
                    this.checkFlushPage(jCPage2);
                }
                n8 += n4;
            }
        }
        jCPrinter.closeDocument(rectangle2D);
    }

    public void checkOutputPage(JCPage jCPage) {
        int n2;
        if (this.outputPolicy != 2) {
            return;
        }
        Rectangle2D rectangle2D = jCPage.getPageSize();
        if (!this.printer.isDocumentOpen()) {
            this.printer.openDocument(rectangle2D);
            this.lastPage = -1;
        }
        if ((n2 = this.pageList.indexOf(jCPage)) != this.lastPage + 1) {
            return;
        }
        for (int i2 = this.printer.getNumCopies(); i2 > 0; --i2) {
            this.printer.beginPage(rectangle2D, jCPage.getPageNumber());
            jCPage.draw((Graphics2D)this.printer.getGraphics());
            this.printer.endPage(rectangle2D);
        }
        this.checkFlushPage(jCPage);
        this.lastPage = n2;
    }

    private void checkFlushPage(JCPage jCPage) {
        if (this.flushPolicy == 2) {
            jCPage.delete();
            this.tableList.clear();
        }
    }

    private static class BlankTemplate
    extends ArrayList {
        public BlankTemplate(JCUnit jCUnit, double d2, double d3, double d4) {
            JCPage jCPage = new JCPage("blank", new JCUnit.Point(jCUnit, 0.0, 0.0), new JCUnit.Dimension(jCUnit, d2, d3));
            jCPage.setFlowSectionTemplate(jCPage);
            jCPage.setFlowPageTemplate(jCPage);
            jCPage.setPageType(1);
            JCFrame jCFrame = new JCFrame("blank", new JCUnit.Point(jCUnit, d4, d4), new JCUnit.Dimension(jCUnit, d2 - 2.0 * d4, d3 - 2.0 * d4));
            Vector<JCFrame> vector = new Vector<JCFrame>(1);
            vector.add(jCFrame);
            jCPage.setFrameList(vector);
            jCPage.setFlowFrameList(vector);
            this.add(jCPage);
        }
    }
}

