/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge.indicator;

import com.klg.jclass.gauge.JCGauge;
import com.klg.jclass.gauge.indicator.JCBaseIndicatorGauge;
import com.klg.jclass.gauge.indicator.JCIndicatorGauge;
import com.klg.jclass.gauge.indicator.JCIndicatorGaugePanel;
import com.klg.jclass.gauge.resources.LocaleBundle;
import com.klg.jclass.util.io.PortableImage;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class JCIndicatorIcon
implements Cloneable,
Serializable {
    public static final int SHAPE_RECTANGLE = 0;
    public static final int SHAPE_OVAL = 1;
    public static final int SHAPE_TRIANGLE = 2;
    public static final int SHAPE_SQUARE = 3;
    public static final int SHAPE_CIRCLE = 4;
    public static final int SHAPE_STAR = 5;
    public static final int SHAPE_OCTAGON = 6;
    public static final int SHAPE_DIAMOND = 7;
    public static final int SHAPE_INVERTED_TRIANGLE = 8;
    public static final int SHAPE_CUSTOM = 9;
    protected Color color = Color.black;
    protected Rectangle bounds = null;
    protected int shape = 0;
    protected Object value = null;
    protected GeneralPath customShape = null;
    protected ShapeSizes customShapeSizePolicy = ShapeSizes.SCALE;
    protected boolean imageScaled = true;
    protected PortableImage image = null;
    protected String text = null;
    protected Color foreground = Color.gray;
    protected Font font = new Font("Dialog", 1, 10);
    protected JCBaseIndicatorGauge parent = null;

    public JCIndicatorIcon(JCBaseIndicatorGauge jCBaseIndicatorGauge) {
        this(0, jCBaseIndicatorGauge);
    }

    public JCIndicatorIcon(int n2, JCBaseIndicatorGauge jCBaseIndicatorGauge) {
        this.parent = jCBaseIndicatorGauge;
        if (n2 < 0 || n2 > 9) {
            String string = LocaleBundle.string("Invalid shape");
            throw new IllegalArgumentException(string);
        }
        this.shape = n2;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    protected void setBounds(Rectangle rectangle) {
        this.bounds = rectangle;
    }

    public int getShape() {
        return this.shape;
    }

    public void setShape(int n2) {
        if (n2 < 0 || n2 > 9) {
            String string = LocaleBundle.string("Invalid shape");
            throw new IllegalArgumentException(string);
        }
        this.shape = n2;
    }

    public GeneralPath getCustomShape() {
        return this.customShape;
    }

    public void setCustomShape(GeneralPath generalPath) {
        this.customShape = generalPath;
        this.shape = 9;
    }

    public ShapeSizes getCustomShapeSizePolicy() {
        return this.customShapeSizePolicy;
    }

    public void setCustomShapeSizePolicy(ShapeSizes shapeSizes) {
        this.customShapeSizePolicy = shapeSizes;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public PortableImage getPortableImage() {
        return this.image;
    }

    public void setPortableImage(PortableImage portableImage) {
        this.image = portableImage;
    }

    public boolean isImageScaled() {
        return this.imageScaled;
    }

    public void setImageScaled(boolean bl) {
        this.imageScaled = bl;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        if (color == null) {
            color = Color.gray;
        }
        this.foreground = color;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            font = new Font("Dialog", 1, 10);
        }
        this.font = font;
    }

    protected void paint(Graphics graphics, boolean bl) {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        Serializable serializable2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = graphics2D.getClipBounds();
        boolean bl2 = false;
        if (this.parent != null) {
            serializable2 = null;
            object3 = "com.klg.jclass.gauge.indicator.";
            object2 = "com.klg.jclass.sgauge.indicator.";
            if (this.parent instanceof JCIndicatorGauge) {
                serializable2 = this.parent.getClass();
                object3 = (String)object3 + "JCIndicatorGauge";
                object2 = (String)object2 + "JCServerIndicatorGauge";
            } else if (this.parent instanceof JCBaseIndicatorGauge && (serializable = (object = this.parent).getParent()) instanceof JCIndicatorGaugePanel) {
                serializable2 = serializable.getClass();
                object3 = (String)object3 + "JCIndicatorGaugePanel";
                object2 = (String)object2 + "JCServerIndicatorGaugePanel";
            }
            while (serializable2 != null) {
                object = ((Class)serializable2).getName();
                if (object != null) {
                    if (object.equals(object2)) break;
                    if (object.equals(object3)) {
                        bl2 = true;
                        break;
                    }
                }
                serializable2 = ((Class)serializable2).getSuperclass();
            }
        }
        if (!bl2) {
            serializable2 = graphics2D.getClipBounds();
            object3 = new Font("Dialog", 1, 12);
            graphics2D.setColor(Color.blue);
            graphics2D.fillRect(((Rectangle)serializable2).x, ((Rectangle)serializable2).y, ((Rectangle)serializable2).width, ((Rectangle)serializable2).height);
            graphics2D.setColor(Color.yellow);
            graphics2D.setFont((Font)object3);
            object2 = graphics2D.getFontMetrics();
            object = new String[]{LocaleBundle.string("Invalid use of JCGauge within JCServerGauge!"), LocaleBundle.string("It is not recommended that JCServerGauge and"), LocaleBundle.string("JCGauge jars be on the same classpath, but if"), LocaleBundle.string("they must, the JCServerGauge jar must be first.")};
            JCGauge.printErrorMessages(null, null, object);
            serializable = ((FontMetrics)object2).getStringBounds(object[0], graphics2D).getBounds();
            float f2 = (float)(2.0 * ((Rectangle)serializable).getHeight());
            float f3 = (float)((double)((Rectangle)serializable2).height / 2.0) - f2 * (float)((double)(((String[])object).length + 1) / 2.0);
            for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                if (object[i2] == null) continue;
                serializable = ((FontMetrics)object2).getStringBounds(object[i2], graphics2D).getBounds();
                float f4 = (float)(((double)((Rectangle)serializable2).width - ((Rectangle)serializable).getWidth()) / 2.0);
                graphics2D.drawString(object[i2], f4, f3 += f2);
            }
            return;
        }
        if (!bl) {
            int n2;
            int n3 = n2 = this.parent != null ? this.parent.getPadding() : 0;
            if (this.bounds.width <= 0 || this.bounds.height <= 0) {
                this.bounds = rectangle;
            }
            object3 = new Rectangle(this.bounds.x + n2, this.bounds.y + n2, this.bounds.width - 2 * n2, this.bounds.height - 2 * n2);
            if (((Rectangle)object3).width > 0 && ((Rectangle)object3).height > 0) {
                switch (this.shape) {
                    case 0: {
                        this.drawRectangle(graphics2D, (Rectangle)object3);
                        break;
                    }
                    case 1: {
                        this.drawOval(graphics2D, (Rectangle)object3);
                        break;
                    }
                    case 2: {
                        this.drawTriangle(graphics2D, (Rectangle)object3);
                        break;
                    }
                    case 3: {
                        this.drawSquare(graphics2D, (Rectangle)object3);
                        break;
                    }
                    case 4: {
                        this.drawCircle(graphics2D, (Rectangle)object3);
                        break;
                    }
                    case 5: {
                        this.drawStar(graphics2D, (Rectangle)object3);
                        break;
                    }
                    case 6: {
                        this.drawOctagon(graphics2D, (Rectangle)object3);
                        break;
                    }
                    case 7: {
                        this.drawDiamond(graphics2D, (Rectangle)object3);
                        break;
                    }
                    case 8: {
                        this.drawInvertedTriangle(graphics2D, (Rectangle)object3);
                        break;
                    }
                    case 9: {
                        if (this.customShape == null) break;
                        object2 = this.checkGeneralPathSize(this.customShape, (Rectangle)object3);
                        this.drawGeneralPath(graphics2D, (Rectangle)object3, (GeneralPath)object2);
                        break;
                    }
                    default: {
                        this.drawRectangle(graphics2D, (Rectangle)object3);
                    }
                }
            }
        }
        this.drawText(graphics2D);
    }

    protected void drawText(Graphics2D graphics2D) {
        if (this.text == null || this.text.length() == 0) {
            return;
        }
        if (this.bounds.width <= 0 || this.bounds.height <= 0) {
            return;
        }
        graphics2D.setFont(this.font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        graphics2D.setColor(this.foreground);
        TextLayout textLayout = new TextLayout(this.text, this.font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        double d2 = (double)this.bounds.x - rectangle2D.getX() + ((double)this.bounds.width - rectangle2D.getWidth()) / 2.0;
        double d3 = (double)this.bounds.y + ((double)this.bounds.height - rectangle2D.getY()) / 2.0;
        textLayout.draw(graphics2D, (float)d2, (float)d3);
    }

    private void drawStar(Graphics2D graphics2D, Rectangle rectangle) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(1);
        generalPath.moveTo(rectangle.x + rectangle.width / 20, rectangle.y + rectangle.height);
        generalPath.lineTo(rectangle.x + rectangle.width / 2, rectangle.y);
        generalPath.lineTo(rectangle.x + (rectangle.width - rectangle.width / 20), rectangle.y + rectangle.height);
        generalPath.lineTo(rectangle.x, rectangle.y + rectangle.height / 3);
        generalPath.lineTo(rectangle.x + rectangle.width, rectangle.y + rectangle.height / 3);
        generalPath.closePath();
        this.drawGeneralPath(graphics2D, rectangle, generalPath);
    }

    private void drawOctagon(Graphics2D graphics2D, Rectangle rectangle) {
        this.createSquareDrawRect(rectangle);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(rectangle.x + 2 * (rectangle.width / 3), rectangle.y);
        generalPath.lineTo(rectangle.x + rectangle.width / 3, rectangle.y);
        generalPath.lineTo(rectangle.x, rectangle.y + rectangle.height / 3);
        generalPath.lineTo(rectangle.x, rectangle.y + 2 * (rectangle.height / 3));
        generalPath.lineTo(rectangle.x + rectangle.width / 3, rectangle.y + rectangle.height);
        generalPath.lineTo(rectangle.x + 2 * (rectangle.width / 3), rectangle.y + rectangle.height);
        generalPath.lineTo(rectangle.x + rectangle.width, rectangle.y + 2 * (rectangle.height / 3));
        generalPath.lineTo(rectangle.x + rectangle.width, rectangle.y + rectangle.height / 3);
        generalPath.closePath();
        this.drawGeneralPath(graphics2D, rectangle, generalPath);
    }

    private void drawDiamond(Graphics2D graphics2D, Rectangle rectangle) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(rectangle.x + rectangle.width / 2, rectangle.y);
        generalPath.lineTo(rectangle.x, rectangle.y + rectangle.height / 2);
        generalPath.lineTo(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height);
        generalPath.lineTo(rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
        generalPath.closePath();
        this.drawGeneralPath(graphics2D, rectangle, generalPath);
    }

    private void drawCircle(Graphics2D graphics2D, Rectangle rectangle) {
        this.createSquareDrawRect(rectangle);
        if (this.color != null) {
            graphics2D.setColor(this.color);
            graphics2D.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.image != null && this.image.getImage() != null && this.parent != null) {
            Shape shape = graphics2D.getClip();
            Ellipse2D.Double double_ = new Ellipse2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setClip(double_);
            this.parent.drawImage(graphics2D, this.image, rectangle, null);
            graphics2D.setClip(shape);
        }
    }

    private void createSquareDrawRect(Rectangle rectangle) {
        if (rectangle.width < rectangle.height) {
            rectangle.y += (rectangle.height - rectangle.width) / 2;
            rectangle.height = rectangle.width;
        } else {
            rectangle.x += (rectangle.width - rectangle.height) / 2;
            rectangle.width = rectangle.height;
        }
    }

    private void drawSquare(Graphics2D graphics2D, Rectangle rectangle) {
        this.createSquareDrawRect(rectangle);
        if (this.color != null) {
            graphics2D.setColor(this.color);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.renderImageToClip(graphics2D, rectangle);
    }

    private void renderImageToClip(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.image != null && this.image.getImage() != null && this.parent != null) {
            Shape shape = graphics2D.getClip();
            graphics2D.setClip(rectangle);
            this.parent.drawImage(graphics2D, this.image, rectangle, null);
            graphics2D.setClip(shape);
        }
    }

    private GeneralPath checkGeneralPathSize(GeneralPath generalPath, Rectangle rectangle) {
        GeneralPath generalPath2 = (GeneralPath)generalPath.clone();
        Rectangle rectangle2 = generalPath2.getBounds();
        if (this.customShapeSizePolicy.equals((Object)ShapeSizes.SCALE)) {
            double d2 = (double)rectangle.width / (double)rectangle2.width;
            double d3 = (double)rectangle.height / (double)rectangle2.height;
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(d2, d3);
            generalPath2.transform(affineTransform);
            rectangle2 = generalPath2.getBounds();
            int n2 = rectangle.x + rectangle.width / 2 - (rectangle2.x + rectangle2.width / 2);
            int n3 = rectangle.y + rectangle.height / 2 - (rectangle2.y + rectangle2.height / 2);
            affineTransform = new AffineTransform();
            affineTransform.translate(n2, n3);
            generalPath2.transform(affineTransform);
        } else if (this.customShapeSizePolicy.equals((Object)ShapeSizes.PRESERVE_ASPECT_RATIO)) {
            double d4 = (double)rectangle.width / (double)rectangle2.width;
            double d5 = (double)rectangle.height / (double)rectangle2.height;
            double d6 = d4 < d5 ? d4 : d5;
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(d6, d6);
            generalPath2.transform(affineTransform);
            rectangle2 = generalPath2.getBounds();
            int n4 = rectangle.x + rectangle.width / 2 - (rectangle2.x + rectangle2.width / 2);
            int n5 = rectangle.y + rectangle.height / 2 - (rectangle2.y + rectangle2.height / 2);
            affineTransform = new AffineTransform();
            affineTransform.translate(n4, n5);
            generalPath2.transform(affineTransform);
        } else {
            int n6 = rectangle.x + rectangle.width / 2 - (rectangle2.x + rectangle2.width / 2);
            int n7 = rectangle.y + rectangle.height / 2 - (rectangle2.y + rectangle2.height / 2);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n6, n7);
            generalPath2.transform(affineTransform);
        }
        return generalPath2;
    }

    private void drawGeneralPath(Graphics2D graphics2D, Rectangle rectangle, GeneralPath generalPath) {
        if (this.color != null) {
            graphics2D.setColor(this.color);
            graphics2D.fill(generalPath);
        }
        if (this.image != null && this.image.getImage() != null && this.parent != null) {
            Shape shape = graphics2D.getClip();
            graphics2D.setClip(generalPath);
            this.parent.drawImage(graphics2D, this.image, rectangle, null);
            graphics2D.setClip(shape);
        }
    }

    private void drawTriangle(Graphics2D graphics2D, Rectangle rectangle) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(rectangle.x + rectangle.width / 2, rectangle.y);
        generalPath.lineTo(rectangle.x, rectangle.y + rectangle.height);
        generalPath.lineTo(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        generalPath.closePath();
        this.drawGeneralPath(graphics2D, rectangle, generalPath);
    }

    private void drawInvertedTriangle(Graphics2D graphics2D, Rectangle rectangle) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(rectangle.x, rectangle.y);
        generalPath.lineTo(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height);
        generalPath.lineTo(rectangle.x + rectangle.width, rectangle.y);
        generalPath.closePath();
        this.drawGeneralPath(graphics2D, rectangle, generalPath);
    }

    private void drawOval(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.color != null) {
            graphics2D.setColor(this.color);
            graphics2D.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.image != null && this.image.getImage() != null && this.parent != null) {
            Shape shape = graphics2D.getClip();
            Ellipse2D.Double double_ = new Ellipse2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setClip(double_);
            this.parent.drawImage(graphics2D, this.image, rectangle, null);
            graphics2D.setClip(shape);
        }
    }

    private void drawRectangle(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.color != null) {
            graphics2D.setColor(this.color);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.renderImageToClip(graphics2D, rectangle);
    }

    protected Object clone() throws CloneNotSupportedException {
        JCIndicatorIcon jCIndicatorIcon = (JCIndicatorIcon)super.clone();
        jCIndicatorIcon.parent = null;
        jCIndicatorIcon.setBounds(this.bounds);
        jCIndicatorIcon.setColor(this.color);
        jCIndicatorIcon.setFont(this.font);
        jCIndicatorIcon.setForeground(this.foreground);
        jCIndicatorIcon.setImageScaled(this.imageScaled);
        if (this.image != null) {
            jCIndicatorIcon.setPortableImage((PortableImage)this.image.clone());
        }
        jCIndicatorIcon.setShape(this.shape);
        jCIndicatorIcon.setText(this.text);
        jCIndicatorIcon.setValue(this.value);
        return jCIndicatorIcon;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShapeSizes {
        SCALE,
        PRESERVE_ASPECT_RATIO,
        ACTUAL_SIZE;

    }
}

