/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge.indicator;

import com.klg.jclass.gauge.AccessibleValueState;
import com.klg.jclass.gauge.indicator.AccessibleIndicatorGaugeRole;
import com.klg.jclass.gauge.indicator.IconController;
import com.klg.jclass.gauge.indicator.JCBaseIndicatorGauge;
import com.klg.jclass.gauge.resources.LocaleBundle;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.ServerRenderable;
import com.klg.jclass.util.ServerRenderer;
import com.klg.jclass.util.graphics.GraphicsUtil;
import com.klg.jclass.util.graphics.JCFont;
import com.klg.jclass.util.graphics.JCFontMetrics;
import com.klg.jclass.util.io.PortableImage;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Comparator;
import java.util.Enumeration;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCIndicatorGauge
extends JCBaseIndicatorGauge
implements IconController,
ActionListener,
ServerRenderable,
RenderProperties {
    protected JCListenerList valueListeners = null;
    protected String[] rangeToolTips = null;
    protected String[] rangeText = null;
    protected Object[] rangeDisplays = null;
    protected Object[] rangeValues = new Object[]{new Integer(0), new Integer(1)};
    protected Object baseValue = null;
    protected Comparator<Object> comparator = null;
    protected boolean textValueDisplayed = false;
    private int blinkOnInterval = 0;
    private int blinkOffInterval = 0;
    protected transient Graphics prevSetGraphics;
    private Timer t = null;
    protected int antiAliasing = 0;

    public JCIndicatorGauge(int n2) {
        super(n2);
        this.rangeDisplays = new Color[]{Color.black, Color.white};
        this.baseValue = new Integer(0);
        this.setValue(new Integer(0));
    }

    public JCIndicatorGauge() {
        this(0);
    }

    @Override
    public void setIconShape(int n2) {
        this.icon.setShape(n2);
        this.resetIcon();
    }

    @Override
    public int getIconShape() {
        return this.icon.getShape();
    }

    @Override
    public void setIconFont(Font font) {
        this.icon.setFont(font);
    }

    @Override
    public Font getIconFont() {
        return this.icon.getFont();
    }

    @Override
    public void setIconForeground(Color color) {
        this.icon.setForeground(color);
    }

    @Override
    public Color getIconForeground() {
        return this.icon.getForeground();
    }

    @Override
    public void setIconImageScaled(boolean bl) {
        this.icon.setImageScaled(bl);
    }

    @Override
    public boolean isIconImageScaled() {
        return this.icon.isImageScaled();
    }

    @Override
    public void setValue(Object object) {
        if (this.checkValidity(object)) {
            JCValueEvent jCValueEvent = new JCValueEvent(this, this.icon.getValue(), object);
            this.fireValueChangingEvent(jCValueEvent);
            if (jCValueEvent.getAllowChange()) {
                this.icon.setValue(jCValueEvent.getNewValue());
                this.resetIcon();
            }
            this.fireValueChangedEvent(jCValueEvent);
        }
    }

    @Override
    public Object getValue() {
        return this.icon.getValue();
    }

    protected int compareValue(Object object, Object object2) {
        int n2;
        if (this.comparator != null) {
            n2 = this.comparator.compare(object, object2);
        } else if (object instanceof Comparable) {
            n2 = ((Comparable)object).compareTo(object2);
        } else {
            String string = LocaleBundle.string("Value must implement Comparable or a Comparator must be supplied");
            throw new IllegalArgumentException(string);
        }
        return n2;
    }

    protected boolean checkValidity(Object object) {
        if (object == null) {
            return false;
        }
        int n2 = this.compareValue(object, this.baseValue);
        return n2 >= 0;
    }

    protected void resetIcon() {
        int n2 = this.determineRangeIndex();
        if (this.textValueDisplayed) {
            this.icon.setText(this.getValue().toString());
        } else if (this.rangeText != null) {
            if (this.rangeText.length > n2) {
                this.icon.setText(this.rangeText[n2]);
            } else {
                this.icon.setText(this.rangeText[this.rangeText.length - 1]);
            }
        }
        Object object = null;
        if (this.rangeDisplays != null) {
            object = this.rangeDisplays.length > n2 ? this.rangeDisplays[n2] : this.rangeDisplays[this.rangeDisplays.length - 1];
        }
        if (object == null) {
            return;
        }
        if (object instanceof Color) {
            this.icon.setColor((Color)object);
            this.icon.setPortableImage(null);
        } else if (object instanceof URL) {
            this.icon.setColor(null);
            this.icon.setPortableImage(new PortableImage((URL)object, this.icon.isImageScaled()));
        } else if (object instanceof PortableImage) {
            this.icon.setColor(null);
            this.icon.setPortableImage((PortableImage)object);
        }
        if (this.rangeToolTips != null) {
            if (this.rangeToolTips.length > n2) {
                this.setToolTipText(this.rangeToolTips[n2]);
            } else {
                this.setToolTipText(this.rangeToolTips[this.rangeToolTips.length - 1]);
            }
        } else if (this.textValueDisplayed) {
            this.setToolTipText(this.icon.getText());
        } else {
            this.setToolTipText(object.toString());
        }
        this.repaint();
    }

    protected int determineRangeIndex() {
        Object object = this.icon.getValue();
        for (int i2 = 0; i2 < this.rangeValues.length; ++i2) {
            int n2 = this.compareValue(object, this.rangeValues[i2]);
            if (n2 > 0) continue;
            return i2;
        }
        return this.rangeValues.length;
    }

    public void addValueListener(JCValueListener jCValueListener) {
        this.valueListeners = JCListenerList.add(this.valueListeners, jCValueListener);
    }

    public void removeValueListener(JCValueListener jCValueListener) {
        this.valueListeners = JCListenerList.remove(this.valueListeners, jCValueListener);
    }

    protected void fireValueChangedEvent(JCValueEvent jCValueEvent) {
        Enumeration<Object> enumeration = JCListenerList.elements(this.valueListeners);
        while (enumeration.hasMoreElements()) {
            ((JCValueListener)enumeration.nextElement()).valueChanged(jCValueEvent);
        }
    }

    protected void fireValueChangingEvent(JCValueEvent jCValueEvent) {
        Enumeration<Object> enumeration = JCListenerList.elements(this.valueListeners);
        while (enumeration.hasMoreElements()) {
            ((JCValueListener)enumeration.nextElement()).valueChanging(jCValueEvent);
        }
    }

    @Override
    public void setRangeToolTips(String[] stringArray) {
        this.rangeToolTips = stringArray;
    }

    @Override
    public String[] getRangeToolTips() {
        return this.rangeToolTips;
    }

    @Override
    public void setRangeText(String[] stringArray) {
        this.rangeText = stringArray;
    }

    @Override
    public String[] getRangeText() {
        return this.rangeText;
    }

    @Override
    public void setTextValueDisplayed(boolean bl) {
        this.textValueDisplayed = bl;
    }

    @Override
    public boolean isTextValueDisplayed() {
        return this.textValueDisplayed;
    }

    @Override
    public void setRangeDisplays(Object[] objectArray) {
        if (objectArray != null) {
            for (Object object : objectArray) {
                if (object == null || object instanceof Color || object instanceof URL || object instanceof PortableImage) continue;
                String string = LocaleBundle.string("RangeDisplay entries must be either a Color, URL, or PortableImage object.");
                throw new IllegalArgumentException(string);
            }
        }
        this.rangeDisplays = objectArray;
    }

    @Override
    public Object[] getRangeDisplays() {
        return this.rangeDisplays;
    }

    @Override
    public void setRangeValues(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            String string = LocaleBundle.string("Range value array must have at least one element.");
            throw new IllegalArgumentException(string);
        }
        for (Object object : objectArray) {
            if (this.checkValidity(object)) continue;
            String string = LocaleBundle.string("Range values must be non-null and greater than the base value.");
            throw new IllegalArgumentException(string);
        }
        this.rangeValues = objectArray;
    }

    @Override
    public Object[] getRangeValues() {
        return this.rangeValues;
    }

    @Override
    public void setBaseValue(Object object) {
        if (object == null) {
            object = new Integer(0);
        }
        this.baseValue = object;
    }

    @Override
    public Object getBaseValue() {
        return this.baseValue;
    }

    public Comparator<Object> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<Object> comparator) {
        this.comparator = comparator;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleIndicatorGauge();
        }
        return this.accessibleContext;
    }

    @Override
    public int getBlinkInterval() {
        return this.blinkOnInterval == this.blinkOffInterval ? this.blinkOnInterval : 0;
    }

    public int getBlinkOnInterval() {
        return this.blinkOnInterval;
    }

    public int getBlinkOffInterval() {
        return this.blinkOffInterval;
    }

    @Override
    public void setBlinkInterval(int n2) {
        this.validateIntervalInput(n2);
        if (n2 > 0) {
            this.blinkOnInterval = this.blinkOffInterval = n2;
        }
    }

    private void validateIntervalInput(int n2) {
        this.stopBlinking();
        if (n2 < 0) {
            String string = LocaleBundle.string("Blink Interval must be positive");
            throw new IllegalArgumentException(string);
        }
    }

    public void setBlinkOnInterval(int n2) {
        this.validateIntervalInput(n2);
        if (n2 > 0) {
            this.blinkOnInterval = n2;
        }
    }

    public void setBlinkOffInterval(int n2) {
        this.validateIntervalInput(n2);
        if (n2 > 0) {
            this.blinkOffInterval = n2;
        }
    }

    public void startBlinking() {
        if (this.getTime() != null) {
            this.t.start();
        }
    }

    public void stopBlinking() {
        if (this.t != null) {
            this.t.stop();
            this.blink = false;
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.repaint();
        this.changeTimerInterval(this.blink ? this.blinkOnInterval : this.blinkOffInterval);
        this.blink = !this.blink;
    }

    private void changeTimerInterval(int n2) {
        this.getTime().setDelay(n2);
        this.getTime().setInitialDelay(n2);
        if (this.getTime().isRunning()) {
            this.getTime().restart();
        }
    }

    private Timer getTime() {
        if (this.t == null && this.blinkOnInterval > 0) {
            this.t = new Timer(this.blinkOnInterval, this);
        }
        return this.t;
    }

    @Override
    public int getAntiAliasing() {
        return this.antiAliasing;
    }

    @Override
    public void setAntiAliasing(int n2) {
        this.antiAliasing = n2;
    }

    @Override
    public void setUsingDoublePixels(boolean bl) {
    }

    @Override
    public boolean isUsingDoublePixels() {
        return false;
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = GraphicsUtil.setAntiAliasing(graphics2D, this.antiAliasing);
        super.paint(graphics2D);
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        JCFont jCFont;
        JCFontMetrics jCFontMetrics;
        if (font instanceof JCFont && (jCFontMetrics = (jCFont = (JCFont)((Object)font)).getJCFontMetrics()) != null) {
            return jCFontMetrics.getEncoderFontMetrics();
        }
        return super.getFontMetrics(font);
    }

    @Override
    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics.create();
    }

    @Override
    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
    }

    @Override
    public Image serverSnapshot() {
        return ServerRenderer.snapshot(this);
    }

    @Override
    public void serverPaint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = GraphicsUtil.setAntiAliasing(graphics2D, this.antiAliasing);
        ServerRenderer.paintComponent(graphics, this);
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
    }

    public static void main(String[] stringArray) {
        JCIndicatorGauge jCIndicatorGauge = new JCIndicatorGauge(1);
        jCIndicatorGauge.setPadding(20);
        jCIndicatorGauge.getIcon().setColor(Color.red);
        URL uRL = jCIndicatorGauge.getClass().getResource("pict0360.jpg");
        if (uRL != null) {
            jCIndicatorGauge.getIcon().setPortableImage(new PortableImage(uRL, false));
        }
        jCIndicatorGauge.setBackground(Color.orange);
        Font font = new Font("Dialog", 1, 18);
        jCIndicatorGauge.getIcon().setFont(font);
        jCIndicatorGauge.getIcon().setForeground(Color.black);
        jCIndicatorGauge.getIcon().setText("Hi, Mom and dad");
        jCIndicatorGauge.setBlinkOnInterval(7000);
        jCIndicatorGauge.setBlinkOffInterval(1000);
        jCIndicatorGauge.setOpaque(true);
        jCIndicatorGauge.setPreferredSize(new Dimension(300, 300));
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().setLayout(new BoxLayout(jFrame.getContentPane(), 1));
        jFrame.getContentPane().add(new JLabel("How do you like me now?"));
        jFrame.getContentPane().add(jCIndicatorGauge);
        jFrame.pack();
        jCIndicatorGauge.setSize(new Dimension(200, 200));
        jCIndicatorGauge.startBlinking();
        jFrame.setVisible(true);
    }

    protected class AccessibleIndicatorGauge
    extends JComponent.AccessibleJComponent {
        protected AccessibleIndicatorGauge() {
            super(JCIndicatorGauge.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleIndicatorGaugeRole.INDICATOR_GAUGE;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(new AccessibleValueState("value = ", JCIndicatorGauge.this.icon.getValue().toString()));
            return accessibleStateSet;
        }
    }
}

