/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge.graph;

import com.klg.jclass.gauge.JCGauge;
import com.klg.jclass.gauge.graph.ScaleProvider;
import com.klg.jclass.gauge.graph.ScaleProviderAdaptor;
import com.klg.jclass.gauge.graph.Scaled;
import com.klg.jclass.gauge.resources.LocaleBundle;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.ServerRenderer;
import com.klg.jclass.util.graphics.GraphicsUtil;
import com.klg.jclass.util.graphics.JCFont;
import com.klg.jclass.util.graphics.JCFontMetrics;
import com.klg.jclass.util.io.OutputProperties;
import com.klg.jclass.util.io.PortableImage;
import com.klg.jclass.util.style.JCFillStyle;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class JCGraph
extends JComponent
implements ComponentListener,
Scaled,
RenderProperties,
Serializable {
    public static final int DEFAULT_SIZE = 100;
    public static final int RIGHT = 0;
    public static final int LEFT = 1;
    public static final int UP = 2;
    public static final int DOWN = 3;
    protected int pixelsPerValue = 2;
    protected boolean initialized = false;
    protected int curWidth = -1;
    protected int curHeight = -1;
    protected Insets curInsets = null;
    protected int direction = 0;
    protected PortableImage image = null;
    protected JCFillStyle fillStyle = null;
    protected Color lineColor = null;
    protected BasicStroke lineStroke = new BasicStroke();
    protected ScaleProvider scale;
    protected double originalMin = Double.MAX_VALUE;
    protected double originalMax = -1.7976931348623157E308;
    protected double[] values = new double[0];
    protected int[] graphCoords = new int[0];
    protected int ndx = -1;
    protected boolean full = false;
    protected double widthOffset = 0.0;
    protected double heightOffset = 0.0;
    protected double widthOverRange = 0.0;
    protected double heightOverRange = 0.0;
    protected JCListenerList valueListeners = null;
    protected boolean isServerGraph = false;
    protected int antiAliasing = 1;
    protected transient Graphics prevSetGraphics = null;
    protected JComponent.AccessibleJComponent accessibleContext = null;

    public JCGraph() {
        this(0);
    }

    public JCGraph(int n2) {
        this.setSize(new Dimension(100, 100));
        this.scale = new ScaleProviderAdaptor();
        this.setDirection(n2);
        this.addComponentListener(this);
    }

    public JCGraph(double[] dArray) {
        this.setSize(new Dimension(100, 100));
        this.scale = new ScaleProviderAdaptor();
        this.values = dArray == null ? new double[]{} : dArray;
        this.graphCoords = new int[this.values.length];
        this.ndx = this.values.length - 1;
        this.setDirection(0);
        this.addComponentListener(this);
    }

    public JCGraph(int n2, double[] dArray, double d2, double d3) {
        this.setSize(new Dimension(100, 100));
        this.originalMin = d2;
        this.originalMax = d3;
        this.scale = new ScaleProviderAdaptor(d2, d3);
        this.values = dArray == null ? new double[]{} : dArray;
        this.graphCoords = new int[this.values.length];
        this.ndx = this.values.length - 1;
        this.setDirection(n2);
        this.addComponentListener(this);
    }

    public int getDirection() {
        return this.direction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirection(int n2) {
        if (n2 < 0 || n2 > 3) {
            String string = LocaleBundle.string("Value must be one of JCGraph.RIGHT, JCGraph.LEFT, JCGraph.UP, JCGraph.DOWN.");
            throw new IllegalArgumentException(string);
        }
        this.direction = n2;
        JCGraph jCGraph = this;
        synchronized (jCGraph) {
            this.recalc(true);
        }
    }

    public Color getLineColor() {
        if (this.lineColor != null) {
            return this.lineColor;
        }
        Color color = this.getForeground();
        if (color != null) {
            return color;
        }
        return Color.black;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public BasicStroke getLineStroke() {
        return this.lineStroke;
    }

    public void setLineStroke(BasicStroke basicStroke) {
        if (basicStroke == null) {
            basicStroke = new BasicStroke();
        }
        this.lineStroke = basicStroke;
    }

    public float getLineWidth() {
        return this.lineStroke.getLineWidth();
    }

    public void setLineWidth(float f2) {
        BasicStroke basicStroke = new BasicStroke(f2, this.lineStroke.getEndCap(), this.lineStroke.getLineJoin(), 10.0f, this.lineStroke.getDashArray(), 0.0f);
        this.setLineStroke(basicStroke);
    }

    public int getLineJoin() {
        return this.lineStroke.getLineJoin();
    }

    public void setLineJoin(int n2) {
        BasicStroke basicStroke = new BasicStroke(this.lineStroke.getLineWidth(), this.lineStroke.getEndCap(), n2, 10.0f, this.lineStroke.getDashArray(), 0.0f);
        this.setLineStroke(basicStroke);
    }

    public int getLineCap() {
        return this.lineStroke.getEndCap();
    }

    public void setLineCap(int n2) {
        BasicStroke basicStroke = new BasicStroke(this.lineStroke.getLineWidth(), n2, this.lineStroke.getLineJoin(), 10.0f, this.lineStroke.getDashArray(), 0.0f);
        this.setLineStroke(basicStroke);
    }

    public void setMinValue(double d2) {
        this.scale.setMinimum(d2);
        this.resetMinMaxValue();
    }

    public double getMinValue() {
        return this.scale.getMinimum();
    }

    public void setMaxValue(double d2) {
        this.scale.setMaximum(d2);
        this.resetMinMaxValue();
    }

    public double getMaxValue() {
        return this.scale.getMaximum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPixelsPerValue(int n2) {
        if (n2 <= 0) {
            String string = LocaleBundle.string("The new value for pixelPerValue must a positive integer.");
            throw new IllegalArgumentException(string);
        }
        this.pixelsPerValue = n2;
        JCGraph jCGraph = this;
        synchronized (jCGraph) {
            this.recalc(true);
        }
    }

    public int getPixelsPerValue() {
        return this.pixelsPerValue;
    }

    public void setScale(ScaleProvider scaleProvider) {
        if (scaleProvider == null) {
            this.resetScale();
        } else {
            this.scale = scaleProvider;
        }
        this.resetMinMaxValue();
    }

    public ScaleProvider getScale() {
        return this.scale;
    }

    public void addValueListener(JCValueListener jCValueListener) {
        this.valueListeners = JCListenerList.add(this.valueListeners, jCValueListener);
    }

    public void removeValueListener(JCValueListener jCValueListener) {
        this.valueListeners = JCListenerList.remove(this.valueListeners, jCValueListener);
    }

    protected void fireValueChangedEvent(JCValueEvent jCValueEvent) {
        Enumeration<Object> enumeration = JCListenerList.elements(this.valueListeners);
        while (enumeration.hasMoreElements()) {
            ((JCValueListener)enumeration.nextElement()).valueChanged(jCValueEvent);
        }
    }

    protected void fireValueChangingEvent(JCValueEvent jCValueEvent) {
        Enumeration<Object> enumeration = JCListenerList.elements(this.valueListeners);
        while (enumeration.hasMoreElements()) {
            ((JCValueListener)enumeration.nextElement()).valueChanging(jCValueEvent);
        }
    }

    protected void recalc(boolean bl) {
        this.curWidth = this.getWidth();
        this.curHeight = this.getHeight();
        if (this.curWidth < 1 || this.curHeight < 1) {
            if (this.initialized) {
                return;
            }
            this.curHeight = 100;
            this.curWidth = 100;
        }
        int n2 = this.values.length;
        Container container = this.getParent();
        if (container != null || this.values.length == 0 || this.isServerGraph) {
            this.curInsets = this.getInsets();
            int n3 = Math.max(this.curWidth - this.curInsets.left - this.curInsets.right, 0);
            int n4 = Math.max(this.curHeight - this.curInsets.top - this.curInsets.bottom, 0);
            switch (this.direction) {
                case 0: {
                    n2 = n3 / this.pixelsPerValue;
                    break;
                }
                case 1: {
                    n2 = n3 / this.pixelsPerValue;
                    break;
                }
                case 2: {
                    n2 = n4 / this.pixelsPerValue;
                    break;
                }
                case 3: {
                    n2 = n4 / this.pixelsPerValue;
                }
            }
        }
        this.initRatios();
        if (n2 != this.values.length) {
            this.resetGraphValues(n2);
        } else {
            this.reloadLineGraphCoords();
        }
        this.initialized = true;
        if (bl) {
            this.repaint();
        }
    }

    protected void resetGraphValues(int n2) {
        if (n2 <= 0) {
            this.full = true;
            this.ndx = -1;
            this.values = new double[0];
            this.graphCoords = new int[0];
            return;
        }
        double[] dArray = new double[n2];
        if (this.full && n2 > this.values.length) {
            int n3;
            int n4 = 0;
            for (n3 = this.ndx + 1; n3 < this.values.length; ++n3) {
                dArray[n4++] = this.values[n3];
            }
            for (n3 = 0; n3 <= this.ndx; ++n3) {
                dArray[n4++] = this.values[n3];
            }
            this.full = false;
            this.ndx = n4 - 1;
        } else if (this.full && this.values.length > n2) {
            int n5;
            int n6 = this.values.length - (n2 - this.ndx) + 1;
            int n7 = 0;
            for (n5 = n6; n5 < this.values.length && n7 < n2; ++n5) {
                dArray[n7++] = this.values[n5];
            }
            for (n5 = n6 = n6 > this.values.length ? n6 % this.values.length : 0; n5 <= this.ndx && n7 < n2; ++n5) {
                dArray[n7++] = this.values[n5];
            }
            this.full = true;
            this.ndx = n7 - 1;
        } else if (this.ndx >= n2) {
            int n8 = this.ndx - n2 + 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                dArray[i2] = this.values[n8++];
            }
            this.full = true;
            this.ndx = n2 - 1;
        } else {
            for (int i3 = 0; i3 <= this.ndx; ++i3) {
                dArray[i3] = this.values[i3];
            }
            this.full = false;
        }
        this.values = dArray;
        this.graphCoords = new int[this.values.length];
        this.reloadLineGraphCoords();
    }

    public synchronized void addValue(double d2) {
        if (!this.initialized) {
            this.recalc(false);
        }
        JCValueEvent jCValueEvent = new JCValueEvent(this, null, new Double(d2));
        this.fireValueChangingEvent(jCValueEvent);
        if (!jCValueEvent.getAllowChange()) {
            return;
        }
        if (++this.ndx >= this.values.length) {
            this.ndx = this.values.length > 0 ? 0 : -1;
            this.full = true;
        }
        if (jCValueEvent.getNewValue() instanceof Double) {
            d2 = (Double)jCValueEvent.getNewValue();
        }
        if (this.values.length > 0) {
            this.values[this.ndx] = d2;
            this.graphCoords[this.ndx] = this.calcCoord(d2);
        }
        double d3 = this.scale.getMinimum();
        double d4 = this.scale.getMaximum();
        this.scale.hit(d2);
        if (d3 != this.scale.getMinimum() || d4 != this.scale.getMaximum()) {
            this.resetMinMaxValue();
        }
        if (this.ndx >= 0) {
            this.repaint();
        }
        this.fireValueChangedEvent(jCValueEvent);
    }

    public synchronized void addValues(double[] dArray) {
        if (!this.initialized) {
            this.recalc(false);
        }
        JCValueEvent jCValueEvent = new JCValueEvent(this, null, dArray);
        this.fireValueChangingEvent(jCValueEvent);
        if (!jCValueEvent.getAllowChange()) {
            return;
        }
        Object object = jCValueEvent.getNewValue();
        double[] dArray2 = object instanceof Double ? new double[]{(Double)object} : (object instanceof double[] ? (double[])object : dArray);
        double d2 = this.scale.getMinimum();
        double d3 = this.scale.getMaximum();
        for (double d4 : dArray2) {
            if (++this.ndx >= this.values.length) {
                this.ndx = this.values.length > 0 ? 0 : -1;
                this.full = true;
            }
            if (this.values.length > 0) {
                this.values[this.ndx] = d4;
                this.graphCoords[this.ndx] = this.calcCoord(d4);
            }
            this.scale.hit(d4);
        }
        if (d2 != this.scale.getMinimum() || d3 != this.scale.getMaximum()) {
            this.resetMinMaxValue();
        }
        if (this.ndx >= 0) {
            this.repaint();
        }
        this.fireValueChangedEvent(jCValueEvent);
    }

    public synchronized void setValues(double[] dArray) {
        if (dArray == null) {
            dArray = new double[]{};
        }
        this.values = dArray;
        this.ndx = dArray.length - 1;
        this.graphCoords = new int[dArray.length];
        this.recalc(true);
    }

    public synchronized double getCurrentValue() {
        if (this.values.length > 0 && this.ndx >= 0) {
            return this.values[this.ndx];
        }
        return Double.MAX_VALUE;
    }

    public synchronized double[] getValues() {
        double[] dArray;
        if (this.full) {
            int n2;
            dArray = new double[this.values.length];
            int n3 = 0;
            for (n2 = this.ndx + 1; n2 < this.values.length; ++n2) {
                dArray[n3++] = this.values[n2];
            }
            for (n2 = 0; n2 <= this.ndx; ++n2) {
                dArray[n3++] = this.values[n2];
            }
        } else {
            dArray = new double[this.ndx + 1];
            for (int i2 = 0; i2 <= this.ndx; ++i2) {
                dArray[i2] = this.values[i2];
            }
        }
        return dArray;
    }

    public void setGraphValues(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        double[] dArray = new double[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            dArray[n2++] = Double.parseDouble(stringTokenizer.nextToken());
        }
        this.setValues(dArray);
    }

    public String getGraphValues() {
        double[] dArray = this.getValues();
        String string = "";
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            string = i2 < dArray.length - 1 ? string + dArray[i2] + "," : string + dArray[i2] + "";
        }
        return string;
    }

    public synchronized void clear() {
        this.ndx = -1;
        this.full = this.values.length <= 0;
        this.resetScale();
        this.resetMinMaxValue();
    }

    protected void resetScale() {
        this.scale = this.originalMin != Double.MAX_VALUE ? new ScaleProviderAdaptor(this.originalMin, this.originalMax) : new ScaleProviderAdaptor();
    }

    public PortableImage getPortableImage() {
        return this.image;
    }

    public void setPortableImage(PortableImage portableImage) {
        this.image = portableImage;
    }

    public Image getImage() {
        if (this.image == null) {
            return null;
        }
        return this.image.getImage();
    }

    public void setImage(URL uRL) {
        ImageIcon imageIcon;
        if (uRL != null && (imageIcon = new ImageIcon(uRL)).getImageLoadStatus() == 8) {
            this.setImage(imageIcon.getImage());
        }
    }

    public void setImage(Image image) {
        if (this.image == null) {
            this.image = new PortableImage(image);
        } else {
            this.image.setImage(image);
        }
    }

    public boolean isImageScaled() {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        return this.image.isImageScaled();
    }

    public void setImageScaled(boolean bl) {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        this.image.setImageScaled(bl);
    }

    public OutputProperties getImageOutputProperties() {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        return this.image.getOutputProperties();
    }

    public void setImageOutputProperties(OutputProperties outputProperties) {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        this.image.setOutputProperties(outputProperties);
    }

    public JCFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        if (this.fillStyle != null) {
            this.fillStyle.parent = null;
        }
        this.fillStyle = jCFillStyle;
        if (this.fillStyle != null) {
            this.fillStyle.parent = this;
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = GraphicsUtil.setAntiAliasing(graphics2D, this.antiAliasing);
        super.paint(graphics2D);
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
    }

    protected synchronized void paintComponent(Graphics graphics) {
        Object object;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (n2 < 1 || n3 < 1) {
            return;
        }
        if (!this.initialized || n2 != this.curWidth || n3 != this.curHeight || !this.getInsets().equals(this.curInsets)) {
            this.recalc(false);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        boolean bl = false;
        for (Class<?> clazz = this.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            object = clazz.getName();
            if (object == null) continue;
            if (((String)object).equals("com.klg.jclass.sgauge.graph.JCServerGraph")) break;
            if (!((String)object).equals("com.klg.jclass.gauge.graph.JCGraph")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            object = graphics2D.getClipBounds();
            Font font = new Font("Dialog", 1, 12);
            graphics2D.setColor(Color.blue);
            graphics2D.fillRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            graphics2D.setColor(Color.yellow);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            String[] stringArray = new String[]{LocaleBundle.string("Invalid use of JCGauge within JCServerGauge!"), LocaleBundle.string("It is not recommended that JCServerGauge and"), LocaleBundle.string("JCGauge jars be on the same classpath, but if"), LocaleBundle.string("they must, the JCServerGauge jar must be first.")};
            JCGauge.printErrorMessages(null, null, stringArray);
            Rectangle rectangle = fontMetrics.getStringBounds(stringArray[0], graphics2D).getBounds();
            float f2 = (float)(2.0 * rectangle.getHeight());
            float f3 = (float)((double)((Rectangle)object).height / 2.0) - f2 * (float)((double)(stringArray.length + 1) / 2.0);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2] == null) continue;
                rectangle = fontMetrics.getStringBounds(stringArray[i2], graphics2D).getBounds();
                float f4 = (float)(((double)((Rectangle)object).width - rectangle.getWidth()) / 2.0);
                graphics2D.drawString(stringArray[i2], f4, f3 += f2);
            }
            return;
        }
        object = this.isOpaque() ? this.getBackground() : new Color(0, 0, 0, 0);
        Rectangle rectangle = this.getBounds();
        rectangle.setLocation(0, 0);
        if (object != null) {
            graphics2D.setColor((Color)object);
            graphics2D.fill(rectangle);
        }
        if (this.isOpaque()) {
            if (this.fillStyle != null) {
                Insets insets = this.getInsets();
                int n4 = Math.max(0, rectangle.width - insets.left - insets.right);
                int n5 = Math.max(0, rectangle.height - insets.top - insets.bottom);
                Rectangle rectangle2 = new Rectangle(insets.left, insets.top, n4, n5);
                this.fillStyle.updateAnchorRect(rectangle2);
                this.fillStyle.fillRect((Graphics)graphics2D, insets.left, insets.top, n4, n5);
                this.fillStyle.updateAnchorRect(null);
            }
            this.drawImage(graphics2D, this.image, rectangle);
        }
        this.drawLineGraph(graphics2D);
    }

    protected void resetMinMaxValue() {
        this.initRatios();
        this.reloadLineGraphCoords();
    }

    protected void initRatios() {
        double d2;
        Insets insets = this.getInsets();
        int n2 = Math.max(this.getWidth() - insets.left - insets.right, 0);
        int n3 = Math.max(this.getHeight() - insets.top - insets.bottom, 0);
        this.widthOffset = insets.left;
        this.heightOffset = Math.max(this.getHeight() - insets.bottom, 0);
        double d3 = d2 = this.scale.isAtDefault() ? 1.0 : this.scale.getMaximum() - this.scale.getMinimum();
        if (d2 <= 0.0) {
            String string = LocaleBundle.string("The scale minimum must be less than the maximum.");
            throw new RuntimeException(string);
        }
        this.heightOverRange = (double)n3 / d2;
        this.widthOverRange = (double)n2 / d2;
    }

    protected int calcCoord(double d2) {
        double d3 = this.scale.getMinimum();
        int n2 = this.direction == 1 || this.direction == 0 ? (int)(this.heightOffset - (d2 - d3) * this.heightOverRange) : (int)(this.widthOffset + (d2 - d3) * this.widthOverRange);
        return n2;
    }

    protected void reloadLineGraphCoords() {
        int n2;
        int n3 = this.full ? this.values.length : this.ndx + 1;
        double d2 = this.scale.getMinimum();
        double d3 = this.scale.getMaximum();
        for (n2 = 0; n2 < n3; ++n2) {
            this.scale.hit(this.values[n2]);
        }
        if (d2 != this.scale.getMinimum() || d3 != this.scale.getMaximum()) {
            this.initRatios();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.graphCoords[n2] = this.calcCoord(this.values[n2]);
        }
    }

    protected void drawLineGraph(Graphics2D graphics2D) {
        if (this.ndx < 0 || this.ndx < 1 && !this.full) {
            return;
        }
        graphics2D.setStroke(this.lineStroke);
        graphics2D.setColor(this.getLineColor());
        switch (this.direction) {
            case 0: {
                this.drawRightLine(graphics2D);
                break;
            }
            case 1: {
                this.drawLeftLine(graphics2D);
                break;
            }
            case 2: {
                this.drawUpLine(graphics2D);
                break;
            }
            case 3: {
                this.drawDownLine(graphics2D);
            }
        }
        graphics2D.setStroke(new BasicStroke());
    }

    protected void drawRightLine(Graphics2D graphics2D) {
        int n2;
        int n3 = this.getInsets().left;
        int n4 = n3 + this.pixelsPerValue;
        if (this.full && this.ndx < this.graphCoords.length - 1) {
            for (n2 = this.ndx + 1; n2 < this.graphCoords.length - 1; ++n2) {
                graphics2D.drawLine(n3, this.graphCoords[n2], n4, this.graphCoords[n2 + 1]);
                n3 = n4;
                n4 += this.pixelsPerValue;
            }
            graphics2D.drawLine(n3, this.graphCoords[this.graphCoords.length - 1], n4, this.graphCoords[0]);
            n3 = n4;
            n4 += this.pixelsPerValue;
        }
        for (n2 = 0; n2 < this.ndx; ++n2) {
            graphics2D.drawLine(n3, this.graphCoords[n2], n4, this.graphCoords[n2 + 1]);
            n3 = n4;
            n4 += this.pixelsPerValue;
        }
    }

    protected void drawLeftLine(Graphics2D graphics2D) {
        int n2;
        int n3 = this.getWidth() - 1 - this.getInsets().right;
        int n4 = n3 - this.pixelsPerValue;
        if (this.full && this.ndx < this.graphCoords.length - 1) {
            for (n2 = this.ndx + 1; n2 < this.graphCoords.length - 1; ++n2) {
                graphics2D.drawLine(n3, this.graphCoords[n2], n4, this.graphCoords[n2 + 1]);
                n3 = n4;
                n4 -= this.pixelsPerValue;
            }
            graphics2D.drawLine(n3, this.graphCoords[this.graphCoords.length - 1], n4, this.graphCoords[0]);
            n3 = n4;
            n4 -= this.pixelsPerValue;
        }
        for (n2 = 0; n2 < this.ndx; ++n2) {
            graphics2D.drawLine(n3, this.graphCoords[n2], n4, this.graphCoords[n2 + 1]);
            n3 = n4;
            n4 -= this.pixelsPerValue;
        }
    }

    protected void drawDownLine(Graphics2D graphics2D) {
        int n2;
        int n3 = this.getInsets().top;
        int n4 = n3 + this.pixelsPerValue;
        if (this.full && this.ndx < this.graphCoords.length - 1) {
            for (n2 = this.ndx + 1; n2 < this.graphCoords.length - 1; ++n2) {
                graphics2D.drawLine(this.graphCoords[n2], n3, this.graphCoords[n2 + 1], n4);
                n3 = n4;
                n4 += this.pixelsPerValue;
            }
            graphics2D.drawLine(this.graphCoords[this.graphCoords.length - 1], n3, this.graphCoords[0], n4);
            n3 = n4;
            n4 += this.pixelsPerValue;
        }
        for (n2 = 0; n2 < this.ndx; ++n2) {
            graphics2D.drawLine(this.graphCoords[n2], n3, this.graphCoords[n2 + 1], n4);
            n3 = n4;
            n4 += this.pixelsPerValue;
        }
    }

    protected void drawUpLine(Graphics2D graphics2D) {
        int n2;
        int n3 = this.getHeight() - 1 - this.getInsets().bottom;
        int n4 = n3 - this.pixelsPerValue;
        if (this.full && this.ndx < this.graphCoords.length - 1) {
            for (n2 = this.ndx + 1; n2 < this.graphCoords.length - 1; ++n2) {
                graphics2D.drawLine(this.graphCoords[n2], n3, this.graphCoords[n2 + 1], n4);
                n3 = n4;
                n4 -= this.pixelsPerValue;
            }
            graphics2D.drawLine(this.graphCoords[this.graphCoords.length - 1], n3, this.graphCoords[0], n4);
            n3 = n4;
            n4 -= this.pixelsPerValue;
        }
        for (n2 = 0; n2 < this.ndx; ++n2) {
            graphics2D.drawLine(this.graphCoords[n2], n3, this.graphCoords[n2 + 1], n4);
            n3 = n4;
            n4 -= this.pixelsPerValue;
        }
    }

    protected void drawImage(Graphics graphics, PortableImage portableImage, Rectangle rectangle) {
        ImageIcon imageIcon;
        if (portableImage != null && portableImage.getImage() != null && (imageIcon = new ImageIcon(portableImage.getImage())).getImageLoadStatus() == 8) {
            Image image = imageIcon.getImage();
            Insets insets = this.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            if (portableImage.isImageScaled()) {
                graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
            } else {
                int n2 = imageIcon.getIconWidth();
                int n3 = imageIcon.getIconHeight();
                if (n2 > 0 && n3 > 0) {
                    int n4 = rectangle.x - (n2 - rectangle.width) / 2;
                    int n5 = rectangle.y - (n3 - rectangle.height) / 2;
                    graphics.drawImage(image, n4, n5, n2, n3, this);
                }
            }
        }
    }

    public Image snapshot() {
        return this.snapshot(2);
    }

    public Image snapshot(int n2) {
        Image image;
        Dimension dimension = this.getSize();
        try {
            image = new BufferedImage(dimension.width, dimension.height, n2);
        }
        catch (Exception exception) {
            image = this.createImage(dimension.width, dimension.height);
        }
        this.snapshot(image);
        return image;
    }

    public void snapshot(Image image) {
        if (image != null) {
            Graphics graphics = image.getGraphics();
            graphics.setClip(0, 0, this.getSize().width, this.getSize().height);
            this.paint(graphics);
            graphics.dispose();
        }
    }

    public FontMetrics getFontMetrics(Font font) {
        JCFont jCFont;
        JCFontMetrics jCFontMetrics;
        if (font instanceof JCFont && (jCFontMetrics = (jCFont = (JCFont)((Object)font)).getJCFontMetrics()) != null) {
            return jCFontMetrics.getEncoderFontMetrics();
        }
        return super.getFontMetrics(font);
    }

    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics.create();
    }

    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
    }

    public Image serverSnapshot() {
        return ServerRenderer.snapshot(this);
    }

    public void serverPaint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = GraphicsUtil.setAntiAliasing(graphics2D, this.antiAliasing);
        ServerRenderer.paintComponent(graphics2D, this);
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentResized(ComponentEvent componentEvent) {
        JCGraph jCGraph = this;
        synchronized (jCGraph) {
            this.recalc(true);
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public int getAntiAliasing() {
        return this.antiAliasing;
    }

    public void setAntiAliasing(int n2) {
        this.antiAliasing = n2;
    }

    public void setUsingDoublePixels(boolean bl) {
    }

    public boolean isUsingDoublePixels() {
        return false;
    }
}

