/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge;

import com.klg.jclass.gauge.GaugeUtil;
import com.klg.jclass.gauge.JCAbstractScale;
import com.klg.jclass.gauge.JCAbstractTick;
import com.klg.jclass.gauge.JCGauge;
import com.klg.jclass.gauge.JCLinearGauge;
import com.klg.jclass.gauge.JCLinearScale;
import com.klg.jclass.gauge.JCTickStyle;
import com.klg.jclass.gauge.LinearConstraint;
import com.klg.jclass.gauge.LinearLayout;
import com.klg.jclass.util.JCNumberUtil;
import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.graphics.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import javax.swing.JComponent;

public class JCLinearTick
extends JCAbstractTick {
    protected boolean minorLogTicksDrawn = false;

    public JCLinearTick(JCLinearScale jCLinearScale) {
        super(jCLinearScale, jCLinearScale.getMin(), jCLinearScale.getMax());
        this.setLayout(new LinearLayout());
    }

    public JCLinearTick(JCLinearScale jCLinearScale, boolean bl, double d2, double d3, double d4, boolean bl2, int n2, double d5, boolean bl3, boolean bl4, double d6, double d7, double d8, Color color, JCTickStyle jCTickStyle, Font font, Color color2) {
        super(jCLinearScale, bl, d2, d3, d4, bl2, n2, d5, bl3, bl4, d6, d7, d8, color, jCTickStyle, font, color2);
        this.setLayout(new LinearLayout());
    }

    protected JCLinearScale getLinearScale() {
        return (JCLinearScale)this.getScale();
    }

    public Dimension getPreferredSize() {
        return this.getLinearScale().getPreferredSize();
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        super.setBounds(n2, n3, n4, n5);
        this.redrawLabels();
    }

    public void calcLinearTicks(Graphics graphics) {
        JCLinearScale jCLinearScale = this.getLinearScale();
        JCLinearScale.Orientation orientation = jCLinearScale.getOrientation();
        Rectangle2D rectangle2D = jCLinearScale.getScaleSize();
        double d2 = rectangle2D.getWidth();
        double d3 = rectangle2D.getHeight();
        int n2 = (int)(orientation == JCLinearScale.Orientation.HORIZONTAL ? d2 : d3);
        if (jCLinearScale.isLogarithmic()) {
            this.calcLogTicks(graphics, n2);
        } else {
            this.calcTicks(graphics, n2);
        }
    }

    protected void calcLogTicks(Graphics graphics, int n2) {
        double d2 = this.scale.getMin();
        double d3 = this.scale.getMax();
        int n3 = JCNumberUtil.ifloor(JCNumberUtil.precCorrect(10, JCNumberUtil.log10(d2)));
        int n4 = JCNumberUtil.iceil(JCNumberUtil.precCorrect(10, JCNumberUtil.log10(d3)));
        if (this.precisionUseDefault) {
            this.precision = JCNumberUtil.tickBasedPrecision(d2);
        }
        this.startValue = JCNumberUtil.pow10(n3);
        this.stopValue = JCNumberUtil.pow10(n4);
        this.incrementValue = 1.0;
    }

    public void redrawLabels() {
        JCLinearScale jCLinearScale = this.getLinearScale();
        JCLinearScale.Orientation orientation = jCLinearScale.getOrientation();
        JCAbstractScale.Direction direction = jCLinearScale.getDirection();
        if (this.drawLabels) {
            Iterator<Double> iterator;
            Graphics graphics;
            this.removeAll();
            double d2 = jCLinearScale.getMin();
            double d3 = jCLinearScale.getMax();
            if (this.automatic && (graphics = this.getGraphics()) != null) {
                this.calcLinearTicks(graphics);
            }
            boolean bl = orientation == JCLinearScale.Orientation.VERTICAL;
            boolean bl2 = direction.equals(JCAbstractScale.Direction.BACKWARD);
            boolean bl3 = jCLinearScale.isLogarithmic();
            boolean bl4 = bl2 ^ bl && !bl3;
            Iterator<Double> iterator2 = iterator = bl3 ? new LogarithmicTickIterator() : new LinearTickIterator();
            while (iterator.hasNext()) {
                LogarithmicTickIterator logarithmicTickIterator;
                Double d4 = iterator.next();
                double d5 = d4;
                if (bl3 && !this.minorLogTicksDrawn && !(logarithmicTickIterator = (LogarithmicTickIterator)iterator).isMajor()) continue;
                double d6 = bl4 ? d3 - d5 + d2 : d5;
                double d7 = 0.0;
                if (d2 < d3) {
                    d7 = bl3 ? GaugeUtil.valueToPositionLog(d6, d2, d3, 0.0, 1.0, bl, bl2) : (d6 - d2) / Math.abs(d3 - d2);
                    d7 *= 100.0;
                }
                LinearConstraint linearConstraint = new LinearConstraint((JCGauge)jCLinearScale.getLinearGauge(), this.getLabelExtent(), d7);
                JComponent jComponent = this.labelGenerator != null ? this.labelGenerator.makeLabel(this, d5, linearConstraint) : this.generateLabel(d5);
                if (jComponent == null) continue;
                jComponent.setSize(jComponent.getPreferredSize());
                this.add((Component)jComponent, linearConstraint);
            }
            this.doLayout();
        }
    }

    public void paintComponent(Graphics graphics) {
        Iterator<Double> iterator;
        double d2;
        double d3;
        boolean bl;
        JCLinearScale jCLinearScale = this.getLinearScale();
        JCLinearGauge jCLinearGauge = (JCLinearGauge)this.getLinearScale().getGauge();
        JCLinearScale.Orientation orientation = jCLinearScale.getOrientation();
        JCAbstractScale.Direction direction = jCLinearScale.getDirection();
        Rectangle2D rectangle2D = jCLinearScale.getScaleSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = null;
        RenderProperties renderProperties = GraphicsUtil.getRenderPropertiesParent(this);
        if (renderProperties != null) {
            object = GraphicsUtil.setAntiAliasing(graphics2D, renderProperties.getAntiAliasing());
        }
        super.paintComponent(graphics2D);
        if (this.automatic) {
            this.calcLinearTicks(graphics2D);
        }
        double d4 = jCLinearScale.getMin();
        double d5 = jCLinearScale.getMax();
        if (!this.isVisible() || d4 >= d5 || !this.drawTicks || this.innerExtent >= this.outerExtent || this.startValue > this.stopValue || this.incrementValue <= 0.0 || this.tickWidth <= 0.0) {
            return;
        }
        boolean bl2 = direction.equals(JCAbstractScale.Direction.BACKWARD);
        boolean bl3 = orientation == JCLinearScale.Orientation.VERTICAL;
        boolean bl4 = jCLinearScale.isLogarithmic();
        boolean bl5 = bl = bl2 ^ bl3 && !bl4;
        if (bl3) {
            d3 = this.innerExtent * rectangle2D.getWidth();
            d2 = this.outerExtent * rectangle2D.getWidth();
        } else {
            d3 = this.innerExtent * rectangle2D.getHeight();
            d2 = this.outerExtent * rectangle2D.getHeight();
        }
        Iterator<Double> iterator2 = iterator = bl4 ? new LogarithmicTickIterator() : new LinearTickIterator();
        while (iterator.hasNext()) {
            LogarithmicTickIterator logarithmicTickIterator;
            Double d6 = iterator.next();
            double d7 = d6;
            if (bl4 && !this.minorLogTicksDrawn && !(logarithmicTickIterator = (LogarithmicTickIterator)iterator).isMajor()) continue;
            if (this.tickStyle == JCTickStyle.LINE) {
                double d8;
                double d9;
                double d10;
                double d11;
                double d12 = bl ? d5 - d7 + d4 : d7;
                double d13 = jCLinearGauge.valueToPosition(d12);
                double d14 = rectangle2D.getX();
                double d15 = rectangle2D.getY();
                if (bl3) {
                    d11 = d14 + d3;
                    d10 = d13;
                    d9 = d14 + d2;
                    d8 = d13;
                } else {
                    d11 = d13;
                    d10 = d15 + d3;
                    d9 = d13;
                    d8 = d15 + d2;
                }
                graphics2D.setColor(this.tickColor);
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(new Line2D.Double(d11, d10, d9, d8));
                continue;
            }
            if (this.tickStyle == JCTickStyle.CIRCLE) {
                GaugeUtil.drawCircleForLinearScale(graphics2D, jCLinearScale, this.tickColor, d7, this.innerExtent, this.outerExtent);
                continue;
            }
            GaugeUtil.drawLinearPolygon(graphics2D, jCLinearScale, this.tickColor, this.innerExtent, this.outerExtent, this.tickWidth, d7, this.reversed, true, this.tickStyle);
        }
        if (renderProperties != null && object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    public void redraw(boolean bl) {
        JCGauge jCGauge = this.getLinearScale().getGauge();
        if (jCGauge != null && jCGauge.getRepaintEnabled()) {
            if (bl) {
                this.redrawLabels();
            }
            this.revalidate();
            jCGauge.repaint();
        }
    }

    public boolean isMinorLogTicksDrawn() {
        return this.minorLogTicksDrawn;
    }

    public void setMinorLogTicksDrawn(boolean bl) {
        if (this.minorLogTicksDrawn == bl) {
            return;
        }
        this.minorLogTicksDrawn = bl;
        this.redraw();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LogarithmicTickIterator
    implements Iterator<Double> {
        protected double value;
        protected double linearMin;
        protected double linearMax;
        protected int iLogMin;
        protected int iLogMax;
        protected int i;
        protected int j;

        public LogarithmicTickIterator() {
            JCLinearScale jCLinearScale = JCLinearTick.this.getLinearScale();
            this.linearMin = jCLinearScale.getMin();
            this.linearMax = jCLinearScale.getMax();
            double d2 = JCLinearTick.this.startValue;
            double d3 = JCLinearTick.this.stopValue;
            if (d3 <= 0.0) {
                d3 = 1.0;
                d2 = 0.1;
            } else if (d2 <= 0.0) {
                d2 = d3 / 10.0;
            }
            double d4 = JCNumberUtil.precCorrect(10, JCNumberUtil.log10(d2));
            double d5 = JCNumberUtil.precCorrect(10, JCNumberUtil.log10(d3));
            this.iLogMin = JCNumberUtil.ifloor(d4);
            this.iLogMax = JCNumberUtil.iceil(d5);
            this.i = this.iLogMin;
            this.j = 1;
            this.value = (double)this.j * JCNumberUtil.pow10(this.i);
            while (this.hasNext() && this.value < this.linearMin) {
                this.incrementValue();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("LogarithmicTickIterator doesnot upport the remove operation.");
        }

        public boolean isMajor() {
            return this.j == 2;
        }

        public void incrementValue() {
            ++this.j;
            if (this.j > 9) {
                ++this.i;
                this.j = 1;
            }
            this.value = (double)this.j * JCNumberUtil.pow10(this.i);
        }

        @Override
        public boolean hasNext() {
            return this.value <= JCLinearTick.this.stopValue && this.value <= this.linearMax && this.i <= this.iLogMax;
        }

        @Override
        public Double next() {
            double d2 = this.value;
            this.incrementValue();
            return new Double(d2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LinearTickIterator
    implements Iterator<Double> {
        protected double value;
        protected double linearMin;
        protected double linearMax;

        public LinearTickIterator() {
            this.value = JCLinearTick.this.startValue;
            JCLinearScale jCLinearScale = JCLinearTick.this.getLinearScale();
            this.linearMin = jCLinearScale.getMin();
            this.linearMax = jCLinearScale.getMax();
            while (this.hasNext() && this.value < this.linearMin) {
                this.value += JCLinearTick.this.incrementValue;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("LinearTickIterator doesnot upport the remove operation.");
        }

        @Override
        public boolean hasNext() {
            return JCLinearTick.this.incrementValue != 0.0 && this.value <= JCLinearTick.this.stopValue && this.value <= this.linearMax;
        }

        @Override
        public Double next() {
            double d2 = this.value;
            this.value += JCLinearTick.this.incrementValue;
            return new Double(d2);
        }
    }
}

