/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge;

import com.klg.jclass.gauge.GaugeUtil;
import com.klg.jclass.gauge.JCAbstractScale;
import com.klg.jclass.gauge.JCGauge;
import com.klg.jclass.gauge.JCGaugeArea;
import com.klg.jclass.gauge.JCLinearGauge;
import com.klg.jclass.gauge.JCLinearTick;
import com.klg.jclass.gauge.JCTick;
import com.klg.jclass.gauge.LinearConstraint;
import com.klg.jclass.gauge.LinearLayout;
import com.klg.jclass.gauge.resources.LocaleBundle;
import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.graphics.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Vector;

public class JCLinearScale
extends JCAbstractScale {
    protected Orientation orientation = Orientation.HORIZONTAL;
    protected boolean useZoomFactorForMin = true;
    protected boolean useZoomFactorForMax = true;
    protected boolean logarithmic = false;

    public JCLinearScale(JCLinearGauge jCLinearGauge) {
        super(jCLinearGauge);
        this.setLayout(new LinearLayout());
        this.setBackground(Color.white);
        GaugeUtil.createLegendPopulatorRenderer(jCLinearGauge, this);
    }

    public JCLinearScale(JCLinearGauge jCLinearGauge, double d2, double d3) {
        super(jCLinearGauge, d2, d3);
        this.setLayout(new LinearLayout());
        this.setBackground(Color.white);
        GaugeUtil.createLegendPopulatorRenderer(jCLinearGauge, this);
    }

    public JCLinearScale(JCLinearGauge jCLinearGauge, JCAbstractScale.Direction direction, double d2, double d3, Orientation orientation, Color color) {
        super(jCLinearGauge, direction, d2, d3, color);
        this.setLayout(new LinearLayout());
        this.orientation = orientation;
        GaugeUtil.createLegendPopulatorRenderer(jCLinearGauge, this);
    }

    public JCLinearGauge getLinearGauge() {
        return (JCLinearGauge)this.getGauge();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getParent().getBounds().width, this.getParent().getBounds().height);
    }

    public Component add(Component component) {
        this.add(component, new LinearConstraint(this.getGauge(), Double.MAX_VALUE, Double.MAX_VALUE));
        return component;
    }

    public Component add(Component component, int n2) {
        this.add(component, new LinearConstraint(this.getGauge(), Double.MAX_VALUE, Double.MAX_VALUE), n2);
        return component;
    }

    public Rectangle2D getScaleSize() {
        JCGaugeArea jCGaugeArea = this.getGauge().getGaugeArea();
        Insets insets = jCGaugeArea.getInsets();
        Insets insets2 = this.getInsets();
        int n2 = Math.max(insets2.left, insets.left);
        int n3 = Math.max(insets2.right, insets.right);
        int n4 = Math.max(insets2.top, insets.top);
        int n5 = Math.max(insets2.bottom, insets.bottom);
        double d2 = n2;
        double d3 = n4;
        double d4 = jCGaugeArea.getBounds().width;
        double d5 = jCGaugeArea.getBounds().height;
        d4 -= (double)(n2 + n3);
        d5 -= (double)(n4 + n5);
        d4 = Math.max(d4, 0.0);
        d5 = Math.max(d5, 0.0);
        if (this.useZoomFactorForMin || this.useZoomFactorForMax) {
            if (this.orientation == Orientation.VERTICAL) {
                double d6 = d4 - d4 * this.zoomFactor;
                if (this.useZoomFactorForMin && this.useZoomFactorForMax) {
                    d2 += d6 / 2.0;
                } else if (this.useZoomFactorForMin) {
                    d2 += d6;
                }
                d4 *= this.zoomFactor;
            } else {
                double d7 = d5 - d5 * this.zoomFactor;
                if (this.useZoomFactorForMin && this.useZoomFactorForMax) {
                    d3 += d7 / 2.0;
                } else if (this.useZoomFactorForMin) {
                    d3 += d7;
                }
                d5 *= this.zoomFactor;
            }
        }
        return new Rectangle2D.Double(d2, d3, d4, d5);
    }

    public void paintComponent(Graphics graphics) {
        Object object;
        if (!this.isVisible()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        JCLinearGauge jCLinearGauge = this.getLinearGauge();
        boolean bl = false;
        for (Class<?> clazz = jCLinearGauge.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            object = clazz.getName();
            if (object == null) continue;
            if (((String)object).equals("com.klg.jclass.sgauge.JCServerLinearGauge")) break;
            if (!((String)object).equals("com.klg.jclass.gauge.JCLinearGauge")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            object = graphics.getClipBounds();
            Font font = new Font("Dialog", 1, 12);
            graphics2D.setColor(Color.blue);
            graphics2D.fillRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            graphics2D.setColor(Color.yellow);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            String[] stringArray = new String[]{LocaleBundle.string("Invalid use of JCGauge within JCServerGauge!"), LocaleBundle.string("It is not recommended that JCServerGauge and"), LocaleBundle.string("JCGauge jars be on the same classpath, but if"), LocaleBundle.string("they must, the JCServerGauge jar must be first.")};
            JCGauge.printErrorMessages(null, null, stringArray);
            Rectangle rectangle = fontMetrics.getStringBounds(stringArray[0], graphics2D).getBounds();
            float f2 = (float)(2.0 * rectangle.getHeight());
            float f3 = (float)((double)((Rectangle)object).height / 2.0) - f2 * (float)((double)(stringArray.length + 1) / 2.0);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2] == null) continue;
                rectangle = fontMetrics.getStringBounds(stringArray[i2], graphics2D).getBounds();
                float f4 = (float)(((double)((Rectangle)object).width - rectangle.getWidth()) / 2.0);
                graphics2D.drawString(stringArray[i2], f4, f3 += f2);
            }
            this.makeComponentsInvisible();
            return;
        }
        object = null;
        RenderProperties renderProperties = GraphicsUtil.getRenderPropertiesParent(this);
        if (renderProperties != null) {
            object = GraphicsUtil.setAntiAliasing(graphics2D, renderProperties.getAntiAliasing());
        }
        Rectangle2D rectangle2D = this.getScaleSize();
        if (this.isOpaque()) {
            Color color = this.getBackground();
            if (color != null) {
                graphics2D.setColor(color);
                graphics2D.fill(rectangle2D);
            }
            if (this.fillStyle != null) {
                this.fillStyle.updateAnchorRect(rectangle2D);
                this.fillStyle.fillRect((Graphics)graphics2D, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                this.fillStyle.updateAnchorRect(null);
            }
            this.drawImage(graphics2D, this.image, rectangle2D);
        }
        if (renderProperties != null && object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    private void drawRotatedWatermark(Graphics2D graphics2D, double d2, String string) {
    }

    private void drawDevelopmentWatermark(Graphics2D graphics2D, String string) {
    }

    public double pick(Point point) {
        double d2;
        Rectangle2D rectangle2D = this.getScaleSize();
        boolean bl = this.orientation == Orientation.VERTICAL;
        boolean bl2 = this.direction.equals(JCAbstractScale.Direction.BACKWARD);
        double d3 = bl ? (double)point.y : (double)point.x;
        double d4 = bl ? rectangle2D.getY() : rectangle2D.getX();
        double d5 = bl ? rectangle2D.getY() + rectangle2D.getHeight() : rectangle2D.getX() + rectangle2D.getWidth();
        double d6 = this.getMin();
        double d7 = this.getMax();
        double d8 = d2 = this.logarithmic ? GaugeUtil.positionToValueLog(d3, d6, d7, d4, d5, bl, bl2) : GaugeUtil.positionToValueDouble(d3, d6, d7, d4, d5);
        if (bl2 ^ bl && !this.logarithmic) {
            d2 = d7 - d2 + d6;
        }
        d2 = GaugeUtil.clamp(d2, d6, d7);
        return d2;
    }

    public void setDirection(JCAbstractScale.Direction direction) {
        if (direction != null && (direction.string.equals(JCAbstractScale.Direction.CLOCKWISE.string) || direction.string.equals(JCAbstractScale.Direction.COUNTERCLOCKWISE.string))) {
            throw new IllegalArgumentException("Clockwise or CounterClockwise direction does not apply to linear scales.");
        }
        super.setDirection(direction);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.redraw();
    }

    public boolean getUseZoomFactorForMin() {
        return this.useZoomFactorForMin;
    }

    public void setUseZoomFactorForMin(boolean bl) {
        this.useZoomFactorForMin = bl;
    }

    public boolean getUseZoomFactorForMax() {
        return this.useZoomFactorForMax;
    }

    public void setUseZoomFactorForMax(boolean bl) {
        this.useZoomFactorForMax = bl;
    }

    public boolean isLogarithmic() {
        return this.logarithmic;
    }

    public void setLogarithmic(boolean bl) {
        this.logarithmic = bl;
        this.redraw();
    }

    public double getMin() {
        if (this.logarithmic && this.min <= 0.0) {
            if (this.max > 0.0) {
                return this.max / 10.0;
            }
            return 0.1;
        }
        return this.min;
    }

    public double getMax() {
        if (this.logarithmic && this.max <= 0.0) {
            if (this.min > 0.0) {
                return this.min / 10.0;
            }
            return 1.0;
        }
        return this.max;
    }

    public void redraw() {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (this.gauge != null && this.gauge.getRepaintEnabled()) {
            Vector<JCTick> vector = this.gauge.getTicks();
            if (vector != null) {
                Enumeration<JCTick> enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    JCLinearTick jCLinearTick = (JCLinearTick)enumeration.nextElement();
                    jCLinearTick.redraw(true);
                }
            }
            this.gauge.repaint();
        }
    }

    private void makeComponentsInvisible() {
        int n2;
        Component component;
        JCGauge jCGauge = this.getGauge();
        for (int i2 = 0; i2 < jCGauge.getComponentCount(); ++i2) {
            component = jCGauge.getComponent(i2);
            if (component instanceof JCGaugeArea) continue;
            component.setVisible(false);
        }
        JCGaugeArea jCGaugeArea = this.getGauge().getGaugeArea();
        for (n2 = 0; n2 < jCGaugeArea.getComponentCount(); ++n2) {
            component = jCGaugeArea.getComponent(n2);
            if (component instanceof JCLinearScale) continue;
            component.setVisible(false);
        }
        for (n2 = 0; n2 < this.getComponentCount(); ++n2) {
            this.getComponent(n2).setVisible(false);
        }
    }

    public static class Orientation {
        public static final Orientation HORIZONTAL = new Orientation();
        public static final Orientation VERTICAL = new Orientation();

        private Orientation() {
        }
    }
}

