/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge;

import com.klg.jclass.gauge.GaugeUtil;
import com.klg.jclass.gauge.JCAbstractRange;
import com.klg.jclass.gauge.JCAbstractScale;
import com.klg.jclass.gauge.JCGauge;
import com.klg.jclass.gauge.JCLinearScale;
import com.klg.jclass.gauge.resources.LocaleBundle;
import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.graphics.GraphicsUtil;
import com.klg.jclass.util.io.OutputProperties;
import com.klg.jclass.util.io.PortableImage;
import com.klg.jclass.util.label.JCLabel;
import com.klg.jclass.util.style.JCFillStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import javax.swing.ImageIcon;

public class JCLinearRange
extends JCAbstractRange {
    protected PortableImage foregroundImage;
    protected JCFillStyle foregroundFillStyle = null;
    protected double foregroundCoverage = 0.0;
    protected JCLinearScale.Orientation maskOrientation = JCLinearScale.Orientation.HORIZONTAL;

    public JCLinearRange(JCLinearScale jCLinearScale) {
        super(jCLinearScale);
    }

    public JCLinearRange(Color color, JCLinearScale jCLinearScale, double d2, double d3, double d4, double d5) {
        super(color, jCLinearScale, d2, d3, d4, d5);
    }

    protected JCLinearScale getLinearScale() {
        return (JCLinearScale)this.getScale();
    }

    public Dimension getPreferredSize() {
        return this.getLinearScale().getPreferredSize();
    }

    public Rectangle2D getLinearRangeSize(JCLinearScale jCLinearScale, Rectangle2D rectangle2D) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        JCLinearScale.Orientation orientation = jCLinearScale.getOrientation();
        boolean bl = orientation == JCLinearScale.Orientation.VERTICAL;
        JCAbstractScale.Direction direction = jCLinearScale.getDirection();
        boolean bl2 = direction.equals(JCAbstractScale.Direction.BACKWARD);
        double d9 = jCLinearScale.getMin();
        double d10 = jCLinearScale.getMax();
        double d11 = GaugeUtil.clamp(this.startValue, d9, d10);
        double d12 = GaugeUtil.clamp(this.stopValue, d9, d10);
        if (bl2 ^ bl && !jCLinearScale.isLogarithmic()) {
            d12 = d10 - d12 + d9;
            d11 = d10 - d11 + d9;
        }
        if (this.image != null && this.image.getImage() != null) {
            if (this.innerExtent > 1.0) {
                this.innerExtent = 1.0;
            }
            if (this.outerExtent > 1.0) {
                this.outerExtent = 1.0;
            }
        }
        double d13 = rectangle2D.getX();
        double d14 = rectangle2D.getWidth();
        double d15 = rectangle2D.getY();
        double d16 = rectangle2D.getHeight();
        double d17 = bl ? d15 : d13;
        double d18 = d8 = bl ? d15 + d16 : d13 + d14;
        if (jCLinearScale.isLogarithmic()) {
            d7 = GaugeUtil.valueToPositionLog(d11, d9, d10, d17, d8, bl, bl2);
            d6 = GaugeUtil.valueToPositionLog(d12, d9, d10, d17, d8, bl, bl2);
        } else {
            d7 = GaugeUtil.valueToPositionDouble(d11, d9, d10, d17, d8);
            d6 = GaugeUtil.valueToPositionDouble(d12, d9, d10, d17, d8);
        }
        if (bl) {
            d5 = d7;
            d4 = d6 - d5;
            d3 = d13 + d14 * this.innerExtent;
            d2 = d14 * (this.outerExtent - this.innerExtent);
            if (!bl2) {
                d5 = d6;
                d4 = -d4;
            }
        } else {
            d3 = d7;
            d2 = d6 - d3;
            d5 = d15 + d16 * this.innerExtent;
            d4 = d16 * (this.outerExtent - this.innerExtent);
            if (bl2) {
                d3 = d6;
                d2 = -d2;
            }
        }
        return new Rectangle2D.Double(d3, d5, d2, d4);
    }

    public void paintComponent(Graphics graphics) {
        JCLinearScale jCLinearScale = this.getLinearScale();
        double d2 = jCLinearScale.getMin();
        double d3 = jCLinearScale.getMax();
        double d4 = GaugeUtil.clamp(this.startValue, d2, d3);
        double d5 = GaugeUtil.clamp(this.stopValue, d2, d3);
        if (!this.isVisible() || d2 >= d3 || this.innerExtent >= this.outerExtent || d4 >= d5) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = null;
        RenderProperties renderProperties = GraphicsUtil.getRenderPropertiesParent(this);
        if (renderProperties != null) {
            object = GraphicsUtil.setAntiAliasing(graphics2D, renderProperties.getAntiAliasing());
        }
        Rectangle2D rectangle2D = this.getLinearRangeSize(jCLinearScale, jCLinearScale.getScaleSize());
        this.drawBackgroundForeground(graphics, rectangle2D);
        if (renderProperties != null && object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    public void redraw() {
        JCGauge jCGauge = this.getLinearScale().getGauge();
        if (jCGauge != null && jCGauge.getRepaintEnabled()) {
            jCGauge.repaint();
        }
    }

    public PortableImage getPortableForegroundImage() {
        return this.foregroundImage;
    }

    public void setPortableForegroundImage(PortableImage portableImage) {
        this.foregroundImage = portableImage;
        this.redraw();
    }

    public void setForegroundImage(Image image) {
        if (this.foregroundImage == null) {
            this.foregroundImage = new PortableImage(image);
        } else {
            this.foregroundImage.setImage(image);
        }
        this.redraw();
    }

    public void setForegroundImage(URL uRL) {
        ImageIcon imageIcon;
        if (uRL != null && (imageIcon = new ImageIcon(uRL)).getImageLoadStatus() == 8) {
            this.setForegroundImage(imageIcon.getImage());
        }
    }

    public Image getForegroundImage() {
        if (this.foregroundImage == null) {
            return null;
        }
        return this.foregroundImage.getImage();
    }

    public OutputProperties getForegroundImageOutputProperties() {
        if (this.foregroundImage == null) {
            this.foregroundImage = new PortableImage();
        }
        return this.foregroundImage.getOutputProperties();
    }

    public void setForegroundImageOutputProperties(OutputProperties outputProperties) {
        if (this.foregroundImage == null) {
            this.foregroundImage = new PortableImage();
        }
        this.foregroundImage.setOutputProperties(outputProperties);
    }

    public JCFillStyle getForegroundFillStyle() {
        return this.foregroundFillStyle;
    }

    public void setForegroundFillStyle(JCFillStyle jCFillStyle) {
        this.foregroundFillStyle = jCFillStyle;
    }

    public void setForegroundCoverage(double d2) {
        if (this.foregroundCoverage < 0.0 || this.foregroundCoverage > 1.0) {
            String string = LocaleBundle.string("Foreground coverage must be between 0 and 1");
            throw new IllegalArgumentException(string);
        }
        this.foregroundCoverage = d2;
        this.redraw();
    }

    public double getForegroundCoverage() {
        return this.foregroundCoverage;
    }

    public void setMaskOrientation(JCLinearScale.Orientation orientation) {
        if (orientation != JCLinearScale.Orientation.HORIZONTAL && orientation != JCLinearScale.Orientation.VERTICAL) {
            String string = LocaleBundle.string("Mask orientation must be one of JCLinearScale.Orientation.HORIZONTAL or JCLinearScale.Orientation.VERTICAL");
            throw new IllegalArgumentException(string);
        }
        this.maskOrientation = orientation;
        this.redraw();
    }

    public JCLinearScale.Orientation getMaskOrientation() {
        return this.maskOrientation;
    }

    protected void drawBackgroundForeground(Graphics graphics, Rectangle2D rectangle2D) {
        Object object;
        if (graphics == null || rectangle2D == null || rectangle2D.getWidth() < 0.0 || rectangle2D.getHeight() < 0.0) {
            return;
        }
        JCLabel jCLabel = null;
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        boolean bl = this.image != null && this.image.getImage() != null;
        boolean bl2 = bl && this.image.isImageScaled();
        Color color = this.getBackground();
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fill(new Rectangle2D.Double(d2, d3, d4, d5));
        }
        if (this.fillStyle != null) {
            this.fillStyle.updateAnchorRect(rectangle2D);
            this.fillStyle.fillRect((Graphics)graphics2D, d2, d3, d4, d5);
            this.fillStyle.updateAnchorRect(null);
        }
        if (bl) {
            object = this.image.getImage();
            jCLabel = new JCLabel();
            if (!bl2) {
                d4 = ((Image)object).getWidth(jCLabel);
                d5 = ((Image)object).getHeight(jCLabel);
                if (d4 > 0.0 && d5 > 0.0) {
                    d2 -= (d4 - rectangle2D.getWidth()) / 2.0;
                    d3 -= (d5 - rectangle2D.getHeight()) / 2.0;
                }
            }
            if (d4 > 0.0 && d5 > 0.0) {
                graphics2D.drawImage((Image)object, (int)d2, (int)d3, (int)d4, (int)d5, jCLabel);
            } else {
                d4 = rectangle2D.getWidth();
                d5 = rectangle2D.getHeight();
            }
        }
        if (this.foregroundCoverage > 0.0) {
            Object object2;
            object = (Rectangle)graphics2D.getClip();
            Rectangle2D.Double double_ = this.maskOrientation == JCLinearScale.Orientation.HORIZONTAL ? new Rectangle2D.Double(d2, d3, d4 * this.foregroundCoverage, d5) : new Rectangle2D.Double(d2, d3, d4, d5 * this.foregroundCoverage);
            graphics2D.setClip(double_);
            boolean bl3 = true;
            Color color2 = this.getForeground();
            if (this.foregroundImage != null && this.foregroundImage.getImage() != null) {
                object2 = this.foregroundImage.getImage();
                if (jCLabel == null) {
                    jCLabel = new JCLabel();
                }
                if (!bl) {
                    bl2 = this.foregroundImage.isImageScaled();
                }
                if (!bl2) {
                    d2 = rectangle2D.getX();
                    d3 = rectangle2D.getY();
                    d4 = ((Image)object2).getWidth(jCLabel);
                    d5 = ((Image)object2).getHeight(jCLabel);
                    if (d4 > 0.0 && d5 > 0.0) {
                        d2 -= (d4 - rectangle2D.getWidth()) / 2.0;
                        d3 -= (d5 - rectangle2D.getHeight()) / 2.0;
                    }
                }
                if (d4 > 0.0 && d5 > 0.0) {
                    if (color2 != null) {
                        graphics2D.drawImage((Image)object2, (int)d2, (int)d3, (int)d4, (int)d5, color2, jCLabel);
                    } else {
                        graphics2D.drawImage((Image)object2, (int)d2, (int)d3, (int)d4, (int)d5, jCLabel);
                    }
                    bl3 = false;
                } else {
                    d4 = rectangle2D.getWidth();
                    d5 = rectangle2D.getHeight();
                }
            }
            if (bl3) {
                object2 = new Rectangle2D.Double(d2, d3, d4, d5);
                if (this.foregroundFillStyle != null) {
                    this.foregroundFillStyle.updateAnchorRect((Rectangle2D)object2);
                    this.foregroundFillStyle.fillRect((Graphics)graphics2D, d2, d3, d4, d5);
                    this.foregroundFillStyle.updateAnchorRect(null);
                } else if (color2 != null) {
                    graphics2D.setColor(color2);
                    graphics2D.fill((Shape)object2);
                }
            }
            graphics2D.setClip((Shape)object);
        }
        graphics2D.dispose();
    }
}

