/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge;

import com.klg.jclass.gauge.JCCircularGauge;
import com.klg.jclass.gauge.JCGauge;
import com.klg.jclass.gauge.LinearConstraint;
import com.klg.jclass.gauge.LinearLayout;
import com.klg.jclass.gauge.RadialConstraint;
import com.klg.jclass.gauge.RadialLayout;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.graphics.GraphicsUtil;
import com.klg.jclass.util.style.JCFillStyle;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.Serializable;
import javax.swing.JComponent;

public class JCGaugeArea
extends JComponent
implements Serializable {
    static final long serialVersionUID = 2667771882493917459L;
    protected JCGauge gauge;
    protected boolean isCircularGauge;
    protected JCFillStyle fillStyle = null;
    private transient Graphics prevSetGraphics = null;
    private ImageMapInfo imageMapInfo = null;

    protected JCGaugeArea(JCGauge jCGauge) {
        this.isCircularGauge = jCGauge instanceof JCCircularGauge;
        if (this.isCircularGauge) {
            this.setLayout(new RadialLayout());
        } else {
            this.setLayout(new LinearLayout());
        }
        this.setOpaque(false);
        this.gauge = jCGauge;
    }

    public Component add(Component component) {
        if (this.isCircularGauge) {
            this.add(component, new RadialConstraint(this.gauge, Double.MAX_VALUE, Double.MAX_VALUE));
        } else {
            this.add(component, new LinearConstraint(this.gauge, Double.MAX_VALUE, Double.MAX_VALUE));
        }
        return component;
    }

    public Component add(Component component, int n2) {
        if (this.isCircularGauge) {
            this.add(component, new RadialConstraint(this.gauge, Double.MAX_VALUE, Double.MAX_VALUE), n2);
        } else {
            this.add(component, new LinearConstraint(this.gauge, Double.MAX_VALUE, Double.MAX_VALUE), n2);
        }
        return component;
    }

    public JCFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        if (this.fillStyle != null) {
            this.fillStyle.parent = null;
        }
        this.fillStyle = jCFillStyle;
        if (this.fillStyle != null) {
            this.fillStyle.parent = this;
        }
        this.repaint();
    }

    protected void paintChildren(Graphics graphics) {
        if (this.gauge != null && !this.gauge.inServerPaint) {
            super.paintChildren(graphics);
        }
    }

    public void paintComponent(Graphics graphics) {
        if (graphics == null || !this.isVisible()) {
            return;
        }
        if (this.isOpaque()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = null;
            RenderProperties renderProperties = GraphicsUtil.getRenderPropertiesParent(this);
            if (renderProperties != null) {
                object = GraphicsUtil.setAntiAliasing(graphics2D, renderProperties.getAntiAliasing());
            }
            if (!graphics2D.getColor().equals(this.getBackground())) {
                graphics2D.setColor(this.getBackground());
            }
            Rectangle rectangle = this.getBounds();
            rectangle.setLocation(0, 0);
            graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
            if (this.fillStyle != null) {
                Insets insets = this.getInsets();
                int n2 = Math.max(0, rectangle.width - insets.left - insets.right);
                int n3 = Math.max(0, rectangle.height - insets.top - insets.bottom);
                Rectangle rectangle2 = new Rectangle(insets.left, insets.top, n2, n3);
                this.fillStyle.updateAnchorRect(rectangle2);
                this.fillStyle.fillRect((Graphics)graphics2D, insets.left, insets.top, n2, n3);
                this.fillStyle.updateAnchorRect(null);
            }
            if (renderProperties != null && object != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            }
        }
    }

    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics.create();
    }

    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
    }

    public void setImageMapInfo(ImageMapInfo imageMapInfo) {
        this.imageMapInfo = imageMapInfo;
    }

    public ImageMapInfo getImageMapInfo() {
        return this.imageMapInfo;
    }
}

