/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge;

import com.klg.jclass.gauge.DefaultLegendPopulatorRenderer;
import com.klg.jclass.gauge.GaugeConstraint;
import com.klg.jclass.gauge.JCAbstractIndicator;
import com.klg.jclass.gauge.JCAbstractNeedle;
import com.klg.jclass.gauge.JCAbstractRange;
import com.klg.jclass.gauge.JCAbstractTick;
import com.klg.jclass.gauge.JCGaugeArea;
import com.klg.jclass.gauge.JCGaugePickEvent;
import com.klg.jclass.gauge.JCGaugePickListener;
import com.klg.jclass.gauge.JCIndicator;
import com.klg.jclass.gauge.JCNeedle;
import com.klg.jclass.gauge.JCRange;
import com.klg.jclass.gauge.JCScale;
import com.klg.jclass.gauge.JCTick;
import com.klg.jclass.swing.JCVersion;
import com.klg.jclass.util.Changeable;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.ServerRenderable;
import com.klg.jclass.util.ServerRenderer;
import com.klg.jclass.util.graphics.GraphicsUtil;
import com.klg.jclass.util.graphics.JCFont;
import com.klg.jclass.util.graphics.JCFontMetrics;
import com.klg.jclass.util.io.OutputProperties;
import com.klg.jclass.util.io.PortableImage;
import com.klg.jclass.util.label.JCLabel;
import com.klg.jclass.util.legend.JCGridLegend;
import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.legend.JCLegendItem;
import com.klg.jclass.util.legend.LegendComponentLayout;
import com.klg.jclass.util.legend.LegendComponentLayoutUser;
import com.klg.jclass.util.style.JCFillStyle;
import com.klg.jclass.util.swing.ToolTipUser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCGauge
extends JComponent
implements MouseListener,
MouseMotionListener,
LegendComponentLayoutUser,
ToolTipUser,
ServerRenderable,
Serializable,
Accessible,
Changeable,
RenderProperties {
    static final long serialVersionUID = 1763099717300034832L;
    public static boolean generateLicenseExceptions = false;
    public static boolean errorMessagesPrinted = false;
    protected JCGaugeArea gaugeArea;
    protected JComponent header;
    protected JComponent footer;
    protected JCLegend legend;
    protected JCScale scale;
    protected Vector<JCIndicator> indicators;
    protected Vector<JCNeedle> needles;
    protected Vector<JComponent> labels = new Vector();
    protected Vector<GaugeConstraint> constraints = new Vector();
    protected JCListenerList pickListeners = null;
    protected JCNeedle draggedNeedle = null;
    protected boolean snapToValue = false;
    protected boolean repaintEnabled = true;
    protected Rectangle gaugeAreaLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle legendLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle headerLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle footerLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected JCFillStyle fillStyle = null;
    protected PortableImage image = null;
    protected transient Graphics prevSetGraphics = null;
    protected JComponent.AccessibleJComponent accessibleContext = null;
    protected boolean registeredForToolTips = false;
    protected ImageMapInfo imageMapInfo = null;
    protected ImageMapInfo headerImageMapInfo = null;
    protected ImageMapInfo footerImageMapInfo = null;
    protected HashMap<JLabel, ImageMapInfo> labelImageMapInfos = null;
    protected int antiAliasing = 0;
    private boolean usingDoublePixels = false;
    protected boolean inServerPaint = false;

    public JCGauge() {
        this.init();
    }

    private void init() {
        this.setLayout(new LegendComponentLayout());
        this.header = new JCLabel();
        this.header.setVisible(false);
        this.add(this.header);
        this.gaugeArea = new JCGaugeArea(this);
        this.add(this.gaugeArea);
        this.footer = new JCLabel();
        this.footer.setVisible(false);
        this.add(this.footer);
        this.legend = new JCGridLegend();
        this.legend.setVisible(false);
        this.add(this.legend);
        this.indicators = new Vector();
        this.needles = new Vector();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public boolean getSnapToValue() {
        return this.snapToValue;
    }

    public boolean isSnapToValue() {
        return this.snapToValue;
    }

    public void setSnapToValue(boolean bl) {
        this.snapToValue = bl;
    }

    public void addIndicator(JCAbstractIndicator jCAbstractIndicator) {
        this.addIndicator(jCAbstractIndicator, 0);
    }

    public void addIndicator(JCAbstractIndicator jCAbstractIndicator, int n2) {
        this.indicators.addElement(jCAbstractIndicator);
        this.gaugeArea.add((Component)jCAbstractIndicator, n2);
    }

    public void removeIndicator(JCAbstractIndicator jCAbstractIndicator) {
        if (this.indicators.contains(jCAbstractIndicator)) {
            this.indicators.removeElement(jCAbstractIndicator);
            this.gaugeArea.remove(jCAbstractIndicator);
        }
    }

    public Vector<JCIndicator> getIndicators() {
        return this.indicators;
    }

    public JCAbstractIndicator getIndicator(int n2) {
        if (this.indicators == null || this.indicators.size() <= n2) {
            return null;
        }
        return (JCAbstractIndicator)this.indicators.get(n2);
    }

    protected void setIndicatorScales(JCScale jCScale) {
        if (this.indicators != null) {
            Enumeration<JCIndicator> enumeration = this.indicators.elements();
            while (enumeration.hasMoreElements()) {
                JCAbstractIndicator jCAbstractIndicator = (JCAbstractIndicator)enumeration.nextElement();
                jCAbstractIndicator.setScale(jCScale);
            }
        }
    }

    public void addNeedle(JCAbstractNeedle jCAbstractNeedle) {
        this.addNeedle(jCAbstractNeedle, 0);
    }

    public void addNeedle(JCAbstractNeedle jCAbstractNeedle, int n2) {
        this.needles.addElement(jCAbstractNeedle);
        this.gaugeArea.add((Component)jCAbstractNeedle, n2);
    }

    public void removeNeedle(JCAbstractNeedle jCAbstractNeedle) {
        if (this.needles.contains(jCAbstractNeedle)) {
            this.needles.removeElement(jCAbstractNeedle);
            this.gaugeArea.remove(jCAbstractNeedle);
        }
    }

    protected void setNeedleScales(JCScale jCScale) {
        if (this.needles != null) {
            for (JCNeedle jCNeedle : this.needles) {
                JCAbstractNeedle jCAbstractNeedle = (JCAbstractNeedle)jCNeedle;
                jCAbstractNeedle.setScale(jCScale);
            }
        }
    }

    public Vector<JCNeedle> getNeedles() {
        return this.needles;
    }

    public JCAbstractNeedle getNeedle(int n2) {
        if (this.needles == null || this.needles.size() <= n2) {
            return null;
        }
        return (JCAbstractNeedle)this.needles.get(n2);
    }

    public Vector<JComponent> getLabels() {
        return this.labels;
    }

    public Vector<GaugeConstraint> getConstraints() {
        return this.constraints;
    }

    public void addTick(JCTick jCTick) {
        if (this.scale == null) {
            return;
        }
        this.scale.addTick(jCTick);
    }

    public void addTick(JCTick jCTick, int n2) {
        if (this.scale == null) {
            return;
        }
        this.scale.addTick(jCTick, n2);
    }

    public void removeTick(JCTick jCTick) {
        if (this.scale == null) {
            return;
        }
        this.scale.removeTick(jCTick);
    }

    public Vector<JCTick> getTicks() {
        if (this.scale == null) {
            return null;
        }
        return this.scale.getTicks();
    }

    public JCAbstractTick getTick(int n2) {
        if (this.scale == null || this.scale.getTicks().size() <= n2) {
            return null;
        }
        return (JCAbstractTick)this.scale.getTicks().get(n2);
    }

    public void addRange(JCRange jCRange) {
        if (this.scale == null) {
            return;
        }
        this.scale.addRange(jCRange);
    }

    public void addRange(JCRange jCRange, int n2) {
        if (this.scale == null) {
            return;
        }
        this.scale.addRange(jCRange, n2);
    }

    public void removeRange(JCRange jCRange) {
        if (this.scale == null) {
            return;
        }
        this.scale.removeRange(jCRange);
    }

    public Vector<JCRange> getRanges() {
        if (this.scale == null) {
            return null;
        }
        return this.scale.getRanges();
    }

    public JCAbstractRange getRange(int n2) {
        if (this.scale == null || this.scale.getRanges().size() <= n2) {
            return null;
        }
        return (JCAbstractRange)this.scale.getRanges().get(n2);
    }

    public JCScale getScale() {
        return this.scale;
    }

    @Override
    public JCLegend getLegend() {
        return this.legend;
    }

    @Override
    public void setLegend(JCLegend jCLegend) {
        if (jCLegend == null) {
            return;
        }
        if (this.legend != null) {
            this.remove(this.legend);
        }
        this.legend = jCLegend;
        DefaultLegendPopulatorRenderer defaultLegendPopulatorRenderer = new DefaultLegendPopulatorRenderer(this.legend, this.scale.getRanges());
        if (this.legend.getLegendPopulator() == null) {
            this.legend.setLegendPopulator(defaultLegendPopulatorRenderer);
        }
        if (this.legend.getLegendRenderer() == null) {
            this.legend.setLegendRenderer(defaultLegendPopulatorRenderer);
        }
        this.add(this.legend);
    }

    public JCGaugeArea getGaugeArea() {
        return this.gaugeArea;
    }

    public void setGaugeArea(JCGaugeArea jCGaugeArea) {
        if (jCGaugeArea == null) {
            return;
        }
        if (this.gaugeArea != null) {
            this.remove(this.gaugeArea);
        }
        this.gaugeArea = jCGaugeArea;
        this.add(this.gaugeArea);
    }

    public void setRepaintEnabled(boolean bl) {
        this.repaintEnabled = bl;
        if (bl) {
            this.repaint();
        }
    }

    public boolean getRepaintEnabled() {
        return this.repaintEnabled;
    }

    public JCGaugePickEvent pick(Point point) {
        JCGaugePickEvent jCGaugePickEvent;
        Component component = this.getComponentAt(point.x, point.y);
        if (component == null) {
            return null;
        }
        Point point2 = new Point(point.x - component.getLocation().x, point.y - component.getLocation().y);
        if (component instanceof JCGaugeArea) {
            double d2 = this.scale.pick(point2);
            if (this.snapToValue) {
                d2 = Math.round(d2);
            }
            if (!this.scale.inBounds((jCGaugePickEvent = new JCGaugePickEvent(this, component, d2, point2)).getValue())) {
                jCGaugePickEvent = null;
            }
        } else {
            JCLegendItem jCLegendItem;
            JCLegend jCLegend;
            jCGaugePickEvent = component instanceof JCLegend ? new JCGaugePickEvent(this, jCLegend, Double.MAX_VALUE, point2, (jCLegendItem = (jCLegend = (JCLegend)component).pick(point2)) == null ? null : jCLegendItem.itemInfo) : new JCGaugePickEvent(this, component, Double.MAX_VALUE, point2);
        }
        return jCGaugePickEvent;
    }

    public void addPickListener(JCGaugePickListener jCGaugePickListener) {
        this.pickListeners = JCListenerList.add(this.pickListeners, jCGaugePickListener);
    }

    public void removePickListener(JCGaugePickListener jCGaugePickListener) {
        this.pickListeners = JCListenerList.remove(this.pickListeners, jCGaugePickListener);
    }

    public void sendPickEvent(JCGaugePickEvent jCGaugePickEvent) {
        Enumeration<Object> enumeration = JCListenerList.elements(this.pickListeners);
        while (enumeration.hasMoreElements()) {
            ((JCGaugePickListener)enumeration.nextElement()).pick(jCGaugePickEvent);
        }
    }

    @Override
    public JComponent getHeader() {
        return this.header;
    }

    public void setHeader(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        if (this.header != null) {
            this.remove(this.header);
        }
        this.header = jComponent;
        this.add(this.header);
    }

    @Override
    public JComponent getFooter() {
        return this.footer;
    }

    public void setFooter(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        if (this.footer != null) {
            this.remove(this.footer);
        }
        this.footer = jComponent;
        this.add(this.footer);
    }

    @Override
    public int getDrawingAreaHeight() {
        int n2 = 0;
        Insets insets = this.getInsets();
        if (insets != null) {
            n2 = insets.top + insets.bottom;
        }
        return Math.max(0, this.getSize().height - n2);
    }

    @Override
    public int getDrawingAreaWidth() {
        int n2 = 0;
        Insets insets = this.getInsets();
        if (insets != null) {
            n2 = insets.left + insets.right;
        }
        return Math.max(0, this.getSize().width - n2);
    }

    @Override
    public Rectangle getLayoutHints(JComponent jComponent) {
        if (jComponent == this.gaugeArea) {
            return this.gaugeAreaLayoutHints;
        }
        if (jComponent == this.legend) {
            return this.legendLayoutHints;
        }
        if (jComponent == this.header) {
            return this.headerLayoutHints;
        }
        if (jComponent == this.footer) {
            return this.footerLayoutHints;
        }
        return null;
    }

    @Override
    public void setLayoutHints(JComponent jComponent, Rectangle rectangle) {
        if (jComponent == null) {
            return;
        }
        if (jComponent == this.gaugeArea) {
            this.gaugeAreaLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (jComponent == this.legend) {
            this.legendLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (jComponent == this.header) {
            this.headerLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (jComponent == this.footer) {
            this.footerLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        jComponent.invalidate();
        this.validate();
    }

    @Override
    public JComponent getComponentArea() {
        return this.getGaugeArea();
    }

    @Override
    public Color getForeground() {
        Color color = super.getForeground();
        if (color == null) {
            color = Color.black;
        }
        return color;
    }

    public JCFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        if (this.fillStyle != null) {
            this.fillStyle.parent = null;
        }
        this.fillStyle = jCFillStyle;
        if (this.fillStyle != null) {
            this.fillStyle.parent = this;
        }
        this.redraw();
    }

    public PortableImage getPortableImage() {
        return this.image;
    }

    public void setPortableImage(PortableImage portableImage) {
        this.image = portableImage;
        this.redraw();
    }

    public Image getImage() {
        if (this.image == null) {
            return null;
        }
        return this.image.getImage();
    }

    public void setImage(Image image) {
        if (this.image == null) {
            this.image = new PortableImage(image);
        } else {
            this.image.setImage(image);
        }
        this.redraw();
    }

    public void setImage(URL uRL) {
        ImageIcon imageIcon;
        if (uRL != null && (imageIcon = new ImageIcon(uRL)).getImageLoadStatus() == 8) {
            this.setImage(imageIcon.getImage());
        }
    }

    public boolean isImageScaled() {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        return this.image.isImageScaled();
    }

    public void setImageScaled(boolean bl) {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        this.image.setImageScaled(bl);
        this.redraw();
    }

    public OutputProperties getImageOutputProperties() {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        return this.image.getOutputProperties();
    }

    public void setImageOutputProperties(OutputProperties outputProperties) {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        this.image.setOutputProperties(outputProperties);
    }

    protected void drawImage(Graphics graphics, PortableImage portableImage, Rectangle rectangle) {
        if (portableImage == null || portableImage.getImage() == null) {
            return;
        }
        JCLabel jCLabel = new JCLabel();
        rectangle = GraphicsUtil.getDrawingArea(this, rectangle);
        Image image = portableImage.getImage();
        if (portableImage.isImageScaled()) {
            graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, jCLabel);
        } else {
            int n2 = image.getWidth(jCLabel);
            int n3 = image.getHeight(jCLabel);
            if (n2 > 0 && n3 > 0) {
                int n4 = rectangle.x - (n2 - rectangle.width) / 2;
                int n5 = rectangle.y - (n3 - rectangle.height) / 2;
                graphics.drawImage(image, n4, n5, n2, n3, jCLabel);
            }
        }
    }

    public abstract void redraw();

    @Override
    public abstract AccessibleContext getAccessibleContext();

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.draggedNeedle = null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        JCGaugePickEvent jCGaugePickEvent = this.pick(mouseEvent.getPoint());
        this.sendPickEvent(jCGaugePickEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        JCGaugePickEvent jCGaugePickEvent = this.pick(mouseEvent.getPoint());
        this.sendPickEvent(jCGaugePickEvent);
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public void setAbout(String string) {
    }

    public static void printErrorMessages(String string, String string2, String[] stringArray) {
        if (!errorMessagesPrinted) {
            if (string != null) {
                System.err.println(string);
            }
            if (string2 != null) {
                System.err.println(string2);
            }
            if (stringArray != null) {
                for (String string3 : stringArray) {
                    if (string3 == null) continue;
                    System.err.println(string3);
                }
            }
            errorMessagesPrinted = true;
        }
    }

    @Override
    public void registerForTooltips() {
        if (this.registeredForToolTips) {
            return;
        }
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.registeredForToolTips = true;
    }

    @Override
    public void unregisterForTooltips(Object object) {
        if (!this.registeredForToolTips) {
            return;
        }
        if (this.getToolTipText() == null) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.unregisterComponent(this);
        }
        this.registeredForToolTips = false;
    }

    @Override
    public void setToolTipText(String string) {
        super.setToolTipText(string);
        if (string == null && this.registeredForToolTips) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.registerComponent(this);
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        JCFont jCFont;
        JCFontMetrics jCFontMetrics;
        if (font instanceof JCFont && (jCFontMetrics = (jCFont = (JCFont)((Object)font)).getJCFontMetrics()) != null) {
            return jCFontMetrics.getEncoderFontMetrics();
        }
        return super.getFontMetrics(font);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        JCLegend jCLegend;
        Component component = this.getComponentAt(mouseEvent.getX(), mouseEvent.getY());
        if (component instanceof JCLegend && (jCLegend = (JCLegend)component).isItemTextToolTipEnabled()) {
            Point point = component.getLocation();
            MouseEvent mouseEvent2 = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - point.x, mouseEvent.getY() - point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            return jCLegend.getToolTipText(mouseEvent2);
        }
        return super.getToolTipText(mouseEvent);
    }

    @Override
    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics.create();
    }

    @Override
    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
        this.getGaugeArea().setGraphics(graphics);
        this.getLegend().setGraphics(graphics);
    }

    @Override
    public Image serverSnapshot() {
        return ServerRenderer.snapshot(this);
    }

    @Override
    public void serverPaint(Graphics graphics) {
        this.inServerPaint = true;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = GraphicsUtil.setAntiAliasing(graphics2D, this.antiAliasing);
        ServerRenderer.paintComponent(graphics, this);
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
        this.inServerPaint = false;
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        if (!this.inServerPaint) {
            super.paintChildren(graphics);
        }
    }

    public void setImageMapInfo(ImageMapInfo imageMapInfo) {
        this.imageMapInfo = imageMapInfo;
    }

    public ImageMapInfo getImageMapInfo() {
        return this.imageMapInfo;
    }

    public ImageMapInfo getFooterImageMapInfo() {
        return this.footerImageMapInfo;
    }

    public void setFooterImageMapInfo(ImageMapInfo imageMapInfo) {
        this.footerImageMapInfo = imageMapInfo;
    }

    public ImageMapInfo getHeaderImageMapInfo() {
        return this.headerImageMapInfo;
    }

    public void setHeaderImageMapInfo(ImageMapInfo imageMapInfo) {
        this.headerImageMapInfo = imageMapInfo;
    }

    public void addLabelImageMapInfo(JLabel jLabel, ImageMapInfo imageMapInfo) {
        if (this.labelImageMapInfos == null) {
            this.labelImageMapInfos = new HashMap();
        }
        this.labelImageMapInfos.put(jLabel, imageMapInfo);
    }

    public HashMap<JLabel, ImageMapInfo> getLabelImageMapInfoMap() {
        return this.labelImageMapInfos;
    }

    public ImageMapInfo getLabelImageMapInfo(JLabel jLabel) {
        ImageMapInfo imageMapInfo = null;
        if (jLabel != null && this.labelImageMapInfos != null) {
            imageMapInfo = this.labelImageMapInfos.get(jLabel);
        }
        return imageMapInfo;
    }

    @Override
    public void setUsingDoublePixels(boolean bl) {
        this.usingDoublePixels = bl;
    }

    @Override
    public boolean isUsingDoublePixels() {
        return this.usingDoublePixels;
    }

    @Override
    public int getAntiAliasing() {
        return this.antiAliasing;
    }

    @Override
    public void setAntiAliasing(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("The antiAliasing value must be one of ANTI_ALIASING_DEFAULT,ANTI_ALIASING_ON, or ANTI_ALIASING_OFF");
        }
        if (this.antiAliasing == n2) {
            return;
        }
        this.antiAliasing = n2;
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = GraphicsUtil.setAntiAliasing(graphics2D, this.antiAliasing);
        super.paint(graphics2D);
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
    }

    @Override
    public boolean getChanged() {
        return false;
    }

    @Override
    public boolean getChanged(int n2) {
        return false;
    }

    @Override
    public boolean isChanged() {
        return false;
    }

    @Override
    public boolean isChanged(int n2) {
        return false;
    }

    @Override
    public void setChanged(boolean bl, int n2) {
    }

    @Override
    public void setChanged(boolean bl, int n2, boolean bl2) {
    }

    @Override
    public boolean isBatched() {
        return !this.repaintEnabled;
    }
}

