/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge;

import com.klg.jclass.gauge.GaugeUtil;
import com.klg.jclass.gauge.JCAbstractScale;
import com.klg.jclass.gauge.JCAbstractTick;
import com.klg.jclass.gauge.JCCircularScale;
import com.klg.jclass.gauge.JCGauge;
import com.klg.jclass.gauge.JCTickStyle;
import com.klg.jclass.gauge.RadialConstraint;
import com.klg.jclass.gauge.RadialLayout;
import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.graphics.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.JComponent;

public class JCCircularTick
extends JCAbstractTick
implements Serializable {
    static final long serialVersionUID = -5247737898082678005L;

    public JCCircularTick(JCCircularScale jCCircularScale) {
        super(jCCircularScale, jCCircularScale.getMin(), jCCircularScale.getMax());
        this.setLayout(new RadialLayout());
    }

    public JCCircularTick(JCCircularScale jCCircularScale, boolean bl, double d2, double d3, double d4, boolean bl2, int n2, double d5, boolean bl3, boolean bl4, double d6, double d7, double d8, Color color, JCTickStyle jCTickStyle, Font font, Color color2) {
        super(jCCircularScale, bl, d2, d3, d4, bl2, n2, d5, bl3, bl4, d6, d7, d8, color, jCTickStyle, font, color2);
        this.setLayout(new RadialLayout());
    }

    public JCCircularScale getCircularScale() {
        return (JCCircularScale)this.getScale();
    }

    public Dimension getPreferredSize() {
        return this.getCircularScale().getPreferredSize();
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        super.setBounds(n2, n3, n4, n5);
        this.redrawLabels();
    }

    public void calcCircularTicks(Graphics graphics) {
        JCCircularScale jCCircularScale = this.getCircularScale();
        double d2 = GaugeUtil.normalizeAngle(jCCircularScale.getStartAngle());
        double d3 = GaugeUtil.normalizeAngle(jCCircularScale.getStopAngle());
        double d4 = jCCircularScale.getRadius();
        if (d2 >= d3) {
            d3 += 360.0;
        }
        double d5 = d3 == d2 ? 360.0 : Math.abs(d3 - d2);
        double d6 = this.drawLabels ? this.labelExtent : 1.0;
        int n2 = (int)(GaugeUtil.toRadians(d5) * d4 * d6);
        this.calcTicks(graphics, n2);
    }

    public void redrawLabels() {
        JCCircularScale jCCircularScale = this.getCircularScale();
        JCAbstractScale.Direction direction = jCCircularScale.getDirection();
        if (this.drawLabels) {
            Graphics graphics;
            boolean bl;
            this.removeAll();
            double d2 = jCCircularScale.getMin();
            double d3 = jCCircularScale.getMax();
            double d4 = GaugeUtil.normalizeAngle(jCCircularScale.getStartAngle());
            double d5 = GaugeUtil.normalizeAngle(jCCircularScale.getStopAngle());
            if (d4 >= d5) {
                d5 += 360.0;
            }
            boolean bl2 = bl = d4 == d5;
            if (this.automatic && (graphics = this.getGraphics()) != null) {
                this.calcCircularTicks(graphics);
            }
            double d6 = Math.max(0.0, this.labelExtent);
            double d7 = this.startValue;
            while (d7 <= this.stopValue && d7 <= d3 && this.incrementValue != 0.0) {
                if (d7 < d2) {
                    d7 += this.incrementValue;
                    continue;
                }
                if (bl && this.automatic && (d7 == this.stopValue || 1.0 + Math.abs(this.stopValue - d7) == 1.0)) break;
                double d8 = d7;
                if (direction.equals(JCAbstractScale.Direction.BACKWARD)) {
                    d8 = d3 - d7 + d2;
                }
                double d9 = GaugeUtil.valueToAngle(d8, d2, d3, 0.0, GaugeUtil.arcAngle(d4, d5));
                RadialConstraint radialConstraint = new RadialConstraint(jCCircularScale.getCircularGauge(), d6, d9);
                JComponent jComponent = this.labelGenerator != null ? this.labelGenerator.makeLabel(this, d7, radialConstraint) : this.generateLabel(d7);
                if (jComponent != null) {
                    jComponent.setSize(jComponent.getPreferredSize());
                    this.add((Component)jComponent, radialConstraint);
                }
                d7 += this.incrementValue;
            }
            this.doLayout();
        }
    }

    public void paintComponent(Graphics graphics) {
        JCCircularScale jCCircularScale = this.getCircularScale();
        JCAbstractScale.Direction direction = jCCircularScale.getDirection();
        Rectangle2D.Double double_ = jCCircularScale.getCircularGauge().getArcBounds();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = null;
        RenderProperties renderProperties = GraphicsUtil.getRenderPropertiesParent(this);
        if (renderProperties != null) {
            object = GraphicsUtil.setAntiAliasing(graphics2D, renderProperties.getAntiAliasing());
        }
        super.paintComponent(graphics2D);
        if (this.automatic) {
            this.calcCircularTicks(graphics2D);
        }
        double d2 = jCCircularScale.getMin();
        double d3 = jCCircularScale.getMax();
        double d4 = Math.max(0.0, this.innerExtent);
        double d5 = Math.max(0.0, this.outerExtent);
        if (!this.isVisible() || d2 >= d3 || d4 >= d5 || this.startValue > this.stopValue || this.incrementValue <= 0.0 || this.tickWidth <= 0.0) {
            return;
        }
        double d6 = jCCircularScale.getRadius();
        double d7 = double_.x + d6;
        double d8 = double_.y + d6;
        double d9 = GaugeUtil.normalizeAngle(jCCircularScale.getStartAngle());
        double d10 = GaugeUtil.normalizeAngle(jCCircularScale.getStopAngle());
        double d11 = d4 * d6;
        double d12 = d5 * d6;
        double d13 = this.startValue;
        while (d13 <= this.stopValue && d13 <= d3) {
            if (d13 < d2) {
                d13 += this.incrementValue;
                continue;
            }
            if (this.drawTicks) {
                if (this.tickStyle == JCTickStyle.LINE) {
                    double d14 = d13;
                    if (direction.equals(JCAbstractScale.Direction.BACKWARD)) {
                        d14 = d3 - d13 + d2;
                    }
                    double d15 = GaugeUtil.valueToAngle(d14, d2, d3, d9, d10);
                    double d16 = GaugeUtil.toRadians(d15);
                    double d17 = Math.cos(d16);
                    double d18 = Math.sin(d16);
                    graphics2D.setColor(this.tickColor);
                    double d19 = d7 + d11 * d17;
                    double d20 = d8 - d11 * d18;
                    double d21 = d7 + d12 * d17;
                    double d22 = d8 - d12 * d18;
                    Line2D.Double double_2 = new Line2D.Double(d19, d20, d21, d22);
                    graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                    graphics2D.draw(double_2);
                } else if (this.tickStyle == JCTickStyle.CIRCLE) {
                    GaugeUtil.drawCircleForCircularScale(graphics2D, jCCircularScale, this.tickColor, d13, d4, d5);
                } else {
                    GaugeUtil.drawCircularPolygon(graphics2D, jCCircularScale, this.tickColor, d4, d5, this.tickWidth, d13, this.reversed, true, this.tickStyle);
                }
            }
            d13 += this.incrementValue;
        }
        if (renderProperties != null && object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    public void redraw(boolean bl) {
        JCGauge jCGauge = this.getCircularScale().getGauge();
        if (jCGauge != null && jCGauge.getRepaintEnabled()) {
            if (bl) {
                this.redrawLabels();
            }
            this.revalidate();
            jCGauge.repaint();
        }
    }
}

