/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge;

import com.klg.jclass.gauge.GaugeUtil;
import com.klg.jclass.gauge.JCAbstractScale;
import com.klg.jclass.gauge.JCCircularGauge;
import com.klg.jclass.gauge.JCCircularTick;
import com.klg.jclass.gauge.JCGauge;
import com.klg.jclass.gauge.JCGaugeArea;
import com.klg.jclass.gauge.JCTick;
import com.klg.jclass.gauge.RadialConstraint;
import com.klg.jclass.gauge.RadialLayout;
import com.klg.jclass.gauge.resources.LocaleBundle;
import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.graphics.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class JCCircularScale
extends JCAbstractScale
implements Serializable {
    static final long serialVersionUID = 6835510720826476109L;
    protected double startAngle = 0.0;
    protected double stopAngle = 360.0;
    protected double minSize = 8.0;
    protected boolean paintCompleteBackground = false;
    protected boolean allSpaceUsed = false;

    public JCCircularScale(JCCircularGauge jCCircularGauge) {
        super(jCCircularGauge);
        JCCircularGauge.GaugeType gaugeType = jCCircularGauge.getGaugeType();
        if (gaugeType == JCCircularGauge.GaugeType.LOWER_LEFT_QUARTER_CIRCLE || gaugeType == JCCircularGauge.GaugeType.LOWER_RIGHT_QUARTER_CIRCLE || gaugeType == JCCircularGauge.GaugeType.UPPER_LEFT_QUARTER_CIRCLE || gaugeType == JCCircularGauge.GaugeType.UPPER_RIGHT_QUARTER_CIRCLE) {
            this.setAllSpaceUsed(true);
        }
        this.setLayout(new RadialLayout());
        this.setBackground(Color.white);
        GaugeUtil.createLegendPopulatorRenderer(jCCircularGauge, this);
    }

    public JCCircularScale(JCCircularGauge jCCircularGauge, double d2, double d3) {
        super(jCCircularGauge, d2, d3);
        this.setLayout(new RadialLayout());
        this.setBackground(Color.white);
        GaugeUtil.createLegendPopulatorRenderer(jCCircularGauge, this);
    }

    public JCCircularScale(JCCircularGauge jCCircularGauge, JCAbstractScale.Direction direction, double d2, double d3, double d4, double d5, Color color) {
        super(jCCircularGauge, direction, d2, d3, color);
        this.startAngle = d4;
        this.stopAngle = d5;
        this.setLayout(new RadialLayout());
        GaugeUtil.createLegendPopulatorRenderer(jCCircularGauge, this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getParent().getBounds().width, this.getParent().getBounds().height);
    }

    public Component add(Component component) {
        this.add(component, new RadialConstraint(this.getGauge(), Double.MAX_VALUE, Double.MAX_VALUE));
        return component;
    }

    public Component add(Component component, int n2) {
        this.add(component, new RadialConstraint(this.getGauge(), Double.MAX_VALUE, Double.MAX_VALUE), n2);
        return component;
    }

    public void paintComponent(Graphics graphics) {
        double d2;
        Object object;
        if (!this.isVisible()) {
            return;
        }
        JCCircularGauge jCCircularGauge = this.getCircularGauge();
        Graphics2D graphics2D = (Graphics2D)graphics;
        boolean bl = false;
        for (Class<?> clazz = jCCircularGauge.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            object = clazz.getName();
            if (object == null) continue;
            if (((String)object).equals("com.klg.jclass.sgauge.JCServerCircularGauge")) break;
            if (!((String)object).equals("com.klg.jclass.gauge.JCCircularGauge")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            object = graphics2D.getClipBounds();
            Font font = new Font("Dialog", 1, 12);
            graphics2D.setColor(Color.blue);
            graphics2D.fillRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            graphics2D.setColor(Color.yellow);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            String[] stringArray = new String[]{LocaleBundle.string("Invalid use of JCGauge within JCServerGauge!"), LocaleBundle.string("It is not recommended that JCServerGauge and"), LocaleBundle.string("JCGauge jars be on the same classpath, but if"), LocaleBundle.string("they must, the JCServerGauge jar must be first.")};
            JCGauge.printErrorMessages(null, null, stringArray);
            Rectangle rectangle = fontMetrics.getStringBounds(stringArray[0], graphics2D).getBounds();
            float f2 = (float)(2.0 * rectangle.getHeight());
            float f3 = (float)((double)((Rectangle)object).height / 2.0) - f2 * (float)((double)(stringArray.length + 1) / 2.0);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2] == null) continue;
                rectangle = fontMetrics.getStringBounds(stringArray[i2], graphics2D).getBounds();
                float f4 = (float)(((double)((Rectangle)object).width - rectangle.getWidth()) / 2.0);
                graphics2D.drawString(stringArray[i2], f4, f3 += f2);
            }
            this.makeComponentsInvisible();
            return;
        }
        object = null;
        RenderProperties renderProperties = GraphicsUtil.getRenderPropertiesParent(this);
        if (renderProperties != null) {
            object = GraphicsUtil.setAntiAliasing(graphics2D, renderProperties.getAntiAliasing());
        }
        double d3 = GaugeUtil.normalizeAngle(this.startAngle);
        double d4 = GaugeUtil.normalizeAngle(this.stopAngle);
        if (this.getPaintCompleteBackground()) {
            d3 = jCCircularGauge.getGaugeType().getStartAngle();
            d2 = jCCircularGauge.getGaugeType().getSweepAngle();
        } else {
            if (d3 >= d4) {
                d4 += 360.0;
            }
            d2 = GaugeUtil.arcAngle(d3, d4);
        }
        Rectangle2D.Double double_ = jCCircularGauge.getArcBounds();
        Rectangle2D.Double double_2 = jCCircularGauge.getArcDrawingBounds(double_);
        double d5 = double_.x;
        double d6 = double_.y;
        double d7 = double_.width;
        double d8 = double_.height;
        Arc2D.Double double_3 = new Arc2D.Double(d5, d6, d7, d8, d3, d2, 2);
        if (this.isOpaque()) {
            Color color = this.getBackground();
            if (color != null) {
                graphics2D.setColor(color);
                graphics2D.fill(double_3);
            }
            if (this.fillStyle != null) {
                this.fillStyle.updateAnchorRect(double_2);
                this.fillStyle.fillArc((Graphics)graphics2D, d5, d6, d7, d8, d3, d2);
                this.fillStyle.updateAnchorRect(null);
            }
            GaugeUtil.drawImage(graphics2D, this.image, double_2, double_3, true);
        }
        if (renderProperties != null && object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    private void drawRotatedWatermark(Graphics2D graphics2D, double d2, String string) {
    }

    private void drawDevelopmentWatermark(Graphics2D graphics2D, String string) {
    }

    public double pick(Point point) {
        double d2;
        double d3 = GaugeUtil.normalizeAngle(this.startAngle);
        double d4 = GaugeUtil.normalizeAngle(this.stopAngle);
        boolean bl = this.direction.equals(JCAbstractScale.Direction.BACKWARD);
        JCCircularGauge jCCircularGauge = this.getCircularGauge();
        Rectangle2D.Double double_ = jCCircularGauge.getArcBounds();
        if (d3 == d4) {
            d4 += 360.0;
        }
        double d5 = (double)point.x - double_.x;
        double d6 = (double)point.y - double_.y;
        double d7 = this.getRadius();
        double d8 = d2 = GaugeUtil.pointToAngle(d5, d6, d7, d7);
        if (d2 < d3) {
            d2 += 360.0;
        }
        double d9 = GaugeUtil.angleToValue(d2, this.min, this.max, d3, d4);
        if (bl) {
            d9 = this.max - d9 + this.min;
        }
        if (!this.inBounds(d9)) {
            double d10 = GaugeUtil.distanceBetweenAngles(d8, d3);
            double d11 = GaugeUtil.distanceBetweenAngles(d8, d4);
            d9 = bl ? (d10 <= d11 ? this.max : this.min) : (d10 <= d11 ? this.min : this.max);
        }
        return d9;
    }

    protected Insets getScaleInsets() {
        Container container = this.getParent();
        if (container != null) {
            Insets insets = this.getInsets();
            Insets insets2 = container.getInsets();
            int n2 = Math.max(insets2.top, insets.top);
            int n3 = Math.max(insets2.left, insets.left);
            int n4 = Math.max(insets2.bottom, insets.bottom);
            int n5 = Math.max(insets2.right, insets.right);
            return new Insets(n2, n3, n4, n5);
        }
        return this.getInsets();
    }

    public double getRadius() {
        Rectangle rectangle = this.getGauge().getGaugeArea().getBounds();
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        Insets insets = this.getScaleInsets();
        double d2 = Math.max(this.minSize, (double)Math.min(n2 -= insets.left + insets.right, n3 -= insets.top + insets.bottom));
        JCCircularGauge.GaugeType gaugeType = this.getCircularGauge().getGaugeType();
        if (gaugeType.equals(JCCircularGauge.GaugeType.FULL_CIRCLE)) {
            d2 /= 2.0;
        } else if (gaugeType.equals(JCCircularGauge.GaugeType.TOP_HALF_CIRCLE) || gaugeType.equals(JCCircularGauge.GaugeType.BOTTOM_HALF_CIRCLE)) {
            while (n2 / 2 > n3) {
                --n2;
            }
            d2 = (double)n2 / 2.0;
        } else if (gaugeType.equals(JCCircularGauge.GaugeType.LEFT_HALF_CIRCLE) || gaugeType.equals(JCCircularGauge.GaugeType.RIGHT_HALF_CIRCLE)) {
            while (n3 / 2 > n2) {
                --n3;
            }
            d2 = (double)n3 / 2.0;
        }
        return d2 *= this.zoomFactor;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double d2) {
        this.startAngle = d2;
        this.redraw();
    }

    public double getStopAngle() {
        return this.stopAngle;
    }

    public void setStopAngle(double d2) {
        this.stopAngle = d2;
        this.redraw();
    }

    public JCCircularGauge getCircularGauge() {
        return (JCCircularGauge)this.getGauge();
    }

    public boolean getPaintCompleteBackground() {
        return this.paintCompleteBackground;
    }

    public boolean isAllSpaceUsed() {
        return this.allSpaceUsed;
    }

    public void setAllSpaceUsed(boolean bl) {
        this.allSpaceUsed = bl;
        this.redraw();
    }

    public void setPaintCompleteBackground(boolean bl) {
        this.paintCompleteBackground = bl;
        this.redraw();
    }

    public void redraw() {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (this.gauge != null && this.gauge.getRepaintEnabled()) {
            Vector<JCTick> vector = this.gauge.getTicks();
            if (vector != null) {
                Enumeration<JCTick> enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    JCCircularTick jCCircularTick = (JCCircularTick)enumeration.nextElement();
                    jCCircularTick.redraw(true);
                }
            }
            this.gauge.repaint();
        }
    }

    private void makeComponentsInvisible() {
        int n2;
        JCGauge jCGauge = this.getGauge();
        for (int i2 = 0; i2 < jCGauge.getComponentCount(); ++i2) {
            Component component = jCGauge.getComponent(i2);
            if (component instanceof JCGaugeArea) continue;
            component.setVisible(false);
        }
        JCGaugeArea jCGaugeArea = this.getGauge().getGaugeArea();
        for (n2 = 0; n2 < jCGaugeArea.getComponentCount(); ++n2) {
            Component component = jCGaugeArea.getComponent(n2);
            if (component instanceof JCCircularScale) continue;
            component.setVisible(false);
        }
        for (n2 = 0; n2 < this.getComponentCount(); ++n2) {
            this.getComponent(n2).setVisible(false);
        }
    }
}

