/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge;

import com.klg.jclass.gauge.AccessibleGaugeRole;
import com.klg.jclass.gauge.AccessibleGaugeState;
import com.klg.jclass.gauge.AccessibleValueState;
import com.klg.jclass.gauge.GaugeUtil;
import com.klg.jclass.gauge.JCAbstractNeedle;
import com.klg.jclass.gauge.JCAbstractScale;
import com.klg.jclass.gauge.JCCenter;
import com.klg.jclass.gauge.JCCircularNeedle;
import com.klg.jclass.gauge.JCCircularScale;
import com.klg.jclass.gauge.JCCircularTick;
import com.klg.jclass.gauge.JCGauge;
import com.klg.jclass.gauge.JCGaugeArea;
import com.klg.jclass.gauge.JCGaugePickEvent;
import com.klg.jclass.gauge.JCIndicatorStyle;
import com.klg.jclass.gauge.JCNeedle;
import com.klg.jclass.gauge.RadialConstraint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;

public class JCCircularGauge
extends JCGauge {
    static final long serialVersionUID = -5471322510947631802L;
    protected GaugeType gaugeType = GaugeType.FULL_CIRCLE;
    protected JCCenter center;

    public JCCircularGauge() {
        JCCircularScale jCCircularScale = new JCCircularScale(this);
        this.setScale(jCCircularScale, false);
        JCCenter jCCenter = new JCCenter(jCCircularScale);
        this.setCenter(jCCenter);
        JCCircularNeedle jCCircularNeedle = new JCCircularNeedle(jCCircularScale);
        this.addNeedle(jCCircularNeedle);
        JCCircularTick jCCircularTick = new JCCircularTick(jCCircularScale);
        this.addTick(jCCircularTick);
        this.gaugeArea.add(jCCircularScale);
        this.setPreferredSize(new Dimension(300, 300));
    }

    public JCCircularGauge(boolean bl) {
        if (bl) {
            JCCircularScale jCCircularScale = new JCCircularScale(this);
            this.setScale(jCCircularScale);
        }
    }

    public JCCircularGauge(GaugeType gaugeType) {
        this.gaugeType = gaugeType;
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = this.getBounds();
        rectangle.setLocation(0, 0);
        if (this.isOpaque()) {
            Serializable serializable;
            Color color = this.getBackground();
            if (color != null) {
                serializable = graphics2D.getColor();
                if (serializable != null && !graphics2D.getColor().equals(color)) {
                    graphics2D.setColor(color);
                }
                graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
            }
            if (this.fillStyle != null) {
                serializable = this.getInsets();
                int n2 = Math.max(0, rectangle.width - ((Insets)serializable).left - ((Insets)serializable).right);
                int n3 = Math.max(0, rectangle.height - ((Insets)serializable).top - ((Insets)serializable).bottom);
                Rectangle rectangle2 = new Rectangle(((Insets)serializable).left, ((Insets)serializable).top, n2, n3);
                this.fillStyle.updateAnchorRect(rectangle2);
                this.fillStyle.fillRect((Graphics)graphics2D, ((Insets)serializable).left, ((Insets)serializable).top, n2, n3);
                this.fillStyle.updateAnchorRect(null);
            }
            this.drawImage(graphics2D, this.image, rectangle);
        }
    }

    public JCCircularScale getCircularScale() {
        return (JCCircularScale)this.getScale();
    }

    public void setScale(JCCircularScale jCCircularScale, boolean bl) {
        if (this.scale != null) {
            this.gaugeArea.remove((Component)((Object)this.scale));
        }
        this.scale = jCCircularScale;
        if (bl) {
            this.gaugeArea.add(jCCircularScale);
        }
        this.setIndicatorScales(jCCircularScale);
        this.setNeedleScales(jCCircularScale);
    }

    public void setScale(JCCircularScale jCCircularScale) {
        this.setScale(jCCircularScale, true);
    }

    public void addLabel(JComponent jComponent, RadialConstraint radialConstraint) {
        this.labels.addElement(jComponent);
        this.constraints.addElement(radialConstraint);
        this.getGaugeArea().add(jComponent, radialConstraint, 0);
    }

    public void addLabel(JComponent jComponent, RadialConstraint radialConstraint, int n2) {
        this.labels.addElement(jComponent);
        this.constraints.addElement(radialConstraint);
        this.getGaugeArea().add(jComponent, radialConstraint, n2);
    }

    public void removeLabel(JComponent jComponent) {
        if (this.labels.contains(jComponent)) {
            int n2 = this.labels.indexOf(jComponent);
            this.labels.removeElement(jComponent);
            this.constraints.removeElementAt(n2);
            this.getGaugeArea().remove(jComponent);
        }
    }

    public JCCenter getCenter() {
        return this.center;
    }

    public void setCenter(JCCenter jCCenter, int n2) {
        if (this.center != null) {
            this.gaugeArea.remove(this.center);
        }
        this.center = jCCenter;
        if (jCCenter != null) {
            this.getGaugeArea().add(jCCenter, new RadialConstraint(this, 0.0, 0.0), n2);
        }
    }

    public void setCenter(JCCenter jCCenter) {
        this.setCenter(jCCenter, 0);
    }

    public GaugeType getGaugeType() {
        return this.gaugeType;
    }

    public void setGaugeType(GaugeType gaugeType) {
        JCCircularScale jCCircularScale;
        this.gaugeType = gaugeType;
        if (this.gaugeArea != null) {
            this.gaugeArea.doLayout();
        }
        if ((jCCircularScale = this.getCircularScale()) != null) {
            if (gaugeType == GaugeType.FULL_CIRCLE) {
                jCCircularScale.setStartAngle(0.0);
                jCCircularScale.setStopAngle(360.0);
            } else if (gaugeType == GaugeType.TOP_HALF_CIRCLE) {
                jCCircularScale.setStartAngle(0.0);
                jCCircularScale.setStopAngle(180.0);
            } else if (gaugeType == GaugeType.BOTTOM_HALF_CIRCLE) {
                jCCircularScale.setStartAngle(180.0);
                jCCircularScale.setStopAngle(360.0);
            } else if (gaugeType == GaugeType.LEFT_HALF_CIRCLE) {
                jCCircularScale.setStartAngle(90.0);
                jCCircularScale.setStopAngle(270.0);
            } else if (gaugeType == GaugeType.RIGHT_HALF_CIRCLE) {
                jCCircularScale.setStartAngle(270.0);
                jCCircularScale.setStopAngle(90.0);
            } else if (gaugeType == GaugeType.LOWER_LEFT_QUARTER_CIRCLE) {
                jCCircularScale.setStartAngle(180.0);
                jCCircularScale.setStopAngle(270.0);
            } else if (gaugeType == GaugeType.LOWER_RIGHT_QUARTER_CIRCLE) {
                jCCircularScale.setStartAngle(270.0);
                jCCircularScale.setStopAngle(360.0);
            } else if (gaugeType == GaugeType.UPPER_RIGHT_QUARTER_CIRCLE) {
                jCCircularScale.setStartAngle(0.0);
                jCCircularScale.setStopAngle(90.0);
            } else if (gaugeType == GaugeType.UPPER_LEFT_QUARTER_CIRCLE) {
                jCCircularScale.setStartAngle(90.0);
                jCCircularScale.setStopAngle(180.0);
            }
            jCCircularScale.doLayout();
            for (int i2 = 0; i2 < jCCircularScale.getTicks().size(); ++i2) {
                JCCircularTick jCCircularTick = (JCCircularTick)jCCircularScale.getTicks().elementAt(i2);
                jCCircularTick.doLayout();
            }
        }
        this.redraw();
    }

    public Rectangle2D.Double getArcBounds() {
        double d2;
        double d3;
        JCCircularScale jCCircularScale = this.getCircularScale();
        boolean bl = jCCircularScale.isAllSpaceUsed();
        double d4 = jCCircularScale.getRadius();
        double d5 = d4 * 2.0;
        Insets insets = jCCircularScale.getScaleInsets();
        double d6 = insets.left;
        double d7 = insets.top;
        Rectangle rectangle = this.gaugeArea.getBounds();
        double d8 = rectangle.width - (insets.left + insets.right);
        double d9 = rectangle.height - (insets.top + insets.bottom);
        if (this.gaugeType.equals(GaugeType.FULL_CIRCLE)) {
            d3 = d6 + (d8 - d5) / 2.0;
            d2 = d7 + (d9 - d5) / 2.0;
        } else if (this.gaugeType.equals(GaugeType.TOP_HALF_CIRCLE)) {
            d3 = d6 + (d8 - d5) / 2.0;
            d2 = bl ? d7 + (d9 - d4) / 2.0 : d7;
        } else if (this.gaugeType.equals(GaugeType.BOTTOM_HALF_CIRCLE)) {
            d3 = d6 + (d8 - d5) / 2.0;
            d2 = bl ? d7 + (d9 - d4) / 2.0 - d4 : d7 - d4;
        } else if (this.gaugeType.equals(GaugeType.LEFT_HALF_CIRCLE)) {
            d3 = bl ? d6 + (d8 - d4) / 2.0 : d6;
            d2 = d7 + (d9 - d5) / 2.0;
        } else if (this.gaugeType.equals(GaugeType.RIGHT_HALF_CIRCLE)) {
            d3 = bl ? d6 + (d8 - d4) / 2.0 - d4 : d6 - d4;
            d2 = d7 + (d9 - d5) / 2.0;
        } else if (this.gaugeType.equals(GaugeType.LOWER_LEFT_QUARTER_CIRCLE)) {
            d3 = bl ? d6 + (d8 - d4) / 2.0 : d6;
            d2 = bl ? d7 + (d9 - d4) / 2.0 - d4 : d7 - d4;
        } else if (this.gaugeType.equals(GaugeType.LOWER_RIGHT_QUARTER_CIRCLE)) {
            d3 = bl ? d6 + (d8 - d4) / 2.0 - d4 : d6 - d4;
            d2 = bl ? d7 + (d9 - d4) / 2.0 - d4 : d7 - d4;
        } else if (this.gaugeType.equals(GaugeType.UPPER_RIGHT_QUARTER_CIRCLE)) {
            d3 = bl ? d6 + (d8 - d4) / 2.0 - d4 : d6 - d4;
            d2 = bl ? d7 + (d9 - d4) / 2.0 : d7;
        } else if (this.gaugeType.equals(GaugeType.UPPER_LEFT_QUARTER_CIRCLE)) {
            d3 = bl ? d6 + (d8 - d4) / 2.0 : d6;
            d2 = bl ? d7 + (d9 - d4) / 2.0 : d7;
        } else {
            return null;
        }
        return new Rectangle2D.Double(d3, d2, d5, d5);
    }

    public Rectangle2D.Double getArcDrawingBounds(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return null;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        if (this.getCircularScale().isAllSpaceUsed()) {
            double d2 = rectangle2D.getWidth() / 2.0;
            double d3 = rectangle2D.getHeight() / 2.0;
            if (this.gaugeType.equals(GaugeType.TOP_HALF_CIRCLE)) {
                double_.height = d3;
            } else if (this.gaugeType.equals(GaugeType.BOTTOM_HALF_CIRCLE)) {
                double_.height = d3;
                double_.y += d3;
            } else if (this.gaugeType.equals(GaugeType.LEFT_HALF_CIRCLE)) {
                double_.width = d2;
            } else if (this.gaugeType.equals(GaugeType.RIGHT_HALF_CIRCLE)) {
                double_.width = d2;
                double_.x += d2;
            } else if (this.gaugeType.equals(GaugeType.UPPER_LEFT_QUARTER_CIRCLE)) {
                double_.width = d2;
                double_.height = d3;
            } else if (this.gaugeType.equals(GaugeType.LOWER_LEFT_QUARTER_CIRCLE)) {
                double_.width = d2;
                double_.height = d3;
                double_.y += d3;
            } else if (this.gaugeType.equals(GaugeType.UPPER_RIGHT_QUARTER_CIRCLE)) {
                double_.width = d2;
                double_.height = d3;
                double_.x += d2;
            } else if (this.gaugeType.equals(GaugeType.LOWER_RIGHT_QUARTER_CIRCLE)) {
                double_.width = d2;
                double_.height = d3;
                double_.x += d2;
                double_.y += d3;
            }
        }
        return double_;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        JCGaugePickEvent jCGaugePickEvent = this.pick(mouseEvent.getPoint());
        if (jCGaugePickEvent != null) {
            JCCircularNeedle jCCircularNeedle;
            this.sendPickEvent(jCGaugePickEvent);
            if (jCGaugePickEvent.getComponent() instanceof JCGaugeArea && (jCCircularNeedle = this.getClosestNeedle(jCGaugePickEvent, JCAbstractNeedle.InteractionType.CLICK)) != null) {
                jCCircularNeedle.setValue(jCGaugePickEvent.getValue());
                this.invalidate();
                this.redraw();
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        JCGaugePickEvent jCGaugePickEvent = this.pick(mouseEvent.getPoint());
        if (jCGaugePickEvent != null) {
            this.sendPickEvent(jCGaugePickEvent);
            if (jCGaugePickEvent.getComponent() instanceof JCGaugeArea) {
                double d2;
                if (this.draggedNeedle == null) {
                    this.draggedNeedle = this.getClosestNeedle(jCGaugePickEvent, JCAbstractNeedle.InteractionType.DRAG);
                }
                if (this.draggedNeedle != null && (d2 = jCGaugePickEvent.getValue()) != this.draggedNeedle.getValue()) {
                    this.draggedNeedle.setValue(d2);
                    this.redraw();
                }
            }
        }
    }

    public JCCircularNeedle getClosestNeedle(JCGaugePickEvent jCGaugePickEvent, JCAbstractNeedle.InteractionType interactionType) {
        JCCircularNeedle jCCircularNeedle = null;
        double d2 = this.valueToAngle(jCGaugePickEvent.getValue());
        for (JCNeedle jCNeedle : this.needles) {
            JCCircularNeedle jCCircularNeedle2 = (JCCircularNeedle)jCNeedle;
            JCAbstractNeedle.InteractionType interactionType2 = jCCircularNeedle2.getInteractionType();
            if (interactionType2 != JCAbstractNeedle.InteractionType.CLICK_DRAG && interactionType2 != interactionType) continue;
            if (jCCircularNeedle == null) {
                jCCircularNeedle = jCCircularNeedle2;
                continue;
            }
            double d3 = this.valueToAngle(jCCircularNeedle2.getValue());
            double d4 = this.valueToAngle(jCCircularNeedle.getValue());
            double d5 = GaugeUtil.distanceBetweenAngles(d2, d3);
            double d6 = GaugeUtil.distanceBetweenAngles(d2, d4);
            if (!(d6 > d5)) continue;
            jCCircularNeedle = jCCircularNeedle2;
        }
        return jCCircularNeedle;
    }

    protected double valueToAngle(double d2) {
        JCCircularScale jCCircularScale = this.getCircularScale();
        return GaugeUtil.valueToAngle(d2, jCCircularScale.getMin(), jCCircularScale.getMax(), jCCircularScale.getStartAngle(), jCCircularScale.getStopAngle());
    }

    public void redraw() {
        if (this.getRepaintEnabled()) {
            this.repaint();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleGauge();
        }
        return this.accessibleContext;
    }

    public static class GaugeType
    implements Serializable {
        public static final GaugeType FULL_CIRCLE = new GaugeType(0, 360);
        public static final GaugeType TOP_HALF_CIRCLE = new GaugeType(0, 180);
        public static final GaugeType BOTTOM_HALF_CIRCLE = new GaugeType(180, 180);
        public static final GaugeType LEFT_HALF_CIRCLE = new GaugeType(90, 180);
        public static final GaugeType RIGHT_HALF_CIRCLE = new GaugeType(270, 180);
        public static final GaugeType UPPER_RIGHT_QUARTER_CIRCLE = new GaugeType(0, 90);
        public static final GaugeType LOWER_RIGHT_QUARTER_CIRCLE = new GaugeType(270, 90);
        public static final GaugeType UPPER_LEFT_QUARTER_CIRCLE = new GaugeType(90, 90);
        public static final GaugeType LOWER_LEFT_QUARTER_CIRCLE = new GaugeType(180, 90);
        int startAngle;
        int sweepAngle;

        private GaugeType(int n2, int n3) {
            this.startAngle = n2;
            this.sweepAngle = n3;
        }

        public int getStartAngle() {
            return this.startAngle;
        }

        public int getSweepAngle() {
            return this.sweepAngle;
        }

        public boolean equals(GaugeType gaugeType) {
            return this.startAngle == gaugeType.startAngle && this.sweepAngle == gaugeType.sweepAngle;
        }
    }

    protected class AccessibleGauge
    extends JComponent.AccessibleJComponent {
        protected AccessibleGauge() {
            super(JCCircularGauge.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleGaugeRole.GAUGE;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            JCCircularScale jCCircularScale = JCCircularGauge.this.getCircularScale();
            if (jCCircularScale.getDirection() == JCAbstractScale.Direction.FORWARD) {
                accessibleStateSet.add(AccessibleGaugeState.FORWARD);
            } else {
                accessibleStateSet.add(AccessibleGaugeState.BACKWARD);
            }
            for (int i2 = 0; i2 < JCCircularGauge.this.getNeedles().size(); ++i2) {
                JCCircularNeedle jCCircularNeedle = (JCCircularNeedle)JCCircularGauge.this.getNeedles().get(i2);
                JCAbstractNeedle.InteractionType interactionType = jCCircularNeedle.getInteractionType();
                if (interactionType == JCAbstractNeedle.InteractionType.NONE) {
                    accessibleStateSet.add(AccessibleGaugeState.INTERACTION_NONE);
                } else if (interactionType == JCAbstractNeedle.InteractionType.DRAG) {
                    accessibleStateSet.add(AccessibleGaugeState.INTERACTION_DRAG);
                } else if (interactionType == JCAbstractNeedle.InteractionType.CLICK) {
                    accessibleStateSet.add(AccessibleGaugeState.INTERACTION_CLICK);
                } else if (interactionType == JCAbstractNeedle.InteractionType.CLICK_DRAG) {
                    accessibleStateSet.add(AccessibleGaugeState.INTERACTION_CLICK_DRAG);
                }
                accessibleStateSet.add(new AccessibleValueState("value = ", jCCircularNeedle.getValue()));
                JCIndicatorStyle jCIndicatorStyle = jCCircularNeedle.getIndicatorStyle();
                if (jCIndicatorStyle == JCIndicatorStyle.RECTANGLE) {
                    accessibleStateSet.add(AccessibleGaugeState.NEEDLE_RECTANGLE);
                    continue;
                }
                if (jCIndicatorStyle == JCIndicatorStyle.CIRCLE) {
                    accessibleStateSet.add(AccessibleGaugeState.NEEDLE_CIRCLE);
                    continue;
                }
                if (jCIndicatorStyle == JCIndicatorStyle.POINTER) {
                    accessibleStateSet.add(AccessibleGaugeState.NEEDLE_POINTER);
                    continue;
                }
                if (jCIndicatorStyle == JCIndicatorStyle.TAILED_POINTER) {
                    accessibleStateSet.add(AccessibleGaugeState.NEEDLE_TAILED_POINTER);
                    continue;
                }
                if (jCIndicatorStyle == JCIndicatorStyle.ARROW) {
                    accessibleStateSet.add(AccessibleGaugeState.NEEDLE_ARROW);
                    continue;
                }
                if (jCIndicatorStyle == JCIndicatorStyle.TAILED_ARROW) {
                    accessibleStateSet.add(AccessibleGaugeState.NEEDLE_TAILED_ARROW);
                    continue;
                }
                if (jCIndicatorStyle != JCIndicatorStyle.TRIANGLE) continue;
                accessibleStateSet.add(AccessibleGaugeState.NEEDLE_TRIANGLE);
            }
            return accessibleStateSet;
        }
    }
}

