/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge;

import com.klg.jclass.gauge.JCGauge;
import com.klg.jclass.gauge.JCLabelGenerator;
import com.klg.jclass.gauge.JCScale;
import com.klg.jclass.gauge.JCTick;
import com.klg.jclass.gauge.JCTickStyle;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.JCNumberUtil;
import com.klg.jclass.util.label.JCLabel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;

public abstract class JCAbstractTick
extends JComponent
implements JCTick,
Serializable {
    static final long serialVersionUID = 6997480289846291634L;
    protected JCScale scale;
    protected boolean automatic = true;
    protected double startValue;
    protected double stopValue;
    protected double incrementValue = 10.0;
    protected boolean precisionUseDefault = true;
    protected int precision = 0;
    protected double tickWidth = 2.0;
    protected boolean reversed = false;
    protected boolean drawLabels = true;
    protected boolean drawTicks = true;
    protected double labelExtent = 0.8;
    protected double innerExtent = 0.85;
    protected double outerExtent = 1.0;
    protected Color tickColor = Color.black;
    protected JCTickStyle tickStyle = JCTickStyle.LINE;
    protected Color fontColor = Color.black;
    protected JCLabelGenerator labelGenerator;
    protected ImageMapInfo imageMapInfo = null;

    public JCAbstractTick(JCScale jCScale, double d2, double d3) {
        this.scale = jCScale;
        this.startValue = d2;
        this.stopValue = d3;
    }

    public JCAbstractTick(JCScale jCScale, boolean bl, double d2, double d3, double d4, boolean bl2, int n2, double d5, boolean bl3, boolean bl4, double d6, double d7, double d8, Color color, JCTickStyle jCTickStyle, Font font, Color color2) {
        this.scale = jCScale;
        this.automatic = bl;
        this.startValue = d2;
        this.stopValue = d3;
        this.incrementValue = d4;
        this.precisionUseDefault = bl2;
        this.precision = n2;
        this.tickWidth = d5;
        this.drawLabels = bl3;
        this.drawTicks = bl4;
        this.labelExtent = d6;
        this.innerExtent = d7;
        this.outerExtent = d8;
        this.tickColor = color;
        this.tickStyle = jCTickStyle;
        this.fontColor = color2;
        this.setFont(font);
    }

    public void paintChildren(Graphics graphics) {
        JCGauge jCGauge = this.scale.getGauge();
        if (this.drawLabels && jCGauge != null && !jCGauge.inServerPaint) {
            super.paintChildren(graphics);
        }
    }

    protected void calcTicks(Graphics graphics, int n2) {
        double d2;
        int n3;
        Font font = this.getFont();
        if (font == null) {
            font = new Font("Dialog", 0, 10);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        double d3 = this.scale.getMin();
        double d4 = this.scale.getMax();
        this.calcPrecision(d3, d4);
        d3 = JCNumberUtil.precFloor(this.precision, d3);
        d4 = JCNumberUtil.precCeil(this.precision, d4);
        if (d4 <= d3) {
            n3 = this.precision;
            do {
                d4 = d3 + Math.pow(10.0, -n3);
                --n3;
            } while (d4 <= d3);
        }
        double d5 = d3;
        double d6 = d4;
        int n4 = 0;
        while (true) {
            int n5;
            d3 = JCNumberUtil.precFloor(this.precision, d3);
            d4 = JCNumberUtil.precCeil(this.precision, d4);
            double d7 = d3;
            double d8 = d4;
            double d9 = 0.5 * Math.pow(10.0, -this.precision - 1);
            double d10 = d4 - d3;
            String string = JCNumberUtil.format(d4, this.precision);
            int n6 = fontMetrics.stringWidth(string);
            String string2 = JCNumberUtil.format(d3, this.precision);
            int n7 = fontMetrics.stringWidth(string2);
            if (n7 > n6) {
                n6 = n7;
            }
            int n8 = this.drawTicks && this.drawLabels ? Math.max((int)this.tickWidth, n6) : (this.drawTicks ? (int)this.tickWidth : (this.drawLabels ? n6 : 0));
            int n9 = n5 = n8 == 0 ? 0 : n2 / n8;
            if (n5 <= 0) {
                d2 = 0.0;
            } else {
                double d11 = d10 / (double)n5;
                n3 = this.precision;
                if (this.precisionUseDefault) {
                    n3 = JCNumberUtil.nicePrecision(d4 - d3);
                    n3 = Math.min(n3, this.precision);
                }
                d2 = JCAbstractTick.niceNum(d11, -n3, false);
            }
            if (d2 != 0.0) {
                d3 = d2 * Math.floor(d3 / d2);
                d4 = d2 * Math.ceil(d4 / d2);
            } else if (Math.abs(d4 - d3) < d9) {
                d4 = d3 + 1.0;
            }
            if (!(Math.abs(d3 - d7) > d9) && !(Math.abs(d4 - d8) > d9)) break;
            boolean bl = true;
            if (d4 - d2 >= d6) {
                d4 -= d2;
            } else {
                bl = false;
            }
            if (d3 + d2 <= d5) {
                d3 += d2;
            } else {
                bl = false;
            }
            if (bl || n4 >= 2) break;
            ++n4;
        }
        this.startValue = d3;
        this.stopValue = d4;
        this.incrementValue = d2;
    }

    protected void calcPrecision(double d2, double d3) {
        if (this.precisionUseDefault) {
            this.precision = d3 <= d2 ? JCNumberUtil.nicePrecision(Math.abs(d3)) : JCNumberUtil.nicePrecision(d3 - d2);
        }
    }

    public JLabel generateLabel(double d2) {
        String string = JCNumberUtil.format(d2, this.precision);
        JCLabel jCLabel = new JCLabel(string);
        jCLabel.setFont(this.getFont());
        jCLabel.setForeground(this.fontColor);
        return jCLabel;
    }

    public static double niceNum(double d2, int n2, boolean bl) {
        if (d2 == 0.0) {
            return 0.0;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        double d3 = d2 / Math.pow(10.0, n2);
        double d4 = bl ? (d3 < 1.5 ? 1.0 : (d3 < 3.0 ? 2.0 : (d3 < 7.0 ? 5.0 : 10.0))) : (d3 <= 1.0 ? 1.0 : (d3 <= 2.0 ? 2.0 : (d3 <= 5.0 ? 5.0 : 10.0)));
        return d4 * Math.pow(10.0, n2);
    }

    public JCScale getScale() {
        return this.scale;
    }

    public JCLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public void setLabelGenerator(JCLabelGenerator jCLabelGenerator) {
        this.labelGenerator = jCLabelGenerator;
        this.redrawLabels();
    }

    public boolean getAutomatic() {
        return this.automatic;
    }

    public void setAutomatic(boolean bl) {
        this.automatic = bl;
    }

    public double getStartValue() {
        return this.startValue;
    }

    public void setStartValue(double d2) {
        this.startValue = d2;
        this.redraw(true);
    }

    public double getStopValue() {
        return this.stopValue;
    }

    public void setStopValue(double d2) {
        this.stopValue = d2;
        this.redraw(true);
    }

    public double getIncrementValue() {
        return this.incrementValue;
    }

    public void setIncrementValue(double d2) {
        this.incrementValue = d2;
        this.redraw(true);
    }

    public boolean getPrecisionUseDefault() {
        return this.precisionUseDefault;
    }

    public void setPrecisionUseDefault(boolean bl) {
        this.precisionUseDefault = bl;
        this.redraw();
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int n2) {
        this.precision = n2;
        this.redraw();
    }

    public double getTickWidth() {
        return this.tickWidth;
    }

    public void setTickWidth(double d2) {
        this.tickWidth = d2;
        this.redraw();
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean bl) {
        this.reversed = bl;
        this.redraw();
    }

    public boolean getDrawLabels() {
        return this.drawLabels;
    }

    public void setDrawLabels(boolean bl) {
        this.drawLabels = bl;
        this.redraw();
    }

    public boolean getDrawTicks() {
        return this.drawTicks;
    }

    public void setDrawTicks(boolean bl) {
        this.drawTicks = bl;
        this.redraw();
    }

    public double getLabelExtent() {
        return this.labelExtent;
    }

    public void setLabelExtent(double d2) {
        this.labelExtent = d2;
        this.redraw(true);
    }

    public double getInnerExtent() {
        return this.innerExtent;
    }

    public void setInnerExtent(double d2) {
        this.innerExtent = d2;
        this.redraw();
    }

    public double getOuterExtent() {
        return this.outerExtent;
    }

    public void setOuterExtent(double d2) {
        this.outerExtent = d2;
        this.redraw();
    }

    public Color getTickColor() {
        return this.tickColor;
    }

    public void setTickColor(Color color) {
        this.tickColor = color;
        this.redraw();
    }

    public JCTickStyle getTickStyle() {
        return this.tickStyle;
    }

    public void setTickStyle(JCTickStyle jCTickStyle) {
        this.tickStyle = jCTickStyle;
        this.redraw();
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
        this.redraw(true);
    }

    public void redraw(boolean bl) {
    }

    public void redraw() {
        this.redraw(false);
    }

    public void redrawLabels() {
    }

    public void setImageMapInfo(ImageMapInfo imageMapInfo) {
        this.imageMapInfo = imageMapInfo;
    }

    public ImageMapInfo getImageMapInfo() {
        return this.imageMapInfo;
    }
}

