/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge;

import com.klg.jclass.gauge.GaugeUtil;
import com.klg.jclass.gauge.JCGauge;
import com.klg.jclass.gauge.JCIndicator;
import com.klg.jclass.gauge.JCIndicatorStyle;
import com.klg.jclass.gauge.JCScale;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.style.JCFillStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public abstract class JCAbstractIndicator
extends JComponent
implements JCIndicator {
    protected JCScale scale;
    protected double indicatorWidth = 15.0;
    protected boolean reversed = false;
    protected double inner_extent = 0.0;
    protected double outer_extent = 1.0;
    protected Color color = Color.black;
    protected JCIndicatorStyle indicatorStyle = JCIndicatorStyle.RECTANGLE;
    protected double value;
    protected ImageMapInfo imageMapInfo = null;
    protected JCFillStyle fillStyle = null;

    public JCAbstractIndicator(JCScale jCScale) {
        this.scale = jCScale;
        this.value = jCScale.getMin();
    }

    public JCAbstractIndicator(Color color, double d2, JCScale jCScale, boolean bl, double d3, double d4, JCIndicatorStyle jCIndicatorStyle, double d5) {
        this.scale = jCScale;
        this.color = color;
        this.indicatorWidth = d2;
        this.inner_extent = d3;
        this.outer_extent = d4;
        this.indicatorStyle = jCIndicatorStyle;
        this.value = d5;
        this.setVisible(bl);
    }

    public void setForeground(Color color) {
        this.setColor(color);
    }

    public Color getForeground() {
        return this.getColor();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.redraw();
    }

    public Dimension getPreferredSize() {
        return this.scale.getGauge().getGaugeArea().getPreferredSize();
    }

    public abstract void paint(Graphics var1);

    public JCScale getScale() {
        return this.scale;
    }

    protected void setScale(JCScale jCScale) {
        this.scale = jCScale;
        this.value = GaugeUtil.clamp(this.value, jCScale.getMin(), jCScale.getMax());
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d2) {
        if (this.value != (d2 = GaugeUtil.clamp(d2, this.scale.getMin(), this.scale.getMax()))) {
            this.value = d2;
            this.redraw();
        }
    }

    public double getInnerExtent() {
        return this.inner_extent;
    }

    public void setInnerExtent(double d2) {
        this.inner_extent = d2;
        this.redraw();
    }

    public double getOuterExtent() {
        return this.outer_extent;
    }

    public void setOuterExtent(double d2) {
        this.outer_extent = d2;
        this.redraw();
    }

    public JCIndicatorStyle getIndicatorStyle() {
        return this.indicatorStyle;
    }

    public void setIndicatorStyle(JCIndicatorStyle jCIndicatorStyle) {
        this.indicatorStyle = jCIndicatorStyle;
        this.redraw();
    }

    public double getIndicatorWidth() {
        return this.indicatorWidth;
    }

    public void setIndicatorWidth(double d2) {
        this.indicatorWidth = d2;
        this.redraw();
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean bl) {
        this.reversed = bl;
        this.redraw();
    }

    public void redraw() {
        JCGauge jCGauge = this.scale.getGauge();
        if (jCGauge != null && jCGauge.getRepaintEnabled()) {
            jCGauge.repaint();
        }
    }

    public void setImageMapInfo(ImageMapInfo imageMapInfo) {
        this.imageMapInfo = imageMapInfo;
    }

    public ImageMapInfo getImageMapInfo() {
        return this.imageMapInfo;
    }

    public JCFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        this.fillStyle = jCFillStyle;
        this.redraw();
    }
}

