/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge;

import com.klg.jclass.gauge.DefaultLegendPopulatorRenderer;
import com.klg.jclass.gauge.JCAbstractScale;
import com.klg.jclass.gauge.JCCircularScale;
import com.klg.jclass.gauge.JCGauge;
import com.klg.jclass.gauge.JCLinearScale;
import com.klg.jclass.gauge.JCPolygon;
import com.klg.jclass.gauge.JCScale;
import com.klg.jclass.util.JCNumberUtil;
import com.klg.jclass.util.io.PortableImage;
import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.style.JCFillStyle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaugeUtil {
    public static double clamp(double d2, double d3, double d4) {
        if (d2 < d3) {
            d2 = d3;
        }
        if (d2 > d4) {
            d2 = d4;
        }
        return d2;
    }

    public static double valueToAngle(double d2, double d3, double d4, double d5, double d6) {
        if (d5 >= d6) {
            d6 += 360.0;
        }
        double d7 = d6 - d5;
        double d8 = Math.max(d4, d3) - Math.min(d3, d4);
        double d9 = d7 / d8;
        double d10 = d9 * (d2 - d3) + d5;
        d10 = GaugeUtil.normalizeAngle(d10);
        return d10;
    }

    public static double valueToPositionDouble(double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.max(d6, d5) - Math.min(d5, d6);
        double d8 = Math.max(d4, d3) - Math.min(d3, d4);
        double d9 = d7 / d8;
        return d9 * (d2 - d3) + d5;
    }

    public static double valueToPositionLog(double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2) {
        double d7;
        double d8 = JCNumberUtil.log10(d3);
        double d9 = JCNumberUtil.log10(d4);
        double d10 = d9 - d8;
        double d11 = d6 - d5;
        if (bl2) {
            d11 = -d11;
        }
        double d12 = d10 != 0.0 ? d11 / d10 : 0.0;
        double d13 = d7 = d11 < 0.0 ? d5 - d9 * d12 : d5 - d8 * d12;
        if (d2 <= 0.0) {
            d2 = d3;
        }
        double d14 = d12 * JCNumberUtil.log10(d2) + d7;
        return bl ? d6 + d5 - d14 : d14;
    }

    public static int valueToPosition(double d2, double d3, double d4, int n2, int n3) {
        double d5 = Math.max(n3, n2) - Math.min(n2, n3);
        double d6 = Math.max(d4, d3) - Math.min(d3, d4);
        double d7 = d5 / d6;
        return (int)(d7 * (d2 - d3)) + n2;
    }

    public static double pointToAngle(double d2, double d3, double d4, double d5) {
        double d6 = d2 - d4;
        double d7 = d3 - d5;
        double d8 = d7 < 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        double d9 = Math.abs(d6) > 0.0 ? Math.atan2(-d7, d6) : d8;
        return GaugeUtil.fromRadians(d9);
    }

    public static double angleToValue(double d2, double d3, double d4, double d5, double d6) {
        if (d5 >= d6) {
            d6 += 360.0;
        }
        double d7 = d6 - d5;
        double d8 = Math.max(d4, d3) - Math.min(d3, d4);
        double d9 = d8 / d7;
        return d9 * (d2 - d5) + Math.min(d3, d4);
    }

    public static double positionToValue(int n2, double d2, double d3, int n3, int n4) {
        double d4 = Math.max(n4, n3) - Math.min(n3, n4);
        double d5 = Math.max(d3, d2) - Math.min(d2, d3);
        double d6 = d5 / d4;
        return d6 * (double)(n2 - n3) + d2;
    }

    public static double positionToValueDouble(double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.max(d6, d5) - Math.min(d5, d6);
        double d8 = Math.max(d4, d3) - Math.min(d3, d4);
        double d9 = d8 / d7;
        return d9 * (d2 - d5) + d3;
    }

    public static double positionToValueLog(double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2) {
        double d7;
        double d8 = JCNumberUtil.log10(d3);
        double d9 = JCNumberUtil.log10(d4);
        double d10 = d9 - d8;
        double d11 = d6 - d5;
        if (bl2) {
            d11 = -d11;
        }
        double d12 = d10 != 0.0 ? d11 / d10 : 0.0;
        double d13 = d7 = d11 < 0.0 ? d5 - d9 * d12 : d5 - d8 * d12;
        if (bl) {
            d2 = d6 + d5 - d2;
        }
        return Math.pow(10.0, (d2 - d7) / d12);
    }

    public static double distanceBetweenAngles(double d2, double d3) {
        double d4 = Math.abs(d2 - d3);
        if (Math.abs(360.0 - d4) < d4) {
            d4 = Math.abs(360.0 - d4);
        }
        return d4;
    }

    public static double arcAngle(double d2, double d3) {
        double d4 = d2 == d3 ? 360.0 : (d2 < d3 ? d3 - d2 : d3 + 180.0);
        return d4;
    }

    public static double normalizeAngle(double d2) {
        while (d2 >= 360.0) {
            d2 -= 360.0;
        }
        while (d2 < 0.0) {
            d2 += 360.0;
        }
        return d2;
    }

    public static double toRadians(double d2) {
        return Math.toRadians(d2);
    }

    public static double fromRadians(double d2) {
        return Math.toDegrees(d2);
    }

    public static List<Point2D.Double> convertPolygonToPointList(Polygon polygon) {
        if (polygon == null) {
            return null;
        }
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        for (int i2 = 0; i2 < polygon.npoints; ++i2) {
            Point2D.Double double_ = new Point2D.Double(polygon.xpoints[i2], polygon.ypoints[i2]);
            arrayList.add(double_);
        }
        return arrayList;
    }

    public static Polygon scale(Polygon polygon, double d2, double d3) {
        Polygon polygon2 = new Polygon();
        int[] nArray = polygon.xpoints;
        int[] nArray2 = polygon.ypoints;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            polygon2.addPoint((int)((double)nArray[i2] * d2), (int)((double)nArray2[i2] * d3));
        }
        return polygon2;
    }

    public static List<Point2D.Double> scalePointList(List<Point2D.Double> list, double d2, double d3) {
        if (list == null) {
            return null;
        }
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        for (Point2D.Double double_ : list) {
            Point2D.Double double_2 = new Point2D.Double(double_.getX() * d2, double_.getY() * d3);
            arrayList.add(double_2);
        }
        return arrayList;
    }

    public static Polygon rotate(Polygon polygon, double d2) {
        if (d2 == 0.0) {
            return polygon;
        }
        Polygon polygon2 = new Polygon();
        int[] nArray = polygon.xpoints;
        int[] nArray2 = polygon.ypoints;
        double d3 = GaugeUtil.toRadians(d2);
        double d4 = Math.sin(d3);
        double d5 = Math.cos(d3);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            int n3 = nArray2[i2];
            int n4 = (int)((double)n2 * d5 + (double)n3 * d4);
            int n5 = (int)((double)n3 * d5 - (double)n2 * d4);
            polygon2.addPoint(n4, n5);
        }
        return polygon2;
    }

    public static List<Point2D.Double> rotatePointList(List<Point2D.Double> list, double d2) {
        if (d2 == 0.0) {
            return list;
        }
        if (list == null) {
            return null;
        }
        double d3 = GaugeUtil.toRadians(d2);
        double d4 = Math.sin(d3);
        double d5 = Math.cos(d3);
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        for (Point2D.Double double_ : list) {
            double d6 = double_.getX();
            double d7 = double_.getY();
            Point2D.Double double_2 = new Point2D.Double(d6 * d5 + d7 * d4, d7 * d5 - d6 * d4);
            arrayList.add(double_2);
        }
        return arrayList;
    }

    public static Polygon translate(Polygon polygon, int n2, int n3) {
        Polygon polygon2 = new Polygon();
        for (int i2 = 0; i2 < polygon.xpoints.length; ++i2) {
            int n4 = polygon.xpoints[i2] + n2;
            int n5 = polygon.ypoints[i2] + n3;
            polygon2.addPoint(n4, n5);
        }
        return polygon2;
    }

    public static Polygon getCircularPolygon(JCCircularScale jCCircularScale, double d2, double d3, double d4, double d5, boolean bl, boolean bl2, JCPolygon jCPolygon) {
        double d6;
        double d7;
        double d8 = jCCircularScale.getRadius();
        double d9 = (d3 *= d8) - (d2 *= d8);
        Rectangle rectangle = jCPolygon.getExtrema();
        double d10 = 0.0;
        if (bl2) {
            d10 = d9 / (double)(rectangle.x - rectangle.width);
        } else if ((double)rectangle.width != 0.0) {
            d10 = d9 / (double)rectangle.width;
        }
        double d11 = d4 / (double)(rectangle.y - rectangle.height);
        Polygon polygon = GaugeUtil.scale(jCPolygon, Math.abs(d10), Math.abs(d11));
        double d12 = jCCircularScale.getMin();
        double d13 = jCCircularScale.getMax();
        double d14 = GaugeUtil.clamp(d5, d12, d13);
        if (jCCircularScale.getDirection().equals(JCAbstractScale.Direction.BACKWARD)) {
            d14 = d13 - d14 + d12;
        }
        double d15 = GaugeUtil.normalizeAngle(jCCircularScale.getStartAngle());
        double d16 = GaugeUtil.normalizeAngle(jCCircularScale.getStopAngle());
        double d17 = GaugeUtil.valueToAngle(d14, d12, d13, d15, d16);
        if (bl) {
            d17 = GaugeUtil.normalizeAngle(d17 + 180.0);
        }
        double d18 = GaugeUtil.toRadians(d17);
        Polygon polygon2 = GaugeUtil.rotate(polygon, d17);
        double d19 = d2 + d9 / 2.0;
        double d20 = bl2 ? d19 : d2;
        Rectangle2D.Double double_ = jCCircularScale.getCircularGauge().getArcBounds();
        double d21 = double_.x + d8;
        double d22 = double_.y + d8;
        if (bl) {
            if (!bl2) {
                d20 += d9;
            }
            d7 = d21 - d20 * Math.cos(d18);
            d6 = d22 + d20 * Math.sin(d18);
        } else {
            d7 = d21 + d20 * Math.cos(d18);
            d6 = d22 - d20 * Math.sin(d18);
        }
        int n2 = polygon2.npoints + 1;
        Polygon polygon3 = new Polygon(new int[n2], new int[n2], n2);
        polygon3.xpoints[0] = (int)d7;
        polygon3.ypoints[0] = (int)d6;
        for (int i2 = 1; i2 < polygon3.npoints; ++i2) {
            polygon3.xpoints[i2] = polygon2.xpoints[i2 - 1];
            polygon3.ypoints[i2] = polygon2.ypoints[i2 - 1];
        }
        return polygon3;
    }

    public static List<Point2D.Double> getCircularPolygonPointList(JCCircularScale jCCircularScale, double d2, double d3, double d4, double d5, boolean bl, boolean bl2, JCPolygon jCPolygon) {
        double d6;
        double d7;
        List<Point2D.Double> list = GaugeUtil.convertPolygonToPointList(jCPolygon);
        if (list == null) {
            return null;
        }
        double d8 = jCCircularScale.getRadius();
        double d9 = (d3 *= d8) - (d2 *= d8);
        Rectangle rectangle = jCPolygon.getExtrema();
        double d10 = 0.0;
        if (bl2) {
            d10 = d9 / (double)(rectangle.x - rectangle.width);
        } else if ((double)rectangle.width != 0.0) {
            d10 = d9 / (double)rectangle.width;
        }
        double d11 = d4 / (double)(rectangle.y - rectangle.height);
        list = GaugeUtil.scalePointList(list, Math.abs(d10), Math.abs(d11));
        double d12 = jCCircularScale.getMin();
        double d13 = jCCircularScale.getMax();
        double d14 = GaugeUtil.clamp(d5, d12, d13);
        if (jCCircularScale.getDirection().equals(JCAbstractScale.Direction.BACKWARD)) {
            d14 = d13 - d14 + d12;
        }
        double d15 = GaugeUtil.normalizeAngle(jCCircularScale.getStartAngle());
        double d16 = GaugeUtil.normalizeAngle(jCCircularScale.getStopAngle());
        double d17 = GaugeUtil.valueToAngle(d14, d12, d13, d15, d16);
        if (bl) {
            d17 = GaugeUtil.normalizeAngle(d17 + 180.0);
        }
        double d18 = GaugeUtil.toRadians(d17);
        list = GaugeUtil.rotatePointList(list, d17);
        double d19 = d2 + d9 / 2.0;
        double d20 = bl2 ? d19 : d2;
        Rectangle2D.Double double_ = jCCircularScale.getCircularGauge().getArcBounds();
        double d21 = double_.x + d8;
        double d22 = double_.y + d8;
        if (bl) {
            if (!bl2) {
                d20 += d9;
            }
            d7 = d21 - d20 * Math.cos(d18);
            d6 = d22 + d20 * Math.sin(d18);
        } else {
            d7 = d21 + d20 * Math.cos(d18);
            d6 = d22 - d20 * Math.sin(d18);
        }
        list.add(0, new Point2D.Double(d7, d6));
        return list;
    }

    public static void drawCircularPolygon(Graphics graphics, JCCircularScale jCCircularScale, Color color, double d2, double d3, double d4, double d5, boolean bl, boolean bl2, JCPolygon jCPolygon) {
        GaugeUtil.drawCircularPolygon(graphics, jCCircularScale, color, d2, d3, d4, d5, bl, bl2, jCPolygon, null);
    }

    public static void drawCircularPolygon(Graphics graphics, JCCircularScale jCCircularScale, Color color, double d2, double d3, double d4, double d5, boolean bl, boolean bl2, JCPolygon jCPolygon, JCFillStyle jCFillStyle) {
        List<Point2D.Double> list = GaugeUtil.getCircularPolygonPointList(jCCircularScale, d2, d3, d4, d5, bl, bl2, jCPolygon);
        if (list == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(color);
        GeneralPath generalPath = new GeneralPath();
        Point2D.Double double_ = list.get(0);
        graphics2D.translate(double_.getX(), double_.getY());
        for (int i2 = 1; i2 < list.size(); ++i2) {
            double_ = list.get(i2);
            if (i2 == 1) {
                generalPath.moveTo((float)double_.getX(), (float)double_.getY());
                continue;
            }
            generalPath.lineTo((float)double_.getX(), (float)double_.getY());
        }
        generalPath.closePath();
        if (jCFillStyle != null) {
            jCFillStyle.updateAnchorRect(generalPath.getBounds2D());
            jCFillStyle.fillPolygon((Graphics)graphics2D, generalPath);
            jCFillStyle.updateAnchorRect(null);
        } else {
            graphics2D.fill(generalPath);
        }
        graphics2D.dispose();
    }

    public static Polygon getLinearPolygon(JCLinearScale jCLinearScale, double d2, double d3, double d4, double d5, boolean bl, boolean bl2, JCPolygon jCPolygon, Rectangle rectangle) {
        double d6;
        double d7;
        double d8;
        JCLinearScale.Orientation orientation = jCLinearScale.getOrientation();
        boolean bl3 = orientation == JCLinearScale.Orientation.VERTICAL;
        JCAbstractScale.Direction direction = jCLinearScale.getDirection();
        boolean bl4 = direction.equals(JCAbstractScale.Direction.BACKWARD);
        double d9 = jCLinearScale.getMin();
        double d10 = jCLinearScale.getMax();
        d5 = GaugeUtil.clamp(d5, d9, d10);
        if (bl4 ^ bl3 && !jCLinearScale.isLogarithmic()) {
            d5 = d10 - d5 + d9;
        }
        if (bl3) {
            d2 *= (double)rectangle.width;
            d3 *= (double)rectangle.width;
        } else {
            d2 *= (double)rectangle.height;
            d3 *= (double)rectangle.height;
        }
        double d11 = Math.abs(d3 - d2);
        Rectangle rectangle2 = jCPolygon.getExtrema();
        double d12 = 0.0;
        if (bl2) {
            d12 = d11 / (double)(rectangle2.x - rectangle2.width);
        } else if ((double)rectangle2.width != 0.0) {
            d12 = d11 / (double)rectangle2.width;
        }
        double d13 = d4 / (double)(rectangle2.y - rectangle2.height);
        Polygon polygon = GaugeUtil.scale(jCPolygon, Math.abs(d12), Math.abs(d13));
        double d14 = bl3 ? (double)(bl ? 180 : 0) : (double)(bl ? 90 : 270);
        Polygon polygon2 = GaugeUtil.rotate(polygon, d14);
        double d15 = d2 + d11 / 2.0;
        double d16 = d8 = bl2 ? d15 : d2;
        if (bl && !bl2) {
            d8 += d11;
        }
        double d17 = bl3 ? rectangle.getY() : rectangle.getX();
        double d18 = bl3 ? rectangle.getY() + rectangle.getHeight() : rectangle.getX() + rectangle.getWidth();
        double d19 = jCLinearScale.isLogarithmic() ? GaugeUtil.valueToPositionLog(d5, d9, d10, d17, d18, bl3, bl4) : GaugeUtil.valueToPositionDouble(d5, d9, d10, d17, d18);
        if (bl3) {
            d7 = rectangle.getX() + d8;
            d6 = d19;
        } else {
            d7 = d19;
            d6 = rectangle.getY() + d8;
        }
        int n2 = polygon2.npoints + 1;
        Polygon polygon3 = new Polygon(new int[n2], new int[n2], n2);
        polygon3.xpoints[0] = (int)d7;
        polygon3.ypoints[0] = (int)d6;
        for (int i2 = 1; i2 < polygon3.npoints; ++i2) {
            polygon3.xpoints[i2] = polygon2.xpoints[i2 - 1];
            polygon3.ypoints[i2] = polygon2.ypoints[i2 - 1];
        }
        return polygon3;
    }

    public static List<Point2D.Double> getLinearPolygonPointList(JCLinearScale jCLinearScale, double d2, double d3, double d4, double d5, boolean bl, boolean bl2, JCPolygon jCPolygon, Rectangle2D rectangle2D) {
        double d6;
        double d7;
        double d8;
        List<Point2D.Double> list = GaugeUtil.convertPolygonToPointList(jCPolygon);
        if (list == null) {
            return null;
        }
        JCLinearScale.Orientation orientation = jCLinearScale.getOrientation();
        boolean bl3 = orientation == JCLinearScale.Orientation.VERTICAL;
        JCAbstractScale.Direction direction = jCLinearScale.getDirection();
        boolean bl4 = direction.equals(JCAbstractScale.Direction.BACKWARD);
        double d9 = jCLinearScale.getMin();
        double d10 = jCLinearScale.getMax();
        d5 = GaugeUtil.clamp(d5, d9, d10);
        if (bl4 ^ bl3 && !jCLinearScale.isLogarithmic()) {
            d5 = d10 - d5 + d9;
        }
        if (bl3) {
            d2 *= rectangle2D.getWidth();
            d3 *= rectangle2D.getWidth();
        } else {
            d2 *= rectangle2D.getHeight();
            d3 *= rectangle2D.getHeight();
        }
        double d11 = Math.abs(d3 - d2);
        Rectangle rectangle = jCPolygon.getExtrema();
        double d12 = 0.0;
        if (bl2) {
            d12 = d11 / (double)(rectangle.x - rectangle.width);
        } else if ((double)rectangle.width != 0.0) {
            d12 = d11 / (double)rectangle.width;
        }
        double d13 = d4 / (double)(rectangle.y - rectangle.height);
        list = GaugeUtil.scalePointList(list, Math.abs(d12), Math.abs(d13));
        double d14 = bl3 ? (double)(bl ? 180 : 0) : (double)(bl ? 90 : 270);
        list = GaugeUtil.rotatePointList(list, d14);
        double d15 = d2 + d11 / 2.0;
        double d16 = d8 = bl2 ? d15 : d2;
        if (bl && !bl2) {
            d8 += d11;
        }
        double d17 = bl3 ? rectangle2D.getY() : rectangle2D.getX();
        double d18 = bl3 ? rectangle2D.getY() + rectangle2D.getHeight() : rectangle2D.getX() + rectangle2D.getWidth();
        double d19 = jCLinearScale.isLogarithmic() ? GaugeUtil.valueToPositionLog(d5, d9, d10, d17, d18, bl3, bl4) : GaugeUtil.valueToPositionDouble(d5, d9, d10, d17, d18);
        if (bl3) {
            d7 = rectangle2D.getX() + d8;
            d6 = d19;
        } else {
            d7 = d19;
            d6 = rectangle2D.getY() + d8;
        }
        list.add(0, new Point2D.Double(d7, d6));
        return list;
    }

    public static void drawLinearPolygon(Graphics graphics, JCLinearScale jCLinearScale, Color color, double d2, double d3, double d4, double d5, boolean bl, boolean bl2, JCPolygon jCPolygon) {
        GaugeUtil.drawLinearPolygon(graphics, jCLinearScale, color, d2, d3, d4, d5, bl, bl2, jCPolygon, null);
    }

    public static void drawLinearPolygon(Graphics graphics, JCLinearScale jCLinearScale, Color color, double d2, double d3, double d4, double d5, boolean bl, boolean bl2, JCPolygon jCPolygon, JCFillStyle jCFillStyle) {
        List<Point2D.Double> list = GaugeUtil.getLinearPolygonPointList(jCLinearScale, d2, d3, d4, d5, bl, bl2, jCPolygon, jCLinearScale.getScaleSize());
        if (list == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(color);
        GeneralPath generalPath = new GeneralPath();
        Point2D.Double double_ = list.get(0);
        graphics2D.translate(double_.getX(), double_.getY());
        for (int i2 = 1; i2 < list.size(); ++i2) {
            double_ = list.get(i2);
            if (i2 == 1) {
                generalPath.moveTo((float)double_.getX(), (float)double_.getY());
                continue;
            }
            generalPath.lineTo((float)double_.getX(), (float)double_.getY());
        }
        generalPath.closePath();
        if (jCFillStyle != null) {
            jCFillStyle.updateAnchorRect(generalPath.getBounds2D());
            jCFillStyle.fillPolygon((Graphics)graphics2D, generalPath);
            jCFillStyle.updateAnchorRect(null);
        } else {
            graphics2D.fill(generalPath);
        }
        graphics2D.dispose();
    }

    public static double[] getCircleForCircularScale(JCCircularScale jCCircularScale, double d2, double d3, double d4) {
        Rectangle2D.Double double_ = jCCircularScale.getCircularGauge().getArcBounds();
        double d5 = jCCircularScale.getRadius();
        double d6 = double_.x + d5;
        double d7 = double_.y + d5;
        double d8 = (d4 *= d5) - (d3 *= d5);
        double d9 = d8 / 2.0;
        double d10 = d3 + d9;
        double d11 = jCCircularScale.getMin();
        double d12 = jCCircularScale.getMax();
        double d13 = GaugeUtil.clamp(d2, d11, d12);
        if (jCCircularScale.getDirection().equals(JCAbstractScale.Direction.BACKWARD)) {
            d13 = d12 - d13 + d11;
        }
        double d14 = GaugeUtil.normalizeAngle(jCCircularScale.getStartAngle());
        double d15 = GaugeUtil.normalizeAngle(jCCircularScale.getStopAngle());
        double d16 = GaugeUtil.valueToAngle(d13, d11, d12, d14, d15);
        double d17 = GaugeUtil.toRadians(d16);
        double d18 = d6 + d10 * Math.cos(d17);
        double d19 = d7 - d10 * Math.sin(d17);
        double[] dArray = new double[]{d18, d19, d9};
        return dArray;
    }

    public static void drawCircleForCircularScale(Graphics graphics, JCCircularScale jCCircularScale, Color color, double d2, double d3, double d4) {
        GaugeUtil.drawCircleForCircularScale(graphics, jCCircularScale, color, d2, d3, d4, null);
    }

    public static void drawCircleForCircularScale(Graphics graphics, JCCircularScale jCCircularScale, Color color, double d2, double d3, double d4, JCFillStyle jCFillStyle) {
        double[] dArray = GaugeUtil.getCircleForCircularScale(jCCircularScale, d2, d3, d4);
        double d5 = dArray[0];
        double d6 = dArray[1];
        double d7 = dArray[2];
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(color);
        d5 -= d7;
        d6 -= d7;
        double d8 = 2.0 * d7;
        if (jCFillStyle != null) {
            jCFillStyle.updateAnchorRect(new Rectangle2D.Double(d5, d6, d8, d8));
            jCFillStyle.fillArc((Graphics)graphics2D, d5, d6, d8, d8, 0.0, 360.0);
            jCFillStyle.updateAnchorRect(null);
        } else {
            Arc2D.Double double_ = new Arc2D.Double(d5, d6, d8, d8, 0.0, 360.0, 2);
            graphics2D.fill(double_);
        }
        graphics2D.dispose();
    }

    public static double[] getCircleForLinearScale(JCLinearScale jCLinearScale, double d2, double d3, double d4, Rectangle2D rectangle2D) {
        double d5;
        double d6;
        JCLinearScale.Orientation orientation = jCLinearScale.getOrientation();
        boolean bl = orientation == JCLinearScale.Orientation.VERTICAL;
        JCAbstractScale.Direction direction = jCLinearScale.getDirection();
        double d7 = jCLinearScale.getMin();
        double d8 = jCLinearScale.getMax();
        d2 = GaugeUtil.clamp(d2, d7, d8);
        boolean bl2 = direction.equals(JCAbstractScale.Direction.BACKWARD);
        if (bl2 ^ bl && !jCLinearScale.isLogarithmic()) {
            d2 = d8 - d2 + d7;
        }
        if (bl) {
            d3 *= rectangle2D.getWidth();
            d4 *= rectangle2D.getWidth();
        } else {
            d3 *= rectangle2D.getHeight();
            d4 *= rectangle2D.getHeight();
        }
        double d9 = d4 - d3;
        double d10 = d9 / 2.0;
        double d11 = d3 + d10;
        double d12 = bl ? rectangle2D.getY() : rectangle2D.getX();
        double d13 = bl ? rectangle2D.getY() + rectangle2D.getHeight() : rectangle2D.getX() + rectangle2D.getWidth();
        double d14 = jCLinearScale.isLogarithmic() ? GaugeUtil.valueToPositionLog(d2, d7, d8, d12, d13, bl, bl2) : GaugeUtil.valueToPositionDouble(d2, d7, d8, d12, d13);
        if (bl) {
            d6 = rectangle2D.getX() + d11;
            d5 = d14;
        } else {
            d6 = d14;
            d5 = rectangle2D.getY() + d11;
        }
        double[] dArray = new double[]{d6, d5, d10};
        return dArray;
    }

    public static void drawCircleForLinearScale(Graphics graphics, JCLinearScale jCLinearScale, Color color, double d2, double d3, double d4) {
        GaugeUtil.drawCircleForLinearScale(graphics, jCLinearScale, color, d2, d3, d4, null);
    }

    public static void drawCircleForLinearScale(Graphics graphics, JCLinearScale jCLinearScale, Color color, double d2, double d3, double d4, JCFillStyle jCFillStyle) {
        double[] dArray = GaugeUtil.getCircleForLinearScale(jCLinearScale, d2, d3, d4, jCLinearScale.getScaleSize());
        double d5 = dArray[0];
        double d6 = dArray[1];
        double d7 = dArray[2];
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(color);
        d5 -= d7;
        d6 -= d7;
        double d8 = 2.0 * d7;
        if (jCFillStyle != null) {
            jCFillStyle.updateAnchorRect(new Rectangle2D.Double(d5, d6, d8, d8));
            jCFillStyle.fillArc((Graphics)graphics2D, d5, d6, d8, d8, 0.0, 360.0);
            jCFillStyle.updateAnchorRect(null);
        } else {
            Arc2D.Double double_ = new Arc2D.Double(d5, d6, d8, d8, 0.0, 360.0, 2);
            graphics2D.fill(double_);
        }
        graphics2D.dispose();
    }

    public static void drawImage(Graphics2D graphics2D, PortableImage portableImage, Rectangle2D rectangle2D, Shape shape, boolean bl) {
        if (portableImage == null || portableImage.getImage() == null || rectangle2D == null || shape == null) {
            return;
        }
        JCFillStyle jCFillStyle = new JCFillStyle(Color.black, 11);
        jCFillStyle.setImage(portableImage.getImage());
        jCFillStyle.setImageLayoutHint(portableImage.isImageScaled() ? 2 : 0);
        jCFillStyle.setFillOrientation(5);
        jCFillStyle.updateAnchorRect(rectangle2D);
        if (bl) {
            jCFillStyle.fillPolygon((Graphics)graphics2D, shape);
        } else {
            jCFillStyle.updateGraphics(graphics2D);
            graphics2D.draw(shape);
            jCFillStyle.resetGraphics(graphics2D);
        }
        jCFillStyle.updateAnchorRect(null);
    }

    public static void createLegendPopulatorRenderer(JCGauge jCGauge, JCScale jCScale) {
        JCLegend jCLegend = jCGauge.getLegend();
        DefaultLegendPopulatorRenderer defaultLegendPopulatorRenderer = new DefaultLegendPopulatorRenderer(jCLegend, jCScale.getRanges());
        jCLegend.setLegendPopulator(defaultLegendPopulatorRenderer);
        jCLegend.setLegendRenderer(defaultLegendPopulatorRenderer);
    }

    public static Polygon translateContour(Polygon polygon) {
        int n2 = polygon.npoints;
        Polygon polygon2 = new Polygon(new int[n2 - 1], new int[n2 - 1], n2 - 1);
        for (int i2 = 0; i2 < polygon2.npoints; ++i2) {
            polygon2.xpoints[i2] = polygon.xpoints[i2 + 1] + polygon.xpoints[0];
            polygon2.ypoints[i2] = polygon.ypoints[i2 + 1] + polygon.ypoints[0];
        }
        return polygon2;
    }
}

