/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge;

import com.klg.jclass.gauge.JCGaugeLegendEntry;
import com.klg.jclass.gauge.resources.LocaleBundle;
import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.legend.JCLegendItem;
import com.klg.jclass.util.legend.JCLegendPopulator;
import com.klg.jclass.util.legend.JCLegendRenderer;
import com.klg.jclass.util.style.JCFillStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLegendPopulatorRenderer
implements JCLegendRenderer,
JCLegendPopulator,
Serializable {
    static final long serialVersionUID = 6132225179285554488L;
    protected List<?> itemObjects;
    protected JCLegend legend;
    protected Color outlineColor = Color.black;
    protected String legendTitle;

    public DefaultLegendPopulatorRenderer(JCLegend jCLegend, List<?> list) {
        if (jCLegend == null) {
            String string = "Null legend in DefaultLegendPopulatorRenderer.";
            throw new IllegalArgumentException(LocaleBundle.string(string));
        }
        this.legend = jCLegend;
        if (list == null) {
            String string = "Null legend item object list.";
            throw new IllegalArgumentException(LocaleBundle.string(string));
        }
        this.itemObjects = list;
    }

    @Override
    public List<List<JCLegendItem>> getLegendItems(FontMetrics fontMetrics) {
        Vector<List<JCLegendItem>> vector = new Vector<List<JCLegendItem>>();
        Vector<Object> vector2 = new Vector<Object>(this.itemObjects.size());
        int n2 = this.legend.getSymbolSize();
        int n3 = fontMetrics.getHeight();
        if (this.legendTitle != null) {
            JCLegendItem jCLegendItem = this.createLegendItem(this.legendTitle, n2, fontMetrics.stringWidth(this.legendTitle), n3, null);
            vector2.addElement(jCLegendItem);
        }
        for (Object obj : this.itemObjects) {
            JCGaugeLegendEntry jCGaugeLegendEntry;
            if (!(obj instanceof JCGaugeLegendEntry) || !(jCGaugeLegendEntry = (JCGaugeLegendEntry)obj).isVisibleInLegend()) continue;
            String string = jCGaugeLegendEntry.getLegendLabel();
            if (string == null) {
                string = "";
            }
            int n4 = fontMetrics.stringWidth(string);
            JCLegendItem jCLegendItem = this.createLegendItem(string, n2, n4, n3, jCGaugeLegendEntry);
            vector2.addElement(jCLegendItem);
        }
        vector.addElement(vector2);
        return vector;
    }

    protected JCLegendItem createLegendItem(String string, int n2, int n3, int n4, Object object) {
        JCLegendItem jCLegendItem = new JCLegendItem();
        jCLegendItem.symbolDim = new Dimension(n2, n2);
        jCLegendItem.textDim = new Dimension(n3, n4);
        jCLegendItem.contents = string;
        jCLegendItem.drawType = 1;
        if (object instanceof Color) {
            object = new LegendEntry(string, (Color)object, null);
        } else if (object instanceof Component) {
            if (object instanceof JCGaugeLegendEntry) {
                JCGaugeLegendEntry jCGaugeLegendEntry = (JCGaugeLegendEntry)object;
                object = new LegendEntry(string, ((Component)object).getBackground(), jCGaugeLegendEntry.getLegendFillStyle());
            } else {
                object = new LegendEntry(string, ((Component)object).getBackground(), null);
            }
        }
        jCLegendItem.itemInfo = object;
        return jCLegendItem;
    }

    @Override
    public boolean isTitleItem(JCLegendItem jCLegendItem) {
        return jCLegendItem.itemInfo == null;
    }

    @Override
    public void drawLegendItem(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
    }

    @Override
    public void drawLegendItemSymbol(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
    }

    @Override
    public void drawLegendItemText(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
    }

    @Override
    public Color getOutlineColor(JCLegendItem jCLegendItem) {
        return this.outlineColor;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }

    @Override
    public void setFillGraphics(Graphics graphics, JCLegendItem jCLegendItem) {
        Object object = jCLegendItem.itemInfo;
        if (object instanceof JCGaugeLegendEntry) {
            JCFillStyle jCFillStyle = ((JCGaugeLegendEntry)object).getLegendFillStyle();
            if (jCFillStyle != null) {
                int n2 = jCLegendItem.pos.x + jCLegendItem.symbolPos.x;
                int n3 = jCLegendItem.pos.y + jCLegendItem.symbolPos.y;
                Dimension dimension = jCLegendItem.symbolDim;
                jCFillStyle.updateAnchorRect(new Rectangle(n2, n3, dimension.width, dimension.height));
                jCFillStyle.updateGraphics(graphics);
                return;
            }
            graphics.setColor(((JCGaugeLegendEntry)object).getLegendColor());
        }
    }

    public String getLegendTitle() {
        return this.legendTitle;
    }

    public void setLegendTitle(String string) {
        this.legendTitle = string;
    }

    public class LegendEntry
    implements JCGaugeLegendEntry {
        protected String label;
        protected Color color;
        protected JCFillStyle fillStyle;

        public LegendEntry(String string, Color color, JCFillStyle jCFillStyle) {
            this.label = string;
            this.color = color;
            this.fillStyle = jCFillStyle;
        }

        public Color getLegendColor() {
            return this.color;
        }

        public boolean isVisibleInLegend() {
            return true;
        }

        public String getLegendLabel() {
            return this.label;
        }

        public JCFillStyle getLegendFillStyle() {
            return this.fillStyle;
        }
    }
}

